/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ObjectLocationSpecificationMethod;
import org.pentaho.di.core.ProgressMonitorListener;
import org.pentaho.di.core.changed.ChangedFlag;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.imp.ImportRules;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.job.JobEntryJob;
import org.pentaho.di.job.entries.trans.JobEntryTrans;
import org.pentaho.di.job.entry.JobEntryCopy;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.IRepositoryExporter;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryImporter;
import org.pentaho.di.repository.filerep.KettleFileRepository;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.mapping.MappingMeta;

public class RepositoryExporter
implements IRepositoryExporter {
    private Repository repository;
    private LogChannelInterface log;
    private ImportRules importRules;

    public RepositoryExporter(Repository repository) {
        this.log = repository.getLog();
        this.repository = repository;
        this.importRules = new ImportRules();
    }

    public void setImportRulesToValidate(ImportRules importRules) {
        this.importRules = importRules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized void exportAllObjects(ProgressMonitorListener monitor, String xmlFilename, RepositoryDirectoryInterface root, String exportType) throws KettleException {
        block21: {
            OutputStreamWriter writer;
            BufferedOutputStream os;
            block20: {
                os = null;
                writer = null;
                os = new BufferedOutputStream(KettleVFS.getOutputStream((String)xmlFilename, (boolean)false));
                writer = new OutputStreamWriter((OutputStream)os, "UTF-8");
                if (monitor != null) {
                    monitor.beginTask("Exporting the repository to XML...", 3);
                }
                root = null == root ? this.repository.loadRepositoryDirectoryTree() : root;
                writer.write(XMLHandler.getXMLHeader());
                writer.write("<repository>" + Const.CR + Const.CR);
                if (exportType.equals("all") || exportType.equals("trans")) {
                    writer.write("<transformations>" + Const.CR);
                    this.exportTransformations(monitor, root, writer);
                    writer.write("</transformations>" + Const.CR);
                }
                if (exportType.equals("all") || exportType.equals("jobs")) {
                    writer.write("<jobs>" + Const.CR);
                    this.exportJobs(monitor, root, writer);
                    writer.write("</jobs>" + Const.CR);
                }
                writer.write("</repository>" + Const.CR + Const.CR);
                if (monitor != null) {
                    monitor.worked(1);
                }
                if (monitor != null) {
                    monitor.subTask("Saving XML to file [" + xmlFilename + "]");
                }
                if (monitor == null) break block20;
                monitor.worked(1);
            }
            Object var9_7 = null;
            try {
                if (writer != null) {
                    writer.close();
                }
                if (os != null) {
                    ((OutputStream)os).close();
                }
                break block21;
            }
            catch (Exception e2) {
                System.out.println("Exception closing XML file writer to [" + xmlFilename + "]");
            }
            break block21;
            {
                catch (IOException e) {
                    System.out.println("Couldn't create file [" + xmlFilename + "]");
                    Object var9_8 = null;
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                        if (os != null) {
                            ((OutputStream)os).close();
                        }
                        break block21;
                    }
                    catch (Exception e2) {
                        System.out.println("Exception closing XML file writer to [" + xmlFilename + "]");
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                try {
                    if (writer != null) {
                        writer.close();
                    }
                    if (os != null) {
                        ((OutputStream)os).close();
                    }
                }
                catch (Exception e2) {
                    System.out.println("Exception closing XML file writer to [" + xmlFilename + "]");
                }
                throw throwable;
            }
        }
        if (monitor != null) {
            monitor.done();
        }
    }

    private void exportJobs(ProgressMonitorListener monitor, RepositoryDirectoryInterface dirTree, OutputStreamWriter writer) throws KettleException {
        try {
            ObjectId[] dirids = dirTree.getDirectoryIDs();
            System.out.println("Going through " + dirids.length + " directories in directory [" + dirTree.getPath() + "]");
            if (monitor != null) {
                monitor.subTask("Exporting the jobs...");
            }
            boolean continueOnError = true;
            for (int d = 0; d < dirids.length && (monitor == null || monitor != null && !monitor.isCanceled()); ++d) {
                RepositoryDirectoryInterface repdir = dirTree.findDirectory(dirids[d]);
                String[] jobs = this.repository.getJobNames(dirids[d], false);
                for (int i = 0; i < jobs.length && (monitor == null || monitor != null && !monitor.isCanceled()); ++i) {
                    try {
                        JobMeta jobMeta = this.repository.loadJob(jobs[i], repdir, null, null);
                        jobMeta.setRepository(this.repository);
                        System.out.println("Loading/Exporting job [" + repdir.getPath() + " : " + jobs[i] + "]");
                        if (monitor != null) {
                            monitor.subTask("Exporting job [" + jobs[i] + "]");
                        }
                        this.convertFromFileRepository(jobMeta);
                        try {
                            RepositoryImporter.validateImportedElement(this.importRules, jobMeta);
                        }
                        catch (KettleException ve) {
                            continueOnError = false;
                            throw ve;
                        }
                        writer.write(jobMeta.getXML() + Const.CR);
                        continue;
                    }
                    catch (KettleException ke) {
                        if (continueOnError) {
                            this.log.logError("An error occurred reading job [" + jobs[i] + "] from directory [" + repdir + "] : ", (Throwable)ke);
                            continue;
                        }
                        throw ke;
                    }
                }
            }
        }
        catch (Exception e) {
            throw new KettleException("Error while exporting repository jobs", (Throwable)e);
        }
    }

    private void convertFromFileRepository(JobMeta jobMeta) {
        if (this.repository instanceof KettleFileRepository) {
            KettleFileRepository fileRep = (KettleFileRepository)this.repository;
            String jobMetaFilename = fileRep.calcFilename(jobMeta.getObjectId());
            jobMeta.setFilename(jobMetaFilename);
            for (JobEntryCopy copy : jobMeta.getJobCopies()) {
                JobEntryJob job;
                FileObject fileObject;
                ChangedFlag meta;
                JobEntryTrans trans;
                JobEntryInterface entry = copy.getEntry();
                if (entry instanceof JobEntryTrans && (trans = (JobEntryTrans)entry).getSpecificationMethod() == ObjectLocationSpecificationMethod.FILENAME) {
                    try {
                        meta = trans.getTransMeta(this.repository, jobMeta);
                        fileObject = KettleVFS.getFileObject((String)((TransMeta)meta).getFilename());
                        trans.setSpecificationMethod(ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME);
                        trans.setFileName(null);
                        trans.setTransname(((TransMeta)meta).getName());
                        trans.setDirectory(Const.NVL((String)this.calcRepositoryDirectory(fileRep, fileObject), (String)"/"));
                    }
                    catch (Exception e) {
                        this.log.logError("Unable to load transformation specified in job entry '" + trans.getName() + "'", (Throwable)e);
                    }
                }
                if (!(entry instanceof JobEntryJob) || (job = (JobEntryJob)entry).getSpecificationMethod() != ObjectLocationSpecificationMethod.FILENAME) continue;
                try {
                    meta = job.getJobMeta(this.repository, jobMeta);
                    fileObject = KettleVFS.getFileObject((String)((JobMeta)meta).getFilename());
                    job.setSpecificationMethod(ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME);
                    job.setFileName(null);
                    job.setJobName(((JobMeta)meta).getName());
                    job.setDirectory(Const.NVL((String)this.calcRepositoryDirectory(fileRep, fileObject), (String)"/"));
                }
                catch (Exception e) {
                    this.log.logError("Unable to load job specified in job entry '" + job.getName() + "'", (Throwable)e);
                }
            }
        }
    }

    private void convertFromFileRepository(TransMeta transMeta) {
        if (this.repository instanceof KettleFileRepository) {
            KettleFileRepository fileRep = (KettleFileRepository)this.repository;
            String transMetaFilename = fileRep.calcFilename(transMeta.getObjectId());
            transMeta.setFilename(transMetaFilename);
            for (StepMeta stepMeta : transMeta.getSteps()) {
                MappingMeta mappingMeta;
                if (!stepMeta.isMapping() || (mappingMeta = (MappingMeta)stepMeta.getStepMetaInterface()).getSpecificationMethod() != ObjectLocationSpecificationMethod.FILENAME) continue;
                try {
                    TransMeta meta = MappingMeta.loadMappingMeta(mappingMeta, this.repository, transMeta);
                    FileObject fileObject = KettleVFS.getFileObject((String)meta.getFilename());
                    mappingMeta.setSpecificationMethod(ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME);
                    mappingMeta.setFileName(null);
                    mappingMeta.setTransName(meta.getName());
                    mappingMeta.setDirectoryPath(Const.NVL((String)this.calcRepositoryDirectory(fileRep, fileObject), (String)"/"));
                }
                catch (Exception e) {
                    this.log.logError("Unable to load transformation specified in map '" + mappingMeta.getName() + "'", (Throwable)e);
                }
            }
        }
    }

    private String calcRepositoryDirectory(KettleFileRepository fileRep, FileObject fileObject) throws FileSystemException {
        String baseDirectory;
        String path = fileObject.getParent().getName().getPath();
        if (path.startsWith(baseDirectory = fileRep.getRepositoryMeta().getBaseDirectory())) {
            return path.substring(baseDirectory.length());
        }
        return path;
    }

    private void exportTransformations(ProgressMonitorListener monitor, RepositoryDirectoryInterface dirTree, OutputStreamWriter writer) throws KettleException {
        try {
            if (monitor != null) {
                monitor.subTask("Exporting the transformations...");
            }
            ObjectId[] dirids = dirTree.getDirectoryIDs();
            System.out.println("Going through " + dirids.length + " directories in directory [" + dirTree.getPath() + "]");
            boolean continueOnError = true;
            for (int d = 0; d < dirids.length && (monitor == null || monitor != null && !monitor.isCanceled()); ++d) {
                RepositoryDirectoryInterface repdir = dirTree.findDirectory(dirids[d]);
                System.out.println("Directory ID #" + d + " : " + dirids[d] + " : " + repdir);
                String[] trans = this.repository.getTransformationNames(dirids[d], false);
                for (int i = 0; i < trans.length && (monitor == null || monitor != null && !monitor.isCanceled()); ++i) {
                    try {
                        TransMeta transMeta = this.repository.loadTransformation(trans[i], repdir, null, true, null);
                        transMeta.setRepository(this.repository);
                        System.out.println("Loading/Exporting transformation [" + repdir.getPath() + " : " + trans[i] + "]  (" + transMeta.getRepositoryDirectory().getPath() + ")");
                        if (monitor != null) {
                            monitor.subTask("Exporting transformation [" + trans[i] + "]");
                        }
                        this.convertFromFileRepository(transMeta);
                        try {
                            RepositoryImporter.validateImportedElement(this.importRules, transMeta);
                        }
                        catch (KettleException ve) {
                            continueOnError = false;
                            throw ve;
                        }
                        writer.write(transMeta.getXML() + Const.CR);
                        continue;
                    }
                    catch (KettleException ke) {
                        if (continueOnError) {
                            this.log.logError("An error occurred reading transformation [" + trans[i] + "] from directory [" + repdir + "] : ", (Throwable)ke);
                            continue;
                        }
                        throw ke;
                    }
                }
            }
            if (monitor != null) {
                monitor.worked(1);
            }
        }
        catch (Exception e) {
            throw new KettleException("Error while exporting repository transformations", (Throwable)e);
        }
    }
}

