/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.kdr;

import java.util.List;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.BaseRepositoryMeta;
import org.pentaho.di.repository.RepositoryCapabilities;
import org.pentaho.di.repository.RepositoryMeta;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KettleDatabaseRepositoryMeta
extends BaseRepositoryMeta
implements RepositoryMeta {
    public static String REPOSITORY_TYPE_ID = "KettleDatabaseRepository";
    private DatabaseMeta databaseMeta;

    public KettleDatabaseRepositoryMeta() {
        super(REPOSITORY_TYPE_ID);
    }

    public KettleDatabaseRepositoryMeta(String id, String name, String description, DatabaseMeta connection) {
        super(id, name, description);
        this.databaseMeta = connection;
    }

    public KettleDatabaseRepositoryMeta(String id) {
        super(id, "", "");
        this.databaseMeta = null;
    }

    @Override
    public RepositoryCapabilities getRepositoryCapabilities() {
        return new RepositoryCapabilities(){

            public boolean supportsUsers() {
                return true;
            }

            public boolean managesUsers() {
                return true;
            }

            public boolean isReadOnly() {
                return false;
            }

            public boolean supportsRevisions() {
                return false;
            }

            public boolean supportsMetadata() {
                return true;
            }

            public boolean supportsLocking() {
                return true;
            }

            public boolean hasVersionRegistry() {
                return false;
            }

            public boolean supportsAcls() {
                return false;
            }
        };
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setConnection(DatabaseMeta connection) {
        this.databaseMeta = connection;
    }

    public DatabaseMeta getConnection() {
        return this.databaseMeta;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(100);
        retval.append("  ").append(XMLHandler.openTag((String)"repository"));
        retval.append(super.getXML());
        retval.append("    ").append(XMLHandler.addTagValue((String)"connection", this.databaseMeta != null ? this.databaseMeta.getName() : null));
        retval.append("  ").append(XMLHandler.closeTag((String)"repository"));
        return retval.toString();
    }

    @Override
    public void loadXML(Node repnode, List<DatabaseMeta> databases) throws KettleException {
        super.loadXML(repnode, databases);
        try {
            String conn = XMLHandler.getTagValue((Node)repnode, (String)"connection");
            this.databaseMeta = DatabaseMeta.findDatabase(databases, (String)conn);
        }
        catch (Exception e) {
            throw new KettleException("Unable to load Kettle database repository meta object", (Throwable)e);
        }
    }

    @Override
    public RepositoryMeta clone() {
        return new KettleDatabaseRepositoryMeta(REPOSITORY_TYPE_ID, this.getName(), this.getDescription(), this.getConnection());
    }
}

