/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.kdr.delegates;

import org.pentaho.di.core.Condition;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaAndData;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.repository.LongObjectId;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.kdr.KettleDatabaseRepository;
import org.pentaho.di.repository.kdr.delegates.KettleDatabaseRepositoryBaseDelegate;

public class KettleDatabaseRepositoryConditionDelegate
extends KettleDatabaseRepositoryBaseDelegate {
    public KettleDatabaseRepositoryConditionDelegate(KettleDatabaseRepository repository) {
        super(repository);
    }

    public RowMetaAndData getCondition(ObjectId id_condition) throws KettleException {
        return this.repository.connectionDelegate.getOneRow(this.quoteTable("R_CONDITION"), this.quote("ID_CONDITION"), id_condition);
    }

    public Condition loadCondition(ObjectId id_condition) throws KettleException {
        Condition condition = new Condition();
        try {
            RowMetaAndData r = this.getCondition(id_condition);
            if (r != null) {
                condition.setNegated(r.getBoolean("NEGATED", false));
                condition.setOperator(Condition.getOperator(r.getString("OPERATOR", null)));
                long conditionId = r.getInteger("ID_CONDITION", -1L);
                if (conditionId > 0L) {
                    condition.setObjectId((ObjectId)new LongObjectId(conditionId));
                } else {
                    condition.setObjectId(null);
                }
                ObjectId[] subids = this.repository.getSubConditionIDs(condition.getObjectId());
                if (subids.length == 0) {
                    condition.setLeftValuename(r.getString("LEFT_NAME", null));
                    condition.setFunction(Condition.getFunction(r.getString("CONDITION_FUNCTION", null)));
                    condition.setRightValuename(r.getString("RIGHT_NAME", null));
                    long id_value = r.getInteger("ID_VALUE_RIGHT", -1L);
                    if (id_value > 0L) {
                        ValueMetaAndData v = this.repository.loadValueMetaAndData((ObjectId)new LongObjectId(id_value));
                        condition.setRightExact(v);
                    }
                } else {
                    for (int i = 0; i < subids.length; ++i) {
                        condition.addCondition(this.loadCondition(subids[i]));
                    }
                }
                return condition;
            }
            throw new KettleException("Condition with id_condition=" + id_condition + " could not be found in the repository");
        }
        catch (KettleException dbe) {
            throw new KettleException("Error loading condition from the repository (id_condition=" + id_condition + ")", (Throwable)dbe);
        }
    }

    public ObjectId saveCondition(Condition condition) throws KettleException {
        return this.saveCondition(condition, null);
    }

    public ObjectId saveCondition(Condition condition, ObjectId id_condition_parent) throws KettleException {
        try {
            condition.setObjectId(this.insertCondition(id_condition_parent, condition));
            for (int i = 0; i < condition.nrConditions(); ++i) {
                Condition subc = condition.getCondition(i);
                this.repository.saveCondition(subc, condition.getObjectId());
            }
            return condition.getObjectId();
        }
        catch (KettleException dbe) {
            throw new KettleException("Error saving condition to the repository.", (Throwable)dbe);
        }
    }

    public synchronized ObjectId insertCondition(ObjectId id_condition_parent, Condition condition) throws KettleException {
        ObjectId id = this.repository.connectionDelegate.getNextConditionID();
        String tablename = "R_CONDITION";
        RowMetaAndData table = new RowMetaAndData();
        table.addValue(new ValueMeta("ID_CONDITION", 5), (Object)id);
        table.addValue(new ValueMeta("ID_CONDITION_PARENT", 5), (Object)id_condition_parent);
        table.addValue(new ValueMeta("NEGATED", 4), (Object)condition.isNegated());
        table.addValue(new ValueMeta("OPERATOR", 2), (Object)condition.getOperatorDesc());
        table.addValue(new ValueMeta("LEFT_NAME", 2), (Object)condition.getLeftValuename());
        table.addValue(new ValueMeta("CONDITION_FUNCTION", 2), (Object)condition.getFunctionDesc());
        table.addValue(new ValueMeta("RIGHT_NAME", 2), (Object)condition.getRightValuename());
        ObjectId id_value = null;
        ValueMetaAndData v = condition.getRightExact();
        if (v != null) {
            ValueMetaInterface valueMeta = v.getValueMeta();
            valueMeta.setDecimalSymbol(".");
            valueMeta.setGroupingSymbol(",");
            switch (valueMeta.getType()) {
                case 1: {
                    valueMeta.setConversionMask("#.#");
                    break;
                }
                case 5: {
                    valueMeta.setConversionMask("#");
                    break;
                }
                case 3: {
                    valueMeta.setConversionMask("yyyy/MM/dd HH:mm:ss.SSS");
                    break;
                }
            }
            String stringValue = valueMeta.getString(v.getValueData());
            id_value = this.insertValue(valueMeta.getName(), valueMeta.getTypeDesc(), stringValue, valueMeta.isNull(v.getValueData()), condition.getRightExactID());
            condition.setRightExactID(id_value);
        }
        table.addValue(new ValueMeta("ID_VALUE_RIGHT", 5), id_value);
        this.repository.connectionDelegate.getDatabase().prepareInsert(table.getRowMeta(), tablename);
        this.repository.connectionDelegate.getDatabase().setValuesInsert(table);
        this.repository.connectionDelegate.getDatabase().insertRow();
        this.repository.connectionDelegate.getDatabase().closeInsert();
        return id;
    }

    public synchronized ObjectId insertValue(String name, String type, String value_str, boolean isnull, ObjectId id_value_prev) throws KettleException {
        ObjectId id_value = this.lookupValue(name, type, value_str, isnull);
        if (id_value == null) {
            id_value = this.repository.connectionDelegate.getNextValueID();
            String tablename = "R_VALUE";
            RowMetaAndData table = new RowMetaAndData();
            table.addValue(new ValueMeta("ID_VALUE", 5), (Object)id_value);
            table.addValue(new ValueMeta("NAME", 2), (Object)name);
            table.addValue(new ValueMeta("VALUE_TYPE", 2), (Object)type);
            table.addValue(new ValueMeta("VALUE_STR", 2), (Object)value_str);
            table.addValue(new ValueMeta("IS_NULL", 4), (Object)isnull);
            this.repository.connectionDelegate.getDatabase().prepareInsert(table.getRowMeta(), tablename);
            this.repository.connectionDelegate.getDatabase().setValuesInsert(table);
            this.repository.connectionDelegate.getDatabase().insertRow();
            this.repository.connectionDelegate.getDatabase().closeInsert();
        }
        return id_value;
    }

    public synchronized ObjectId lookupValue(String name, String type, String value_str, boolean isnull) throws KettleException {
        RowMetaAndData table = new RowMetaAndData();
        table.addValue(new ValueMeta("NAME", 2), (Object)name);
        table.addValue(new ValueMeta("VALUE_TYPE", 2), (Object)type);
        table.addValue(new ValueMeta("VALUE_STR", 2), (Object)value_str);
        table.addValue(new ValueMeta("IS_NULL", 4), (Object)isnull);
        String sql = "SELECT " + this.quote("ID_VALUE") + " FROM " + this.quoteTable("R_VALUE") + " ";
        sql = sql + "WHERE " + this.quote("NAME") + "       = ? ";
        sql = sql + "AND   " + this.quote("VALUE_TYPE") + " = ? ";
        sql = sql + "AND   " + this.quote("VALUE_STR") + "  = ? ";
        sql = sql + "AND   " + this.quote("IS_NULL") + "    = ? ";
        RowMetaAndData result = this.repository.connectionDelegate.getOneRow(sql, table.getRowMeta(), table.getData());
        if (result != null && result.getData() != null && result.isNumeric(0)) {
            return new LongObjectId(result.getInteger(0, 0L));
        }
        return null;
    }
}

