/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.kdr.delegates;

import java.util.ArrayList;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.LongObjectId;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.RepositoryDirectory;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.kdr.KettleDatabaseRepository;
import org.pentaho.di.repository.kdr.delegates.KettleDatabaseRepositoryBaseDelegate;

public class KettleDatabaseRepositoryDirectoryDelegate
extends KettleDatabaseRepositoryBaseDelegate {
    private static Class<?> PKG = RepositoryDirectory.class;

    public KettleDatabaseRepositoryDirectoryDelegate(KettleDatabaseRepository repository) {
        super(repository);
    }

    public RowMetaAndData getDirectory(ObjectId id_directory) throws KettleException {
        return this.repository.connectionDelegate.getOneRow(this.quoteTable("R_DIRECTORY"), this.quote("ID_DIRECTORY"), id_directory);
    }

    public RepositoryDirectoryInterface loadPathToRoot(ObjectId id_directory) throws KettleException {
        ArrayList<RepositoryDirectory> path = new ArrayList<RepositoryDirectory>();
        ObjectId directoryId = id_directory;
        RowMetaAndData directoryRow = this.getDirectory(directoryId);
        Long parentId = directoryRow.getInteger(1);
        while (parentId != null && parentId >= 0L) {
            RepositoryDirectory directory = new RepositoryDirectory();
            directory.setName(directoryRow.getString(2, null));
            directory.setObjectId(directoryId);
            path.add(directory);
            System.out.println("+ dir '" + directory.getName() + "'");
            directoryId = new LongObjectId(parentId.longValue());
            directoryRow = this.getDirectory(directoryId);
            parentId = directoryRow.getInteger("ID_DIRECTORY_PARENT");
        }
        RepositoryDirectory root = new RepositoryDirectory();
        root.setObjectId((ObjectId)new LongObjectId(0L));
        path.add(root);
        for (int i = 0; i < path.size() - 1; ++i) {
            RepositoryDirectory item = (RepositoryDirectory)path.get(i);
            RepositoryDirectory parent = (RepositoryDirectory)path.get(i + 1);
            item.setParent((RepositoryDirectoryInterface)parent);
            parent.addSubdirectory((RepositoryDirectoryInterface)item);
        }
        RepositoryDirectory repositoryDirectory = (RepositoryDirectory)path.get(0);
        return repositoryDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryDirectoryInterface loadRepositoryDirectoryTree(RepositoryDirectoryInterface root) throws KettleException {
        try {
            KettleDatabaseRepository kettleDatabaseRepository = this.repository;
            synchronized (kettleDatabaseRepository) {
                root.clear();
                ObjectId[] subids = this.repository.getSubDirectoryIDs(root.getObjectId());
                for (int i = 0; i < subids.length; ++i) {
                    RepositoryDirectory subdir = new RepositoryDirectory();
                    this.loadRepositoryDirectory(subdir, subids[i]);
                    root.addSubdirectory((RepositoryDirectoryInterface)subdir);
                }
            }
            return root;
        }
        catch (Exception e) {
            throw new KettleException("An error occured loading the directory tree from the repository", (Throwable)e);
        }
    }

    public void loadRepositoryDirectory(RepositoryDirectory repositoryDirectory, ObjectId id_directory) throws KettleException {
        if (id_directory == null) {
            id_directory = new LongObjectId(0L);
        }
        try {
            RowMetaAndData row = this.getDirectory(id_directory);
            if (row != null) {
                repositoryDirectory.setObjectId(id_directory);
                repositoryDirectory.setName(row.getString("DIRECTORY_NAME", null));
                ObjectId[] subids = this.repository.getSubDirectoryIDs(repositoryDirectory.getObjectId());
                for (int i = 0; i < subids.length; ++i) {
                    RepositoryDirectory subdir = new RepositoryDirectory();
                    this.loadRepositoryDirectory(subdir, subids[i]);
                    repositoryDirectory.addSubdirectory((RepositoryDirectoryInterface)subdir);
                }
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"Repository.LoadRepositoryDirectory.ErrorLoading.Exception", (String[])new String[0]), (Throwable)e);
        }
    }

    private synchronized ObjectId insertDirectory(ObjectId id_directory_parent, RepositoryDirectoryInterface dir) throws KettleException {
        ObjectId id = this.repository.connectionDelegate.getNextDirectoryID();
        String tablename = "R_DIRECTORY";
        RowMetaAndData table = new RowMetaAndData();
        table.addValue(new ValueMeta("ID_DIRECTORY", 5), (Object)id);
        table.addValue(new ValueMeta("ID_DIRECTORY_PARENT", 5), (Object)id_directory_parent);
        table.addValue(new ValueMeta("DIRECTORY_NAME", 2), (Object)dir.getName());
        this.repository.connectionDelegate.getDatabase().prepareInsert(table.getRowMeta(), tablename);
        this.repository.connectionDelegate.getDatabase().setValuesInsert(table);
        this.repository.connectionDelegate.getDatabase().insertRow();
        this.repository.connectionDelegate.getDatabase().closeInsert();
        return id;
    }

    public synchronized void deleteDirectory(ObjectId id_directory) throws KettleException {
        this.repository.connectionDelegate.performDelete("DELETE FROM " + this.quoteTable("R_DIRECTORY") + " WHERE " + this.quote("ID_DIRECTORY") + " = ? ", id_directory);
    }

    public synchronized void deleteDirectory(RepositoryDirectoryInterface dir) throws KettleException {
        String[] trans = this.repository.getTransformationNames(dir.getObjectId(), false);
        String[] jobs = this.repository.getJobNames(dir.getObjectId(), false);
        ObjectId[] subDirectories = this.repository.getSubDirectoryIDs(dir.getObjectId());
        if (trans.length == 0 && jobs.length == 0 && subDirectories.length == 0) {
            this.repository.directoryDelegate.deleteDirectory(dir.getObjectId());
        } else {
            this.deleteDirectoryRecursively(dir);
        }
    }

    private synchronized void deleteDirectoryRecursively(RepositoryDirectoryInterface dir) throws KettleException {
        ObjectId id;
        String[] trans = this.repository.getTransformationNames(dir.getObjectId(), false);
        String[] jobs = this.repository.getJobNames(dir.getObjectId(), false);
        for (String transformation : trans) {
            id = this.repository.getTransformationID(transformation, dir);
            this.repository.deleteTransformation(id);
        }
        for (String job : jobs) {
            id = this.repository.getJobId(job, dir);
            this.repository.deleteJob(id);
        }
        for (RepositoryDirectoryInterface subDir : dir.getChildren()) {
            this.deleteDirectoryRecursively((RepositoryDirectoryInterface)((RepositoryDirectory)subDir));
        }
        this.repository.directoryDelegate.deleteDirectory(dir.getObjectId());
    }

    public synchronized void renameDirectory(ObjectId id_directory, ObjectId id_directory_parent, String newName) throws KettleException {
        if (id_directory.equals(id_directory_parent)) {
            throw new KettleException("Failed to copy directory into itself");
        }
        RepositoryDirectory rd = new RepositoryDirectory();
        this.loadRepositoryDirectory(rd, id_directory);
        if (rd.findDirectory(id_directory_parent) != null) {
            throw new KettleException("Directory cannot become a child to itself");
        }
        RepositoryDirectory newParent = new RepositoryDirectory();
        this.loadRepositoryDirectory(newParent, id_directory_parent);
        RepositoryDirectory child = newParent.findChild(newName == null ? rd.getName() : newName);
        if (child != null) {
            throw new KettleException("Destination directory already contains a diectory with requested name");
        }
        if (id_directory_parent != null || newName != null) {
            RowMetaAndData r = new RowMetaAndData();
            String sql = "UPDATE " + this.quoteTable("R_DIRECTORY") + " SET ";
            boolean additionalParameter = false;
            if (newName != null) {
                additionalParameter = true;
                sql = sql + this.quote("DIRECTORY_NAME") + " = ?";
                r.addValue(new ValueMeta("DIRECTORY_NAME", 2), (Object)newName);
            }
            if (id_directory_parent != null) {
                if (additionalParameter) {
                    sql = sql + ", ";
                }
                sql = sql + this.quote("ID_DIRECTORY_PARENT") + " = ?";
                r.addValue(new ValueMeta("ID_DIRECTORY_PARENT", 5), (Object)id_directory_parent);
            }
            sql = sql + " WHERE " + this.quote("ID_DIRECTORY") + " = ? ";
            r.addValue(new ValueMeta("id_directory", 5), (Object)Long.valueOf(id_directory.toString()));
            this.repository.connectionDelegate.getDatabase().execStatement(sql, r.getRowMeta(), r.getData());
        }
    }

    public synchronized int getNrSubDirectories(ObjectId id_directory) throws KettleException {
        int retval = 0;
        RowMetaAndData dirParRow = this.repository.connectionDelegate.getParameterMetaData(id_directory);
        String sql = "SELECT COUNT(*) FROM " + this.quoteTable("R_DIRECTORY") + " WHERE " + this.quote("ID_DIRECTORY_PARENT") + " = ? ";
        RowMetaAndData r = this.repository.connectionDelegate.getOneRow(sql, dirParRow.getRowMeta(), dirParRow.getData());
        if (r != null) {
            retval = (int)r.getInteger(0, 0L);
        }
        return retval;
    }

    public synchronized ObjectId[] getSubDirectoryIDs(ObjectId id_directory) throws KettleException {
        return this.repository.connectionDelegate.getIDs("SELECT " + this.quote("ID_DIRECTORY") + " FROM " + this.quoteTable("R_DIRECTORY") + " WHERE " + this.quote("ID_DIRECTORY_PARENT") + " = ? ORDER BY " + this.quote("DIRECTORY_NAME"), id_directory);
    }

    public void saveRepositoryDirectory(RepositoryDirectoryInterface dir) throws KettleException {
        try {
            ObjectId id_directory_parent = null;
            if (dir.getParent() != null) {
                id_directory_parent = dir.getParent().getObjectId();
            }
            dir.setObjectId(this.insertDirectory(id_directory_parent, dir));
            this.log.logDetailed("New id of directory = " + dir.getObjectId());
            this.repository.commit();
        }
        catch (Exception e) {
            throw new KettleException("Unable to save directory [" + dir + "] in the repository", (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void delRepositoryDirectory(RepositoryDirectoryInterface dir, boolean deleteNonEmptyFolder) throws KettleException {
        try {
            if (!deleteNonEmptyFolder) {
                String[] trans = this.repository.getTransformationNames(dir.getObjectId(), false);
                String[] jobs = this.repository.getJobNames(dir.getObjectId(), false);
                ObjectId[] subDirectories = this.repository.getSubDirectoryIDs(dir.getObjectId());
                if (trans.length != 0 || jobs.length != 0 || subDirectories.length != 0) throw new KettleException("This directory is not empty!");
                this.repository.directoryDelegate.deleteDirectory(dir.getObjectId());
                this.repository.commit();
                return;
            } else {
                this.repository.directoryDelegate.deleteDirectory(dir);
                this.repository.commit();
            }
            return;
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error deleting repository directory:", (Throwable)e);
        }
    }

    @Deprecated
    public ObjectId renameRepositoryDirectory(RepositoryDirectory dir) throws KettleException {
        try {
            this.renameDirectory(dir.getObjectId(), null, dir.getName());
            return dir.getObjectId();
        }
        catch (Exception e) {
            throw new KettleException("Unable to rename the specified repository directory [" + dir + "]", (Throwable)e);
        }
    }

    public ObjectId renameRepositoryDirectory(ObjectId id, RepositoryDirectoryInterface newParentDir, String newName) throws KettleException {
        ObjectId parentId = null;
        if (newParentDir != null) {
            parentId = newParentDir.getObjectId();
        }
        try {
            this.renameDirectory(id, parentId, newName);
            return id;
        }
        catch (Exception e) {
            throw new KettleException("Unable to rename the specified repository directory [" + id + "]", (Throwable)e);
        }
    }

    public RepositoryDirectoryInterface createRepositoryDirectory(RepositoryDirectoryInterface parentDirectory, String directoryPath) throws KettleException {
        RepositoryDirectoryInterface refreshedParentDir = parentDirectory;
        String[] path = Const.splitPath((String)directoryPath, (String)"/");
        RepositoryDirectoryInterface parent = refreshedParentDir;
        for (int level = 0; level < path.length; ++level) {
            RepositoryDirectoryInterface rd = parent.findChild(path[level]);
            if (rd == null) {
                rd = new RepositoryDirectory(parent, path[level]);
                this.saveRepositoryDirectory(rd);
                parent.addSubdirectory(rd);
                parent = rd;
                continue;
            }
            parent = rd;
        }
        return parent;
    }
}

