/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.kdr.delegates;

import java.util.List;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.plugins.JobEntryPluginType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryCopy;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.LongObjectId;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.kdr.KettleDatabaseRepository;
import org.pentaho.di.repository.kdr.delegates.KettleDatabaseRepositoryBaseDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KettleDatabaseRepositoryJobEntryDelegate
extends KettleDatabaseRepositoryBaseDelegate {
    public KettleDatabaseRepositoryJobEntryDelegate(KettleDatabaseRepository repository) {
        super(repository);
    }

    public RowMetaAndData getJobEntry(ObjectId id_jobentry) throws KettleException {
        return this.repository.connectionDelegate.getOneRow(this.quoteTable("R_JOBENTRY"), this.quote("ID_JOBENTRY"), id_jobentry);
    }

    public RowMetaAndData getJobEntryCopy(ObjectId id_jobentry_copy) throws KettleException {
        return this.repository.connectionDelegate.getOneRow(this.quoteTable("R_JOBENTRY_COPY"), this.quote("ID_JOBENTRY_COPY"), id_jobentry_copy);
    }

    public RowMetaAndData getJobEntryType(ObjectId id_jobentry_type) throws KettleException {
        return this.repository.connectionDelegate.getOneRow(this.quoteTable("R_JOBENTRY_TYPE"), this.quote("ID_JOBENTRY_TYPE"), id_jobentry_type);
    }

    public synchronized ObjectId getJobEntryID(String name, ObjectId id_job) throws KettleException {
        return this.repository.connectionDelegate.getIDWithValue(this.quoteTable("R_JOBENTRY"), this.quote("ID_JOBENTRY"), this.quote("NAME"), name, this.quote("ID_JOB"), id_job);
    }

    public synchronized ObjectId getJobEntryTypeID(String code) throws KettleException {
        return this.repository.connectionDelegate.getIDWithValue(this.quoteTable("R_JOBENTRY_TYPE"), this.quote("ID_JOBENTRY_TYPE"), this.quote("CODE"), code);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JobEntryCopy loadJobEntryCopy(ObjectId id_job, ObjectId id_jobentry_copy, List<JobEntryInterface> jobentries, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        JobEntryCopy jobEntryCopy = new JobEntryCopy();
        try {
            jobEntryCopy.setObjectId(id_jobentry_copy);
            RowMetaAndData r = this.getJobEntryCopy(id_jobentry_copy);
            if (r == null) throw new KettleException("Unable to find job entry copy in repository with id_jobentry_copy=" + id_jobentry_copy);
            LongObjectId id_jobentry = new LongObjectId(r.getInteger("ID_JOBENTRY", 0L));
            LongObjectId id_jobentry_type = new LongObjectId(r.getInteger("ID_JOBENTRY_TYPE", 0L));
            jobEntryCopy.setNr((int)r.getInteger("NR", 0L));
            int locx = (int)r.getInteger("GUI_LOCATION_X", 0L);
            int locy = (int)r.getInteger("GUI_LOCATION_Y", 0L);
            boolean isdrawn = r.getBoolean("GUI_DRAW", false);
            boolean isparallel = r.getBoolean("PARALLEL", false);
            jobEntryCopy.setEntry(JobMeta.findJobEntry(jobentries, (ObjectId)id_jobentry));
            if (jobEntryCopy.getEntry() == null) {
                RowMetaAndData rt = this.getJobEntryType((ObjectId)new LongObjectId((ObjectId)id_jobentry_type));
                if (rt == null) throw new KettleException("Unable to find Job Entry Type with id=" + id_jobentry_type + " in the repository");
                String jet_code = rt.getString("CODE", null);
                PluginRegistry registry = PluginRegistry.getInstance();
                PluginInterface jobPlugin = registry.findPluginWithId(JobEntryPluginType.class, jet_code);
                if (jobPlugin == null) throw new KettleException("JobEntryLoader was unable to find Job Entry Plugin with description [" + jet_code + "].");
                JobEntryInterface jobEntry = (JobEntryInterface)registry.loadClass(jobPlugin);
                jobEntryCopy.setEntry(jobEntry);
                if (jobEntry instanceof JobEntryBase) {
                    this.loadJobEntryBase((JobEntryBase)((Object)jobEntry), (ObjectId)id_jobentry, databases, slaveServers);
                }
                jobEntry.loadRep(this.repository, (ObjectId)id_jobentry, databases, slaveServers);
                jobEntryCopy.getEntry().setObjectId((ObjectId)id_jobentry);
                jobentries.add(jobEntryCopy.getEntry());
            }
            jobEntryCopy.setLocation(locx, locy);
            jobEntryCopy.setDrawn(isdrawn);
            jobEntryCopy.setLaunchingInParallel(isparallel);
            return jobEntryCopy;
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to load job entry copy from repository with id_jobentry_copy=" + id_jobentry_copy, (Throwable)dbe);
        }
    }

    public void saveJobEntryCopy(JobEntryCopy copy, ObjectId id_job) throws KettleException {
        try {
            ObjectId id_jobentry_type;
            JobEntryInterface entry = copy.getEntry();
            ObjectId id_jobentry = this.getJobEntryID(copy.getName(), id_job);
            if (id_jobentry == null) {
                this.insertJobEntry(id_job, (JobEntryBase)((Object)entry));
                entry.saveRep(this.repository, id_job);
                id_jobentry = entry.getObjectId();
            }
            if ((id_jobentry_type = this.getJobEntryTypeID(entry.getPluginId())) == null) {
                this.repository.updateJobEntryTypes();
                id_jobentry_type = this.getJobEntryTypeID(entry.getPluginId());
            }
            copy.setObjectId(this.insertJobEntryCopy(id_job, id_jobentry, id_jobentry_type, copy.getNr(), copy.getLocation().x, copy.getLocation().y, copy.isDrawn(), copy.isLaunchingInParallel()));
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to save job entry copy to the repository, id_job=" + id_job, (Throwable)dbe);
        }
    }

    public synchronized ObjectId insertJobEntry(ObjectId id_job, JobEntryBase jobEntryBase) throws KettleException {
        ObjectId id = this.repository.connectionDelegate.getNextJobEntryID();
        ObjectId id_jobentry_type = this.getJobEntryTypeID(jobEntryBase.getPluginId());
        this.log.logDebug("ID_JobEntry_type = " + id_jobentry_type + " for type = [" + jobEntryBase.getPluginId() + "]");
        RowMetaAndData table = new RowMetaAndData();
        table.addValue(new ValueMeta("ID_JOBENTRY", 5), (Object)id);
        table.addValue(new ValueMeta("ID_JOB", 5), (Object)id_job);
        table.addValue(new ValueMeta("ID_JOBENTRY_TYPE", 5), (Object)id_jobentry_type);
        table.addValue(new ValueMeta("NAME", 2), (Object)jobEntryBase.getName());
        table.addValue(new ValueMeta("DESCRIPTION", 2), (Object)jobEntryBase.getDescription());
        this.repository.connectionDelegate.getDatabase().prepareInsert(table.getRowMeta(), "R_JOBENTRY");
        this.repository.connectionDelegate.getDatabase().setValuesInsert(table);
        this.repository.connectionDelegate.getDatabase().insertRow();
        this.repository.connectionDelegate.getDatabase().closeInsert();
        jobEntryBase.setObjectId(id);
        return id;
    }

    public synchronized ObjectId insertJobEntryCopy(ObjectId id_job, ObjectId id_jobentry, ObjectId id_jobentry_type, int nr, long gui_location_x, long gui_location_y, boolean gui_draw, boolean parallel) throws KettleException {
        LongObjectId id = this.repository.connectionDelegate.getNextJobEntryCopyID();
        RowMetaAndData table = new RowMetaAndData();
        table.addValue(new ValueMeta("ID_JOBENTRY_COPY", 5), (Object)id);
        table.addValue(new ValueMeta("ID_JOBENTRY", 5), (Object)id_jobentry);
        table.addValue(new ValueMeta("ID_JOB", 5), (Object)id_job);
        table.addValue(new ValueMeta("ID_JOBENTRY_TYPE", 5), (Object)id_jobentry_type);
        table.addValue(new ValueMeta("NR", 5), (Object)new Long(nr));
        table.addValue(new ValueMeta("GUI_LOCATION_X", 5), (Object)new Long(gui_location_x));
        table.addValue(new ValueMeta("GUI_LOCATION_Y", 5), (Object)new Long(gui_location_y));
        table.addValue(new ValueMeta("GUI_DRAW", 4), (Object)gui_draw);
        table.addValue(new ValueMeta("PARALLEL", 4), (Object)parallel);
        this.repository.connectionDelegate.getDatabase().prepareInsert(table.getRowMeta(), "R_JOBENTRY_COPY");
        this.repository.connectionDelegate.getDatabase().setValuesInsert(table);
        this.repository.connectionDelegate.getDatabase().insertRow();
        this.repository.connectionDelegate.getDatabase().closeInsert();
        return id;
    }

    public synchronized int getNrJobEntries(ObjectId id_job) throws KettleException {
        int retval = 0;
        RowMetaAndData par = this.repository.connectionDelegate.getParameterMetaData(id_job);
        String sql = "SELECT COUNT(*) FROM " + this.quoteTable("R_JOBENTRY") + " WHERE " + this.quote("ID_JOB") + " = ? ";
        RowMetaAndData r = this.repository.connectionDelegate.getOneRow(sql, par.getRowMeta(), par.getData());
        if (r != null) {
            retval = (int)r.getInteger(0, 0L);
        }
        return retval;
    }

    public void loadJobEntryBase(JobEntryBase jobEntryBase, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            RowMetaAndData r = this.getJobEntry(id_jobentry);
            if (r != null) {
                jobEntryBase.setName(r.getString("NAME", null));
                jobEntryBase.setDescription(r.getString("DESCRIPTION", null));
                long id_jobentry_type = r.getInteger("ID_JOBENTRY_TYPE", 0L);
                RowMetaAndData jetrow = this.getJobEntryType((ObjectId)new LongObjectId(id_jobentry_type));
                if (jetrow != null) {
                    jobEntryBase.setPluginId(jetrow.getString("CODE", null));
                }
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to load base job entry information from the repository for id_jobentry=" + id_jobentry, (Throwable)dbe);
        }
    }
}

