/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.kdr.delegates;

import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleAuthException;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.IUser;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.RepositoryElementInterface;
import org.pentaho.di.repository.UserInfo;
import org.pentaho.di.repository.kdr.KettleDatabaseRepository;
import org.pentaho.di.repository.kdr.delegates.KettleDatabaseRepositoryBaseDelegate;

public class KettleDatabaseRepositoryUserDelegate
extends KettleDatabaseRepositoryBaseDelegate {
    private static Class<?> PKG = UserInfo.class;

    public KettleDatabaseRepositoryUserDelegate(KettleDatabaseRepository repository) {
        super(repository);
    }

    public RowMetaAndData getUser(ObjectId id_user) throws KettleException {
        return this.repository.connectionDelegate.getOneRow(this.quoteTable("R_USER"), this.quote("ID_USER"), id_user);
    }

    public synchronized ObjectId getUserID(String login) throws KettleException {
        return this.repository.connectionDelegate.getIDWithValue(this.quoteTable("R_USER"), this.quote("ID_USER"), this.quote("LOGIN"), login);
    }

    public IUser loadUserInfo(IUser userInfo, String login) throws KettleException {
        try {
            userInfo.setObjectId(this.getUserID(login));
            if (userInfo.getObjectId() != null) {
                RowMetaAndData r = this.getUser(userInfo.getObjectId());
                if (r != null) {
                    userInfo.setLogin(r.getString("LOGIN", null));
                    userInfo.setPassword(Encr.decryptPassword((String)r.getString("PASSWORD", null)));
                    userInfo.setUsername(r.getString("NAME", null));
                    userInfo.setDescription(r.getString("DESCRIPTION", null));
                    userInfo.setEnabled(r.getBoolean("ENABLED", false));
                    return userInfo;
                }
                throw new KettleDatabaseException(BaseMessages.getString(PKG, (String)"UserInfo.Error.UserNotFound", (String[])new String[]{login}));
            }
            throw new KettleDatabaseException(BaseMessages.getString(PKG, (String)"UserInfo.Error.UserNotFound", (String[])new String[]{login}));
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"UserInfo.Error.UserNotLoaded", (String[])new String[]{login, ""}), (Throwable)dbe);
        }
    }

    public IUser loadUserInfo(IUser userInfo, String login, String passwd) throws KettleException {
        if (userInfo == null || login == null || login.length() <= 0) {
            throw new KettleDatabaseException(BaseMessages.getString(PKG, (String)"UserInfo.Error.IncorrectPasswortLogin", (String[])new String[0]));
        }
        try {
            this.loadUserInfo(userInfo, login);
        }
        catch (KettleException ke) {
            throw new KettleAuthException(BaseMessages.getString(PKG, (String)"UserInfo.Error.IncorrectPasswortLogin", (String[])new String[0]));
        }
        String userPass = Encr.decryptPasswordOptionallyEncrypted((String)passwd);
        if (userInfo.getObjectId() == null || !userInfo.getPassword().equals(userPass)) {
            throw new KettleAuthException(BaseMessages.getString(PKG, (String)"UserInfo.Error.IncorrectPasswortLogin", (String[])new String[0]));
        }
        return userInfo;
    }

    public void saveUserInfo(IUser userInfo) throws KettleException {
        try {
            if (userInfo.getObjectId() == null) {
                userInfo.setObjectId(this.getUserID(userInfo.getLogin()));
            }
            if (userInfo.getObjectId() == null) {
                userInfo.setObjectId(this.repository.connectionDelegate.getNextUserID());
                this.repository.connectionDelegate.insertTableRow("R_USER", this.fillTableRow(userInfo));
            } else {
                this.repository.connectionDelegate.updateTableRow("R_USER", "ID_USER", this.fillTableRow(userInfo));
            }
            this.repository.commit();
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"UserInfo.Error.SavingUser", (String[])new String[]{userInfo.getLogin()}), (Throwable)dbe);
        }
    }

    public RowMetaAndData fillTableRow(IUser userInfo) {
        RowMetaAndData r = new RowMetaAndData();
        r.addValue(new ValueMeta("ID_USER", 5), (Object)userInfo.getObjectId());
        r.addValue(new ValueMeta("LOGIN", 2), (Object)userInfo.getLogin());
        r.addValue(new ValueMeta("PASSWORD", 2), (Object)Encr.encryptPassword((String)userInfo.getPassword()));
        r.addValue(new ValueMeta("NAME", 2), (Object)userInfo.getUsername());
        r.addValue(new ValueMeta("DESCRIPTION", 2), (Object)userInfo.getDescription());
        r.addValue(new ValueMeta("ENABLED", 4), (Object)userInfo.isEnabled());
        return r;
    }

    public synchronized int getNrUsers() throws KettleException {
        int retval = 0;
        String sql = "SELECT COUNT(*) FROM " + this.quoteTable("R_USER");
        RowMetaAndData r = this.repository.connectionDelegate.getOneRow(sql);
        if (r != null) {
            retval = (int)r.getInteger(0, 0L);
        }
        return retval;
    }

    public boolean existsUserInfo(RepositoryElementInterface user) throws KettleException {
        return user.getObjectId() != null || this.getUserID(user.getName()) != null;
    }

    public synchronized void renameUser(ObjectId id_user, String newname) throws KettleException {
        String sql = "UPDATE " + this.quoteTable("R_USER") + " SET " + this.quote("NAME") + " = ? WHERE " + this.quote("ID_USER") + " = ?";
        RowMetaAndData table = new RowMetaAndData();
        table.addValue(new ValueMeta("NAME", 2), (Object)newname);
        table.addValue(new ValueMeta("ID_USER", 5), (Object)id_user);
        this.repository.connectionDelegate.getDatabase().execStatement(sql, table.getRowMeta(), table.getData());
    }
}

