/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMetaDataCombi;
import org.pentaho.di.trans.step.errorhandling.StreamInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleThreadedTransExecutor {
    private Trans trans;
    private List<StepMetaDataCombi> steps;
    private boolean[] done;
    private int nrDone;
    private List<List<StreamInterface>> stepInfoStreams;
    private List<List<RowSet>> stepInfoRowSets;
    private LogChannelInterface log;

    public SingleThreadedTransExecutor(Trans trans) {
        this.trans = trans;
        this.log = trans.getLogChannel();
        this.steps = trans.getSteps();
        for (StepMetaDataCombi combi : this.steps) {
            combi.step.setUsingThreadPriorityManagment(false);
        }
        this.sortSteps();
        this.done = new boolean[this.steps.size()];
        this.nrDone = 0;
        this.stepInfoStreams = new ArrayList<List<StreamInterface>>();
        this.stepInfoRowSets = new ArrayList<List<RowSet>>();
        for (StepMetaDataCombi combi : this.steps) {
            List<StreamInterface> infoStreams = combi.stepMeta.getStepMetaInterface().getStepIOMeta().getInfoStreams();
            this.stepInfoStreams.add(infoStreams);
            ArrayList<RowSet> infoRowSets = new ArrayList<RowSet>();
            for (StreamInterface infoStream : infoStreams) {
                RowSet infoRowSet = trans.findRowSet(infoStream.getStepname(), 0, combi.stepname, 0);
                if (infoRowSet == null) continue;
                infoRowSets.add(infoRowSet);
            }
            this.stepInfoRowSets.add(infoRowSets);
        }
    }

    private void sortSteps() {
        this.trans.getTransMeta().clearCaches();
        boolean testing = true;
        int stepsMinSize = 0;
        int stepsSize = this.steps.size();
        int windowShrinkThreshold = (int)Math.round((double)stepsSize * 0.75);
        int totalIterations = stepsSize * 2;
        int actualIterations = 0;
        boolean isBefore = false;
        boolean forwardChange = false;
        boolean backwardChange = false;
        boolean lastForwardChange = true;
        boolean keepSortingForward = true;
        StepMetaDataCombi one = null;
        StepMetaDataCombi two = null;
        StringBuilder tLogString = new StringBuilder();
        tLogString.append("-------------------------------------------------------").append("\n");
        tLogString.append("--SingleThreadedTransExecutor.sortSteps(cocktail)").append("\n");
        tLogString.append("--Trans: ").append(this.trans.getName()).append("\n");
        tLogString.append("-").append("\n");
        long startTime = System.currentTimeMillis();
        for (int x = 0; x < totalIterations; ++x) {
            if (keepSortingForward) {
                for (int y = stepsMinSize; y < stepsSize - 1; ++y) {
                    one = this.steps.get(y);
                    two = this.steps.get(y + 1);
                    isBefore = this.trans.getTransMeta().findPrevious(one.stepMeta, two.stepMeta);
                    if (!isBefore) continue;
                    this.steps.set(y, two);
                    this.steps.set(y + 1, one);
                    forwardChange = true;
                }
            }
            for (int z = stepsSize - 1; z > stepsMinSize; --z) {
                one = this.steps.get(z);
                two = this.steps.get(z - 1);
                isBefore = this.trans.getTransMeta().findPrevious(one.stepMeta, two.stepMeta);
                if (isBefore) continue;
                this.steps.set(z, two);
                this.steps.set(z - 1, one);
                backwardChange = true;
            }
            if (x > windowShrinkThreshold && !forwardChange && --stepsSize <= stepsMinSize) {
                if (!testing) break;
                tLogString.append(String.format("stepsMinSize:%s  stepsSize:%s", stepsMinSize, stepsSize));
                tLogString.append("stepsSize is <= stepsMinSize.. exiting outer sort loop. index:" + x).append("\n");
                break;
            }
            if (x > windowShrinkThreshold && !backwardChange && ++stepsMinSize >= stepsSize) {
                if (!testing) break;
                tLogString.append(String.format("stepsMinSize:%s  stepsSize:%s", stepsMinSize, stepsSize)).append("\n");
                tLogString.append("stepsMinSize is >= stepsSize.. exiting outer sort loop. index:" + x).append("\n");
                break;
            }
            ++actualIterations;
            if (!forwardChange && !backwardChange) {
                if (!testing) break;
                tLogString.append(String.format("existing outer loop because no change was detected going forward or backward. index:%s  min:%s  max:%s", x, stepsMinSize, stepsSize)).append("\n");
                break;
            }
            if (keepSortingForward && x > 0 && !lastForwardChange && !forwardChange) {
                keepSortingForward = false;
            }
            lastForwardChange = forwardChange;
            forwardChange = false;
            backwardChange = false;
        }
        long endTime = System.currentTimeMillis();
        long totalTime = endTime - startTime;
        tLogString.append("-------------------------------------------------------").append("\n");
        tLogString.append("Steps sort time: " + totalTime + "ms").append("\n");
        tLogString.append("Total iterations: " + actualIterations).append("\n");
        tLogString.append("Step count: " + this.steps.size()).append("\n");
        tLogString.append("Steps after sort: ").append("\n");
        for (StepMetaDataCombi combi : this.steps) {
            tLogString.append(combi.step.getStepname()).append("\n");
        }
        tLogString.append("-------------------------------------------------------").append("\n");
        if (this.log.isDetailed()) {
            this.log.logDetailed(tLogString.toString());
        }
    }

    public boolean init() throws KettleException {
        for (StepMetaDataCombi combi : this.steps) {
            TransMeta.TransformationType[] types = combi.stepMeta.getStepMetaInterface().getSupportedTransformationTypes();
            boolean ok = false;
            for (TransMeta.TransformationType type : types) {
                if (type != TransMeta.TransformationType.SingleThreaded) continue;
                ok = true;
            }
            if (ok) continue;
            throw new KettleException("Step '" + combi.stepname + "' of type '" + combi.stepMeta.getStepID() + "' is not yet supported in a Single Threaded transformation engine.");
        }
        for (StepMetaDataCombi combi : this.steps) {
            boolean ok = combi.step.init(combi.meta, combi.data);
            if (ok) continue;
            return false;
        }
        return true;
    }

    public boolean oneIteration() throws KettleException {
        for (int s = 0; s < this.steps.size() && !this.trans.isStopped(); ++s) {
            if (this.done[s]) continue;
            StepMetaDataCombi combi = this.steps.get(s);
            boolean stepDone = false;
            List<RowSet> infoRowSets = this.stepInfoRowSets.get(s);
            for (RowSet rowSet : infoRowSets) {
                boolean once = true;
                while (once || rowSet.size() > 0 && !stepDone) {
                    once = false;
                    boolean bl = stepDone = !combi.step.processRow(combi.meta, combi.data);
                    if (combi.step.getErrors() <= 0L) continue;
                    return false;
                }
            }
            List<RowSet> rowSets = combi.step.getInputRowSets();
            if (rowSets.size() == 0) {
                while (!stepDone && !this.trans.isStopped()) {
                    boolean bl = stepDone = !combi.step.processRow(combi.meta, combi.data);
                    if (combi.step.getErrors() <= 0L) continue;
                    return false;
                }
            } else {
                int nrRows = 0;
                for (RowSet rowSet : rowSets) {
                    nrRows += rowSet.size();
                }
                for (int i = 0; i < nrRows; ++i) {
                    boolean bl = stepDone = !combi.step.processRow(combi.meta, combi.data);
                    if (combi.step.getErrors() <= 0L) continue;
                    return false;
                }
            }
            combi.step.batchComplete();
            if (stepDone) {
                ++this.nrDone;
            }
            this.done[s] = stepDone;
        }
        return this.nrDone < this.steps.size() && !this.trans.isStopped();
    }

    protected int getTotalRows(List<RowSet> rowSets) {
        int total = 0;
        for (RowSet rowSet : rowSets) {
            total += rowSet.size();
        }
        return total;
    }

    public long getErrors() {
        return this.trans.getErrors();
    }

    public Result getResult() {
        return this.trans.getResult();
    }

    public boolean isStopped() {
        return this.trans.isStopped();
    }

    public void dispose() throws KettleException {
        for (StepMetaDataCombi combi : this.trans.getSteps()) {
            combi.step.setOutputDone();
        }
        for (StepMetaDataCombi combi : this.steps) {
            combi.step.dispose(combi.meta, combi.data);
            combi.step.markStop();
        }
    }
}

