/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.abort;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.abort.AbortMeta;

public class Abort
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = Abort.class;
    private AbortMeta meta;
    private int nrInputRows;
    private int nrThresholdRows;

    public Abort(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (AbortMeta)smi;
        if (super.init(smi, sdi)) {
            this.nrInputRows = 0;
            String threshold = this.environmentSubstitute(this.meta.getRowThreshold());
            this.nrThresholdRows = Const.toInt((String)threshold, (int)-1);
            if (this.nrThresholdRows < 0) {
                this.logError(BaseMessages.getString(PKG, (String)"Abort.Log.ThresholdInvalid", (String[])new String[]{threshold}));
            }
            return true;
        }
        return false;
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (AbortMeta)smi;
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        this.putRow(this.getInputRowMeta(), r);
        ++this.nrInputRows;
        if (this.nrInputRows > this.nrThresholdRows) {
            this.logError(BaseMessages.getString(PKG, (String)"Abort.Log.Wrote.AbortRow", (String[])new String[]{Long.toString(this.nrInputRows), this.getInputRowMeta().getString(r)}));
            String message = this.environmentSubstitute(this.meta.getMessage());
            if (message == null || message.length() == 0) {
                this.logError(BaseMessages.getString(PKG, (String)"Abort.Log.DefaultAbortMessage", (String[])new String[]{"" + this.nrInputRows}));
            } else {
                this.logError(message);
            }
            this.setErrors(1L);
            this.stopAll();
        } else if (this.meta.isAlwaysLogRows()) {
            this.logMinimal(BaseMessages.getString(PKG, (String)"Abort.Log.Wrote.Row", (String[])new String[]{Long.toString(this.nrInputRows), this.getInputRowMeta().getString(r)}));
        } else if (this.log.isRowLevel()) {
            this.logRowlevel(BaseMessages.getString(PKG, (String)"Abort.Log.Wrote.Row", (String[])new String[]{Long.toString(this.nrInputRows), this.getInputRowMeta().getString(r)}));
        }
        return true;
    }
}

