/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.aggregaterows;

import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.aggregaterows.AggregateRowsData;
import org.pentaho.di.trans.steps.aggregaterows.AggregateRowsMeta;

public class AggregateRows
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = AggregateRows.class;
    private AggregateRowsMeta meta;
    private AggregateRowsData data;

    public AggregateRows(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private synchronized void AddAggregate(RowMetaInterface rowMeta, Object[] r) throws KettleValueException {
        block11: for (int i = 0; i < this.data.fieldnrs.length; ++i) {
            Object valueData;
            ValueMetaInterface valueMeta = rowMeta.getValueMeta(this.data.fieldnrs[i]);
            if (!valueMeta.isNull(valueData = r[this.data.fieldnrs[i]])) {
                int n = i;
                this.data.counts[n] = this.data.counts[n] + 1L;
                switch (this.meta.getAggregateType()[i]) {
                    case 1: 
                    case 2: {
                        Double number = valueMeta.getNumber(valueData);
                        if (this.data.values[i] == null) {
                            this.data.values[i] = number;
                            break;
                        }
                        this.data.values[i] = new Double((Double)this.data.values[i] + number);
                        break;
                    }
                    case 4: {
                        if (this.data.values[i] == null) {
                            this.data.values[i] = valueData;
                            break;
                        }
                        if (valueMeta.compare(this.data.values[i], valueData) >= 0) break;
                        this.data.values[i] = valueData;
                        break;
                    }
                    case 5: {
                        if (this.data.values[i] == null) {
                            this.data.values[i] = valueData;
                            break;
                        }
                        if (valueMeta.compare(this.data.values[i], valueData) <= 0) break;
                        this.data.values[i] = valueData;
                        break;
                    }
                    case 0: 
                    case 6: {
                        if (this.data.values[i] != null) break;
                        this.data.values[i] = valueData;
                        break;
                    }
                    case 7: {
                        this.data.values[i] = valueData;
                    }
                }
            }
            switch (this.meta.getAggregateType()[i]) {
                case 8: {
                    if (this.data.values[i] != null) continue block11;
                    this.data.values[i] = valueData;
                    continue block11;
                }
                case 9: {
                    this.data.values[i] = valueData;
                    continue block11;
                }
            }
        }
    }

    private synchronized Object[] buildAggregate() {
        Object[] agg = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
        block5: for (int i = 0; i < this.data.fieldnrs.length; ++i) {
            switch (this.meta.getAggregateType()[i]) {
                case 0: 
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    agg[i] = this.data.values[i];
                    continue block5;
                }
                case 3: {
                    agg[i] = new Double(this.data.counts[i]);
                    continue block5;
                }
                case 2: {
                    agg[i] = new Double((Double)this.data.values[i] / (double)this.data.counts[i]);
                    continue block5;
                }
            }
        }
        return agg;
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (AggregateRowsMeta)smi;
        this.data = (AggregateRowsData)sdi;
        Object[] r = this.getRow();
        if (r == null) {
            Object[] agg = this.buildAggregate();
            this.putRow(this.data.outputRowMeta, agg);
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.data.outputRowMeta = this.getInputRowMeta().clone();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
            for (int i = 0; i < this.meta.getFieldName().length; ++i) {
                this.data.fieldnrs[i] = this.getInputRowMeta().indexOfValue(this.meta.getFieldName()[i]);
                if (this.data.fieldnrs[i] < 0) {
                    this.logError(BaseMessages.getString(PKG, (String)"AggregateRows.Log.CouldNotFindField", (String[])new String[]{this.meta.getFieldName()[i]}));
                    this.setErrors(1L);
                    this.stopAll();
                    return false;
                }
                this.data.counts[i] = 0L;
            }
        }
        this.AddAggregate(this.getInputRowMeta(), r);
        if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"AggregateRows.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
        }
        return true;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (AggregateRowsMeta)smi;
        this.data = (AggregateRowsData)sdi;
        if (super.init(smi, sdi)) {
            int nrfields = this.meta.getFieldName().length;
            this.data.fieldnrs = new int[nrfields];
            this.data.values = new Object[nrfields];
            this.data.counts = new long[nrfields];
            return true;
        }
        return false;
    }
}

