/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.append;

import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepIOMeta;
import org.pentaho.di.trans.step.StepIOMetaInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.errorhandling.Stream;
import org.pentaho.di.trans.step.errorhandling.StreamIcon;
import org.pentaho.di.trans.step.errorhandling.StreamInterface;
import org.pentaho.di.trans.steps.append.Append;
import org.pentaho.di.trans.steps.append.AppendData;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppendMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = Append.class;

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        AppendMeta retval = (AppendMeta)super.clone();
        return retval;
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder();
        List<StreamInterface> infoStreams = this.getStepIOMeta().getInfoStreams();
        retval.append(XMLHandler.addTagValue((String)"head_name", (String)infoStreams.get(0).getStepname()));
        retval.append(XMLHandler.addTagValue((String)"tail_name", (String)infoStreams.get(1).getStepname()));
        return retval.toString();
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            List<StreamInterface> infoStreams = this.getStepIOMeta().getInfoStreams();
            StreamInterface headStream = infoStreams.get(0);
            StreamInterface tailStream = infoStreams.get(1);
            headStream.setSubject(XMLHandler.getTagValue((Node)stepnode, (String)"head_name"));
            tailStream.setSubject(XMLHandler.getTagValue((Node)stepnode, (String)"tail_name"));
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"AppendMeta.Exception.UnableToLoadStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
    }

    @Override
    public void readRep(Repository rep, ObjectId id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            List<StreamInterface> infoStreams = this.getStepIOMeta().getInfoStreams();
            StreamInterface headStream = infoStreams.get(0);
            StreamInterface tailStream = infoStreams.get(1);
            headStream.setSubject(rep.getStepAttributeString(id_step, "head_name"));
            tailStream.setSubject(rep.getStepAttributeString(id_step, "tail_name"));
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"AppendMeta.Exception.UnexpectedErrorReadingStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            List<StreamInterface> infoStreams = this.getStepIOMeta().getInfoStreams();
            StreamInterface headStream = infoStreams.get(0);
            StreamInterface tailStream = infoStreams.get(1);
            rep.saveStepAttribute(id_transformation, id_step, "head_name", headStream.getStepname());
            rep.saveStepAttribute(id_transformation, id_step, "tail_name", tailStream.getStepname());
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"AppendMeta.Exception.UnableToSaveStepInfo", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    @Override
    public void searchInfoAndTargetSteps(List<StepMeta> steps) {
        for (StreamInterface stream : this.getStepIOMeta().getInfoStreams()) {
            stream.setStepMeta(StepMeta.findStep(steps, (String)stream.getSubject()));
        }
    }

    public boolean chosesTargetSteps() {
        return false;
    }

    public String[] getTargetSteps() {
        return null;
    }

    @Override
    public void getFields(RowMetaInterface r, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        if (info != null && info.length > 0 && info[0] != null) {
            r.mergeRowMeta(info[0]);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        List<StreamInterface> infoStreams = this.getStepIOMeta().getInfoStreams();
        StreamInterface headStream = infoStreams.get(0);
        StreamInterface tailStream = infoStreams.get(1);
        if (headStream.getStepname() != null && tailStream.getStepname() != null) {
            CheckResult cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"AppendMeta.CheckResult.SourceStepsOK", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else if (headStream.getStepname() == null && tailStream.getStepname() == null) {
            CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"AppendMeta.CheckResult.SourceStepsMissing", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            CheckResult cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"AppendMeta.CheckResult.OneSourceStepMissing", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new Append(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new AppendData();
    }

    @Override
    public StepIOMetaInterface getStepIOMeta() {
        if (this.ioMeta == null) {
            this.ioMeta = new StepIOMeta(true, true, false, false, false, false);
            this.ioMeta.addStream(new Stream(StreamInterface.StreamType.INFO, null, BaseMessages.getString(PKG, (String)"AppendMeta.InfoStream.FirstStream.Description", (String[])new String[0]), StreamIcon.INFO, null));
            this.ioMeta.addStream(new Stream(StreamInterface.StreamType.INFO, null, BaseMessages.getString(PKG, (String)"AppendMeta.InfoStream.SecondStream.Description", (String[])new String[0]), StreamIcon.INFO, null));
        }
        return this.ioMeta;
    }

    @Override
    public void resetStepIoMeta() {
    }

    @Override
    public TransMeta.TransformationType[] getSupportedTransformationTypes() {
        return new TransMeta.TransformationType[]{TransMeta.TransformationType.Normal};
    }
}

