/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.blockingstep;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.blockingstep.BlockingStep;
import org.pentaho.di.trans.steps.blockingstep.BlockingStepData;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockingStepMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = BlockingStepMeta.class;
    private String directory;
    private String prefix;
    private int cacheSize;
    private boolean compressFiles;
    private boolean passAllRows;
    public static final int CACHE_SIZE = 5000;

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr;
        if (prev != null && prev.size() > 0) {
            String realDirectory = transMeta.environmentSubstitute(this.directory);
            File f = new File(realDirectory);
            if (f.exists()) {
                if (f.isDirectory()) {
                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"BlockingStepMeta.CheckResult.DirectoryExists", (String[])new String[]{realDirectory}), (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                } else {
                    cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"BlockingStepMeta.CheckResult.ExistsButNoDirectory", (String[])new String[]{realDirectory}), (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                }
            } else {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"BlockingStepMeta.CheckResult.DirectoryNotExists", (String[])new String[]{realDirectory}), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"BlockingStepMeta.CheckResult.NoFields", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"BlockingStepMeta.CheckResult.StepExpectingRowsFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"BlockingStepMeta.CheckResult.NoInputReceivedError", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public void getFields(RowMetaInterface inputRowMeta, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        return new BlockingStep(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new BlockingStepData();
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode);
    }

    private void readData(Node stepnode) {
        this.passAllRows = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"pass_all_rows"));
        this.directory = XMLHandler.getTagValue((Node)stepnode, (String)"directory");
        this.prefix = XMLHandler.getTagValue((Node)stepnode, (String)"prefix");
        this.cacheSize = Const.toInt((String)XMLHandler.getTagValue((Node)stepnode, (String)"cache_size"), (int)5000);
        this.compressFiles = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"compress"));
    }

    @Override
    public void setDefault() {
        this.passAllRows = false;
        this.directory = "%%java.io.tmpdir%%";
        this.prefix = "block";
        this.cacheSize = 5000;
        this.compressFiles = true;
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder(300);
        retval.append("      ").append(XMLHandler.addTagValue((String)"pass_all_rows", (boolean)this.passAllRows));
        retval.append("      ").append(XMLHandler.addTagValue((String)"directory", (String)this.directory));
        retval.append("      ").append(XMLHandler.addTagValue((String)"prefix", (String)this.prefix));
        retval.append("      ").append(XMLHandler.addTagValue((String)"cache_size", (int)this.cacheSize));
        retval.append("      ").append(XMLHandler.addTagValue((String)"compress", (boolean)this.compressFiles));
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, ObjectId id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            this.passAllRows = rep.getStepAttributeBoolean(id_step, "pass_all_rows");
            this.directory = rep.getStepAttributeString(id_step, "directory");
            this.prefix = rep.getStepAttributeString(id_step, "prefix");
            this.cacheSize = (int)rep.getStepAttributeInteger(id_step, "cache_size");
            this.compressFiles = rep.getStepAttributeBoolean(id_step, "compress");
            if (this.cacheSize == 0) {
                this.cacheSize = 5000;
            }
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "pass_all_rows", this.passAllRows);
            rep.saveStepAttribute(id_transformation, id_step, "directory", this.directory);
            rep.saveStepAttribute(id_transformation, id_step, "prefix", this.prefix);
            rep.saveStepAttribute(id_transformation, id_step, "cache_size", this.cacheSize);
            rep.saveStepAttribute(id_transformation, id_step, "compress", this.compressFiles);
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public boolean getCompress() {
        return this.compressFiles;
    }

    public void setCompress(boolean compressFiles) {
        this.compressFiles = compressFiles;
    }

    public boolean isPassAllRows() {
        return this.passAllRows;
    }

    public void setPassAllRows(boolean passAllRows) {
        this.passAllRows = passAllRows;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    @Override
    public TransMeta.TransformationType[] getSupportedTransformationTypes() {
        return new TransMeta.TransformationType[]{TransMeta.TransformationType.Normal};
    }
}

