/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.dbproc;

import java.sql.SQLException;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.dbproc.DBProcData;
import org.pentaho.di.trans.steps.dbproc.DBProcMeta;

public class DBProc
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = DBProcMeta.class;
    private DBProcMeta meta;
    private DBProcData data;

    public DBProc(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private Object[] runProc(RowMetaInterface rowMeta, Object[] rowData) throws KettleException {
        if (this.first) {
            this.first = false;
            this.data.outputMeta = this.data.inputRowMeta.clone();
            this.meta.getFields(this.data.outputMeta, this.getStepname(), null, null, this);
            this.data.argnrs = new int[this.meta.getArgument().length];
            for (int i = 0; i < this.meta.getArgument().length; ++i) {
                if (!this.meta.getArgumentDirection()[i].equalsIgnoreCase("OUT")) {
                    this.data.argnrs[i] = rowMeta.indexOfValue(this.meta.getArgument()[i]);
                    if (this.data.argnrs[i] >= 0) continue;
                    this.logError(BaseMessages.getString(PKG, (String)"DBProc.Log.ErrorFindingField", (String[])new String[0]) + this.meta.getArgument()[i] + "]");
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"DBProc.Exception.CouldnotFindField", (String[])new String[]{this.meta.getArgument()[i]}));
                }
                this.data.argnrs[i] = -1;
            }
            this.data.db.setProcLookup(this.environmentSubstitute(this.meta.getProcedure()), this.meta.getArgument(), this.meta.getArgumentDirection(), this.meta.getArgumentType(), this.meta.getResultName(), this.meta.getResultType());
        }
        Object[] outputRowData = RowDataUtil.resizeArray((Object[])rowData, (int)this.data.outputMeta.size());
        int outputIndex = rowMeta.size();
        this.data.db.setProcValues(rowMeta, rowData, this.data.argnrs, this.meta.getArgumentDirection(), !Const.isEmpty((String)this.meta.getResultName()));
        RowMetaAndData add = this.data.db.callProcedure(this.meta.getArgument(), this.meta.getArgumentDirection(), this.meta.getArgumentType(), this.meta.getResultName(), this.meta.getResultType());
        int addIndex = 0;
        if (!Const.isEmpty((String)this.meta.getResultName())) {
            outputRowData[outputIndex++] = add.getData()[addIndex++];
        }
        for (int i = 0; i < this.data.argnrs.length; ++i) {
            if (this.meta.getArgumentDirection()[i].equalsIgnoreCase("OUT")) {
                outputRowData[outputIndex++] = add.getData()[addIndex++];
                continue;
            }
            if (!this.meta.getArgumentDirection()[i].equalsIgnoreCase("INOUT")) continue;
            outputRowData[this.data.argnrs[i]] = add.getData()[addIndex];
            ++addIndex;
        }
        return outputRowData;
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block10: {
            Object[] r;
            this.meta = (DBProcMeta)smi;
            this.data = (DBProcData)sdi;
            boolean sendToErrorRow = false;
            String errorMessage = null;
            if (this.data.readsRows) {
                r = this.getRow();
                if (r == null) {
                    this.setOutputDone();
                    return false;
                }
                this.data.inputRowMeta = this.getInputRowMeta();
            } else {
                r = new Object[]{};
                this.incrementLinesRead();
                this.data.inputRowMeta = new RowMeta();
                this.data.readsRows = true;
            }
            try {
                Object[] outputRowData = this.runProc(this.data.inputRowMeta, r);
                this.putRow(this.data.outputMeta, outputRowData);
                if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"DBProc.LineNumber", (String[])new String[0]) + this.getLinesRead());
                }
            }
            catch (KettleException e) {
                if (this.getStepMeta().isDoingErrorHandling()) {
                    sendToErrorRow = true;
                    errorMessage = e.toString();
                    SQLException nextSQLExOnChain = null;
                    if (e.getCause() != null && e.getCause() instanceof SQLException) {
                        for (nextSQLExOnChain = ((SQLException)e.getCause()).getNextException(); nextSQLExOnChain != null; nextSQLExOnChain = nextSQLExOnChain.getNextException()) {
                            errorMessage = errorMessage + nextSQLExOnChain.getMessage() + Const.CR;
                        }
                    }
                } else {
                    this.logError(BaseMessages.getString(PKG, (String)"DBProc.ErrorInStepRunning", (String[])new String[0]) + e.getMessage());
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                if (!sendToErrorRow) break block10;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, null, "DBP001");
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        block12: {
            this.meta = (DBProcMeta)smi;
            this.data = (DBProcData)sdi;
            if (super.init(smi, sdi)) {
                this.data.readsRows = this.getStepMeta().getRemoteInputSteps().size() > 0;
                List<StepMeta> previous = this.getTransMeta().findPreviousSteps(this.getStepMeta());
                if (previous != null && previous.size() > 0) {
                    this.data.readsRows = true;
                }
                this.data.db = new Database((LoggingObjectInterface)this, this.meta.getDatabase());
                this.data.db.shareVariablesWith((VariableSpace)this);
                try {
                    if (this.getTransMeta().isUsingUniqueConnections()) {
                        Trans trans = this.getTrans();
                        synchronized (trans) {
                            this.data.db.connect(this.getTrans().getThreadName(), this.getPartitionID());
                        }
                    } else {
                        this.data.db.connect(this.getPartitionID());
                    }
                    if (!this.meta.isAutoCommit()) {
                        if (this.log.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"DBProc.Log.AutoCommit", (String[])new String[0]));
                        }
                        this.data.db.setCommit(9999);
                    }
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"DBProc.Log.ConnectedToDB", (String[])new String[0]));
                    }
                    return true;
                }
                catch (KettleException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"DBProc.Log.DBException", (String[])new String[0]) + e.getMessage());
                    if (this.data.db == null) break block12;
                    this.data.db.disconnect();
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        block8: {
            this.meta = (DBProcMeta)smi;
            this.data = (DBProcData)sdi;
            if (this.data.db != null) {
                try {
                    this.data.db.closeProcedureStatement();
                }
                catch (KettleDatabaseException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"DBProc.Log.CloseProcedureError", (String[])new String[0]) + e.getMessage());
                }
                try {
                    block7: {
                        try {
                            if (this.meta.isAutoCommit()) break block7;
                            this.data.db.commit();
                        }
                        catch (KettleDatabaseException e) {
                            this.logError(BaseMessages.getString(PKG, (String)"DBProc.Log.CommitError", (String[])new String[0]) + e.getMessage());
                            Object var5_6 = null;
                            this.data.db.disconnect();
                            break block8;
                        }
                    }
                    Object var5_5 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    this.data.db.disconnect();
                    throw throwable;
                }
                this.data.db.disconnect();
            }
        }
        super.dispose(smi, sdi);
    }
}

