/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.denormaliser;

import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInjectionInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.denormaliser.Denormaliser;
import org.pentaho.di.trans.steps.denormaliser.DenormaliserData;
import org.pentaho.di.trans.steps.denormaliser.DenormaliserMetaInjection;
import org.pentaho.di.trans.steps.denormaliser.DenormaliserTargetField;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DenormaliserMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = DenormaliserMeta.class;
    private String[] groupField;
    private String keyField;
    private DenormaliserTargetField[] denormaliserTargetField;

    public String getKeyField() {
        return this.keyField;
    }

    public void setKeyField(String keyField) {
        this.keyField = keyField;
    }

    public String[] getGroupField() {
        return this.groupField;
    }

    public void setGroupField(String[] groupField) {
        this.groupField = groupField;
    }

    public String[] getDenormaliserTargetFields() {
        String[] fields = new String[this.denormaliserTargetField.length];
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = this.denormaliserTargetField[i].getTargetName();
        }
        return fields;
    }

    public DenormaliserTargetField searchTargetField(String targetName) {
        for (int i = 0; i < this.denormaliserTargetField.length; ++i) {
            DenormaliserTargetField field = this.denormaliserTargetField[i];
            if (!field.getTargetName().equalsIgnoreCase(targetName)) continue;
            return field;
        }
        return null;
    }

    public DenormaliserTargetField[] getDenormaliserTargetField() {
        return this.denormaliserTargetField;
    }

    public void setDenormaliserTargetField(DenormaliserTargetField[] pivotField) {
        this.denormaliserTargetField = pivotField;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode);
    }

    public void allocate(int sizegroup, int nrfields) {
        this.groupField = new String[sizegroup];
        this.denormaliserTargetField = new DenormaliserTargetField[nrfields];
    }

    @Override
    public Object clone() {
        Object retval = super.clone();
        return retval;
    }

    @Override
    public void setDefault() {
        int sizegroup = 0;
        int nrfields = 0;
        this.allocate(sizegroup, nrfields);
    }

    @Override
    public void getFields(RowMetaInterface row, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        int i;
        int idx;
        if (this.keyField != null && this.keyField.length() > 0) {
            idx = row.indexOfValue(this.keyField);
            if (idx < 0) {
                throw new KettleStepException(BaseMessages.getString(PKG, (String)"DenormaliserMeta.Exception.UnableToLocateKeyField", (String[])new String[]{this.keyField}));
            }
        } else {
            throw new KettleStepException(BaseMessages.getString(PKG, (String)"DenormaliserMeta.Exception.RequiredKeyField", (String[])new String[0]));
        }
        row.removeValueMeta(idx);
        for (i = 0; i < this.denormaliserTargetField.length; ++i) {
            String fieldname = this.denormaliserTargetField[i].getFieldName();
            if (fieldname != null && fieldname.length() > 0) {
                int idx2 = row.indexOfValue(fieldname);
                if (idx2 < 0) continue;
                row.removeValueMeta(idx2);
                continue;
            }
            throw new KettleStepException(BaseMessages.getString(PKG, (String)"DenormaliserMeta.Exception.RequiredTargetFieldName", (String[])new String[]{i + 1 + ""}));
        }
        for (i = 0; i < this.denormaliserTargetField.length; ++i) {
            DenormaliserTargetField field = this.denormaliserTargetField[i];
            ValueMeta target = new ValueMeta(field.getTargetName(), field.getTargetType());
            target.setLength(field.getTargetLength(), field.getTargetPrecision());
            target.setOrigin(name);
            row.addValueMeta((ValueMetaInterface)target);
        }
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            Node fnode;
            int i;
            this.keyField = XMLHandler.getTagValue((Node)stepnode, (String)"key_field");
            Node groupn = XMLHandler.getSubNode((Node)stepnode, (String)"group");
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int sizegroup = XMLHandler.countNodes((Node)groupn, (String)"field");
            int nrfields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(sizegroup, nrfields);
            for (i = 0; i < sizegroup; ++i) {
                fnode = XMLHandler.getSubNodeByNr((Node)groupn, (String)"field", (int)i);
                this.groupField[i] = XMLHandler.getTagValue((Node)fnode, (String)"name");
            }
            for (i = 0; i < nrfields; ++i) {
                fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.denormaliserTargetField[i] = new DenormaliserTargetField();
                this.denormaliserTargetField[i].setFieldName(XMLHandler.getTagValue((Node)fnode, (String)"field_name"));
                this.denormaliserTargetField[i].setKeyValue(XMLHandler.getTagValue((Node)fnode, (String)"key_value"));
                this.denormaliserTargetField[i].setTargetName(XMLHandler.getTagValue((Node)fnode, (String)"target_name"));
                this.denormaliserTargetField[i].setTargetType(XMLHandler.getTagValue((Node)fnode, (String)"target_type"));
                this.denormaliserTargetField[i].setTargetFormat(XMLHandler.getTagValue((Node)fnode, (String)"target_format"));
                this.denormaliserTargetField[i].setTargetLength(Const.toInt((String)XMLHandler.getTagValue((Node)fnode, (String)"target_length"), (int)-1));
                this.denormaliserTargetField[i].setTargetPrecision(Const.toInt((String)XMLHandler.getTagValue((Node)fnode, (String)"target_precision"), (int)-1));
                this.denormaliserTargetField[i].setTargetDecimalSymbol(XMLHandler.getTagValue((Node)fnode, (String)"target_decimal_symbol"));
                this.denormaliserTargetField[i].setTargetGroupingSymbol(XMLHandler.getTagValue((Node)fnode, (String)"target_grouping_symbol"));
                this.denormaliserTargetField[i].setTargetCurrencySymbol(XMLHandler.getTagValue((Node)fnode, (String)"target_currency_symbol"));
                this.denormaliserTargetField[i].setTargetNullString(XMLHandler.getTagValue((Node)fnode, (String)"target_null_string"));
                this.denormaliserTargetField[i].setTargetAggregationType(XMLHandler.getTagValue((Node)fnode, (String)"target_aggregation_type"));
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"DenormaliserMeta.Exception.UnableToLoadStepInfoFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public String getXML() {
        int i;
        StringBuffer retval = new StringBuffer();
        retval.append("      " + XMLHandler.addTagValue((String)"key_field", (String)this.keyField));
        retval.append("      <group>" + Const.CR);
        for (i = 0; i < this.groupField.length; ++i) {
            retval.append("        <field>" + Const.CR);
            retval.append("          " + XMLHandler.addTagValue((String)"name", (String)this.groupField[i]));
            retval.append("          </field>" + Const.CR);
        }
        retval.append("        </group>" + Const.CR);
        retval.append("      <fields>" + Const.CR);
        for (i = 0; i < this.denormaliserTargetField.length; ++i) {
            DenormaliserTargetField field = this.denormaliserTargetField[i];
            retval.append("        <field>" + Const.CR);
            retval.append("          " + XMLHandler.addTagValue((String)"field_name", (String)field.getFieldName()));
            retval.append("          " + XMLHandler.addTagValue((String)"key_value", (String)field.getKeyValue()));
            retval.append("          " + XMLHandler.addTagValue((String)"target_name", (String)field.getTargetName()));
            retval.append("          " + XMLHandler.addTagValue((String)"target_type", (String)field.getTargetTypeDesc()));
            retval.append("          " + XMLHandler.addTagValue((String)"target_format", (String)field.getTargetFormat()));
            retval.append("          " + XMLHandler.addTagValue((String)"target_length", (int)field.getTargetLength()));
            retval.append("          " + XMLHandler.addTagValue((String)"target_precision", (int)field.getTargetPrecision()));
            retval.append("          " + XMLHandler.addTagValue((String)"target_decimal_symbol", (String)field.getTargetDecimalSymbol()));
            retval.append("          " + XMLHandler.addTagValue((String)"target_grouping_symbol", (String)field.getTargetGroupingSymbol()));
            retval.append("          " + XMLHandler.addTagValue((String)"target_currency_symbol", (String)field.getTargetCurrencySymbol()));
            retval.append("          " + XMLHandler.addTagValue((String)"target_null_string", (String)field.getTargetNullString()));
            retval.append("          " + XMLHandler.addTagValue((String)"target_aggregation_type", (String)field.getTargetAggregationTypeDesc()));
            retval.append("          </field>" + Const.CR);
        }
        retval.append("        </fields>" + Const.CR);
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, ObjectId id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            int i;
            this.keyField = rep.getStepAttributeString(id_step, "key_field");
            int groupsize = rep.countNrStepAttributes(id_step, "group_name");
            int nrvalues = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(groupsize, nrvalues);
            for (i = 0; i < groupsize; ++i) {
                this.groupField[i] = rep.getStepAttributeString(id_step, i, "group_name");
            }
            for (i = 0; i < nrvalues; ++i) {
                this.denormaliserTargetField[i] = new DenormaliserTargetField();
                this.denormaliserTargetField[i].setFieldName(rep.getStepAttributeString(id_step, i, "field_name"));
                this.denormaliserTargetField[i].setKeyValue(rep.getStepAttributeString(id_step, i, "key_value"));
                this.denormaliserTargetField[i].setTargetName(rep.getStepAttributeString(id_step, i, "target_name"));
                this.denormaliserTargetField[i].setTargetType(rep.getStepAttributeString(id_step, i, "target_type"));
                this.denormaliserTargetField[i].setTargetFormat(rep.getStepAttributeString(id_step, i, "target_format"));
                this.denormaliserTargetField[i].setTargetLength((int)rep.getStepAttributeInteger(id_step, i, "target_length"));
                this.denormaliserTargetField[i].setTargetPrecision((int)rep.getStepAttributeInteger(id_step, i, "target_precision"));
                this.denormaliserTargetField[i].setTargetDecimalSymbol(rep.getStepAttributeString(id_step, i, "target_decimal_symbol"));
                this.denormaliserTargetField[i].setTargetGroupingSymbol(rep.getStepAttributeString(id_step, i, "target_grouping_symbol"));
                this.denormaliserTargetField[i].setTargetCurrencySymbol(rep.getStepAttributeString(id_step, i, "target_currency_symbol"));
                this.denormaliserTargetField[i].setTargetNullString(rep.getStepAttributeString(id_step, i, "target_null_string"));
                this.denormaliserTargetField[i].setTargetAggregationType(rep.getStepAttributeString(id_step, i, "target_aggregation_type"));
            }
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            int i;
            rep.saveStepAttribute(id_transformation, id_step, "key_field", this.keyField);
            for (i = 0; i < this.groupField.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "group_name", this.groupField[i]);
            }
            for (i = 0; i < this.denormaliserTargetField.length; ++i) {
                DenormaliserTargetField field = this.denormaliserTargetField[i];
                rep.saveStepAttribute(id_transformation, id_step, i, "field_name", field.getFieldName());
                rep.saveStepAttribute(id_transformation, id_step, i, "key_value", field.getKeyValue());
                rep.saveStepAttribute(id_transformation, id_step, i, "target_name", field.getTargetName());
                rep.saveStepAttribute(id_transformation, id_step, i, "target_type", field.getTargetTypeDesc());
                rep.saveStepAttribute(id_transformation, id_step, i, "target_format", field.getTargetFormat());
                rep.saveStepAttribute(id_transformation, id_step, i, "target_length", field.getTargetLength());
                rep.saveStepAttribute(id_transformation, id_step, i, "target_precision", field.getTargetPrecision());
                rep.saveStepAttribute(id_transformation, id_step, i, "target_decimal_symbol", field.getTargetDecimalSymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, "target_grouping_symbol", field.getTargetGroupingSymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, "target_currency_symbol", field.getTargetCurrencySymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, "target_null_string", field.getTargetNullString());
                rep.saveStepAttribute(id_transformation, id_step, i, "target_aggregation_type", field.getTargetAggregationTypeDesc());
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"DenormaliserMeta.Exception.UnableToSaveStepInfo", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        if (input.length > 0) {
            CheckResult cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"DenormaliserMeta.CheckResult.ReceivingInfoFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"DenormaliserMeta.CheckResult.NoInputReceived", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new Denormaliser(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new DenormaliserData();
    }

    @Override
    public StepMetaInjectionInterface getStepMetaInjectionInterface() {
        return new DenormaliserMetaInjection(this);
    }
}

