/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.elasticsearchbulk;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.ElasticSearchTimeoutException;
import org.elasticsearch.action.ListenableActionFuture;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.action.bulk.BulkRequestBuilder;
import org.elasticsearch.client.action.index.IndexRequestBuilder;
import org.elasticsearch.client.transport.NoNodeAvailableException;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.elasticsearchbulk.ElasticSearchBulkData;
import org.pentaho.di.trans.steps.elasticsearchbulk.ElasticSearchBulkMeta;

public class ElasticSearchBulk
extends BaseStep
implements StepInterface {
    private static final String INSERT_ERROR_CODE = null;
    private static Class<?> PKG = ElasticSearchBulkMeta.class;
    private ElasticSearchBulkMeta meta;
    private ElasticSearchBulkData data;
    TransportClient tc;
    private Node node;
    private Client client;
    private String index;
    private String type;
    BulkRequestBuilder currentRequest;
    private int batchSize = 2;
    private boolean isJsonInsert = false;
    private int jsonFieldIdx = 0;
    private String idOutFieldName = null;
    private Integer idFieldIndex = null;
    private Long timeout = null;
    private TimeUnit timeoutUnit = TimeUnit.MILLISECONDS;
    private int numberOfErrors = 0;
    private List<IndexRequestBuilder> requestsBuffer;
    private boolean stopOnError = true;
    private boolean useOutput = true;
    private Map<String, String> columnsToJson;
    private boolean hasFields;
    private IndexRequest.OpType opType = IndexRequest.OpType.CREATE;

    public ElasticSearchBulk(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        Object[] rowData = this.getRow();
        if (rowData == null) {
            if (this.currentRequest != null && this.currentRequest.numberOfActions() > 0) {
                this.processBatch(false);
            }
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.setupData();
            this.currentRequest = this.client.prepareBulk();
            this.requestsBuffer = new ArrayList<IndexRequestBuilder>(this.batchSize);
            this.initFieldIndexes();
        }
        try {
            this.data.inputRowBuffer[this.data.nextBufferRowIdx++] = rowData;
            return this.indexRow(this.data.inputRowMeta, rowData) || !this.stopOnError;
        }
        catch (KettleStepException e) {
            throw e;
        }
        catch (Exception e) {
            this.rejectAllRows(e.getLocalizedMessage());
            String msg = BaseMessages.getString(PKG, (String)"ElasticSearchBulk.Log.Exception", (String[])new String[]{e.getLocalizedMessage()});
            this.logError(msg);
            throw new KettleStepException(msg, (Throwable)e);
        }
    }

    private void setupData() throws KettleStepException {
        this.data.nextBufferRowIdx = 0;
        this.data.inputRowMeta = this.getInputRowMeta().clone();
        this.data.inputRowBuffer = new Object[this.batchSize][];
        this.data.outputRowMeta = this.data.inputRowMeta.clone();
        this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
    }

    private void initFieldIndexes() throws KettleStepException {
        if (this.isJsonInsert) {
            Integer idx = ElasticSearchBulk.getFieldIdx(this.data.inputRowMeta, this.environmentSubstitute(this.meta.getJsonField()));
            if (idx != null) {
                this.jsonFieldIdx = idx;
            } else {
                throw new KettleStepException(BaseMessages.getString(PKG, (String)"ElasticSearchBulk.Error.NoJsonField", (String[])new String[0]));
            }
        }
        this.idOutFieldName = this.environmentSubstitute(this.meta.getIdOutField());
        if (StringUtils.isNotBlank((String)this.meta.getIdInField())) {
            this.idFieldIndex = ElasticSearchBulk.getFieldIdx(this.data.inputRowMeta, this.environmentSubstitute(this.meta.getIdInField()));
            if (this.idFieldIndex == null) {
                throw new KettleStepException(BaseMessages.getString(PKG, (String)"ElasticSearchBulk.Error.InvalidIdField", (String[])new String[0]));
            }
        } else {
            this.idFieldIndex = null;
        }
    }

    private static Integer getFieldIdx(RowMetaInterface rowMeta, String fieldName) {
        if (fieldName == null) {
            return null;
        }
        for (int i = 0; i < rowMeta.size(); ++i) {
            String name = rowMeta.getValueMeta(i).getName();
            if (!fieldName.equals(name)) continue;
            return i;
        }
        return null;
    }

    private boolean indexRow(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
        try {
            IndexRequestBuilder requestBuilder = this.client.prepareIndex(this.index, this.type);
            requestBuilder.setOpType(this.opType);
            if (this.idFieldIndex != null) {
                requestBuilder.setId("" + row[this.idFieldIndex]);
            }
            if (this.isJsonInsert) {
                this.addSourceFromJsonString(row, requestBuilder);
            } else {
                this.addSourceFromRowFields(requestBuilder, rowMeta, row);
            }
            this.currentRequest.add(requestBuilder);
            this.requestsBuffer.add(requestBuilder);
            if (this.currentRequest.numberOfActions() >= this.batchSize) {
                return this.processBatch(true);
            }
            return true;
        }
        catch (KettleStepException e) {
            throw e;
        }
        catch (NoNodeAvailableException e) {
            throw new KettleStepException(BaseMessages.getString(PKG, (String)"ElasticSearchBulkDialog.Error.NoNodesFound", (String[])new String[0]));
        }
        catch (Exception e) {
            throw new KettleStepException(BaseMessages.getString(PKG, (String)"ElasticSearchBulk.Log.Exception", (String[])new String[]{e.getLocalizedMessage()}), (Throwable)e);
        }
    }

    private void addSourceFromJsonString(Object[] row, IndexRequestBuilder requestBuilder) throws KettleStepException {
        Object jsonString = row[this.jsonFieldIdx];
        if (jsonString instanceof byte[]) {
            requestBuilder.setSource((byte[])jsonString);
        } else if (jsonString instanceof String) {
            requestBuilder.setSource(((String)jsonString).getBytes());
        } else {
            throw new KettleStepException(BaseMessages.getString((String)"ElasticSearchBulk.Error.NoJsonFieldFormat"));
        }
    }

    private void addSourceFromRowFields(IndexRequestBuilder requestBuilder, RowMetaInterface rowMeta, Object[] row) throws IOException {
        XContentBuilder jsonBuilder = XContentFactory.jsonBuilder().startObject();
        for (int i = 0; i < rowMeta.size(); ++i) {
            if (this.idFieldIndex != null && i == this.idFieldIndex) continue;
            ValueMetaInterface valueMeta = rowMeta.getValueMeta(i);
            String name = this.hasFields ? this.columnsToJson.get(valueMeta.getName()) : valueMeta.getName();
            Object value = row[i];
            if (value instanceof Date && value.getClass() != Date.class) {
                Date subDate = (Date)value;
                value = new Date(subDate.getTime());
            }
            if (!StringUtils.isNotBlank((String)name)) continue;
            jsonBuilder.field(name, value);
        }
        jsonBuilder.endObject();
        requestBuilder.setSource(jsonBuilder);
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (ElasticSearchBulkMeta)smi;
        this.data = (ElasticSearchBulkData)sdi;
        if (super.init(smi, sdi)) {
            try {
                this.numberOfErrors = 0;
                this.initFromMeta();
                this.initClient();
                return true;
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"ElasticSearchBulk.Log.ErrorOccurredDuringStepInitialize", (String[])new String[0]) + e.getMessage());
                return true;
            }
        }
        return false;
    }

    private void initFromMeta() {
        this.index = this.environmentSubstitute(this.meta.getIndex());
        this.type = this.environmentSubstitute(this.meta.getType());
        this.batchSize = this.meta.getBatchSizeInt(this);
        try {
            this.timeout = Long.parseLong(this.environmentSubstitute(this.meta.getTimeOut()));
        }
        catch (NumberFormatException e) {
            this.timeout = null;
        }
        this.timeoutUnit = this.meta.getTimeoutUnit();
        this.isJsonInsert = this.meta.isJsonInsert();
        this.useOutput = this.meta.isUseOutput();
        this.stopOnError = this.meta.isStopOnError();
        this.columnsToJson = this.meta.getFields();
        this.hasFields = this.columnsToJson.size() > 0;
        this.opType = StringUtils.isNotBlank((String)this.meta.getIdInField()) && this.meta.isOverWriteIfSameId() ? IndexRequest.OpType.INDEX : IndexRequest.OpType.CREATE;
    }

    private boolean processBatch(boolean makeNew) throws KettleStepException {
        ListenableActionFuture actionFuture = this.currentRequest.execute();
        boolean responseOk = false;
        BulkResponse response = null;
        try {
            response = this.timeout != null && this.timeoutUnit != null ? (BulkResponse)actionFuture.actionGet(this.timeout.longValue(), this.timeoutUnit) : (BulkResponse)actionFuture.actionGet();
        }
        catch (ElasticSearchException e) {
            String msg = BaseMessages.getString(PKG, (String)"ElasticSearchBulk.Error.BatchExecuteFail", (String[])new String[]{e.getLocalizedMessage()});
            if (e instanceof ElasticSearchTimeoutException) {
                msg = BaseMessages.getString(PKG, (String)"ElasticSearchBulk.Error.Timeout", (String[])new String[0]);
            }
            this.logError(msg);
            this.rejectAllRows(msg);
        }
        if (response != null) {
            responseOk = this.handleResponse(response);
            this.requestsBuffer.clear();
        } else {
            this.numberOfErrors += this.currentRequest.numberOfActions();
            this.setErrors(this.numberOfErrors);
        }
        if (makeNew) {
            this.currentRequest = this.client.prepareBulk();
            this.data.nextBufferRowIdx = 0;
            this.data.inputRowBuffer = new Object[this.batchSize][];
        } else {
            this.currentRequest = null;
            this.data.inputRowBuffer = null;
        }
        return responseOk;
    }

    private boolean handleResponse(BulkResponse response) {
        boolean hasErrors = response.hasFailures();
        if (hasErrors) {
            this.logError(response.buildFailureMessage());
        }
        int errorsInBatch = 0;
        if (hasErrors || this.useOutput) {
            for (BulkItemResponse item : response) {
                if (item.isFailed()) {
                    this.logDetailed(item.failureMessage());
                    ++errorsInBatch;
                    if (!this.getStepMeta().isDoingErrorHandling()) continue;
                    this.rejectRow(item.itemId(), item.failureMessage());
                    continue;
                }
                if (!this.useOutput) continue;
                if (this.idOutFieldName != null) {
                    this.addIdToRow(item.getId(), item.itemId());
                }
                this.echoRow(item.itemId());
            }
        }
        this.numberOfErrors += errorsInBatch;
        this.setErrors(this.numberOfErrors);
        int linesOK = this.currentRequest.numberOfActions() - errorsInBatch;
        if (this.useOutput) {
            this.setLinesOutput(this.getLinesOutput() + (long)linesOK);
        } else {
            this.setLinesWritten(this.getLinesWritten() + (long)linesOK);
        }
        return !hasErrors;
    }

    private void addIdToRow(String id, int rowIndex) {
        this.data.inputRowBuffer[rowIndex] = RowDataUtil.resizeArray((Object[])this.data.inputRowBuffer[rowIndex], (int)(this.getInputRowMeta().size() + 1));
        this.data.inputRowBuffer[rowIndex][this.getInputRowMeta().size()] = id;
    }

    private void echoRow(int rowIndex) {
        try {
            this.putRow(this.data.outputRowMeta, this.data.inputRowBuffer[rowIndex]);
        }
        catch (KettleStepException e) {
            this.logError(e.getLocalizedMessage());
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.logError(e.getLocalizedMessage());
        }
    }

    private void rejectRow(int index, String errorMsg) {
        try {
            this.putError(this.getInputRowMeta(), this.data.inputRowBuffer[index], 1L, errorMsg, null, INSERT_ERROR_CODE);
        }
        catch (KettleStepException e) {
            this.logError(e.getLocalizedMessage());
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.logError(e.getLocalizedMessage());
        }
    }

    private void rejectAllRows(String errorMsg) {
        for (int i = 0; i < this.data.nextBufferRowIdx; ++i) {
            this.rejectRow(i, errorMsg);
        }
    }

    private void initClient() {
        ImmutableSettings.Builder settingsBuilder = ImmutableSettings.settingsBuilder();
        settingsBuilder.put(ImmutableSettings.Builder.EMPTY_SETTINGS);
        settingsBuilder.put(this.meta.getSettings());
        Settings settings = settingsBuilder.build();
        if (this.meta.getServers().length > 0) {
            this.node = null;
            TransportClient tClient = new TransportClient(settings);
            for (InetSocketTransportAddress address : this.meta.getServers()) {
                tClient.addTransportAddress((TransportAddress)address);
            }
            this.client = tClient;
        } else {
            NodeBuilder nodeBuilder = NodeBuilder.nodeBuilder();
            nodeBuilder.settings(settings);
            this.node = nodeBuilder.client(true).node();
            this.client = this.node.client();
            this.node.start();
        }
    }

    private void disposeClient() {
        if (this.client != null) {
            this.client.close();
        }
        if (this.node != null) {
            this.node.close();
        }
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (ElasticSearchBulkMeta)smi;
        this.data = (ElasticSearchBulkData)sdi;
        try {
            this.disposeClient();
        }
        catch (Exception e) {
            this.logError(e.getLocalizedMessage(), e);
        }
        super.dispose(smi, sdi);
    }
}

