/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.excelinput;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.trans.step.StepInjectionMetaEntry;
import org.pentaho.di.trans.step.StepMetaInjectionInterface;
import org.pentaho.di.trans.steps.excelinput.ExcelInputField;
import org.pentaho.di.trans.steps.excelinput.ExcelInputMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelInputMetaInjection
implements StepMetaInjectionInterface {
    private ExcelInputMeta meta;

    public ExcelInputMetaInjection(ExcelInputMeta meta) {
        this.meta = meta;
    }

    @Override
    public List<StepInjectionMetaEntry> getStepInjectionMetadataEntries() throws KettleException {
        StepInjectionMetaEntry metaEntry;
        ArrayList<StepInjectionMetaEntry> all = new ArrayList<StepInjectionMetaEntry>();
        StepInjectionMetaEntry fieldsEntry = new StepInjectionMetaEntry(Entry.FIELDS.name(), Entry.FIELDS.getValueType(), Entry.FIELDS.getDescription());
        all.add(fieldsEntry);
        StepInjectionMetaEntry fieldEntry = new StepInjectionMetaEntry(Entry.FIELD.name(), Entry.FIELD.getValueType(), Entry.FIELD.getDescription());
        fieldsEntry.getDetails().add(fieldEntry);
        for (Entry entry : Entry.values()) {
            if (entry.getParent() != Entry.FIELD) continue;
            metaEntry = new StepInjectionMetaEntry(entry.name(), entry.getValueType(), entry.getDescription());
            fieldEntry.getDetails().add(metaEntry);
        }
        StepInjectionMetaEntry sheetsEntry = new StepInjectionMetaEntry(Entry.SHEETS.name(), Entry.SHEETS.getValueType(), Entry.SHEETS.getDescription());
        all.add(sheetsEntry);
        StepInjectionMetaEntry sheetEntry = new StepInjectionMetaEntry(Entry.SHEET.name(), Entry.SHEET.getValueType(), Entry.SHEET.getDescription());
        sheetsEntry.getDetails().add(sheetEntry);
        for (Entry entry : Entry.values()) {
            if (entry.getParent() != Entry.SHEET) continue;
            metaEntry = new StepInjectionMetaEntry(entry.name(), entry.getValueType(), entry.getDescription());
            sheetEntry.getDetails().add(metaEntry);
        }
        return all;
    }

    @Override
    public void injectStepMetadataEntries(List<StepInjectionMetaEntry> all) throws KettleException {
        ArrayList<ExcelInputField> excelInputFields = new ArrayList<ExcelInputField>();
        ArrayList<ExcelInputSheet> sheets = new ArrayList<ExcelInputSheet>();
        for (StepInjectionMetaEntry lookFields : all) {
            Entry fieldEntry;
            Entry fieldsEntry = Entry.findEntry(lookFields.getKey());
            if (fieldsEntry == null) continue;
            if (fieldsEntry == Entry.FIELDS) {
                for (StepInjectionMetaEntry lookField : lookFields.getDetails()) {
                    fieldEntry = Entry.findEntry(lookField.getKey());
                    if (fieldEntry == null || fieldEntry != Entry.FIELD) continue;
                    ExcelInputField inputField = new ExcelInputField();
                    List<StepInjectionMetaEntry> entries = lookField.getDetails();
                    for (StepInjectionMetaEntry entry : entries) {
                        Entry metaEntry = Entry.findEntry(entry.getKey());
                        if (metaEntry == null) continue;
                        String value = (String)entry.getValue();
                        switch (metaEntry) {
                            case NAME: {
                                inputField.setName(value);
                                break;
                            }
                            case TYPE: {
                                inputField.setType(ValueMeta.getType((String)value));
                                break;
                            }
                            case LENGTH: {
                                inputField.setLength(Const.toInt((String)value, (int)-1));
                                break;
                            }
                            case PRECISION: {
                                inputField.setPrecision(Const.toInt((String)value, (int)-1));
                                break;
                            }
                            case CURRENCY: {
                                inputField.setCurrencySymbol(value);
                                break;
                            }
                            case GROUP: {
                                inputField.setGroupSymbol(value);
                                break;
                            }
                            case DECIMAL: {
                                inputField.setDecimalSymbol(value);
                                break;
                            }
                            case FORMAT: {
                                inputField.setFormat(value);
                                break;
                            }
                            case TRIM_TYPE: {
                                inputField.setTrimType(ValueMeta.getTrimTypeByCode((String)value));
                                break;
                            }
                            case REPEAT: {
                                inputField.setRepeated(ValueMeta.convertStringToBoolean((String)value));
                            }
                        }
                    }
                    excelInputFields.add(inputField);
                }
            }
            if (fieldsEntry != Entry.SHEETS) continue;
            for (StepInjectionMetaEntry lookField : lookFields.getDetails()) {
                fieldEntry = Entry.findEntry(lookField.getKey());
                if (fieldEntry == null || fieldEntry != Entry.SHEET) continue;
                String sheetName = null;
                int startCol = 0;
                int startRow = 0;
                List<StepInjectionMetaEntry> entries = lookField.getDetails();
                for (StepInjectionMetaEntry entry : entries) {
                    Entry metaEntry = Entry.findEntry(entry.getKey());
                    if (metaEntry == null) continue;
                    String value = (String)entry.getValue();
                    switch (metaEntry) {
                        case SHEET_NAME: {
                            sheetName = value;
                            break;
                        }
                        case SHEET_START_ROW: {
                            startRow = Const.toInt((String)value, (int)0);
                            break;
                        }
                        case SHEET_START_COL: {
                            startCol = Const.toInt((String)value, (int)0);
                        }
                    }
                }
                sheets.add(new ExcelInputSheet(sheetName, startCol, startRow));
            }
        }
        this.meta.setField(excelInputFields.toArray(new ExcelInputField[excelInputFields.size()]));
        String[] sheetNames = new String[sheets.size()];
        int[] startCols = new int[sheets.size()];
        int[] startRows = new int[sheets.size()];
        for (int i = 0; i < sheets.size(); ++i) {
            sheetNames[i] = ((ExcelInputSheet)sheets.get((int)i)).sheetName;
            startCols[i] = ((ExcelInputSheet)sheets.get((int)i)).startCol;
            startRows[i] = ((ExcelInputSheet)sheets.get((int)i)).startRow;
        }
        this.meta.setSheetName(sheetNames);
        this.meta.setStartColumn(startCols);
        this.meta.setStartRow(startRows);
    }

    public ExcelInputMeta getMeta() {
        return this.meta;
    }

    public class ExcelInputSheet {
        public String sheetName;
        public int startCol;
        public int startRow;

        private ExcelInputSheet(String sheetName, int startCol, int startRow) {
            this.sheetName = sheetName;
            this.startCol = startCol;
            this.startRow = startRow;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Entry {
        FIELDS(0, "All the fields on the spreadsheets"),
        FIELD(0, "One field"),
        NAME(FIELD, 2, "Field name"),
        TYPE(FIELD, 2, "Field data type"),
        LENGTH(FIELD, 2, "Field length"),
        PRECISION(FIELD, 2, "Field precision"),
        TRIM_TYPE(FIELD, 2, "Field trim type (none, left, right, both)"),
        FORMAT(FIELD, 2, "Field conversion format"),
        CURRENCY(FIELD, 2, "Field currency symbol"),
        DECIMAL(FIELD, 2, "Field decimal symbol"),
        GROUP(FIELD, 2, "Field group symbol"),
        REPEAT(FIELD, 2, "Field repeat (Y/N)"),
        SHEETS(0, "All the sheets in the spreadsheets"),
        SHEET(0, "One sheet in the spreadsheet"),
        SHEET_NAME(SHEET, 2, "Sheet name"),
        SHEET_START_ROW(SHEET, 2, "Sheet start row"),
        SHEET_START_COL(SHEET, 2, "Sheet start col");

        private int valueType;
        private String description;
        private Entry parent;

        private Entry(int valueType, String description) {
            this.valueType = valueType;
            this.description = description;
        }

        private Entry(Entry parent, int valueType, String description) {
            this.parent = parent;
            this.valueType = valueType;
            this.description = description;
        }

        public int getValueType() {
            return this.valueType;
        }

        public String getDescription() {
            return this.description;
        }

        public static Entry findEntry(String key) {
            return Entry.valueOf(key);
        }

        public Entry getParent() {
            return this.parent;
        }
    }
}

