/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.excelinput.ods;

import java.io.InputStream;
import java.util.List;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.doc.OdfSpreadsheetDocument;
import org.odftoolkit.odfdom.doc.table.OdfTable;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.spreadsheet.KSheet;
import org.pentaho.di.core.spreadsheet.KWorkbook;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.trans.steps.excelinput.ods.OdfSheet;

public class OdfWorkbook
implements KWorkbook {
    private String filename;
    private String encoding;
    private OdfDocument document;

    public OdfWorkbook(String filename, String encoding) throws KettleException {
        this.filename = filename;
        this.encoding = encoding;
        try {
            this.document = OdfSpreadsheetDocument.loadDocument((InputStream)KettleVFS.getInputStream((String)filename));
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }

    public void close() {
    }

    public KSheet getSheet(String sheetName) {
        OdfTable table = this.document.getTableByName(sheetName);
        if (table == null) {
            return null;
        }
        return new OdfSheet(table);
    }

    public String[] getSheetNames() {
        List list = this.document.getTableList();
        int nrSheets = list.size();
        String[] names = new String[nrSheets];
        for (int i = 0; i < nrSheets; ++i) {
            names[i] = ((OdfTable)list.get(i)).getTableName();
        }
        return names;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public int getNumberOfSheets() {
        return this.document.getTableList().size();
    }

    public KSheet getSheet(int sheetNr) {
        OdfTable table = (OdfTable)this.document.getTableList().get(sheetNr);
        if (table == null) {
            return null;
        }
        return new OdfSheet(table);
    }
}

