/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.excelinput.poi;

import java.io.InputStream;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.spreadsheet.KSheet;
import org.pentaho.di.core.spreadsheet.KWorkbook;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.trans.steps.excelinput.poi.PoiSheet;

public class PoiWorkbook
implements KWorkbook {
    private Workbook workbook;
    private String filename;
    private String encoding;

    public PoiWorkbook(String filename, String encoding) throws KettleException {
        this.filename = filename;
        this.encoding = encoding;
        try {
            this.workbook = WorkbookFactory.create((InputStream)KettleVFS.getInputStream((String)filename));
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }

    public void close() {
    }

    public KSheet getSheet(String sheetName) {
        Sheet sheet = this.workbook.getSheet(sheetName);
        if (sheet == null) {
            return null;
        }
        return new PoiSheet(sheet);
    }

    public String[] getSheetNames() {
        int nrSheets = this.workbook.getNumberOfSheets();
        String[] names = new String[nrSheets];
        for (int i = 0; i < nrSheets; ++i) {
            names[i] = this.workbook.getSheetName(i);
        }
        return names;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public int getNumberOfSheets() {
        return this.workbook.getNumberOfSheets();
    }

    public KSheet getSheet(int sheetNr) {
        Sheet sheet = this.workbook.getSheetAt(sheetNr);
        if (sheet == null) {
            return null;
        }
        return new PoiSheet(sheet);
    }
}

