/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.excelwriter;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.excelwriter.ExcelWriterStep;
import org.pentaho.di.trans.steps.excelwriter.ExcelWriterStepData;
import org.pentaho.di.trans.steps.excelwriter.ExcelWriterStepField;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelWriterStepMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = ExcelWriterStepMeta.class;
    public static final String IF_FILE_EXISTS_REUSE = "reuse";
    public static final String IF_FILE_EXISTS_CREATE_NEW = "new";
    public static final String IF_SHEET_EXISTS_REUSE = "reuse";
    public static final String IF_SHEET_EXISTS_CREATE_NEW = "new";
    public static final String ROW_WRITE_OVERWRITE = "overwrite";
    public static final String ROW_WRITE_PUSH_DOWN = "push";
    private String fileName;
    private String ifFileExists;
    private String ifSheetExists;
    private boolean makeSheetActive;
    private boolean forceFormulaRecalculation = false;
    private boolean leaveExistingStylesUnchanged = false;
    private int appendOffset = 0;
    private int appendEmpty = 0;
    private boolean appendOmitHeader = false;
    private String rowWritingMethod;
    private String startingCell;
    private String extension;
    private String password;
    private String protectedBy;
    private boolean headerEnabled;
    private boolean footerEnabled;
    private int splitEvery;
    private boolean stepNrInFilename;
    private boolean dateInFilename;
    private boolean addToResultFilenames;
    private boolean protectsheet;
    private boolean timeInFilename;
    private boolean templateEnabled;
    private boolean templateSheetEnabled;
    private String templateFileName;
    private String templateSheetName;
    private String sheetname;
    private ExcelWriterStepField[] outputFields;
    private boolean appendLines;
    private boolean doNotOpenNewFileInit;
    private boolean SpecifyFormat;
    private String date_time_format;
    private boolean autosizecolums;
    private boolean streamingData;

    public int getAppendOffset() {
        return this.appendOffset;
    }

    public void setAppendOffset(int appendOffset) {
        this.appendOffset = appendOffset;
    }

    public int getAppendEmpty() {
        return this.appendEmpty;
    }

    public void setAppendEmpty(int appendEmpty) {
        this.appendEmpty = appendEmpty >= 0 ? appendEmpty : 0;
    }

    public boolean isDateInFilename() {
        return this.dateInFilename;
    }

    public void setDateInFilename(boolean dateInFilename) {
        this.dateInFilename = dateInFilename;
    }

    public boolean isAppendOmitHeader() {
        return this.appendOmitHeader;
    }

    public void setAppendOmitHeader(boolean appendOmitHeader) {
        this.appendOmitHeader = appendOmitHeader;
    }

    public String getStartingCell() {
        return this.startingCell;
    }

    public void setStartingCell(String startingCell) {
        this.startingCell = startingCell;
    }

    public String getRowWritingMethod() {
        return this.rowWritingMethod;
    }

    public void setRowWritingMethod(String rowWritingMethod) {
        this.rowWritingMethod = rowWritingMethod;
    }

    public String getIfFileExists() {
        return this.ifFileExists;
    }

    public void setIfFileExists(String ifFileExists) {
        this.ifFileExists = ifFileExists;
    }

    public String getIfSheetExists() {
        return this.ifSheetExists;
    }

    public void setIfSheetExists(String ifSheetExists) {
        this.ifSheetExists = ifSheetExists;
    }

    public String getProtectedBy() {
        return this.protectedBy;
    }

    public void setProtectedBy(String protectedBy) {
        this.protectedBy = protectedBy;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getSheetname() {
        return this.sheetname;
    }

    public void setSheetname(String sheetname) {
        this.sheetname = sheetname;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isFooterEnabled() {
        return this.footerEnabled;
    }

    public void setFooterEnabled(boolean footer) {
        this.footerEnabled = footer;
    }

    public boolean isAutoSizeColums() {
        return this.autosizecolums;
    }

    public void setAutoSizeColums(boolean autosizecolums) {
        this.autosizecolums = autosizecolums;
    }

    public boolean isHeaderEnabled() {
        return this.headerEnabled;
    }

    public void setHeaderEnabled(boolean header) {
        this.headerEnabled = header;
    }

    public boolean isSpecifyFormat() {
        return this.SpecifyFormat;
    }

    public void setSpecifyFormat(boolean SpecifyFormat) {
        this.SpecifyFormat = SpecifyFormat;
    }

    public String getDateTimeFormat() {
        return this.date_time_format;
    }

    public void setDateTimeFormat(String date_time_format) {
        this.date_time_format = date_time_format;
    }

    public int getSplitEvery() {
        return this.splitEvery;
    }

    public boolean isAddToResultFiles() {
        return this.addToResultFilenames;
    }

    public void setAddToResultFiles(boolean addtoresultfilenamesin) {
        this.addToResultFilenames = addtoresultfilenamesin;
    }

    public void setSplitEvery(int splitEvery) {
        this.splitEvery = splitEvery >= 0 ? splitEvery : 0;
    }

    public boolean isStepNrInFilename() {
        return this.stepNrInFilename;
    }

    public void setStepNrInFilename(boolean stepNrInFilename) {
        this.stepNrInFilename = stepNrInFilename;
    }

    public boolean isTimeInFilename() {
        return this.timeInFilename;
    }

    public boolean isSheetProtected() {
        return this.protectsheet;
    }

    public void setTimeInFilename(boolean timeInFilename) {
        this.timeInFilename = timeInFilename;
    }

    public void setProtectSheet(boolean protectsheet) {
        this.protectsheet = protectsheet;
    }

    public ExcelWriterStepField[] getOutputFields() {
        return this.outputFields;
    }

    public void setOutputFields(ExcelWriterStepField[] outputFields) {
        this.outputFields = outputFields;
    }

    public boolean isTemplateEnabled() {
        return this.templateEnabled;
    }

    public void setTemplateEnabled(boolean template) {
        this.templateEnabled = template;
    }

    public boolean isTemplateSheetEnabled() {
        return this.templateSheetEnabled;
    }

    public void setTemplateSheetEnabled(boolean templateSheetEnabled) {
        this.templateSheetEnabled = templateSheetEnabled;
    }

    public String getTemplateFileName() {
        return this.templateFileName;
    }

    public void setTemplateFileName(String templateFileName) {
        this.templateFileName = templateFileName;
    }

    public String getTemplateSheetName() {
        return this.templateSheetName;
    }

    public void setTemplateSheetName(String templateSheetName) {
        this.templateSheetName = templateSheetName;
    }

    public boolean isDoNotOpenNewFileInit() {
        return this.doNotOpenNewFileInit;
    }

    public void setDoNotOpenNewFileInit(boolean doNotOpenNewFileInit) {
        this.doNotOpenNewFileInit = doNotOpenNewFileInit;
    }

    public boolean isAppendLines() {
        return this.appendLines;
    }

    public void setAppendLines(boolean append) {
        this.appendLines = append;
    }

    public void setMakeSheetActive(boolean makeSheetActive) {
        this.makeSheetActive = makeSheetActive;
    }

    public boolean isMakeSheetActive() {
        return this.makeSheetActive;
    }

    public boolean isForceFormulaRecalculation() {
        return this.forceFormulaRecalculation;
    }

    public void setForceFormulaRecalculation(boolean forceFormulaRecalculation) {
        this.forceFormulaRecalculation = forceFormulaRecalculation;
    }

    public boolean isLeaveExistingStylesUnchanged() {
        return this.leaveExistingStylesUnchanged;
    }

    public void setLeaveExistingStylesUnchanged(boolean leaveExistingStylesUnchanged) {
        this.leaveExistingStylesUnchanged = leaveExistingStylesUnchanged;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode);
    }

    public void allocate(int nrfields) {
        this.outputFields = new ExcelWriterStepField[nrfields];
    }

    @Override
    public Object clone() {
        ExcelWriterStepMeta retval = (ExcelWriterStepMeta)super.clone();
        int nrfields = this.outputFields.length;
        retval.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            retval.outputFields[i] = (ExcelWriterStepField)this.outputFields[i].clone();
        }
        return retval;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.headerEnabled = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"header"));
            this.footerEnabled = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"footer"));
            this.appendOmitHeader = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"appendOmitHeader"));
            this.appendLines = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"appendLines"));
            this.makeSheetActive = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"makeSheetActive"));
            this.appendOffset = Const.toInt((String)XMLHandler.getTagValue((Node)stepnode, (String)"appendOffset"), (int)0);
            this.appendEmpty = Const.toInt((String)XMLHandler.getTagValue((Node)stepnode, (String)"appendEmpty"), (int)0);
            this.startingCell = XMLHandler.getTagValue((Node)stepnode, (String)"startingCell");
            this.rowWritingMethod = XMLHandler.getTagValue((Node)stepnode, (String)"rowWritingMethod");
            this.forceFormulaRecalculation = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"forceFormulaRecalculation"));
            this.leaveExistingStylesUnchanged = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"leaveExistingStylesUnchanged"));
            String addToResult = XMLHandler.getTagValue((Node)stepnode, (String)"add_to_result_filenames");
            this.addToResultFilenames = Const.isEmpty((String)addToResult) ? true : "Y".equalsIgnoreCase(addToResult);
            this.fileName = XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"name");
            this.extension = XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"extention");
            this.doNotOpenNewFileInit = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"do_not_open_newfile_init"));
            this.stepNrInFilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"split"));
            this.dateInFilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"add_date"));
            this.timeInFilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"add_time"));
            this.SpecifyFormat = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"SpecifyFormat"));
            this.date_time_format = XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"date_time_format");
            this.autosizecolums = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"autosizecolums"));
            this.streamingData = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"stream_data"));
            this.protectsheet = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"protect_sheet"));
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"password"));
            this.protectedBy = XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"protected_by");
            this.splitEvery = Const.toInt((String)XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"splitevery"), (int)0);
            this.templateEnabled = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"template", (String)"enabled"));
            this.templateSheetEnabled = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"template", (String)"sheet_enabled"));
            this.templateFileName = XMLHandler.getTagValue((Node)stepnode, (String)"template", (String)"filename");
            this.templateSheetName = XMLHandler.getTagValue((Node)stepnode, (String)"template", (String)"sheetname");
            this.sheetname = XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"sheetname");
            this.ifFileExists = XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"if_file_exists");
            this.ifSheetExists = XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"if_sheet_exists");
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrfields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.outputFields[i] = new ExcelWriterStepField();
                this.outputFields[i].setName(XMLHandler.getTagValue((Node)fnode, (String)"name"));
                this.outputFields[i].setType(XMLHandler.getTagValue((Node)fnode, (String)"type"));
                this.outputFields[i].setFormat(XMLHandler.getTagValue((Node)fnode, (String)"format"));
                this.outputFields[i].setTitle(XMLHandler.getTagValue((Node)fnode, (String)"title"));
                this.outputFields[i].setTitleStyleCell(XMLHandler.getTagValue((Node)fnode, (String)"titleStyleCell"));
                this.outputFields[i].setStyleCell(XMLHandler.getTagValue((Node)fnode, (String)"styleCell"));
                this.outputFields[i].setCommentField(XMLHandler.getTagValue((Node)fnode, (String)"commentField"));
                this.outputFields[i].setCommentAuthorField(XMLHandler.getTagValue((Node)fnode, (String)"commentAuthorField"));
                this.outputFields[i].setFormula(XMLHandler.getTagValue((Node)fnode, (String)"formula") != null && XMLHandler.getTagValue((Node)fnode, (String)"formula").equalsIgnoreCase("Y"));
                this.outputFields[i].setHyperlinkField(XMLHandler.getTagValue((Node)fnode, (String)"hyperlinkField"));
            }
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    public String getNewLine(String fformat) {
        String nl = System.getProperty("line.separator");
        if (fformat != null) {
            if (fformat.equalsIgnoreCase("DOS")) {
                nl = "\r\n";
            } else if (fformat.equalsIgnoreCase("UNIX")) {
                nl = "\n";
            }
        }
        return nl;
    }

    @Override
    public void setDefault() {
        this.autosizecolums = false;
        this.streamingData = false;
        this.headerEnabled = true;
        this.footerEnabled = false;
        this.fileName = "file";
        this.extension = "xls";
        this.doNotOpenNewFileInit = false;
        this.stepNrInFilename = false;
        this.dateInFilename = false;
        this.timeInFilename = false;
        this.date_time_format = null;
        this.SpecifyFormat = false;
        this.addToResultFilenames = true;
        this.protectsheet = false;
        this.splitEvery = 0;
        this.templateEnabled = false;
        this.templateFileName = "template.xls";
        this.sheetname = "Sheet1";
        this.appendLines = false;
        this.ifFileExists = "new";
        this.ifSheetExists = "new";
        this.startingCell = "A1";
        this.rowWritingMethod = ROW_WRITE_OVERWRITE;
        this.appendEmpty = 0;
        this.appendOffset = 0;
        this.appendOmitHeader = false;
        this.makeSheetActive = true;
        this.forceFormulaRecalculation = false;
        this.allocate(0);
    }

    public String[] getFiles(VariableSpace space) {
        int nr;
        int copies = 1;
        int splits = 1;
        if (this.stepNrInFilename) {
            copies = 3;
        }
        if (this.splitEvery != 0) {
            splits = 4;
        }
        if ((nr = copies * splits) > 1) {
            ++nr;
        }
        String[] retval = new String[nr];
        int i = 0;
        for (int copy = 0; copy < copies; ++copy) {
            for (int split = 0; split < splits; ++split) {
                retval[i] = this.buildFilename(space, copy, split);
                ++i;
            }
        }
        if (i < nr) {
            retval[i] = "...";
        }
        return retval;
    }

    public String buildFilename(VariableSpace space, int stepnr, int splitnr) {
        SimpleDateFormat daf = new SimpleDateFormat();
        String retval = space.environmentSubstitute(this.fileName);
        String realextension = space.environmentSubstitute(this.extension);
        Date now = new Date();
        if (this.SpecifyFormat && !Const.isEmpty((String)this.date_time_format)) {
            daf.applyPattern(this.date_time_format);
            String dt = daf.format(now);
            retval = retval + dt;
        } else {
            if (this.dateInFilename) {
                daf.applyPattern("yyyMMdd");
                String d = daf.format(now);
                retval = retval + "_" + d;
            }
            if (this.timeInFilename) {
                daf.applyPattern("HHmmss");
                String t = daf.format(now);
                retval = retval + "_" + t;
            }
        }
        if (this.stepNrInFilename) {
            retval = retval + "_" + stepnr;
        }
        if (this.splitEvery > 0) {
            retval = retval + "_" + splitnr;
        }
        if (realextension != null && realextension.length() != 0) {
            retval = retval + "." + realextension;
        }
        return retval;
    }

    @Override
    public void getFields(RowMetaInterface r, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) {
        if (r == null) {
            r = new RowMeta();
        }
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(800);
        retval.append("    ").append(XMLHandler.addTagValue((String)"header", (boolean)this.headerEnabled));
        retval.append("    ").append(XMLHandler.addTagValue((String)"footer", (boolean)this.footerEnabled));
        retval.append("    ").append(XMLHandler.addTagValue((String)"makeSheetActive", (boolean)this.makeSheetActive));
        retval.append("    ").append(XMLHandler.addTagValue((String)"rowWritingMethod", (String)this.rowWritingMethod));
        retval.append("    ").append(XMLHandler.addTagValue((String)"startingCell", (String)this.startingCell));
        retval.append("    ").append(XMLHandler.addTagValue((String)"appendOmitHeader", (boolean)this.appendOmitHeader));
        retval.append("    ").append(XMLHandler.addTagValue((String)"appendOffset", (int)this.appendOffset));
        retval.append("    ").append(XMLHandler.addTagValue((String)"appendEmpty", (int)this.appendEmpty));
        retval.append("    ").append(XMLHandler.addTagValue((String)"rowWritingMethod", (String)this.rowWritingMethod));
        retval.append("    ").append(XMLHandler.addTagValue((String)"forceFormulaRecalculation", (boolean)this.forceFormulaRecalculation));
        retval.append("    ").append(XMLHandler.addTagValue((String)"leaveExistingStylesUnchanged", (boolean)this.leaveExistingStylesUnchanged));
        retval.append("    " + XMLHandler.addTagValue((String)"appendLines", (boolean)this.appendLines));
        retval.append("    " + XMLHandler.addTagValue((String)"add_to_result_filenames", (boolean)this.addToResultFilenames));
        retval.append("    <file>").append(Const.CR);
        retval.append("      ").append(XMLHandler.addTagValue((String)"name", (String)this.fileName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"extention", (String)this.extension));
        retval.append("      ").append(XMLHandler.addTagValue((String)"do_not_open_newfile_init", (boolean)this.doNotOpenNewFileInit));
        retval.append("      ").append(XMLHandler.addTagValue((String)"split", (boolean)this.stepNrInFilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"add_date", (boolean)this.dateInFilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"add_time", (boolean)this.timeInFilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"SpecifyFormat", (boolean)this.SpecifyFormat));
        retval.append("      ").append(XMLHandler.addTagValue((String)"date_time_format", (String)this.date_time_format));
        retval.append("      ").append(XMLHandler.addTagValue((String)"sheetname", (String)this.sheetname));
        retval.append("      ").append(XMLHandler.addTagValue((String)"autosizecolums", (boolean)this.autosizecolums));
        retval.append("      ").append(XMLHandler.addTagValue((String)"stream_data", (boolean)this.streamingData));
        retval.append("      ").append(XMLHandler.addTagValue((String)"protect_sheet", (boolean)this.protectsheet));
        retval.append("      ").append(XMLHandler.addTagValue((String)"password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.password)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"protected_by", (String)this.protectedBy));
        retval.append("      ").append(XMLHandler.addTagValue((String)"splitevery", (int)this.splitEvery));
        retval.append("      ").append(XMLHandler.addTagValue((String)"if_file_exists", (String)this.ifFileExists));
        retval.append("      ").append(XMLHandler.addTagValue((String)"if_sheet_exists", (String)this.ifSheetExists));
        retval.append("      </file>").append(Const.CR);
        retval.append("    <template>").append(Const.CR);
        retval.append("      ").append(XMLHandler.addTagValue((String)"enabled", (boolean)this.templateEnabled));
        retval.append("      ").append(XMLHandler.addTagValue((String)"sheet_enabled", (boolean)this.templateSheetEnabled));
        retval.append("      ").append(XMLHandler.addTagValue((String)"filename", (String)this.templateFileName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"sheetname", (String)this.templateSheetName));
        retval.append("    </template>").append(Const.CR);
        retval.append("    <fields>").append(Const.CR);
        for (int i = 0; i < this.outputFields.length; ++i) {
            ExcelWriterStepField field = this.outputFields[i];
            if (field.getName() == null || field.getName().length() == 0) continue;
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)field.getName()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"type", (String)field.getTypeDesc()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"format", (String)field.getFormat()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"title", (String)field.getTitle()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"titleStyleCell", (String)field.getTitleStyleCell()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"styleCell", (String)field.getStyleCell()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"commentField", (String)field.getCommentField()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"commentAuthorField", (String)field.getCommentAuthorField()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"formula", (boolean)field.isFormula()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"hyperlinkField", (String)field.getHyperlinkField()));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, ObjectId id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            this.headerEnabled = rep.getStepAttributeBoolean(id_step, "header");
            this.footerEnabled = rep.getStepAttributeBoolean(id_step, "footer");
            this.makeSheetActive = rep.getStepAttributeBoolean(id_step, "makeSheetActive");
            this.appendOmitHeader = rep.getStepAttributeBoolean(id_step, "appendOmitHeader");
            this.startingCell = rep.getStepAttributeString(id_step, "startingCell");
            this.appendEmpty = (int)rep.getStepAttributeInteger(id_step, "appendEmpty");
            this.appendOffset = (int)rep.getStepAttributeInteger(id_step, "appendOffset");
            this.rowWritingMethod = rep.getStepAttributeString(id_step, "rowWritingMethod");
            this.appendLines = rep.getStepAttributeBoolean(id_step, "appendLines");
            this.forceFormulaRecalculation = rep.getStepAttributeBoolean(id_step, "forceFormulaRecalculation");
            this.leaveExistingStylesUnchanged = rep.getStepAttributeBoolean(id_step, "leaveExistingStylesUnchanged");
            String addToResult = rep.getStepAttributeString(id_step, "add_to_result_filenames");
            this.addToResultFilenames = Const.isEmpty((String)addToResult) ? true : rep.getStepAttributeBoolean(id_step, "add_to_result_filenames");
            this.fileName = rep.getStepAttributeString(id_step, "file_name");
            this.extension = rep.getStepAttributeString(id_step, "file_extention");
            this.doNotOpenNewFileInit = rep.getStepAttributeBoolean(id_step, "do_not_open_newfile_init");
            this.splitEvery = (int)rep.getStepAttributeInteger(id_step, "file_split");
            this.stepNrInFilename = rep.getStepAttributeBoolean(id_step, "file_add_stepnr");
            this.dateInFilename = rep.getStepAttributeBoolean(id_step, "file_add_date");
            this.timeInFilename = rep.getStepAttributeBoolean(id_step, "file_add_time");
            this.SpecifyFormat = rep.getStepAttributeBoolean(id_step, "SpecifyFormat");
            this.date_time_format = rep.getStepAttributeString(id_step, "date_time_format");
            this.autosizecolums = rep.getStepAttributeBoolean(id_step, "autosizecolums");
            this.streamingData = rep.getStepAttributeBoolean(id_step, "stream_data");
            this.protectsheet = rep.getStepAttributeBoolean(id_step, "protect_sheet");
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)rep.getStepAttributeString(id_step, "password"));
            this.protectedBy = rep.getStepAttributeString(id_step, "protected_by");
            this.templateEnabled = rep.getStepAttributeBoolean(id_step, "template_enabled");
            this.templateFileName = rep.getStepAttributeString(id_step, "template_filename");
            this.templateSheetEnabled = rep.getStepAttributeBoolean(id_step, "template_sheet_enabled");
            this.templateSheetName = rep.getStepAttributeString(id_step, "template_sheetname");
            this.sheetname = rep.getStepAttributeString(id_step, "sheetname");
            this.ifFileExists = rep.getStepAttributeString(id_step, "if_file_exists");
            this.ifSheetExists = rep.getStepAttributeString(id_step, "if_sheet_exists");
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                this.outputFields[i] = new ExcelWriterStepField();
                this.outputFields[i].setName(rep.getStepAttributeString(id_step, i, "field_name"));
                this.outputFields[i].setType(rep.getStepAttributeString(id_step, i, "field_type"));
                this.outputFields[i].setFormat(rep.getStepAttributeString(id_step, i, "field_format"));
                this.outputFields[i].setTitle(rep.getStepAttributeString(id_step, i, "field_title"));
                this.outputFields[i].setTitleStyleCell(rep.getStepAttributeString(id_step, i, "field_title_style_cell"));
                this.outputFields[i].setStyleCell(rep.getStepAttributeString(id_step, i, "field_style_cell"));
                this.outputFields[i].setCommentField(rep.getStepAttributeString(id_step, i, "field_comment_field"));
                this.outputFields[i].setCommentAuthorField(rep.getStepAttributeString(id_step, i, "field_comment_author_field"));
                this.outputFields[i].setFormula(rep.getStepAttributeBoolean(id_step, i, "field_formula"));
                this.outputFields[i].setHyperlinkField(rep.getStepAttributeString(id_step, i, "field_hyperlink_field"));
            }
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "header", this.headerEnabled);
            rep.saveStepAttribute(id_transformation, id_step, "footer", this.footerEnabled);
            rep.saveStepAttribute(id_transformation, id_step, "makeSheetActive", this.makeSheetActive);
            rep.saveStepAttribute(id_transformation, id_step, "startingCell", this.startingCell);
            rep.saveStepAttribute(id_transformation, id_step, "appendOmitHeader", this.appendOmitHeader);
            rep.saveStepAttribute(id_transformation, id_step, "appendEmpty", this.appendEmpty);
            rep.saveStepAttribute(id_transformation, id_step, "appendOffset", this.appendOffset);
            rep.saveStepAttribute(id_transformation, id_step, "rowWritingMethod", this.rowWritingMethod);
            rep.saveStepAttribute(id_transformation, id_step, "appendLines", this.appendLines);
            rep.saveStepAttribute(id_transformation, id_step, "add_to_result_filenames", this.addToResultFilenames);
            rep.saveStepAttribute(id_transformation, id_step, "file_name", this.fileName);
            rep.saveStepAttribute(id_transformation, id_step, "do_not_open_newfile_init", this.doNotOpenNewFileInit);
            rep.saveStepAttribute(id_transformation, id_step, "forceFormulaRecalculation", this.forceFormulaRecalculation);
            rep.saveStepAttribute(id_transformation, id_step, "leaveExistingStylesUnchanged", this.leaveExistingStylesUnchanged);
            rep.saveStepAttribute(id_transformation, id_step, "file_extention", this.extension);
            rep.saveStepAttribute(id_transformation, id_step, "file_split", this.splitEvery);
            rep.saveStepAttribute(id_transformation, id_step, "file_add_stepnr", this.stepNrInFilename);
            rep.saveStepAttribute(id_transformation, id_step, "file_add_date", this.dateInFilename);
            rep.saveStepAttribute(id_transformation, id_step, "file_add_time", this.timeInFilename);
            rep.saveStepAttribute(id_transformation, id_step, "SpecifyFormat", this.SpecifyFormat);
            rep.saveStepAttribute(id_transformation, id_step, "date_time_format", this.date_time_format);
            rep.saveStepAttribute(id_transformation, id_step, "autosizecolums", this.autosizecolums);
            rep.saveStepAttribute(id_transformation, id_step, "stream_data", this.streamingData);
            rep.saveStepAttribute(id_transformation, id_step, "protect_sheet", this.protectsheet);
            rep.saveStepAttribute(id_transformation, id_step, "protected_by", this.protectedBy);
            rep.saveStepAttribute(id_transformation, id_step, "password", Encr.encryptPasswordIfNotUsingVariables((String)this.password));
            rep.saveStepAttribute(id_transformation, id_step, "template_enabled", this.templateEnabled);
            rep.saveStepAttribute(id_transformation, id_step, "template_filename", this.templateFileName);
            rep.saveStepAttribute(id_transformation, id_step, "template_sheet_enabled", this.templateSheetEnabled);
            rep.saveStepAttribute(id_transformation, id_step, "template_sheetname", this.templateSheetName);
            rep.saveStepAttribute(id_transformation, id_step, "sheetname", this.sheetname);
            rep.saveStepAttribute(id_transformation, id_step, "if_file_exists", this.ifFileExists);
            rep.saveStepAttribute(id_transformation, id_step, "if_sheet_exists", this.ifSheetExists);
            for (int i = 0; i < this.outputFields.length; ++i) {
                ExcelWriterStepField field = this.outputFields[i];
                rep.saveStepAttribute(id_transformation, id_step, i, "field_name", field.getName());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_type", field.getTypeDesc());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_format", field.getFormat());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_title", field.getTitle());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_title_style_cell", field.getTitleStyleCell());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_style_cell", field.getStyleCell());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_comment_field", field.getCommentField());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_comment_author_field", field.getCommentAuthorField());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_formula", field.isFormula());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_hyperlink_field", field.getHyperlinkField());
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr;
        if (prev != null && prev.size() > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ExcelWriterStepMeta.CheckResult.FieldsReceived", (String[])new String[]{"" + prev.size()}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            String error_message = "";
            boolean error_found = false;
            for (int i = 0; i < this.outputFields.length; ++i) {
                int idx = prev.indexOfValue(this.outputFields[i].getName());
                if (idx >= 0) continue;
                error_message = error_message + "\t\t" + this.outputFields[i].getName() + Const.CR;
                error_found = true;
            }
            if (error_found) {
                error_message = BaseMessages.getString(PKG, (String)"ExcelWriterStepMeta.CheckResult.FieldsNotFound", (String[])new String[]{error_message});
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ExcelWriterStepMeta.CheckResult.AllFieldsFound", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ExcelWriterStepMeta.CheckResult.ExpectedInputOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"ExcelWriterStepMeta.CheckResult.ExpectedInputError", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        cr = new CheckResult(2, BaseMessages.getString(PKG, (String)"ExcelWriterStepMeta.CheckResult.FilesNotChecked", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
    }

    @Override
    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface resourceNamingInterface, Repository repository) throws KettleException {
        try {
            FileObject fileObject;
            if (!Const.isEmpty((String)this.fileName)) {
                fileObject = KettleVFS.getFileObject((String)space.environmentSubstitute(this.fileName), (VariableSpace)space);
                this.fileName = resourceNamingInterface.nameResource(fileObject, space, true);
            }
            if (!Const.isEmpty((String)this.templateFileName)) {
                fileObject = KettleVFS.getFileObject((String)space.environmentSubstitute(this.templateFileName), (VariableSpace)space);
                this.templateFileName = resourceNamingInterface.nameResource(fileObject, space, true);
            }
            return null;
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new ExcelWriterStep(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new ExcelWriterStepData();
    }

    @Override
    public String[] getUsedLibraries() {
        return new String[0];
    }

    public boolean isStreamingData() {
        return this.streamingData;
    }

    public void setStreamingData(boolean streamingData) {
        this.streamingData = streamingData;
    }
}

