/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.fuzzymatch;

import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepIOMeta;
import org.pentaho.di.trans.step.StepIOMetaInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.errorhandling.Stream;
import org.pentaho.di.trans.step.errorhandling.StreamIcon;
import org.pentaho.di.trans.step.errorhandling.StreamInterface;
import org.pentaho.di.trans.steps.fuzzymatch.FuzzyMatch;
import org.pentaho.di.trans.steps.fuzzymatch.FuzzyMatchData;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FuzzyMatchMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = FuzzyMatchMeta.class;
    public static final String DEFAULT_SEPARATOR = ",";
    private int algorithm;
    public static final String[] algorithmDesc = new String[]{BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.algorithm.Levenshtein", (String[])new String[0]), BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.algorithm.DamerauLevenshtein", (String[])new String[0]), BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.algorithm.NeedlemanWunsch", (String[])new String[0]), BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.algorithm.Jaro", (String[])new String[0]), BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.algorithm.JaroWinkler", (String[])new String[0]), BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.algorithm.PairSimilarity", (String[])new String[0]), BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.algorithm.Metaphone", (String[])new String[0]), BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.algorithm.DoubleMetaphone", (String[])new String[0]), BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.algorithm.SoundEx", (String[])new String[0]), BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.algorithm.RefinedSoundEx", (String[])new String[0])};
    public static final String[] algorithmCode = new String[]{"levenshtein", "dameraulevenshtein", "needlemanwunsch", "jaro", "jarowinkler", "pairsimilarity", "metaphone", "doublemataphone", "soundex", "refinedsoundex"};
    public static final int OPERATION_TYPE_LEVENSHTEIN = 0;
    public static final int OPERATION_TYPE_DAMERAU_LEVENSHTEIN = 1;
    public static final int OPERATION_TYPE_NEEDLEMAN_WUNSH = 2;
    public static final int OPERATION_TYPE_JARO = 3;
    public static final int OPERATION_TYPE_JARO_WINKLER = 4;
    public static final int OPERATION_TYPE_PAIR_SIMILARITY = 5;
    public static final int OPERATION_TYPE_METAPHONE = 6;
    public static final int OPERATION_TYPE_DOUBLE_METAPHONE = 7;
    public static final int OPERATION_TYPE_SOUNDEX = 8;
    public static final int OPERATION_TYPE_REFINED_SOUNDEX = 9;
    private String lookupfield;
    private String mainstreamfield;
    private String outputmatchfield;
    private String outputvaluefield;
    private boolean caseSensitive;
    private String minimalValue;
    private String maximalValue;
    private String separator;
    private boolean closervalue;
    private String[] value;
    private String[] valueName;

    public String[] getValue() {
        return this.value;
    }

    public void setValue(String[] value) {
        this.value = value;
    }

    public void allocate(int nrvalues) {
        this.value = new String[nrvalues];
        this.valueName = new String[nrvalues];
    }

    @Override
    public Object clone() {
        FuzzyMatchMeta retval = (FuzzyMatchMeta)super.clone();
        int nrvalues = this.value.length;
        retval.allocate(nrvalues);
        for (int i = 0; i < nrvalues; ++i) {
            retval.value[i] = this.value[i];
            retval.valueName[i] = this.valueName[i];
        }
        return retval;
    }

    public String getMainStreamField() {
        return this.mainstreamfield;
    }

    public void setMainStreamField(String mainstreamfield) {
        this.mainstreamfield = mainstreamfield;
    }

    public String getLookupField() {
        return this.lookupfield;
    }

    public void setLookupField(String lookupfield) {
        this.lookupfield = lookupfield;
    }

    public String getOutputMatchField() {
        return this.outputmatchfield;
    }

    public void setOutputMatchField(String outputmatchfield) {
        this.outputmatchfield = outputmatchfield;
    }

    public String getOutputValueField() {
        return this.outputvaluefield;
    }

    public void setOutputValueField(String outputvaluefield) {
        this.outputvaluefield = outputvaluefield;
    }

    public boolean isGetCloserValue() {
        return this.closervalue;
    }

    public String[] getValueName() {
        return this.valueName;
    }

    public void setValueName(String[] valueName) {
        this.valueName = valueName;
    }

    public void setGetCloserValue(boolean closervalue) {
        this.closervalue = closervalue;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public String getMinimalValue() {
        return this.minimalValue;
    }

    public void setMinimalValue(String minimalValue) {
        this.minimalValue = minimalValue;
    }

    public String getMaximalValue() {
        return this.maximalValue;
    }

    public void setMaximalValue(String maximalValue) {
        this.maximalValue = maximalValue;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode, databases);
    }

    public int getAlgorithmType() {
        return this.algorithm;
    }

    public void setAlgorithmType(int algorithm) {
        this.algorithm = algorithm;
    }

    public static String getAlgorithmTypeDesc(int i) {
        if (i < 0 || i >= algorithmDesc.length) {
            return algorithmDesc[0];
        }
        return algorithmDesc[i];
    }

    public static int getAlgorithmTypeByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < algorithmDesc.length; ++i) {
            if (!algorithmDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return FuzzyMatchMeta.getAlgorithmTypeByCode(tt);
    }

    private static int getAlgorithmTypeByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < algorithmCode.length; ++i) {
            if (!algorithmCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    private void readData(Node stepnode, List<? extends SharedObjectInterface> databases) throws KettleXMLException {
        try {
            String lookupFromStepname = XMLHandler.getTagValue((Node)stepnode, (String)"from");
            StreamInterface infoStream = this.getStepIOMeta().getInfoStreams().get(0);
            infoStream.setSubject(lookupFromStepname);
            this.lookupfield = XMLHandler.getTagValue((Node)stepnode, (String)"lookupfield");
            this.mainstreamfield = XMLHandler.getTagValue((Node)stepnode, (String)"mainstreamfield");
            this.caseSensitive = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"caseSensitive"));
            this.closervalue = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"closervalue"));
            this.minimalValue = XMLHandler.getTagValue((Node)stepnode, (String)"minimalValue");
            this.maximalValue = XMLHandler.getTagValue((Node)stepnode, (String)"maximalValue");
            this.separator = XMLHandler.getTagValue((Node)stepnode, (String)"separator");
            this.outputmatchfield = XMLHandler.getTagValue((Node)stepnode, (String)"outputmatchfield");
            this.outputvaluefield = XMLHandler.getTagValue((Node)stepnode, (String)"outputvaluefield");
            this.algorithm = FuzzyMatchMeta.getAlgorithmTypeByCode(Const.NVL((String)XMLHandler.getTagValue((Node)stepnode, (String)"algorithm"), (String)""));
            Node lookup = XMLHandler.getSubNode((Node)stepnode, (String)"lookup");
            int nrvalues = XMLHandler.countNodes((Node)lookup, (String)"value");
            this.allocate(nrvalues);
            for (int i = 0; i < nrvalues; ++i) {
                Node vnode = XMLHandler.getSubNodeByNr((Node)lookup, (String)"value", (int)i);
                this.value[i] = XMLHandler.getTagValue((Node)vnode, (String)"name");
                this.valueName[i] = XMLHandler.getTagValue((Node)vnode, (String)"rename");
                if (this.valueName[i] != null) continue;
                this.valueName[i] = this.value[i];
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.Exception.UnableToLoadStepInfoFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    private static String getAlgorithmTypeCode(int i) {
        if (i < 0 || i >= algorithmCode.length) {
            return algorithmCode[0];
        }
        return algorithmCode[i];
    }

    @Override
    public void setDefault() {
        this.value = null;
        this.valueName = null;
        this.separator = DEFAULT_SEPARATOR;
        this.closervalue = true;
        this.minimalValue = "0";
        this.maximalValue = "1";
        this.caseSensitive = false;
        this.lookupfield = null;
        this.mainstreamfield = null;
        this.outputmatchfield = BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.OutputMatchFieldname", (String[])new String[0]);
        this.outputvaluefield = BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.OutputValueFieldname", (String[])new String[0]);
        int nrvalues = 0;
        this.allocate(nrvalues);
        for (int i = 0; i < nrvalues; ++i) {
            this.value[i] = "value" + i;
            this.valueName[i] = "valuename" + i;
        }
    }

    @Override
    public void getFields(RowMetaInterface inputRowMeta, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        block10: {
            boolean activateAdditionalFields;
            ValueMeta v = new ValueMeta(space.environmentSubstitute(this.getOutputMatchField()), 2);
            v.setOrigin(name);
            v.setStorageType(0);
            inputRowMeta.addValueMeta((ValueMetaInterface)v);
            String mainField = space.environmentSubstitute(this.getOutputValueField());
            if (!Const.isEmpty((String)mainField) && this.isGetCloserValue()) {
                switch (this.getAlgorithmType()) {
                    case 0: 
                    case 1: {
                        v = new ValueMeta(mainField, 5);
                        v.setLength(10);
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        v = new ValueMeta(mainField, 1);
                        break;
                    }
                    default: {
                        v = new ValueMeta(mainField, 2);
                    }
                }
                v.setStorageType(0);
                v.setOrigin(name);
                inputRowMeta.addValueMeta((ValueMetaInterface)v);
            }
            boolean bl = activateAdditionalFields = this.isGetCloserValue() || this.getAlgorithmType() == 7 || this.getAlgorithmType() == 8 || this.getAlgorithmType() == 9 || this.getAlgorithmType() == 6;
            if (!activateAdditionalFields) break block10;
            if (info != null && info.length == 1 && info[0] != null) {
                for (int i = 0; i < this.valueName.length; ++i) {
                    v = info[0].searchValueMeta(this.value[i]);
                    if (v == null) {
                        throw new KettleStepException(BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.Exception.ReturnValueCanNotBeFound", (String[])new String[]{this.value[i]}));
                    }
                    v.setName(this.valueName[i]);
                    v.setOrigin(name);
                    v.setStorageType(0);
                    inputRowMeta.addValueMeta((ValueMetaInterface)v);
                }
            } else {
                for (int i = 0; i < this.valueName.length; ++i) {
                    v = new ValueMeta(this.valueName[i], 2);
                    v.setOrigin(name);
                    inputRowMeta.addValueMeta((ValueMetaInterface)v);
                }
            }
        }
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer();
        StreamInterface infoStream = this.getStepIOMeta().getInfoStreams().get(0);
        retval.append("    " + XMLHandler.addTagValue((String)"from", (String)infoStream.getStepname()));
        retval.append("    " + XMLHandler.addTagValue((String)"lookupfield", (String)this.lookupfield));
        retval.append("    " + XMLHandler.addTagValue((String)"mainstreamfield", (String)this.mainstreamfield));
        retval.append("    " + XMLHandler.addTagValue((String)"outputmatchfield", (String)this.outputmatchfield));
        retval.append("    " + XMLHandler.addTagValue((String)"outputvaluefield", (String)this.outputvaluefield));
        retval.append("    " + XMLHandler.addTagValue((String)"caseSensitive", (boolean)this.caseSensitive));
        retval.append("    " + XMLHandler.addTagValue((String)"closervalue", (boolean)this.closervalue));
        retval.append("    " + XMLHandler.addTagValue((String)"minimalValue", (String)this.minimalValue));
        retval.append("    " + XMLHandler.addTagValue((String)"maximalValue", (String)this.maximalValue));
        retval.append("    " + XMLHandler.addTagValue((String)"separator", (String)this.separator));
        retval.append("    ").append(XMLHandler.addTagValue((String)"algorithm", (String)FuzzyMatchMeta.getAlgorithmTypeCode(this.algorithm)));
        retval.append("    <lookup>" + Const.CR);
        for (int i = 0; i < this.value.length; ++i) {
            retval.append("      <value>" + Const.CR);
            retval.append("        " + XMLHandler.addTagValue((String)"name", (String)this.value[i]));
            retval.append("        " + XMLHandler.addTagValue((String)"rename", (String)this.valueName[i]));
            retval.append("      </value>" + Const.CR);
        }
        retval.append("    </lookup>" + Const.CR);
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, ObjectId id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            String lookupFromStepname = rep.getStepAttributeString(id_step, "lookup_from_step");
            StreamInterface infoStream = this.getStepIOMeta().getInfoStreams().get(0);
            infoStream.setSubject(lookupFromStepname);
            this.lookupfield = rep.getStepAttributeString(id_step, "lookupfield");
            this.mainstreamfield = rep.getStepAttributeString(id_step, "mainstreamfield");
            this.outputmatchfield = rep.getStepAttributeString(id_step, "outputmatchfield");
            this.outputvaluefield = rep.getStepAttributeString(id_step, "outputvaluefield");
            this.caseSensitive = rep.getStepAttributeBoolean(id_step, "caseSensitive");
            this.closervalue = rep.getStepAttributeBoolean(id_step, "closervalue");
            this.minimalValue = rep.getStepAttributeString(id_step, "minimalValue");
            this.maximalValue = rep.getStepAttributeString(id_step, "maximalValue");
            this.separator = rep.getStepAttributeString(id_step, "separator");
            this.algorithm = FuzzyMatchMeta.getAlgorithmTypeByCode(Const.NVL((String)rep.getStepAttributeString(id_step, "algorithm"), (String)""));
            int nrvalues = rep.countNrStepAttributes(id_step, "return_value_name");
            this.allocate(nrvalues);
            for (int i = 0; i < nrvalues; ++i) {
                this.value[i] = rep.getStepAttributeString(id_step, i, "return_value_name");
                this.valueName[i] = rep.getStepAttributeString(id_step, i, "return_value_rename");
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.Exception.UnexpecteErrorReadingStepInfoFromRepository", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            StreamInterface infoStream = this.getStepIOMeta().getInfoStreams().get(0);
            rep.saveStepAttribute(id_transformation, id_step, "lookup_from_step", infoStream.getStepname());
            rep.saveStepAttribute(id_transformation, id_step, "lookupfield", this.lookupfield);
            rep.saveStepAttribute(id_transformation, id_step, "mainstreamfield", this.mainstreamfield);
            rep.saveStepAttribute(id_transformation, id_step, "outputmatchfield", this.outputmatchfield);
            rep.saveStepAttribute(id_transformation, id_step, "outputvaluefield", this.outputvaluefield);
            rep.saveStepAttribute(id_transformation, id_step, "caseSensitive", this.caseSensitive);
            rep.saveStepAttribute(id_transformation, id_step, "closervalue", this.closervalue);
            rep.saveStepAttribute(id_transformation, id_step, "minimalValue", this.minimalValue);
            rep.saveStepAttribute(id_transformation, id_step, "maximalValue", this.maximalValue);
            rep.saveStepAttribute(id_transformation, id_step, "separator", this.separator);
            rep.saveStepAttribute(id_transformation, id_step, "algorithm", FuzzyMatchMeta.getAlgorithmTypeCode(this.algorithm));
            for (int i = 0; i < this.value.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "return_value_name", this.value[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "return_value_rename", this.valueName[i]);
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.Exception.UnableToSaveStepInfoToRepository", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        int idx;
        CheckResult cr;
        if (prev != null && prev.size() > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.CheckResult.StepReceivingFields", (String[])new String[]{prev.size() + ""}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            String mainField = transMeta.environmentSubstitute(this.getMainStreamField());
            idx = prev.indexOfValue(mainField);
            cr = idx < 0 ? new CheckResult(4, BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.CheckResult.MainFieldNotFound", (String[])new String[]{mainField}), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.CheckResult.MainFieldFound", (String[])new String[]{mainField}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.CheckResult.CouldNotFindFieldsFromPreviousSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (info != null && info.size() > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.CheckResult.StepReceivingLookupData", (String[])new String[]{info.size() + ""}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            String lookupField = transMeta.environmentSubstitute(this.getLookupField());
            idx = info.indexOfValue(lookupField);
            cr = idx < 0 ? new CheckResult(4, BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.CheckResult.FieldNotFoundInLookupStream", (String[])new String[]{lookupField}), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.CheckResult.FieldFoundInTheLookupStream", (String[])new String[]{lookupField}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            String error_message = "";
            boolean error_found = false;
            for (int i = 0; i < this.value.length; ++i) {
                idx = info.indexOfValue(this.value[i]);
                if (idx >= 0) continue;
                error_message = error_message + "\t\t" + this.value[i] + Const.CR;
                error_found = true;
            }
            if (error_found) {
                error_message = BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.CheckResult.FieldsNotFoundInLookupStream2", (String[])new String[0]) + Const.CR + Const.CR + error_message;
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.CheckResult.AllFieldsFoundInTheLookupStream2", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            }
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.CheckResult.FieldsNotFoundFromInLookupSep", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        StreamInterface infoStream = this.getStepIOMeta().getInfoStreams().get(0);
        if (infoStream.getStepMeta() == null) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.CheckResult.SourceStepNotSelected", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.CheckResult.SourceStepIsSelected", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            if (info != null) {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.CheckResult.SourceStepExist", (String[])new String[]{infoStream.getStepname() + ""}), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.CheckResult.SourceStepDoesNotExist", (String[])new String[]{infoStream.getStepname() + ""}), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        }
        if (input.length >= 2) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.CheckResult.StepReceivingInfoFromInputSteps", (String[])new String[]{input.length + ""}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.CheckResult.NeedAtLeast2InputStreams", (String[])new String[]{Const.CR, Const.CR}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public void searchInfoAndTargetSteps(List<StepMeta> steps) {
        for (StreamInterface stream : this.getStepIOMeta().getInfoStreams()) {
            stream.setStepMeta(StepMeta.findStep(steps, (String)stream.getSubject()));
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new FuzzyMatch(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new FuzzyMatchData();
    }

    @Override
    public boolean excludeFromRowLayoutVerification() {
        return true;
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }

    @Override
    public StepIOMetaInterface getStepIOMeta() {
        if (this.ioMeta == null) {
            this.ioMeta = new StepIOMeta(true, true, false, false, false, false);
            Stream stream = new Stream(StreamInterface.StreamType.INFO, null, BaseMessages.getString(PKG, (String)"FuzzyMatchMeta.InfoStream.Description", (String[])new String[0]), StreamIcon.INFO, null);
            this.ioMeta.addStream(stream);
        }
        return this.ioMeta;
    }

    @Override
    public void resetStepIoMeta() {
    }
}

