/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.getslavesequence;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.getslavesequence.GetSlaveSequenceData;
import org.pentaho.di.trans.steps.getslavesequence.GetSlaveSequenceMeta;

public class GetSlaveSequence
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = GetSlaveSequence.class;
    private GetSlaveSequenceMeta meta;
    private GetSlaveSequenceData data;

    public GetSlaveSequence(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public Object[] addSequence(RowMetaInterface inputRowMeta, Object[] inputRowData) throws KettleException {
        Long next = null;
        if (this.data.value >= this.data.startValue + this.data.increment) {
            this.data.value = this.data.startValue = this.data.slaveServer.getNextSlaveSequenceValue(this.data.sequenceName, this.data.increment);
        }
        next = this.data.value;
        ++this.data.value;
        if (next != null) {
            Object[] outputRowData = inputRowData;
            if (inputRowData.length < inputRowMeta.size() + 1) {
                outputRowData = RowDataUtil.resizeArray((Object[])inputRowData, (int)(inputRowMeta.size() + 1));
            }
            outputRowData[inputRowMeta.size()] = next;
            return outputRowData;
        }
        throw new KettleStepException(BaseMessages.getString(PKG, (String)"GetSequence.Exception.CouldNotFindNextValueForSequence", (String[])new String[0]) + this.meta.getValuename());
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (GetSlaveSequenceMeta)smi;
        this.data = (GetSlaveSequenceData)sdi;
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.data.outputRowMeta = this.getInputRowMeta().clone();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
            this.data.value = this.data.startValue = this.data.slaveServer.getNextSlaveSequenceValue(this.data.sequenceName, this.data.increment);
        }
        if (this.log.isRowLevel()) {
            this.logRowlevel(BaseMessages.getString(PKG, (String)"GetSequence.Log.ReadRow", (String[])new String[0]) + this.getLinesRead() + " : " + this.getInputRowMeta().getString(r));
        }
        try {
            this.putRow(this.data.outputRowMeta, this.addSequence(this.getInputRowMeta(), r));
            if (this.log.isRowLevel()) {
                this.logRowlevel(BaseMessages.getString(PKG, (String)"GetSequence.Log.WriteRow", (String[])new String[0]) + this.getLinesWritten() + " : " + this.getInputRowMeta().getString(r));
            }
            if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
                this.logBasic(BaseMessages.getString(PKG, (String)"GetSequence.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
            }
        }
        catch (KettleException e) {
            this.logError(BaseMessages.getString(PKG, (String)"GetSequence.Log.ErrorInStep", (String[])new String[0]) + e.getMessage());
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
            return false;
        }
        return true;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (GetSlaveSequenceMeta)smi;
        this.data = (GetSlaveSequenceData)sdi;
        if (super.init(smi, sdi)) {
            this.data.increment = Const.toLong((String)this.environmentSubstitute(this.meta.getIncrement()), (long)1000L);
            this.data.slaveServer = this.getTransMeta().findSlaveServer(this.environmentSubstitute(this.meta.getSlaveServerName()));
            this.data.sequenceName = this.environmentSubstitute(this.meta.getSequenceName());
            this.data.value = -1L;
            return true;
        }
        return false;
    }
}

