/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.getxmldata;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.steps.getxmldata.GetXMLDataMeta;
import org.w3c.dom.Node;

public class GetXMLDataField
implements Cloneable {
    private static Class<?> PKG = GetXMLDataMeta.class;
    public static final int RESULT_TYPE_VALUE_OF = 0;
    public static final int RESULT_TYPE_TYPE_SINGLE_NODE = 1;
    public static final String[] ResultTypeCode = new String[]{"valueof", "singlenode"};
    public static final String[] ResultTypeDesc = new String[]{BaseMessages.getString(PKG, (String)"GetXMLDataField.ResultType.ValueOf", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GetXMLDataField.ResultType.SingleNode", (String[])new String[0])};
    public static final int TYPE_TRIM_NONE = 0;
    public static final int TYPE_TRIM_LEFT = 1;
    public static final int TYPE_TRIM_RIGHT = 2;
    public static final int TYPE_TRIM_BOTH = 3;
    public static final int ELEMENT_TYPE_NODE = 0;
    public static final int ELEMENT_TYPE_ATTRIBUT = 1;
    public static final String[] trimTypeCode = new String[]{"none", "left", "right", "both"};
    public static final String[] trimTypeDesc = new String[]{BaseMessages.getString(PKG, (String)"GetXMLDataField.TrimType.None", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GetXMLDataField.TrimType.Left", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GetXMLDataField.TrimType.Right", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GetXMLDataField.TrimType.Both", (String[])new String[0])};
    public static final String[] ElementTypeCode = new String[]{"node", "attribute"};
    public static final String[] ElementOldTypeCode = new String[]{"node", "attribut"};
    public static final String[] ElementTypeDesc = new String[]{BaseMessages.getString(PKG, (String)"GetXMLDataField.ElementType.Node", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GetXMLDataField.ElementType.Attribute", (String[])new String[0])};
    private String name;
    private String xpath;
    private int type;
    private int length;
    private String format;
    private int trimtype;
    private int elementtype;
    private int resulttype;
    private int precision;
    private String currencySymbol;
    private String decimalSymbol;
    private String groupSymbol;
    private boolean repeat;

    public GetXMLDataField(String fieldname) {
        this.name = fieldname;
        this.xpath = "";
        this.length = -1;
        this.type = 2;
        this.format = "";
        this.trimtype = 0;
        this.elementtype = 0;
        this.resulttype = 0;
        this.groupSymbol = "";
        this.decimalSymbol = "";
        this.currencySymbol = "";
        this.precision = -1;
        this.repeat = false;
    }

    public GetXMLDataField() {
        this("");
    }

    public String getXML() {
        StringBuffer retval = new StringBuffer(400);
        retval.append("      <field>").append(Const.CR);
        retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)this.getName()));
        retval.append("        ").append(XMLHandler.addTagValue((String)"xpath", (String)this.getXPath()));
        retval.append("        ").append(XMLHandler.addTagValue((String)"element_type", (String)this.getElementTypeCode()));
        retval.append("        ").append(XMLHandler.addTagValue((String)"result_type", (String)this.getResultTypeCode()));
        retval.append("        ").append(XMLHandler.addTagValue((String)"type", (String)this.getTypeDesc()));
        retval.append("        ").append(XMLHandler.addTagValue((String)"format", (String)this.getFormat()));
        retval.append("        ").append(XMLHandler.addTagValue((String)"currency", (String)this.getCurrencySymbol()));
        retval.append("        ").append(XMLHandler.addTagValue((String)"decimal", (String)this.getDecimalSymbol()));
        retval.append("        ").append(XMLHandler.addTagValue((String)"group", (String)this.getGroupSymbol()));
        retval.append("        ").append(XMLHandler.addTagValue((String)"length", (int)this.getLength()));
        retval.append("        ").append(XMLHandler.addTagValue((String)"precision", (int)this.getPrecision()));
        retval.append("        ").append(XMLHandler.addTagValue((String)"trim_type", (String)this.getTrimTypeCode()));
        retval.append("        ").append(XMLHandler.addTagValue((String)"repeat", (boolean)this.isRepeated()));
        retval.append("      </field>").append(Const.CR);
        return retval.toString();
    }

    public GetXMLDataField(Node fnode) throws KettleValueException {
        this.setName(XMLHandler.getTagValue((Node)fnode, (String)"name"));
        this.setXPath(XMLHandler.getTagValue((Node)fnode, (String)"xpath"));
        this.setElementType(GetXMLDataField.getElementTypeByCode(XMLHandler.getTagValue((Node)fnode, (String)"element_type")));
        this.setResultType(GetXMLDataField.getResultTypeByCode(XMLHandler.getTagValue((Node)fnode, (String)"result_type")));
        this.setType(ValueMeta.getType((String)XMLHandler.getTagValue((Node)fnode, (String)"type")));
        this.setFormat(XMLHandler.getTagValue((Node)fnode, (String)"format"));
        this.setCurrencySymbol(XMLHandler.getTagValue((Node)fnode, (String)"currency"));
        this.setDecimalSymbol(XMLHandler.getTagValue((Node)fnode, (String)"decimal"));
        this.setGroupSymbol(XMLHandler.getTagValue((Node)fnode, (String)"group"));
        this.setLength(Const.toInt((String)XMLHandler.getTagValue((Node)fnode, (String)"length"), (int)-1));
        this.setPrecision(Const.toInt((String)XMLHandler.getTagValue((Node)fnode, (String)"precision"), (int)-1));
        this.setTrimType(GetXMLDataField.getTrimTypeByCode(XMLHandler.getTagValue((Node)fnode, (String)"trim_type")));
        this.setRepeated(!"N".equalsIgnoreCase(XMLHandler.getTagValue((Node)fnode, (String)"repeat")));
    }

    public static final int getTrimTypeByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < trimTypeCode.length; ++i) {
            if (!trimTypeCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public static final int getElementTypeByCode(String tt) {
        int i;
        if (tt == null) {
            return 0;
        }
        for (i = 0; i < ElementOldTypeCode.length; ++i) {
            if (!ElementOldTypeCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        for (i = 0; i < ElementTypeCode.length; ++i) {
            if (!ElementTypeCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public static final int getTrimTypeByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < trimTypeDesc.length; ++i) {
            if (!trimTypeDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public static final int getElementTypeByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < ElementTypeDesc.length; ++i) {
            if (!ElementTypeDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public static final String getTrimTypeCode(int i) {
        if (i < 0 || i >= trimTypeCode.length) {
            return trimTypeCode[0];
        }
        return trimTypeCode[i];
    }

    public static final String getElementTypeCode(int i) {
        if (i < 0 || i >= ElementOldTypeCode.length) {
            return ElementOldTypeCode[0];
        }
        return ElementOldTypeCode[i];
    }

    public static final String getTrimTypeDesc(int i) {
        if (i < 0 || i >= trimTypeDesc.length) {
            return trimTypeDesc[0];
        }
        return trimTypeDesc[i];
    }

    public static final String getElementTypeDesc(int i) {
        if (i < 0 || i >= ElementTypeDesc.length) {
            return ElementTypeDesc[0];
        }
        return ElementTypeDesc[i];
    }

    public Object clone() {
        try {
            GetXMLDataField retval = (GetXMLDataField)super.clone();
            return retval;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public String getName() {
        return this.name;
    }

    public String getXPath() {
        return this.xpath;
    }

    public void setXPath(String fieldxpath) {
        this.xpath = fieldxpath;
    }

    public void setName(String fieldname) {
        this.name = fieldname;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeDesc() {
        return ValueMeta.getTypeDesc((int)this.type);
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public int getTrimType() {
        return this.trimtype;
    }

    public int getElementType() {
        return this.elementtype;
    }

    public String getTrimTypeCode() {
        return GetXMLDataField.getTrimTypeCode(this.trimtype);
    }

    public String getElementTypeCode() {
        return GetXMLDataField.getElementTypeCode(this.elementtype);
    }

    public String getTrimTypeDesc() {
        return GetXMLDataField.getTrimTypeDesc(this.trimtype);
    }

    public String getElementTypeDesc() {
        return GetXMLDataField.getElementTypeDesc(this.elementtype);
    }

    public void setTrimType(int trimtype) {
        this.trimtype = trimtype;
    }

    public void setElementType(int element_type) {
        this.elementtype = element_type;
    }

    public String getGroupSymbol() {
        return this.groupSymbol;
    }

    public void setGroupSymbol(String group_symbol) {
        this.groupSymbol = group_symbol;
    }

    public String getDecimalSymbol() {
        return this.decimalSymbol;
    }

    public void setDecimalSymbol(String decimal_symbol) {
        this.decimalSymbol = decimal_symbol;
    }

    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public void setCurrencySymbol(String currency_symbol) {
        this.currencySymbol = currency_symbol;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public boolean isRepeated() {
        return this.repeat;
    }

    public void setRepeated(boolean repeat) {
        this.repeat = repeat;
    }

    public void flipRepeated() {
        this.repeat = !this.repeat;
    }

    public static final int getResultTypeByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < ResultTypeDesc.length; ++i) {
            if (!ResultTypeDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public String getResultTypeDesc() {
        return GetXMLDataField.getResultTypeDesc(this.resulttype);
    }

    public static final String getResultTypeDesc(int i) {
        if (i < 0 || i >= ResultTypeDesc.length) {
            return ResultTypeDesc[0];
        }
        return ResultTypeDesc[i];
    }

    public int getResultType() {
        return this.resulttype;
    }

    public void setResultType(int resulttype) {
        this.resulttype = resulttype;
    }

    public static final int getResultTypeByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < ResultTypeCode.length; ++i) {
            if (!ResultTypeCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public static final String getResultTypeCode(int i) {
        if (i < 0 || i >= ResultTypeCode.length) {
            return ResultTypeCode[0];
        }
        return ResultTypeCode[i];
    }

    public String getResultTypeCode() {
        return GetXMLDataField.getResultTypeCode(this.resulttype);
    }
}

