/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.jsoninput;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.vfs.FileObject;
import org.json.simple.JSONArray;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.fileinput.FileInputList;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.jsoninput.JsonInputData;
import org.pentaho.di.trans.steps.jsoninput.JsonInputField;
import org.pentaho.di.trans.steps.jsoninput.JsonInputMeta;
import org.pentaho.di.trans.steps.jsoninput.JsonReader;
import org.pentaho.di.trans.steps.jsoninput.NJSONArray;

public class JsonInput
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = JsonInputMeta.class;
    private JsonInputMeta meta;
    private JsonInputData data;

    public JsonInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private Object[] buildEmptyRow() {
        Object[] rowData = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
        return rowData;
    }

    private void handleMissingFiles() throws KettleException {
        List nonExistantFiles = this.data.files.getNonExistantFiles();
        if (nonExistantFiles.size() != 0) {
            String message = FileInputList.getRequiredFilesDescription((List)nonExistantFiles);
            this.log.logError(BaseMessages.getString(PKG, (String)"JsonInput.Log.RequiredFilesTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"JsonInput.Log.RequiredFiles", (String[])new String[]{message})});
            throw new KettleException(BaseMessages.getString(PKG, (String)"JsonInput.Log.RequiredFilesMissing", (String[])new String[]{message}));
        }
        List nonAccessibleFiles = this.data.files.getNonAccessibleFiles();
        if (nonAccessibleFiles.size() != 0) {
            String message = FileInputList.getRequiredFilesDescription((List)nonAccessibleFiles);
            this.log.logError(BaseMessages.getString(PKG, (String)"JsonInput.Log.RequiredFilesTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"JsonInput.Log.RequiredNotAccessibleFiles", (String[])new String[]{message})});
            throw new KettleException(BaseMessages.getString(PKG, (String)"JsonInput.Log.RequiredNotAccessibleFilesMissing", (String[])new String[]{message}));
        }
    }

    private boolean ReadNextString() {
        try {
            this.data.readrow = this.getRow();
            if (this.data.readrow == null) {
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JsonInput.Log.FinishedProcessing", (String[])new String[0]));
                }
                return false;
            }
            if (this.first) {
                int i;
                this.first = false;
                this.data.inputRowMeta = this.getInputRowMeta();
                this.data.outputRowMeta = this.data.inputRowMeta.clone();
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
                this.data.totalpreviousfields = this.data.inputRowMeta.size();
                this.data.convertRowMeta = this.data.outputRowMeta.clone();
                for (i = 0; i < this.data.convertRowMeta.size(); ++i) {
                    this.data.convertRowMeta.getValueMeta(i).setType(2);
                }
                this.data.convertRowMeta = this.data.outputRowMeta.clone();
                for (i = 0; i < this.data.convertRowMeta.size(); ++i) {
                    this.data.convertRowMeta.getValueMeta(i).setType(2);
                }
                if (Const.isEmpty((String)this.meta.getFieldValue())) {
                    this.logError(BaseMessages.getString(PKG, (String)"JsonInput.Log.NoField", (String[])new String[0]));
                    throw new KettleException(BaseMessages.getString(PKG, (String)"JsonInput.Log.NoField", (String[])new String[0]));
                }
                if (this.data.indexSourceField < 0) {
                    this.data.indexSourceField = this.getInputRowMeta().indexOfValue(this.meta.getFieldValue());
                    if (this.data.indexSourceField < 0) {
                        this.logError(BaseMessages.getString(PKG, (String)"JsonInput.Log.ErrorFindingField", (String[])new String[]{this.meta.getFieldValue()}));
                        throw new KettleException(BaseMessages.getString(PKG, (String)"JsonInput.Exception.CouldnotFindField", (String[])new String[]{this.meta.getFieldValue()}));
                    }
                }
            }
            String fieldValue = this.getInputRowMeta().getString(this.data.readrow, this.data.indexSourceField);
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"JsonInput.Log.SourceValue", (String[])new String[]{this.meta.getFieldValue(), fieldValue}));
            }
            if (this.meta.getIsAFile()) {
                this.data.file = KettleVFS.getFileObject((String)fieldValue, (VariableSpace)this.getTransMeta());
                if (this.meta.isIgnoreEmptyFile() && this.data.file.getContent().getSize() == 0L) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"JsonInput.Error.FileSizeZero", (Object[])new Object[]{this.data.file.getName()}));
                    this.ReadNextString();
                }
            } else {
                this.data.stringToParse = fieldValue;
            }
            this.readFileOrString();
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"JsonInput.Log.UnexpectedError", (String[])new String[]{e.toString()}));
            this.stopAll();
            this.logError(Const.getStackTracker((Throwable)e));
            this.setErrors(1L);
            return false;
        }
        return true;
    }

    private void addFileToResultFilesname(FileObject file) throws Exception {
        if (this.meta.addResultFile()) {
            ResultFile resultFile = new ResultFile(0, file, this.getTransMeta().getName(), this.getStepname());
            resultFile.setComment(BaseMessages.getString(PKG, (String)"JsonInput.Log.FileAddedResult", (String[])new String[0]));
            this.addResultFile(resultFile);
        }
    }

    private boolean openNextFile() {
        try {
            if (this.data.filenr >= this.data.files.nrOfFiles()) {
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JsonInput.Log.FinishedProcessing", (String[])new String[0]));
                }
                return false;
            }
            if (this.data.file != null) {
                this.data.file.close();
            }
            this.data.file = this.data.files.getFile(this.data.filenr);
            if (this.meta.isIgnoreEmptyFile() && this.data.file.getContent().getSize() == 0L) {
                this.logBasic(BaseMessages.getString(PKG, (String)"JsonInput.Error.FileSizeZero", (String[])new String[]{"" + this.data.file.getName()}));
                this.openNextFile();
            }
            this.readFileOrString();
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"JsonInput.Log.UnableToOpenFile", (String[])new String[]{"" + this.data.filenr, this.data.file.toString(), e.toString()}));
            this.stopAll();
            this.setErrors(1L);
            return false;
        }
        return true;
    }

    private void readFileOrString() throws Exception {
        if (this.data.file != null) {
            this.data.filename = KettleVFS.getFilename((FileObject)this.data.file);
            if (this.meta.getShortFileNameField() != null && this.meta.getShortFileNameField().length() > 0) {
                this.data.shortFilename = this.data.file.getName().getBaseName();
            }
            if (this.meta.getPathField() != null && this.meta.getPathField().length() > 0) {
                this.data.path = KettleVFS.getFilename((FileObject)this.data.file.getParent());
            }
            if (this.meta.isHiddenField() != null && this.meta.isHiddenField().length() > 0) {
                this.data.hidden = this.data.file.isHidden();
            }
            if (this.meta.getExtensionField() != null && this.meta.getExtensionField().length() > 0) {
                this.data.extension = this.data.file.getName().getExtension();
            }
            if (this.meta.getLastModificationDateField() != null && this.meta.getLastModificationDateField().length() > 0) {
                this.data.lastModificationDateTime = new Date(this.data.file.getContent().getLastModifiedTime());
            }
            if (this.meta.getUriField() != null && this.meta.getUriField().length() > 0) {
                this.data.uriName = this.data.file.getName().getURI();
            }
            if (this.meta.getRootUriField() != null && this.meta.getRootUriField().length() > 0) {
                this.data.rootUriName = this.data.file.getName().getRootURI();
            }
            long fileSize = this.data.file.getContent().getSize();
            if (this.meta.getSizeField() != null && this.meta.getSizeField().length() > 0) {
                this.data.size = fileSize;
            }
            ++this.data.filenr;
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"JsonInput.Log.OpeningFile", (String[])new String[]{this.data.file.toString()}));
            }
            this.addFileToResultFilesname(this.data.file);
        }
        this.parseJson();
    }

    private void parseJson() throws Exception {
        if (this.data.file != null) {
            this.data.jsonReader.readFile(this.data.filename);
        } else if (this.meta.isReadUrl()) {
            this.data.jsonReader.readUrl(this.data.stringToParse);
        } else {
            this.data.jsonReader.readString(this.data.stringToParse);
        }
        ArrayList<NJSONArray> resultList = new ArrayList<NJSONArray>();
        this.data.nrrecords = -1;
        this.data.recordnr = 0;
        String prevPath = "";
        for (int i = 0; i < this.data.nrInputFields; ++i) {
            String path = this.meta.getInputFields()[i].getPath();
            NJSONArray ja = this.data.jsonReader.getPath(path);
            if (this.data.nrrecords != -1 && this.data.nrrecords != ja.size() && !ja.isNull()) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"JsonInput.Error.BadStructure", (Object[])new Object[]{ja.size(), path, prevPath, this.data.nrrecords}));
            }
            resultList.add(ja);
            if (this.data.nrrecords == -1 && !ja.isNull()) {
                this.data.nrrecords = ja.size();
            }
            prevPath = path;
        }
        this.data.resultList = new ArrayList<NJSONArray>();
        for (NJSONArray j : resultList) {
            if (j.isNull()) {
                if (this.data.nrrecords == -1) {
                    this.data.nrrecords = 1;
                }
                j = new NJSONArray();
                for (int i = 0; i < this.data.nrrecords; ++i) {
                    j.add(null);
                }
            }
            this.data.resultList.add(j);
        }
        resultList = null;
        if (this.log.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"JsonInput.Log.NrRecords", (Object[])new Object[]{this.data.nrrecords}));
        }
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block10: {
            if (this.first && !this.meta.isInFields()) {
                int i;
                this.first = false;
                this.data.files = this.meta.getFiles(this);
                if (!this.meta.isdoNotFailIfNoFile() && this.data.files.nrOfFiles() == 0) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"JsonInput.Log.NoFiles", (String[])new String[0]));
                }
                this.handleMissingFiles();
                this.data.outputRowMeta = new RowMeta();
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
                this.data.convertRowMeta = this.data.outputRowMeta.clone();
                for (i = 0; i < this.data.convertRowMeta.size(); ++i) {
                    this.data.convertRowMeta.getValueMeta(i).setType(2);
                }
                this.data.convertRowMeta = this.data.outputRowMeta.clone();
                for (i = 0; i < this.data.convertRowMeta.size(); ++i) {
                    this.data.convertRowMeta.getValueMeta(i).setType(2);
                }
            }
            Object[] r = null;
            try {
                r = this.getOneRow();
                if (r == null) {
                    this.setOutputDone();
                    return false;
                }
                if (this.log.isRowLevel()) {
                    this.logRowlevel(BaseMessages.getString(PKG, (String)"JsonInput.Log.ReadRow", (String[])new String[]{this.data.outputRowMeta.getString(r)}));
                }
                this.incrementLinesInput();
                ++this.data.rownr;
                this.putRow(this.data.outputRowMeta, r);
                if (this.meta.getRowLimit() > 0L && this.data.rownr > this.meta.getRowLimit()) {
                    this.setOutputDone();
                    return false;
                }
            }
            catch (Exception e) {
                boolean sendToErrorRow = false;
                String errorMessage = null;
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"JsonInput.ErrorInStepRunning", (String[])new String[]{e.getMessage()}));
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block10;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, null, "JsonInput001");
            }
        }
        return true;
    }

    private Object[] getOneRow() throws KettleException {
        if (!this.meta.isInFields()) {
            while (this.data.recordnr >= this.data.nrrecords || this.data.file == null) {
                if (this.openNextFile()) continue;
                return null;
            }
        } else {
            while (this.data.recordnr >= this.data.nrrecords || this.data.readrow == null) {
                if (!this.ReadNextString()) {
                    return null;
                }
                if (this.data.readrow != null) continue;
                return null;
            }
        }
        return this.buildRow();
    }

    private Object[] buildRow() throws KettleException {
        Object[] outputRowData = this.buildEmptyRow();
        if (this.data.readrow != null) {
            outputRowData = (Object[])this.data.readrow.clone();
        }
        for (int i = 0; i < this.data.nrInputFields; ++i) {
            Object jo;
            JsonInputField field = this.meta.getInputFields()[i];
            JSONArray jsona = this.data.resultList.get(i).getJSONArray();
            String nodevalue = null;
            if (jsona != null && (jo = jsona.get(this.data.recordnr)) != null) {
                nodevalue = jo.toString();
            }
            switch (field.getTrimType()) {
                case 1: {
                    nodevalue = Const.ltrim(nodevalue);
                    break;
                }
                case 2: {
                    nodevalue = Const.rtrim(nodevalue);
                    break;
                }
                case 3: {
                    nodevalue = Const.trim(nodevalue);
                    break;
                }
            }
            if (this.meta.isInFields()) {
                outputRowData = RowDataUtil.addValueData((Object[])outputRowData, (int)(this.data.totalpreviousfields + i), (Object)nodevalue);
            }
            ValueMetaInterface targetValueMeta = this.data.outputRowMeta.getValueMeta(this.data.totalpreviousfields + i);
            ValueMetaInterface sourceValueMeta = this.data.convertRowMeta.getValueMeta(this.data.totalpreviousfields + i);
            outputRowData[this.data.totalpreviousfields + i] = targetValueMeta.convertData(sourceValueMeta, (Object)nodevalue);
            if (!this.meta.getInputFields()[i].isRepeated() || this.data.previousRow == null || !Const.isEmpty((String)nodevalue)) continue;
            outputRowData[this.data.totalpreviousfields + i] = this.data.previousRow[this.data.totalpreviousfields + i];
        }
        int rowIndex = this.data.totalpreviousfields + this.data.nrInputFields;
        if (this.meta.includeFilename() && !Const.isEmpty((String)this.meta.getFilenameField())) {
            outputRowData[rowIndex++] = this.data.filename;
        }
        if (this.meta.includeRowNumber() && !Const.isEmpty((String)this.meta.getRowNumberField())) {
            outputRowData[rowIndex++] = new Long(this.data.rownr);
        }
        if (this.meta.getShortFileNameField() != null && this.meta.getShortFileNameField().length() > 0) {
            outputRowData[rowIndex++] = this.data.shortFilename;
        }
        if (this.meta.getExtensionField() != null && this.meta.getExtensionField().length() > 0) {
            outputRowData[rowIndex++] = this.data.extension;
        }
        if (this.meta.getPathField() != null && this.meta.getPathField().length() > 0) {
            outputRowData[rowIndex++] = this.data.path;
        }
        if (this.meta.getSizeField() != null && this.meta.getSizeField().length() > 0) {
            outputRowData[rowIndex++] = new Long(this.data.size);
        }
        if (this.meta.isHiddenField() != null && this.meta.isHiddenField().length() > 0) {
            outputRowData[rowIndex++] = new Boolean(this.data.path);
        }
        if (this.meta.getLastModificationDateField() != null && this.meta.getLastModificationDateField().length() > 0) {
            outputRowData[rowIndex++] = this.data.lastModificationDateTime;
        }
        if (this.meta.getUriField() != null && this.meta.getUriField().length() > 0) {
            outputRowData[rowIndex++] = this.data.uriName;
        }
        if (this.meta.getRootUriField() != null && this.meta.getRootUriField().length() > 0) {
            outputRowData[rowIndex++] = this.data.rootUriName;
        }
        ++this.data.recordnr;
        RowMetaInterface irow = this.getInputRowMeta();
        this.data.previousRow = irow == null ? outputRowData : irow.cloneRow(outputRowData);
        return outputRowData;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (JsonInputMeta)smi;
        this.data = (JsonInputData)sdi;
        if (super.init(smi, sdi)) {
            this.data.rownr = 1L;
            this.data.nrInputFields = this.meta.getInputFields().length;
            for (int i = 0; i < this.data.nrInputFields; ++i) {
                JsonInputField field = this.meta.getInputFields()[i];
                field.setPath(this.environmentSubstitute(field.getPath()));
            }
            try {
                this.data.jsonReader = new JsonReader();
                this.data.jsonReader.SetIgnoreMissingPath(this.meta.isIgnoreMissingPath());
            }
            catch (KettleException e) {
                this.logError(e.getMessage());
                return false;
            }
            return true;
        }
        return false;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (JsonInputMeta)smi;
        this.data = (JsonInputData)sdi;
        if (this.data.file != null) {
            try {
                this.data.file.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.data.resultList = null;
        super.dispose(smi, sdi);
    }
}

