/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.jsonoutput;

import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.commons.vfs.FileObject;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.jsonoutput.JsonOutputData;
import org.pentaho.di.trans.steps.jsonoutput.JsonOutputField;
import org.pentaho.di.trans.steps.jsonoutput.JsonOutputMeta;

public class JsonOutput
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = JsonOutput.class;
    private JsonOutputMeta meta;
    private JsonOutputData data;
    private CompatibilityFactory compatibilityFactory;

    public JsonOutput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
        JsonOutputMeta jsonOutputMeta = (JsonOutputMeta)stepMeta.getStepMetaInterface();
        this.compatibilityFactory = jsonOutputMeta.isCompatibilityMode() ? new CompatibilityMode() : new FixedMode();
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (JsonOutputMeta)smi;
        this.data = (JsonOutputData)sdi;
        Object[] r = this.getRow();
        if (r == null) {
            if (!this.data.rowsAreSafe) {
                this.outPutRow(r);
            }
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.data.inputRowMeta = this.getInputRowMeta();
            this.data.inputRowMetaSize = this.data.inputRowMeta.size();
            if (this.data.outputValue) {
                this.data.outputRowMeta = this.data.inputRowMeta.clone();
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
            }
            this.data.nrFields = this.meta.getOutputFields().length;
            this.data.fieldIndexes = new int[this.data.nrFields];
            for (int i = 0; i < this.data.nrFields; ++i) {
                this.data.fieldIndexes[i] = this.data.inputRowMeta.indexOfValue(this.meta.getOutputFields()[i].getFieldName());
                if (this.data.fieldIndexes[i] < 0) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"JsonOutput.Exception.FieldNotFound", (String[])new String[0]));
                }
                JsonOutputField field = this.meta.getOutputFields()[i];
                field.setElementName(this.environmentSubstitute(field.getElementName()));
            }
        }
        this.data.rowsAreSafe = false;
        this.compatibilityFactory.execute(r);
        if (this.data.writeToFile && !this.data.outputValue) {
            this.putRow(this.data.inputRowMeta, r);
            this.incrementLinesOutput();
        }
        return true;
    }

    private void outPutRow(Object[] rowData) throws KettleStepException {
        this.data.jg = new JSONObject();
        this.data.jg.put((Object)this.data.realBlocName, (Object)this.data.ja);
        String value = this.data.jg.toJSONString();
        if (this.data.outputValue) {
            Object[] outputRowData = RowDataUtil.addValueData((Object[])rowData, (int)this.data.inputRowMetaSize, (Object)value);
            this.incrementLinesOutput();
            this.putRow(this.data.outputRowMeta, outputRowData);
        }
        if (this.data.writeToFile) {
            if (!this.openNewFile()) {
                throw new KettleStepException(BaseMessages.getString(PKG, (String)"JsonOutput.Error.OpenNewFile", (String[])new String[]{this.buildFilename()}));
            }
            try {
                this.data.writer.write(value);
            }
            catch (Exception e) {
                throw new KettleStepException(BaseMessages.getString(PKG, (String)"JsonOutput.Error.Writing", (String[])new String[0]), (Throwable)e);
            }
            this.closeFile();
        }
        this.data.rowsAreSafe = true;
        this.data.ja = new JSONArray();
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (JsonOutputMeta)smi;
        this.data = (JsonOutputData)sdi;
        if (super.init(smi, sdi)) {
            this.data.writeToFile = this.meta.getOperationType() != 0;
            boolean bl = this.data.outputValue = this.meta.getOperationType() != 1;
            if (this.data.outputValue && Const.isEmpty((String)this.environmentSubstitute(this.meta.getOutputValue()))) {
                this.logError(BaseMessages.getString(PKG, (String)"JsonOutput.Error.MissingOutputFieldName", (String[])new String[0]));
                this.stopAll();
                this.setErrors(1L);
                return false;
            }
            if (this.data.writeToFile) {
                if (!this.meta.isServletOutput() && Const.isEmpty((String)this.meta.getFileName())) {
                    this.logError(BaseMessages.getString(PKG, (String)"JsonOutput.Error.MissingTargetFilename", (String[])new String[0]));
                    this.stopAll();
                    this.setErrors(1L);
                    return false;
                }
                if (!this.meta.isDoNotOpenNewFileInit() && !this.openNewFile()) {
                    this.logError(BaseMessages.getString(PKG, (String)"JsonOutput.Error.OpenNewFile", (String[])new String[]{this.buildFilename()}));
                    this.stopAll();
                    this.setErrors(1L);
                    return false;
                }
            }
            this.data.realBlocName = Const.NVL((String)this.environmentSubstitute(this.meta.getJsonBloc()), (String)"");
            this.data.nrRowsInBloc = Const.toInt((String)this.environmentSubstitute(this.meta.getNrRowsInBloc()), (int)0);
            return true;
        }
        return false;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (JsonOutputMeta)smi;
        this.data = (JsonOutputData)sdi;
        if (this.data.ja != null) {
            this.data.ja = null;
        }
        if (this.data.jg != null) {
            this.data.jg = null;
        }
        this.closeFile();
        super.dispose(smi, sdi);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createParentFolder(String filename) throws KettleStepException {
        if (!this.meta.isCreateParentFolder()) {
            return;
        }
        FileObject parentfolder = null;
        try {
            block11: {
                try {
                    parentfolder = KettleVFS.getFileObject((String)filename, (VariableSpace)this.getTransMeta()).getParent();
                    if (parentfolder.exists()) break block11;
                    if (this.log.isDebug()) {
                        this.logDebug(BaseMessages.getString(PKG, (String)"JsonOutput.Error.ParentFolderNotExist", (Object[])new Object[]{parentfolder.getName()}));
                    }
                    parentfolder.createFolder();
                    if (this.log.isDebug()) {
                        this.logDebug(BaseMessages.getString(PKG, (String)"JsonOutput.Log.ParentFolderCreated", (String[])new String[0]));
                    }
                }
                catch (Exception e) {
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"JsonOutput.Error.ErrorCreatingParentFolder", (Object[])new Object[]{parentfolder.getName()}));
                }
            }
            Object var5_3 = null;
            if (parentfolder == null) return;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (parentfolder == null) throw throwable;
            try {
                parentfolder.close();
                throw throwable;
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception ex) {}
        parentfolder.close();
        return;
    }

    public boolean openNewFile() {
        if (this.data.writer != null) {
            return true;
        }
        boolean retval = false;
        try {
            if (this.meta.isServletOutput()) {
                this.data.writer = this.getTrans().getServletPrintWriter();
            } else {
                OutputStream fos;
                String filename = this.buildFilename();
                this.createParentFolder(filename);
                if (this.meta.AddToResult()) {
                    ResultFile resultFile = new ResultFile(0, KettleVFS.getFileObject((String)filename, (VariableSpace)this.getTransMeta()), this.getTransMeta().getName(), this.getStepname());
                    resultFile.setComment(BaseMessages.getString(PKG, (String)"JsonOutput.ResultFilenames.Comment", (String[])new String[0]));
                    this.addResultFile(resultFile);
                }
                OutputStream outputStream = fos = KettleVFS.getOutputStream((String)filename, (VariableSpace)this.getTransMeta(), (boolean)this.meta.isFileAppended());
                this.data.writer = !Const.isEmpty((String)this.meta.getEncoding()) ? new OutputStreamWriter((OutputStream)new BufferedOutputStream(outputStream, 5000), this.environmentSubstitute(this.meta.getEncoding())) : new OutputStreamWriter(new BufferedOutputStream(outputStream, 5000));
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JsonOutput.FileOpened", (String[])new String[]{filename}));
                }
                ++this.data.splitnr;
            }
            retval = true;
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"JsonOutput.Error.OpeningFile", (String[])new String[]{e.toString()}));
        }
        return retval;
    }

    public String buildFilename() {
        return this.meta.buildFilename(this.environmentSubstitute(this.meta.getFileName()), this.getCopy(), this.data.splitnr);
    }

    private boolean closeFile() {
        if (this.data.writer == null) {
            return true;
        }
        boolean retval = false;
        try {
            this.data.writer.close();
            this.data.writer = null;
            retval = true;
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"JsonOutput.Error.ClosingFile", (String[])new String[]{e.toString()}));
            this.setErrors(1L);
            retval = false;
        }
        return retval;
    }

    private class FixedMode
    implements CompatibilityFactory {
        private FixedMode() {
        }

        public void execute(Object[] row) throws KettleException {
            JSONObject jo = new JSONObject();
            block6: for (int i = 0; i < ((JsonOutput)JsonOutput.this).data.nrFields; ++i) {
                JsonOutputField outputField = JsonOutput.this.meta.getOutputFields()[i];
                ValueMetaInterface v = ((JsonOutput)JsonOutput.this).data.inputRowMeta.getValueMeta(((JsonOutput)JsonOutput.this).data.fieldIndexes[i]);
                switch (v.getType()) {
                    case 4: {
                        jo.put((Object)outputField.getElementName(), (Object)((JsonOutput)JsonOutput.this).data.inputRowMeta.getBoolean(row, ((JsonOutput)JsonOutput.this).data.fieldIndexes[i]));
                        continue block6;
                    }
                    case 5: {
                        jo.put((Object)outputField.getElementName(), (Object)((JsonOutput)JsonOutput.this).data.inputRowMeta.getInteger(row, ((JsonOutput)JsonOutput.this).data.fieldIndexes[i]));
                        continue block6;
                    }
                    case 1: {
                        jo.put((Object)outputField.getElementName(), (Object)((JsonOutput)JsonOutput.this).data.inputRowMeta.getNumber(row, ((JsonOutput)JsonOutput.this).data.fieldIndexes[i]));
                        continue block6;
                    }
                    case 6: {
                        jo.put((Object)outputField.getElementName(), (Object)((JsonOutput)JsonOutput.this).data.inputRowMeta.getBigNumber(row, ((JsonOutput)JsonOutput.this).data.fieldIndexes[i]));
                        continue block6;
                    }
                    default: {
                        jo.put((Object)outputField.getElementName(), (Object)((JsonOutput)JsonOutput.this).data.inputRowMeta.getString(row, ((JsonOutput)JsonOutput.this).data.fieldIndexes[i]));
                    }
                }
            }
            ((JsonOutput)JsonOutput.this).data.ja.add((Object)jo);
            ++((JsonOutput)JsonOutput.this).data.nrRow;
            if (((JsonOutput)JsonOutput.this).data.nrRowsInBloc > 0) {
                System.out.println("data.nrRow%data.nrRowsInBloc = " + ((JsonOutput)JsonOutput.this).data.nrRow % ((JsonOutput)JsonOutput.this).data.nrRowsInBloc);
                if (((JsonOutput)JsonOutput.this).data.nrRow % ((JsonOutput)JsonOutput.this).data.nrRowsInBloc == 0) {
                    System.out.println("outputting the row.");
                    JsonOutput.this.outPutRow(row);
                }
            }
        }
    }

    private class CompatibilityMode
    implements CompatibilityFactory {
        private CompatibilityMode() {
        }

        public void execute(Object[] row) throws KettleException {
            for (int i = 0; i < ((JsonOutput)JsonOutput.this).data.nrFields; ++i) {
                JsonOutputField outputField = JsonOutput.this.meta.getOutputFields()[i];
                ValueMetaInterface v = ((JsonOutput)JsonOutput.this).data.inputRowMeta.getValueMeta(((JsonOutput)JsonOutput.this).data.fieldIndexes[i]);
                JSONObject jo = new JSONObject();
                switch (v.getType()) {
                    case 4: {
                        jo.put((Object)outputField.getElementName(), (Object)((JsonOutput)JsonOutput.this).data.inputRowMeta.getBoolean(row, ((JsonOutput)JsonOutput.this).data.fieldIndexes[i]));
                        break;
                    }
                    case 5: {
                        jo.put((Object)outputField.getElementName(), (Object)((JsonOutput)JsonOutput.this).data.inputRowMeta.getInteger(row, ((JsonOutput)JsonOutput.this).data.fieldIndexes[i]));
                        break;
                    }
                    case 1: {
                        jo.put((Object)outputField.getElementName(), (Object)((JsonOutput)JsonOutput.this).data.inputRowMeta.getNumber(row, ((JsonOutput)JsonOutput.this).data.fieldIndexes[i]));
                        break;
                    }
                    case 6: {
                        jo.put((Object)outputField.getElementName(), (Object)((JsonOutput)JsonOutput.this).data.inputRowMeta.getBigNumber(row, ((JsonOutput)JsonOutput.this).data.fieldIndexes[i]));
                        break;
                    }
                    default: {
                        jo.put((Object)outputField.getElementName(), (Object)((JsonOutput)JsonOutput.this).data.inputRowMeta.getString(row, ((JsonOutput)JsonOutput.this).data.fieldIndexes[i]));
                    }
                }
                ((JsonOutput)JsonOutput.this).data.ja.add((Object)jo);
            }
            ++((JsonOutput)JsonOutput.this).data.nrRow;
            if (((JsonOutput)JsonOutput.this).data.nrRowsInBloc > 0) {
                System.out.println("data.nrRow%data.nrRowsInBloc = " + ((JsonOutput)JsonOutput.this).data.nrRow % ((JsonOutput)JsonOutput.this).data.nrRowsInBloc);
                if (((JsonOutput)JsonOutput.this).data.nrRow % ((JsonOutput)JsonOutput.this).data.nrRowsInBloc == 0) {
                    System.out.println("outputting the row.");
                    JsonOutput.this.outPutRow(row);
                }
            }
        }
    }

    private static interface CompatibilityFactory {
        public void execute(Object[] var1) throws KettleException;
    }
}

