/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.ldapinput.store;

import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;

public class KettleTrustManager
implements X509TrustManager {
    private static Class<?> PKG = KettleTrustManager.class;
    private X509TrustManager tm;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public KettleTrustManager(KeyStore keyStore, String certFilename, String certPassword) throws KettleException {
        try {
            block11: {
                InputStream inputStream = null;
                try {
                    try {
                        inputStream = KettleVFS.getInputStream((String)certFilename);
                        keyStore.load(inputStream, Const.NVL((String)certPassword, (String)"").toCharArray());
                    }
                    catch (Exception e) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"KettleTrustManager.Exception.CouldNotOpenCertStore", (String[])new String[0]), (Throwable)e);
                    }
                    Object var7_6 = null;
                    if (inputStream == null) break block11;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    if (inputStream == null) throw throwable;
                    try {
                        inputStream.close();
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"KettleTrustManager.Exception.CouldNotOpenCertStore", (String[])new String[0]), (Throwable)e);
                    }
                }
                try {}
                catch (Exception e) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"KettleTrustManager.Exception.CouldNotOpenCertStore", (String[])new String[0]), (Throwable)e);
                }
                inputStream.close();
            }
            try {
                TrustManagerFactory tmf = null;
                tmf = TrustManagerFactory.getInstance("SunX509");
                tmf.init(keyStore);
                TrustManager[] tms = tmf.getTrustManagers();
                this.tm = (X509TrustManager)tms[0];
                return;
            }
            catch (Exception e) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"KettleTrustManager.Exception.CouldNotInitializeTrustManager", (String[])new String[0]), (Throwable)e);
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"KettleTrustManager.Exception.CouldNotInitializeKettleTrustManager", (String[])new String[0]), (Throwable)e);
        }
    }

    public X509Certificate[] getAcceptedIssuers() {
        if (this.tm == null) {
            return null;
        }
        return this.tm.getAcceptedIssuers();
    }

    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (this.tm == null) {
            return;
        }
        this.tm.checkClientTrusted(chain, authType);
    }

    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (this.tm == null) {
            return;
        }
        this.tm.checkServerTrusted(chain, authType);
    }
}

