/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.loadfileinput;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.List;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.fileinput.FileInputList;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.loadfileinput.LoadFileInputData;
import org.pentaho.di.trans.steps.loadfileinput.LoadFileInputField;
import org.pentaho.di.trans.steps.loadfileinput.LoadFileInputMeta;

public class LoadFileInput
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = LoadFileInputMeta.class;
    private LoadFileInputMeta meta;
    private LoadFileInputData data;

    public LoadFileInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private void addFileToResultFilesname(FileObject file) throws Exception {
        if (this.meta.addResultFile()) {
            ResultFile resultFile = new ResultFile(0, file, this.getTransMeta().getName(), this.getStepname());
            resultFile.setComment("File was read by a LoadFileInput step");
            this.addResultFile(resultFile);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean openNextFile() {
        try {
            block29: {
                block28: {
                    if (!this.meta.getIsInFields()) break block28;
                    this.data.readrow = this.getRow();
                    if (this.data.readrow == null) {
                        if (!this.isDetailed()) return false;
                        this.logDetailed(BaseMessages.getString(PKG, (String)"LoadFileInput.Log.FinishedProcessing", (String[])new String[0]));
                        return false;
                    }
                    if (this.first) {
                        this.first = false;
                        this.data.inputRowMeta = this.getInputRowMeta();
                        this.data.outputRowMeta = this.data.inputRowMeta.clone();
                        this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
                        this.data.convertRowMeta = this.data.outputRowMeta.clone();
                        this.data.convertRowMeta = this.data.outputRowMeta.clone();
                        for (int i = 0; i < this.data.convertRowMeta.size(); ++i) {
                            this.data.convertRowMeta.getValueMeta(i).setType(2);
                        }
                        if (this.meta.getIsInFields()) {
                            if (Const.isEmpty((String)this.meta.getDynamicFilenameField())) {
                                this.logError(BaseMessages.getString(PKG, (String)"LoadFileInput.Log.NoField", (String[])new String[0]));
                                throw new KettleException(BaseMessages.getString(PKG, (String)"LoadFileInput.Log.NoField", (String[])new String[0]));
                            }
                            if (this.data.indexOfFilenameField < 0) {
                                this.data.indexOfFilenameField = this.data.inputRowMeta.indexOfValue(this.meta.getDynamicFilenameField());
                                if (this.data.indexOfFilenameField < 0) {
                                    this.logError(BaseMessages.getString(PKG, (String)"LoadFileInput.Log.ErrorFindingField", (String[])new String[0]) + "[" + this.meta.getDynamicFilenameField() + "]");
                                    throw new KettleException(BaseMessages.getString(PKG, (String)"LoadFileInput.Exception.CouldnotFindField", (String[])new String[]{this.meta.getDynamicFilenameField()}));
                                }
                            }
                            this.data.totalpreviousfields = this.data.inputRowMeta.size();
                        }
                    }
                    String Fieldvalue = this.data.inputRowMeta.getString(this.data.readrow, this.data.indexOfFilenameField);
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"LoadFileInput.Log.Stream", (String[])new String[]{this.meta.getDynamicFilenameField(), Fieldvalue}));
                    }
                    Object file = null;
                    try {
                        try {
                            this.data.file = KettleVFS.getFileObject((String)Fieldvalue);
                        }
                        catch (Exception e) {
                            throw new KettleException((Throwable)e);
                        }
                        Object var5_5 = null;
                        {
                        }
                    }
                    catch (Throwable throwable) {
                        Object var5_6 = null;
                        try {
                            if (file == null) throw throwable;
                            file.close();
                            throw throwable;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {}
                    catch (Exception e) {}
                    if (file != null) {
                        file.close();
                    }
                    break block29;
                }
                if (this.data.filenr >= this.data.files.nrOfFiles()) {
                    if (!this.isDetailed()) return false;
                    this.logDetailed(BaseMessages.getString(PKG, (String)"LoadFileInput.Log.FinishedProcessing", (String[])new String[0]));
                    return false;
                }
                this.data.last_file = this.data.filenr == this.data.files.nrOfFiles() - 1;
                this.data.file = this.data.files.getFile(this.data.filenr);
            }
            this.data.fileSize = this.data.file.getContent().getSize();
            ++this.data.filenr;
            if (this.meta.isIgnoreEmptyFile() && this.data.fileSize == 0L) {
                this.logError(BaseMessages.getString(PKG, (String)"LoadFileInput.Error.FileSizeZero", (String[])new String[]{"" + this.data.file.getName()}));
                this.openNextFile();
                return true;
            }
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"LoadFileInput.Log.OpeningFile", (String[])new String[]{this.data.file.toString()}));
            }
            this.data.filename = KettleVFS.getFilename((FileObject)this.data.file);
            if (this.meta.getShortFileNameField() != null && this.meta.getShortFileNameField().length() > 0) {
                this.data.shortFilename = this.data.file.getName().getBaseName();
            }
            if (this.meta.getPathField() != null && this.meta.getPathField().length() > 0) {
                this.data.path = KettleVFS.getFilename((FileObject)this.data.file.getParent());
            }
            if (this.meta.isHiddenField() != null && this.meta.isHiddenField().length() > 0) {
                this.data.hidden = this.data.file.isHidden();
            }
            if (this.meta.getExtensionField() != null && this.meta.getExtensionField().length() > 0) {
                this.data.extension = this.data.file.getName().getExtension();
            }
            if (this.meta.getLastModificationDateField() != null && this.meta.getLastModificationDateField().length() > 0) {
                this.data.lastModificationDateTime = new Date(this.data.file.getContent().getLastModifiedTime());
            }
            if (this.meta.getUriField() != null && this.meta.getUriField().length() > 0) {
                this.data.uriName = this.data.file.getName().getURI();
            }
            if (this.meta.getRootUriField() != null && this.meta.getRootUriField().length() > 0) {
                this.data.rootUriName = this.data.file.getName().getRootURI();
            }
            this.getFileContent();
            this.addFileToResultFilesname(this.data.file);
            if (!this.isDetailed()) return true;
            this.logDetailed(BaseMessages.getString(PKG, (String)"LoadFileInput.Log.FileOpened", (String[])new String[]{this.data.file.toString()}));
            return true;
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"LoadFileInput.Log.UnableToOpenFile", (String[])new String[]{"" + this.data.filenr, this.data.file.toString(), e.toString()}));
            this.stopAll();
            this.setErrors(1L);
            return false;
        }
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        try {
            Object[] outputRowData = this.getOneRow();
            if (outputRowData == null) {
                this.setOutputDone();
                return false;
            }
            if (this.isRowLevel()) {
                this.logRowlevel(BaseMessages.getString(PKG, (String)"LoadFileInput.Log.ReadRow", (String[])new String[]{this.data.outputRowMeta.getString(outputRowData)}));
            }
            this.putRow(this.data.outputRowMeta, outputRowData);
            if (this.meta.getRowLimit() > 0L && this.data.rownr > this.meta.getRowLimit()) {
                this.setOutputDone();
                return false;
            }
        }
        catch (KettleException e) {
            this.logError(BaseMessages.getString(PKG, (String)"LoadFileInput.ErrorInStepRunning", (String[])new String[]{e.getMessage()}));
            this.logError(Const.getStackTracker((Throwable)e));
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
            return false;
        }
        return true;
    }

    private void getFileContent() throws KettleException {
        try {
            this.data.filecontent = LoadFileInput.getTextFileContent(this.data.file.toString(), this.meta.getEncoding());
        }
        catch (OutOfMemoryError o) {
            this.logError("There is no enaugh memory to load the content of the file [" + this.data.file.getName() + "]");
            throw new KettleException((Throwable)o);
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }

    /*
     * Loose catch block
     */
    public static String getTextFileContent(String vfsFilename, String encoding) throws KettleException {
        String retval;
        block15: {
            Exception e22;
            InputStreamReader reader;
            InputStream inputStream;
            block14: {
                int c;
                inputStream = null;
                reader = null;
                retval = null;
                inputStream = KettleVFS.getInputStream((String)vfsFilename);
                reader = !Const.isEmpty((String)encoding) ? new InputStreamReader((InputStream)new BufferedInputStream(inputStream), encoding) : new InputStreamReader(new BufferedInputStream(inputStream));
                StringBuffer stringBuffer = new StringBuffer();
                while ((c = reader.read()) != -1) {
                    stringBuffer.append((char)c);
                }
                retval = stringBuffer.toString();
                Object var8_8 = null;
                if (reader == null) break block14;
                try {
                    reader.close();
                }
                catch (Exception e22) {
                    // empty catch block
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception e22) {}
            }
            break block15;
            {
                catch (Exception e3) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"LoadFileInput.Error.GettingFileContent", (String[])new String[]{vfsFilename, e3.toString()}));
                }
            }
            catch (Throwable throwable) {
                Exception e22;
                Object var8_9 = null;
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception e22) {
                        // empty catch block
                    }
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception e22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return retval;
    }

    private void handleMissingFiles() throws KettleException {
        List nonExistantFiles = this.data.files.getNonExistantFiles();
        if (nonExistantFiles.size() != 0) {
            String message = FileInputList.getRequiredFilesDescription((List)nonExistantFiles);
            this.logError(BaseMessages.getString(PKG, (String)"LoadFileInput.Log.RequiredFilesTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LoadFileInput.Log.RequiredFiles", (String[])new String[]{message}));
            throw new KettleException(BaseMessages.getString(PKG, (String)"LoadFileInput.Log.RequiredFilesMissing", (String[])new String[]{message}));
        }
        List nonAccessibleFiles = this.data.files.getNonAccessibleFiles();
        if (nonAccessibleFiles.size() != 0) {
            String message = FileInputList.getRequiredFilesDescription((List)nonAccessibleFiles);
            this.logError(BaseMessages.getString(PKG, (String)"LoadFileInput.Log.RequiredFilesTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LoadFileInput.Log.RequiredNotAccessibleFiles", (String[])new String[]{message}));
            throw new KettleException(BaseMessages.getString(PKG, (String)"LoadFileInput.Log.RequiredNotAccessibleFilesMissing", (String[])new String[]{message}));
        }
    }

    private Object[] buildEmptyRow() {
        Object[] rowData = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
        return rowData;
    }

    private Object[] getOneRow() throws KettleException {
        if (!this.openNextFile()) {
            return null;
        }
        Object[] outputRowData = this.buildEmptyRow();
        try {
            RowMetaInterface irow;
            if (this.meta.getIsInFields()) {
                System.arraycopy(this.data.readrow, 0, outputRowData, 0, this.data.readrow.length);
            }
            for (int i = 0; i < this.data.nrInputFields; ++i) {
                LoadFileInputField loadFileInputField = this.meta.getInputFields()[i];
                String o = null;
                switch (loadFileInputField.getElementType()) {
                    case 0: {
                        switch (loadFileInputField.getTrimType()) {
                            case 1: {
                                this.data.filecontent = Const.ltrim((String)this.data.filecontent);
                                break;
                            }
                            case 2: {
                                this.data.filecontent = Const.rtrim((String)this.data.filecontent);
                                break;
                            }
                            case 3: {
                                this.data.filecontent = Const.trim((String)this.data.filecontent);
                                break;
                            }
                        }
                        o = this.data.filecontent;
                        break;
                    }
                    case 1: {
                        o = String.valueOf(this.data.fileSize);
                        break;
                    }
                }
                int indexField = this.data.totalpreviousfields + i;
                ValueMetaInterface targetValueMeta = this.data.outputRowMeta.getValueMeta(indexField);
                ValueMetaInterface sourceValueMeta = this.data.convertRowMeta.getValueMeta(indexField);
                outputRowData[indexField] = targetValueMeta.convertData(sourceValueMeta, (Object)o);
                if (!loadFileInputField.isRepeated() || this.data.previousRow == null || o != null) continue;
                outputRowData[indexField] = this.data.previousRow[indexField];
            }
            int rowIndex = this.data.totalpreviousfields + this.data.nrInputFields;
            if (this.meta.includeFilename() && this.meta.getFilenameField() != null && this.meta.getFilenameField().length() > 0) {
                outputRowData[rowIndex++] = this.data.filename;
            }
            if (this.meta.includeRowNumber() && this.meta.getRowNumberField() != null && this.meta.getRowNumberField().length() > 0) {
                outputRowData[rowIndex++] = new Long(this.data.rownr);
            }
            if (this.meta.getShortFileNameField() != null && this.meta.getShortFileNameField().length() > 0) {
                outputRowData[rowIndex++] = this.data.shortFilename;
            }
            if (this.meta.getExtensionField() != null && this.meta.getExtensionField().length() > 0) {
                outputRowData[rowIndex++] = this.data.extension;
            }
            if (this.meta.getPathField() != null && this.meta.getPathField().length() > 0) {
                outputRowData[rowIndex++] = this.data.path;
            }
            if (this.meta.isHiddenField() != null && this.meta.isHiddenField().length() > 0) {
                outputRowData[rowIndex++] = new Boolean(this.data.hidden);
            }
            if (this.meta.getLastModificationDateField() != null && this.meta.getLastModificationDateField().length() > 0) {
                outputRowData[rowIndex++] = this.data.lastModificationDateTime;
            }
            if (this.meta.getUriField() != null && this.meta.getUriField().length() > 0) {
                outputRowData[rowIndex++] = this.data.uriName;
            }
            if (this.meta.getRootUriField() != null && this.meta.getRootUriField().length() > 0) {
                outputRowData[rowIndex++] = this.data.rootUriName;
            }
            this.data.previousRow = (irow = this.getInputRowMeta()) == null ? outputRowData : irow.cloneRow(outputRowData);
            this.incrementLinesInput();
            ++this.data.rownr;
        }
        catch (Exception e) {
            throw new KettleException("Impossible de charger le fichier", (Throwable)e);
        }
        return outputRowData;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (LoadFileInputMeta)smi;
        this.data = (LoadFileInputData)sdi;
        if (super.init(smi, sdi)) {
            if (!this.meta.getIsInFields()) {
                try {
                    this.data.files = this.meta.getFiles(this);
                    this.handleMissingFiles();
                    this.data.outputRowMeta = new RowMeta();
                    this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
                    this.data.convertRowMeta = this.data.outputRowMeta.clone();
                    this.data.convertRowMeta = this.data.outputRowMeta.clone();
                    for (int i = 0; i < this.data.convertRowMeta.size(); ++i) {
                        this.data.convertRowMeta.getValueMeta(i).setType(2);
                    }
                }
                catch (Exception e) {
                    this.logError("Error at step initialization: " + e.toString());
                    this.logError(Const.getStackTracker((Throwable)e));
                    return false;
                }
            }
            this.data.rownr = 1L;
            this.data.nrInputFields = this.meta.getInputFields().length;
            return true;
        }
        return false;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (LoadFileInputMeta)smi;
        this.data = (LoadFileInputData)sdi;
        if (this.data.file != null) {
            try {
                this.data.file.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.dispose(smi, sdi);
    }
}

