/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.luciddbbulkloader;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.DBCache;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.StreamLogger;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.luciddbbulkloader.LucidDBBulkLoaderData;
import org.pentaho.di.trans.steps.luciddbbulkloader.LucidDBBulkLoaderMeta;

public class LucidDBBulkLoader
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = LucidDBBulkLoaderMeta.class;
    private LucidDBBulkLoaderMeta meta;
    private LucidDBBulkLoaderData data;

    public LucidDBBulkLoader(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(LucidDBBulkLoaderMeta meta, boolean wait) throws KettleException {
        Runtime rt = Runtime.getRuntime();
        try {
            Object mkFifoCmd;
            String tableName = this.environmentSubstitute(meta.getTableName());
            String fifoVfsDirectory = this.environmentSubstitute(meta.getFifoDirectory());
            FileObject directory = KettleVFS.getFileObject((String)fifoVfsDirectory, (VariableSpace)this.getTransMeta());
            directory.createFolder();
            String fifoDirectory = KettleVFS.getFilename((FileObject)directory);
            this.data.fifoFilename = KettleVFS.getFilename((FileObject)directory) + Const.FILE_SEPARATOR + tableName + ".csv";
            this.data.bcpFilename = KettleVFS.getFilename((FileObject)directory) + Const.FILE_SEPARATOR + tableName + ".bcp";
            File fifoFile = new File(this.data.fifoFilename);
            if (!fifoFile.exists()) {
                mkFifoCmd = "mkfifo " + this.data.fifoFilename + "";
                this.logBasic("Creating FIFO file using this command : " + (String)mkFifoCmd);
                Process mkFifoProcess = rt.exec((String)mkFifoCmd);
                StreamLogger errorLogger = new StreamLogger(this.log, mkFifoProcess.getErrorStream(), "mkFifoError");
                StreamLogger outputLogger = new StreamLogger(this.log, mkFifoProcess.getInputStream(), "mkFifoOuptut");
                new Thread((Runnable)errorLogger).start();
                new Thread((Runnable)outputLogger).start();
                int result = mkFifoProcess.waitFor();
                if (result != 0) {
                    throw new Exception("Return code " + result + " received from statement : " + (String)mkFifoCmd);
                }
            }
            DBCache.getInstance().clear(meta.getDatabaseMeta().getName());
            if (meta.getDatabaseMeta() == null) {
                this.logError(BaseMessages.getString(PKG, (String)"LuciDBBulkLoader.Init.ConnectionMissing", (String[])new String[]{this.getStepname()}));
                return false;
            }
            this.data.db = new Database((LoggingObjectInterface)this, meta.getDatabaseMeta());
            this.data.db.shareVariablesWith((VariableSpace)this);
            if (this.getTransMeta().isUsingUniqueConnections()) {
                mkFifoCmd = this.getTrans();
                synchronized (mkFifoCmd) {
                    this.data.db.connect(this.getTrans().getThreadName(), this.getPartitionID());
                }
            } else {
                this.data.db.connect(this.getPartitionID());
            }
            this.logBasic("Connected to LucidDB");
            String fifoServerStatement = "";
            fifoServerStatement = fifoServerStatement + "create or replace server " + meta.getFifoServerName() + Const.CR;
            fifoServerStatement = fifoServerStatement + "foreign data wrapper sys_file_wrapper" + Const.CR;
            fifoServerStatement = fifoServerStatement + "options (" + Const.CR;
            fifoServerStatement = fifoServerStatement + "directory '" + fifoDirectory + "'," + Const.CR;
            fifoServerStatement = fifoServerStatement + "file_extension 'csv'," + Const.CR;
            fifoServerStatement = fifoServerStatement + "with_header 'no'," + Const.CR;
            fifoServerStatement = fifoServerStatement + "num_rows_scan '0'," + Const.CR;
            fifoServerStatement = fifoServerStatement + "lenient 'no');" + Const.CR;
            this.logBasic("Creating LucidDB fifo_server with the following command: " + fifoServerStatement);
            this.data.db.execStatements(fifoServerStatement);
            String errorMaxStatement = "";
            errorMaxStatement = errorMaxStatement + "alter session set \"errorMax\" = " + meta.getMaxErrors() + ";" + Const.CR;
            this.logBasic("Setting error limit in LucidDB session with the following command: " + errorMaxStatement);
            this.data.db.execStatements(errorMaxStatement);
            this.createBulkLoadConfigFile(this.data.bcpFilename);
            this.executeLoadCommand(tableName);
            this.data.fifoStream = new BufferedOutputStream(new FileOutputStream(fifoFile));
        }
        catch (Exception ex) {
            throw new KettleException((Throwable)ex);
        }
        return true;
    }

    private void executeLoadCommand(String tableName) throws KettleException {
        String loadCommand = "";
        loadCommand = loadCommand + "insert into " + this.data.schemaTable + Const.CR;
        loadCommand = loadCommand + "select * from " + this.meta.getFifoServerName() + ".\"DEFAULT\"." + tableName + Const.CR;
        this.logBasic("Preparing load command : " + Const.CR + loadCommand);
        PreparedStatement ps = this.data.db.prepareSQL(loadCommand);
        this.data.sqlRunner = new SqlRunner(this.data, ps);
        this.data.sqlRunner.start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createBulkLoadConfigFile(String bcpFilename) throws KettleException {
        File bcpFile = new File(bcpFilename);
        FileWriter writer = null;
        try {
            try {
                writer = new FileWriter(bcpFile);
                writer.write("9.0" + Const.CR);
                writer.write(this.meta.getFieldTable().length + Const.CR);
                RowMetaInterface targetFieldMeta = this.meta.getRequiredFields(this);
                this.data.bulkFormatMeta = new ValueMetaInterface[this.meta.getFieldTable().length];
                for (int i = 0; i < this.meta.getFieldTable().length; ++i) {
                    ValueMetaInterface field = this.getInputRowMeta().getValueMeta(this.data.keynrs[i]);
                    writer.write(Integer.toString(i + 1) + " ");
                    String dataType = null;
                    switch (field.getType()) {
                        case 2: {
                            dataType = "SQLVARCHAR";
                            break;
                        }
                        case 6: {
                            dataType = "SQLREAL";
                            break;
                        }
                        case 1: {
                            dataType = "SQLFLT8";
                            break;
                        }
                        case 5: {
                            dataType = "SQLBIGINT";
                            break;
                        }
                        case 3: {
                            if (((ValueMetaInterface)targetFieldMeta.getValueMetaList().get(i)).getOriginalColumnType() == 91) {
                                this.data.bulkFormatMeta[i] = this.data.bulkDateMeta;
                                dataType = "SQLDATE";
                                break;
                            }
                            this.data.bulkFormatMeta[i] = this.data.bulkTimestampMeta;
                            dataType = "SQLTIMESTAMP";
                            break;
                        }
                        case 4: {
                            dataType = "SQLCHAR";
                            break;
                        }
                        default: {
                            dataType = "SQLVARCHAR";
                        }
                    }
                    writer.write(dataType + " ");
                    writer.write("0 ");
                    if (field.getLength() == -1) {
                        writer.write("1000 ");
                    } else {
                        writer.write("" + field.getLength() + " ");
                    }
                    writer.write("\"\\t\" ");
                    writer.write(Integer.toString(i + 1) + " ");
                    writer.write(this.meta.getFieldTable()[i] + " ");
                    writer.write("\"\" ");
                    writer.write(Const.CR);
                }
                Object var9_9 = null;
                if (writer == null) return;
            }
            catch (Exception e) {
                throw new KettleException("Unable to create BCP control file", (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (writer == null) throw throwable;
            try {
                writer.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new KettleException("Unable to close BCP file '" + bcpFilename + "'", (Throwable)e);
            }
        }
        try {}
        catch (IOException e) {
            throw new KettleException("Unable to close BCP file '" + bcpFilename + "'", (Throwable)e);
        }
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (LucidDBBulkLoaderMeta)smi;
        this.data = (LucidDBBulkLoaderData)sdi;
        try {
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                this.data.fifoStream.close();
                this.data.fifoStream = null;
                this.data.sqlRunner.join();
                SqlRunner sqlRunner = this.data.sqlRunner;
                this.data.sqlRunner = null;
                for (String warning : sqlRunner.warnings) {
                    this.logError(" (WARNING) " + warning);
                }
                sqlRunner.checkExcn();
                if (!sqlRunner.warnings.isEmpty()) {
                    ResultSet rs = this.data.db.openQuery("SELECT PARAM_VALUE FROM SYS_ROOT.USER_SESSION_PARAMETERS WHERE PARAM_NAME='lastRowsRejected'");
                    try {
                        rs.next();
                        this.setLinesRejected(rs.getInt(1));
                        Object var8_9 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_10 = null;
                        rs.close();
                        throw throwable;
                    }
                    rs.close();
                    {
                    }
                }
                return false;
            }
            if (this.first) {
                this.first = false;
                this.data.keynrs = new int[this.meta.getFieldStream().length];
                for (int i = 0; i < this.data.keynrs.length; ++i) {
                    this.data.keynrs[i] = this.getInputRowMeta().indexOfValue(this.meta.getFieldStream()[i]);
                }
                this.execute(this.meta, true);
            }
            this.writeRowToBulk(this.getInputRowMeta(), r);
            this.putRow(this.getInputRowMeta(), r);
            this.incrementLinesOutput();
            return true;
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"LucidDBBulkLoader.Log.ErrorInStep", (String[])new String[0]), e);
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
            return false;
        }
    }

    private void writeRowToBulk(RowMetaInterface rowMeta, Object[] r) throws KettleException {
        try {
            block10: for (int i = 0; i < this.data.keynrs.length; ++i) {
                if (i > 0) {
                    this.data.fifoStream.write(this.data.separator);
                }
                int index = this.data.keynrs[i];
                ValueMetaInterface valueMeta = rowMeta.getValueMeta(index);
                Object valueData = r[index];
                if (valueData == null) continue;
                switch (valueMeta.getType()) {
                    case 2: {
                        this.data.fifoStream.write(this.data.quote);
                        if (valueMeta.isStorageBinaryString() && this.meta.getFieldFormatOk()[i]) {
                            this.data.fifoStream.write((byte[])valueData);
                        } else {
                            this.data.fifoStream.write(valueMeta.getString(valueData).getBytes());
                        }
                        this.data.fifoStream.write(this.data.quote);
                        continue block10;
                    }
                    case 5: {
                        if (valueMeta.isStorageBinaryString() && this.meta.getFieldFormatOk()[i]) {
                            this.data.fifoStream.write((byte[])valueData);
                            continue block10;
                        }
                        this.data.fifoStream.write(Long.toString(valueMeta.getInteger(valueData)).getBytes());
                        continue block10;
                    }
                    case 3: {
                        Date date = valueMeta.getDate(valueData);
                        this.data.fifoStream.write(this.data.bulkFormatMeta[i].getString((Object)date).getBytes());
                        continue block10;
                    }
                    case 4: {
                        if (valueMeta.isStorageBinaryString() && this.meta.getFieldFormatOk()[i]) {
                            this.data.fifoStream.write((byte[])valueData);
                            continue block10;
                        }
                        this.data.fifoStream.write(Boolean.toString(valueMeta.getBoolean(valueData)).getBytes());
                        continue block10;
                    }
                    case 1: {
                        if (valueMeta.isStorageBinaryString() && this.meta.getFieldFormatOk()[i]) {
                            this.data.fifoStream.write((byte[])valueData);
                            continue block10;
                        }
                        this.data.fifoStream.write(Double.toString(valueMeta.getNumber(valueData)).getBytes());
                        continue block10;
                    }
                    case 6: {
                        if (valueMeta.isStorageBinaryString() && this.meta.getFieldFormatOk()[i]) {
                            this.data.fifoStream.write((byte[])valueData);
                            continue block10;
                        }
                        this.data.fifoStream.write(valueMeta.getString(valueData).getBytes());
                    }
                }
            }
            this.data.fifoStream.write(this.data.newline);
        }
        catch (Exception e) {
            throw new KettleException("Error serializing rows of data to the fifo file", (Throwable)e);
        }
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (LucidDBBulkLoaderMeta)smi;
        this.data = (LucidDBBulkLoaderData)sdi;
        if (super.init(smi, sdi)) {
            this.data.quote = "\"".getBytes();
            this.data.separator = ",".getBytes();
            this.data.newline = Const.CR.getBytes();
            this.data.bulkTimestampMeta = new ValueMeta("timestampMeta", 3);
            this.data.bulkTimestampMeta.setConversionMask("yyyy-MM-dd HH:mm:ss");
            this.data.bulkTimestampMeta.setStringEncoding(this.meta.getEncoding());
            this.data.bulkDateMeta = new ValueMeta("dateMeta", 3);
            this.data.bulkDateMeta.setConversionMask("yyyy-MM-dd");
            this.data.bulkDateMeta.setStringEncoding(this.meta.getEncoding());
            this.data.bulkNumberMeta = new ValueMeta("numberMeta", 1);
            this.data.bulkNumberMeta.setConversionMask("#.#");
            this.data.bulkNumberMeta.setGroupingSymbol(",");
            this.data.bulkNumberMeta.setDecimalSymbol(".");
            this.data.bulkNumberMeta.setStringEncoding(this.meta.getEncoding());
            this.data.bufferSize = Const.toInt((String)this.environmentSubstitute(this.meta.getBufferSize()), (int)100000);
            this.data.rowBuffer = new byte[this.data.bufferSize][];
            this.data.bufferIndex = 0;
            this.data.schemaTable = this.meta.getDatabaseMeta().getQuotedSchemaTableCombination(this.environmentSubstitute(this.meta.getSchemaName()), this.environmentSubstitute(this.meta.getTableName()));
            return true;
        }
        return false;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (LucidDBBulkLoaderMeta)smi;
        this.data = (LucidDBBulkLoaderData)sdi;
        try {
            if (this.data.fifoStream != null) {
                this.data.fifoStream.close();
            }
            if (this.data.sqlRunner != null) {
                this.data.sqlRunner.join();
                this.data.sqlRunner = null;
            }
            if (this.data.db != null) {
                this.data.db.disconnect();
                this.data.db = null;
            }
        }
        catch (Exception e) {
            this.setErrors(1L);
            this.logError("Unexpected error encountered while closing the client connection", e);
        }
        super.dispose(smi, sdi);
    }

    static class SqlRunner
    extends Thread {
        private LucidDBBulkLoaderData data;
        private PreparedStatement ps;
        private SQLException ex;
        List<String> warnings;

        SqlRunner(LucidDBBulkLoaderData data, PreparedStatement ps) {
            this.data = data;
            this.ps = ps;
            this.warnings = new ArrayList<String>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Lifted jumps to return sites
         */
        public void run() {
            try {
                try {
                    this.ps.executeUpdate();
                    for (SQLWarning warning = this.ps.getWarnings(); warning != null; warning = warning.getNextWarning()) {
                        this.warnings.add(warning.getMessage());
                    }
                    Object var3_3 = null;
                }
                catch (SQLException ex) {
                    this.ex = ex;
                    Object var3_4 = null;
                    try {}
                    catch (Throwable throwable) {
                        Object var6_11 = null;
                        this.ps = null;
                        throw throwable;
                    }
                    try {}
                    catch (KettleException ke) {
                        Object var6_10 = null;
                        this.ps = null;
                        return;
                    }
                    this.data.db.closePreparedStatement(this.ps);
                    Object var6_9 = null;
                    this.ps = null;
                    return;
                }
                try {
                    try {
                        this.data.db.closePreparedStatement(this.ps);
                    }
                    catch (KettleException ke) {
                        Object var6_7 = null;
                        this.ps = null;
                        return;
                    }
                    Object var6_6 = null;
                    this.ps = null;
                    return;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    this.ps = null;
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                try {}
                catch (Throwable throwable2) {
                    Object var6_14 = null;
                    this.ps = null;
                    throw throwable2;
                }
                try {}
                catch (KettleException ke) {
                    Object var6_13 = null;
                    this.ps = null;
                    throw throwable;
                }
                this.data.db.closePreparedStatement(this.ps);
                Object var6_12 = null;
                this.ps = null;
                throw throwable;
            }
        }

        void checkExcn() throws SQLException {
            if (this.ex != null) {
                throw this.ex;
            }
        }
    }
}

