/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.luciddbbulkloader;

import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.ProvidesDatabaseConnectionInformation;
import org.pentaho.di.core.SQLStatement;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.DatabaseImpact;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.luciddbbulkloader.LucidDBBulkLoader;
import org.pentaho.di.trans.steps.luciddbbulkloader.LucidDBBulkLoaderData;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LucidDBBulkLoaderMeta
extends BaseStepMeta
implements StepMetaInterface,
ProvidesDatabaseConnectionInformation {
    private static Class<?> PKG = LucidDBBulkLoaderMeta.class;
    private String schemaName;
    private String tableName;
    private String fifoDirectory;
    private String fifoServerName;
    private DatabaseMeta databaseMeta;
    private String[] fieldTable;
    private String[] fieldStream;
    private boolean[] fieldFormatOk;
    private String encoding;
    private int maxErrors;
    private String bufferSize;

    @Override
    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta database) {
        this.databaseMeta = database;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String[] getFieldTable() {
        return this.fieldTable;
    }

    public void setFieldTable(String[] fieldTable) {
        this.fieldTable = fieldTable;
    }

    public String[] getFieldStream() {
        return this.fieldStream;
    }

    public void setFieldStream(String[] fieldStream) {
        this.fieldStream = fieldStream;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode, databases);
    }

    public void allocate(int nrvalues) {
        this.fieldTable = new String[nrvalues];
        this.fieldStream = new String[nrvalues];
        this.fieldFormatOk = new boolean[nrvalues];
    }

    @Override
    public Object clone() {
        LucidDBBulkLoaderMeta retval = (LucidDBBulkLoaderMeta)super.clone();
        int nrvalues = this.fieldTable.length;
        retval.allocate(nrvalues);
        for (int i = 0; i < nrvalues; ++i) {
            retval.fieldTable[i] = this.fieldTable[i];
            retval.fieldStream[i] = this.fieldStream[i];
        }
        return retval;
    }

    private void readData(Node stepnode, List<? extends SharedObjectInterface> databases) throws KettleXMLException {
        try {
            String con = XMLHandler.getTagValue((Node)stepnode, (String)"connection");
            this.databaseMeta = DatabaseMeta.findDatabase(databases, (String)con);
            String serror = XMLHandler.getTagValue((Node)stepnode, (String)"errors");
            this.maxErrors = Const.toInt((String)serror, (int)0);
            this.bufferSize = XMLHandler.getTagValue((Node)stepnode, (String)"buffer_size");
            this.schemaName = XMLHandler.getTagValue((Node)stepnode, (String)"schema");
            this.tableName = XMLHandler.getTagValue((Node)stepnode, (String)"table");
            this.fifoDirectory = XMLHandler.getTagValue((Node)stepnode, (String)"fifo_directory");
            this.fifoServerName = XMLHandler.getTagValue((Node)stepnode, (String)"fifo_server_name");
            this.encoding = XMLHandler.getTagValue((Node)stepnode, (String)"encoding");
            int nrvalues = XMLHandler.countNodes((Node)stepnode, (String)"mapping");
            this.allocate(nrvalues);
            for (int i = 0; i < nrvalues; ++i) {
                Node vnode = XMLHandler.getSubNodeByNr((Node)stepnode, (String)"mapping", (int)i);
                this.fieldTable[i] = XMLHandler.getTagValue((Node)vnode, (String)"stream_name");
                this.fieldStream[i] = XMLHandler.getTagValue((Node)vnode, (String)"field_name");
                if (this.fieldStream[i] == null) {
                    this.fieldStream[i] = this.fieldTable[i];
                }
                this.fieldFormatOk[i] = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)vnode, (String)"field_format_ok"));
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"LucidDBBulkLoaderMeta.Exception.UnableToReadStepInfoFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        this.fieldTable = null;
        this.databaseMeta = null;
        this.maxErrors = 0;
        this.bufferSize = "100000";
        this.schemaName = "";
        this.tableName = BaseMessages.getString(PKG, (String)"LucidDBBulkLoaderMeta.DefaultTableName", (String[])new String[0]);
        this.encoding = "";
        this.fifoDirectory = "/tmp/fifo/";
        this.allocate(0);
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(300);
        retval.append("    ").append(XMLHandler.addTagValue((String)"connection", (String)(this.databaseMeta == null ? "" : this.databaseMeta.getName())));
        retval.append("    ").append(XMLHandler.addTagValue((String)"errors", (int)this.maxErrors));
        retval.append("    ").append(XMLHandler.addTagValue((String)"buffer_size", (String)this.bufferSize));
        retval.append("    ").append(XMLHandler.addTagValue((String)"schema", (String)this.schemaName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"table", (String)this.tableName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"encoding", (String)this.encoding));
        retval.append("    ").append(XMLHandler.addTagValue((String)"fifo_directory", (String)this.fifoDirectory));
        retval.append("    ").append(XMLHandler.addTagValue((String)"fifo_server_name", (String)this.fifoServerName));
        for (int i = 0; i < this.fieldTable.length; ++i) {
            retval.append("      <mapping>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"stream_name", (String)this.fieldTable[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"field_name", (String)this.fieldStream[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"field_format_ok", (boolean)this.fieldFormatOk[i]));
            retval.append("      </mapping>").append(Const.CR);
        }
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, ObjectId id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            this.databaseMeta = rep.loadDatabaseMetaFromStepAttribute(id_step, "id_connection", databases);
            this.maxErrors = (int)rep.getStepAttributeInteger(id_step, "errors");
            this.bufferSize = rep.getStepAttributeString(id_step, "buffer_size");
            this.schemaName = rep.getStepAttributeString(id_step, "schema");
            this.tableName = rep.getStepAttributeString(id_step, "table");
            this.encoding = rep.getStepAttributeString(id_step, "encoding");
            this.fifoDirectory = rep.getStepAttributeString(id_step, "fifo_directory");
            this.fifoServerName = rep.getStepAttributeString(id_step, "fifo_server_name");
            int nrvalues = rep.countNrStepAttributes(id_step, "stream_name");
            this.allocate(nrvalues);
            for (int i = 0; i < nrvalues; ++i) {
                this.fieldTable[i] = rep.getStepAttributeString(id_step, i, "stream_name");
                this.fieldStream[i] = rep.getStepAttributeString(id_step, i, "field_name");
                if (this.fieldStream[i] == null) {
                    this.fieldStream[i] = this.fieldTable[i];
                }
                this.fieldFormatOk[i] = rep.getStepAttributeBoolean(id_step, i, "field_format_ok");
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"LucidDBBulkLoaderMeta.Exception.UnexpectedErrorReadingStepInfoFromRepository", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveDatabaseMetaStepAttribute(id_transformation, id_step, "id_connection", this.databaseMeta);
            rep.saveStepAttribute(id_transformation, id_step, "errors", this.maxErrors);
            rep.saveStepAttribute(id_transformation, id_step, "buffer_size", this.bufferSize);
            rep.saveStepAttribute(id_transformation, id_step, "schema", this.schemaName);
            rep.saveStepAttribute(id_transformation, id_step, "table", this.tableName);
            rep.saveStepAttribute(id_transformation, id_step, "encoding", this.encoding);
            rep.saveStepAttribute(id_transformation, id_step, "fifo_directory", this.fifoDirectory);
            rep.saveStepAttribute(id_transformation, id_step, "fifo_server_name", this.fifoServerName);
            for (int i = 0; i < this.fieldTable.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "stream_name", this.fieldTable[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_name", this.fieldStream[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_format_ok", this.fieldFormatOk[i]);
            }
            if (this.databaseMeta != null) {
                rep.insertStepDatabase(id_transformation, id_step, this.databaseMeta.getObjectId());
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"LucidDBBulkLoaderMeta.Exception.UnableToSaveStepInfoToRepository", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    @Override
    public void getFields(RowMetaInterface rowMeta, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr;
        block17: {
            String error_message = "";
            if (this.databaseMeta != null) {
                Database db = new Database(loggingObject, this.databaseMeta);
                db.shareVariablesWith((VariableSpace)transMeta);
                try {
                    try {
                        boolean error_found;
                        boolean first;
                        db.connect();
                        if (!Const.isEmpty((String)this.tableName)) {
                            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"LucidDBBulkLoaderMeta.CheckResult.TableNameOK", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                            remarks.add((CheckResultInterface)cr);
                            first = true;
                            error_found = false;
                            error_message = "";
                            String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(transMeta.environmentSubstitute(this.schemaName), transMeta.environmentSubstitute(this.tableName));
                            RowMetaInterface r = db.getTableFields(schemaTable);
                            if (r != null) {
                                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"LucidDBBulkLoaderMeta.CheckResult.TableExists", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                                remarks.add((CheckResultInterface)cr);
                                first = true;
                                error_found = false;
                                error_message = "";
                                for (int i = 0; i < this.fieldTable.length; ++i) {
                                    String field = this.fieldTable[i];
                                    ValueMetaInterface v = r.searchValueMeta(field);
                                    if (v != null) continue;
                                    if (first) {
                                        first = false;
                                        error_message = error_message + BaseMessages.getString(PKG, (String)"LucidDBBulkLoaderMeta.CheckResult.MissingFieldsToLoadInTargetTable", (String[])new String[0]) + Const.CR;
                                    }
                                    error_found = true;
                                    error_message = error_message + "\t\t" + field + Const.CR;
                                }
                                cr = error_found ? new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"LucidDBBulkLoaderMeta.CheckResult.AllFieldsFoundInTargetTable", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                                remarks.add((CheckResultInterface)cr);
                            } else {
                                error_message = BaseMessages.getString(PKG, (String)"LucidDBBulkLoaderMeta.CheckResult.CouldNotReadTableInfo", (String[])new String[0]);
                                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                                remarks.add((CheckResultInterface)cr);
                            }
                        }
                        if (prev != null && prev.size() > 0) {
                            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"LucidDBBulkLoaderMeta.CheckResult.StepReceivingDatas", (String[])new String[]{prev.size() + ""}), (CheckResultSourceInterface)stepMeta);
                            remarks.add((CheckResultInterface)cr);
                            first = true;
                            error_message = "";
                            error_found = false;
                            for (int i = 0; i < this.fieldStream.length; ++i) {
                                ValueMetaInterface v = prev.searchValueMeta(this.fieldStream[i]);
                                if (v != null) continue;
                                if (first) {
                                    first = false;
                                    error_message = error_message + BaseMessages.getString(PKG, (String)"LucidDBBulkLoaderMeta.CheckResult.MissingFieldsInInput", (String[])new String[0]) + Const.CR;
                                }
                                error_found = true;
                                error_message = error_message + "\t\t" + this.fieldStream[i] + Const.CR;
                            }
                            cr = error_found ? new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"LucidDBBulkLoaderMeta.CheckResult.AllFieldsFoundInInput", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                            remarks.add((CheckResultInterface)cr);
                        } else {
                            error_message = BaseMessages.getString(PKG, (String)"LucidDBBulkLoaderMeta.CheckResult.MissingFieldsInInput3", (String[])new String[0]) + Const.CR;
                            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                            remarks.add((CheckResultInterface)cr);
                        }
                    }
                    catch (KettleException e) {
                        error_message = BaseMessages.getString(PKG, (String)"LucidDBBulkLoaderMeta.CheckResult.DatabaseErrorOccurred", (String[])new String[0]) + e.getMessage();
                        cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                        Object var19_21 = null;
                        db.disconnect();
                        break block17;
                    }
                    Object var19_20 = null;
                }
                catch (Throwable throwable) {
                    Object var19_22 = null;
                    db.disconnect();
                    throw throwable;
                }
                db.disconnect();
            } else {
                error_message = BaseMessages.getString(PKG, (String)"LucidDBBulkLoaderMeta.CheckResult.InvalidConnection", (String[])new String[0]);
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"LucidDBBulkLoaderMeta.CheckResult.StepReceivingInfoFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            return;
        }
        cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"LucidDBBulkLoaderMeta.CheckResult.NoInputError", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
    }

    @Override
    public SQLStatement getSQLStatements(TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev) throws KettleStepException {
        SQLStatement retval;
        block11: {
            retval = new SQLStatement(stepMeta.getName(), this.databaseMeta, null);
            if (this.databaseMeta != null) {
                if (prev != null && prev.size() > 0) {
                    RowMeta tableFields = new RowMeta();
                    for (int i = 0; i < this.fieldTable.length; ++i) {
                        ValueMetaInterface v = prev.searchValueMeta(this.fieldStream[i]);
                        if (v == null) {
                            throw new KettleStepException("Unable to find field [" + this.fieldStream[i] + "] in the input rows");
                        }
                        ValueMetaInterface tableField = v.clone();
                        tableField.setName(this.fieldTable[i]);
                        tableFields.addValueMeta(tableField);
                    }
                    if (!Const.isEmpty((String)this.tableName)) {
                        Database db = new Database(loggingObject, this.databaseMeta);
                        db.shareVariablesWith((VariableSpace)transMeta);
                        try {
                            db.connect();
                            String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(transMeta.environmentSubstitute(this.schemaName), transMeta.environmentSubstitute(this.tableName));
                            String sql = db.getDDL(schemaTable, (RowMetaInterface)tableFields, null, false, null, true);
                            if (Const.isEmpty((String)sql)) {
                                retval.setSQL(null);
                                break block11;
                            }
                            retval.setSQL(sql);
                        }
                        catch (KettleException e) {
                            retval.setError(BaseMessages.getString(PKG, (String)"LucidDBBulkLoaderMeta.GetSQL.ErrorOccurred", (String[])new String[0]) + e.getMessage());
                        }
                    } else {
                        retval.setError(BaseMessages.getString(PKG, (String)"LucidDBBulkLoaderMeta.GetSQL.NoTableDefinedOnConnection", (String[])new String[0]));
                    }
                } else {
                    retval.setError(BaseMessages.getString(PKG, (String)"LucidDBBulkLoaderMeta.GetSQL.NotReceivingAnyFields", (String[])new String[0]));
                }
            } else {
                retval.setError(BaseMessages.getString(PKG, (String)"LucidDBBulkLoaderMeta.GetSQL.NoConnectionDefined", (String[])new String[0]));
            }
        }
        return retval;
    }

    @Override
    public void analyseImpact(List<DatabaseImpact> impact, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) throws KettleStepException {
        if (prev != null) {
            for (int i = 0; i < this.fieldTable.length; ++i) {
                ValueMetaInterface v = prev.searchValueMeta(this.fieldStream[i]);
                DatabaseImpact ii = new DatabaseImpact(3, transMeta.getName(), stepMeta.getName(), this.databaseMeta.getDatabaseName(), transMeta.environmentSubstitute(this.tableName), this.fieldTable[i], this.fieldStream[i], v != null ? v.getOrigin() : "?", "", "Type = " + v.toStringMeta());
                impact.add(ii);
            }
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new LucidDBBulkLoader(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new LucidDBBulkLoaderData();
    }

    @Override
    public DatabaseMeta[] getUsedDatabaseConnections() {
        if (this.databaseMeta != null) {
            return new DatabaseMeta[]{this.databaseMeta};
        }
        return super.getUsedDatabaseConnections();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public RowMetaInterface getRequiredFields(VariableSpace space) throws KettleException {
        Database db;
        block5: {
            String realTableName = space.environmentSubstitute(this.tableName);
            String realSchemaName = space.environmentSubstitute(this.schemaName);
            if (this.databaseMeta == null) throw new KettleException(BaseMessages.getString(PKG, (String)"LucidDBBulkLoaderMeta.Exception.ConnectionNotDefined", (String[])new String[0]));
            db = new Database(loggingObject, this.databaseMeta);
            db.connect();
            if (Const.isEmpty((String)realTableName)) throw new KettleException(BaseMessages.getString(PKG, (String)"LucidDBBulkLoaderMeta.Exception.TableNotSpecified", (String[])new String[0]));
            String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(realSchemaName, realTableName);
            if (!db.checkTableExists(schemaTable)) break block5;
            RowMetaInterface rowMetaInterface = db.getTableFields(schemaTable);
            Object var8_8 = null;
            db.disconnect();
            return rowMetaInterface;
        }
        try {
            try {
                throw new KettleException(BaseMessages.getString(PKG, (String)"LucidDBBulkLoaderMeta.Exception.TableNotFound", (String[])new String[0]));
            }
            catch (Exception e) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"LucidDBBulkLoaderMeta.Exception.ErrorGettingFields", (String[])new String[0]), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            db.disconnect();
            throw throwable;
        }
    }

    @Override
    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getDelimiter() {
        return ",";
    }

    public String getEnclosure() {
        return "\"";
    }

    public int getMaxErrors() {
        return this.maxErrors;
    }

    public void setMaxErrors(int maxErrors) {
        this.maxErrors = maxErrors;
    }

    public String getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(String bufferSize) {
        this.bufferSize = bufferSize;
    }

    public boolean[] getFieldFormatOk() {
        return this.fieldFormatOk;
    }

    public void setFieldFormatOk(boolean[] fieldFormatOk) {
        this.fieldFormatOk = fieldFormatOk;
    }

    public String getFifoServerName() {
        return this.fifoServerName;
    }

    public void setFifoServerName(String fifoServerName) {
        this.fifoServerName = fifoServerName;
    }

    public String getFifoDirectory() {
        return this.fifoDirectory;
    }

    public void setFifoDirectory(String fifoDirectory) {
        this.fifoDirectory = fifoDirectory;
    }

    @Override
    public String getMissingDatabaseConnectionInformationMessage() {
        return null;
    }
}

