/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mapping;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogTableField;
import org.pentaho.di.core.logging.TransLogTable;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.SingleThreadedTransExecutor;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.RemoteStep;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaDataCombi;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mapping.MappingData;
import org.pentaho.di.trans.steps.mapping.MappingIODefinition;
import org.pentaho.di.trans.steps.mapping.MappingMeta;
import org.pentaho.di.trans.steps.mapping.MappingParameters;
import org.pentaho.di.trans.steps.mapping.MappingValueRename;
import org.pentaho.di.trans.steps.mappinginput.MappingInput;
import org.pentaho.di.trans.steps.mappingoutput.MappingOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mapping
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = MappingMeta.class;
    private MappingMeta meta;
    private MappingData data;

    public Mapping(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        try {
            this.meta = (MappingMeta)smi;
            this.data = (MappingData)sdi;
            MappingInput[] mappingInputs = this.data.mappingTrans.findMappingInput();
            MappingOutput[] mappingOutputs = this.data.mappingTrans.findMappingOutput();
            switch (this.data.mappingTransMeta.getTransformationType()) {
                case Normal: 
                case SerialSingleThreaded: {
                    if (!this.getInputRowSets().isEmpty()) {
                        for (RowSet rowSet : new ArrayList<RowSet>(this.getInputRowSets())) {
                            if (mappingInputs.length == 1) {
                                mappingInputs[0].getInputRowSets().add(rowSet);
                                continue;
                            }
                            throw new KettleException("Unsupported situation detected where more than one Mapping Input step needs to be handled.  To solve it, insert a dummy step before the mapping step.");
                        }
                        this.getInputRowSets().clear();
                    }
                    if (!this.getRemoteInputSteps().isEmpty()) {
                        for (RemoteStep remoteStep : this.getRemoteInputSteps()) {
                            if (mappingInputs.length == 1) {
                                mappingInputs[0].getRemoteInputSteps().add(remoteStep);
                                continue;
                            }
                            throw new KettleException("Unsupported situation detected where a remote input step is expecting data to end up in a particular Mapping Input step of a sub-transformation.  To solve it, insert a dummy step before the mapping.");
                        }
                        this.getRemoteInputSteps().clear();
                    }
                    this.data.mappingTrans.startThreads();
                    if (this.getTransMeta().getTransformationType() == TransMeta.TransformationType.Normal) {
                        this.data.mappingTrans.waitUntilFinished();
                        Result result = this.data.mappingTrans.getResult();
                        this.setErrors(result.getNrErrors());
                        this.setLinesRead(result.getNrLinesRead());
                        this.setLinesWritten(result.getNrLinesWritten());
                        this.setLinesInput(result.getNrLinesInput());
                        this.setLinesOutput(result.getNrLinesOutput());
                        this.setLinesUpdated(result.getNrLinesUpdated());
                        this.setLinesRejected(result.getNrLinesRejected());
                    }
                    return false;
                }
                case SingleThreaded: {
                    boolean result;
                    if (mappingInputs.length > 1 || mappingOutputs.length > 1) {
                        throw new KettleException("Multiple input or output steps are not supported for a single threaded mapping.");
                    }
                    System.out.println("# of input buffers: " + mappingInputs[0].getInputRowSets().size());
                    if (mappingInputs[0].getInputRowSets().size() > 0) {
                        System.out.println("Input buffer 0 size: " + mappingInputs[0].getInputRowSets().get(0).size());
                    }
                    if (!(result = this.data.singleThreadedTransExcecutor.oneIteration())) {
                        this.data.singleThreadedTransExcecutor.dispose();
                        this.setOutputDone();
                        return false;
                    }
                    return true;
                }
            }
            throw new KettleException("Transformation type '" + this.data.mappingTransMeta.getTransformationType().getDescription() + "' is an unsupported transformation type for a mapping");
        }
        catch (Throwable t) {
            if (this.data.mappingTrans != null) {
                this.data.mappingTrans.stopAll();
            }
            throw new KettleException(t);
        }
    }

    private void setMappingParameters() throws KettleException {
        MappingParameters mappingParameters = this.meta.getMappingParameters();
        if (mappingParameters != null) {
            int i;
            String[] parameterValues;
            String[] parameters;
            if (mappingParameters.isInheritingAllVariables()) {
                parameters = this.data.mappingTransMeta.listParameters();
                parameterValues = new String[parameters.length];
                for (i = 0; i < parameters.length; ++i) {
                    parameterValues[i] = this.getVariable(parameters[i]);
                }
            } else {
                parameters = mappingParameters.getVariable();
                parameterValues = new String[parameters.length];
                for (i = 0; i < parameters.length; ++i) {
                    parameterValues[i] = this.environmentSubstitute(mappingParameters.getInputField()[i]);
                }
            }
            for (i = 0; i < parameters.length; ++i) {
                String value = Const.NVL((String)parameterValues[i], (String)"");
                this.data.mappingTrans.setParameterValue(parameters[i], value);
            }
            this.data.mappingTrans.activateParameters();
        }
    }

    public void prepareMappingExecution() throws KettleException {
        this.data.mappingTrans = new Trans(this.data.mappingTransMeta, this.getTrans());
        this.setMappingParameters();
        if (this.data.mappingTransMeta.getTransformationType() != TransMeta.TransformationType.Normal) {
            this.data.mappingTrans.getTransMeta().setUsingThreadPriorityManagment(false);
        }
        this.data.mappingTrans.setParentTrans(this.getTrans());
        this.data.mappingTrans.setSafeModeEnabled(this.getTrans().isSafeModeEnabled());
        this.data.mappingTrans.setMappingStepName(this.getStepname());
        try {
            this.data.mappingTrans.prepareExecution(this.getTransMeta().getArguments());
        }
        catch (KettleException e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"Mapping.Exception.UnableToPrepareExecutionOfMapping", (String[])new String[0]), (Throwable)e);
        }
        switch (this.data.mappingTransMeta.getTransformationType()) {
            case Normal: 
            case SerialSingleThreaded: {
                break;
            }
            case SingleThreaded: {
                this.data.singleThreadedTransExcecutor = new SingleThreadedTransExecutor(this.data.mappingTrans);
                if (this.data.singleThreadedTransExcecutor.init()) break;
                throw new KettleException(BaseMessages.getString(PKG, (String)"Mapping.Exception.UnableToInitSingleThreadedTransformation", (String[])new String[0]));
            }
        }
        MappingInput[] mappingInputs = this.data.mappingTrans.findMappingInput();
        LogTableField readField = this.data.mappingTransMeta.getTransLogTable().findField(TransLogTable.ID.LINES_READ);
        if (readField.getSubject() == null && mappingInputs != null && mappingInputs.length >= 1) {
            readField.setSubject((Object)mappingInputs[0].getStepMeta());
        }
        MappingOutput[] mappingOutputs = this.data.mappingTrans.findMappingOutput();
        LogTableField writeField = this.data.mappingTransMeta.getTransLogTable().findField(TransLogTable.ID.LINES_WRITTEN);
        if (writeField.getSubject() == null && mappingOutputs != null && mappingOutputs.length >= 1) {
            writeField.setSubject((Object)mappingOutputs[0].getStepMeta());
        }
        for (MappingIODefinition inputDefinition : this.meta.getInputMappings()) {
            StepInterface[] sourceSteps;
            if (!Const.isEmpty((String)inputDefinition.getInputStepname())) {
                StepInterface sourceStep = this.getTrans().findRunThread(inputDefinition.getInputStepname());
                if (sourceStep == null) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"MappingDialog.Exception.StepNameNotFound", (String[])new String[]{inputDefinition.getInputStepname()}));
                }
                sourceSteps = new StepInterface[]{sourceStep};
            } else {
                List<StepMeta> prevSteps = this.getTransMeta().findPreviousSteps(this.getStepMeta());
                sourceSteps = new StepInterface[prevSteps.size()];
                for (int s = 0; s < sourceSteps.length; ++s) {
                    sourceSteps[s] = this.getTrans().findRunThread(prevSteps.get(s).getName());
                }
            }
            MappingInput mappingInputTarget = null;
            MappingInput[] mappingInputSteps = this.data.mappingTrans.findMappingInput();
            if (Const.isEmpty((String)inputDefinition.getOutputStepname())) {
                if (mappingInputSteps.length == 0) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"MappingDialog.Exception.OneMappingInputStepRequired", (String[])new String[0]));
                }
                if (mappingInputSteps.length > 1) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"MappingDialog.Exception.OnlyOneMappingInputStepAllowed", (String[])new String[]{"" + mappingInputSteps.length}));
                }
                mappingInputTarget = mappingInputSteps[0];
            } else {
                for (int s = 0; s < mappingInputSteps.length && mappingInputTarget == null; ++s) {
                    if (!mappingInputSteps[s].getStepname().equals(inputDefinition.getOutputStepname())) continue;
                    mappingInputTarget = mappingInputSteps[s];
                }
                if (mappingInputTarget == null) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"MappingDialog.Exception.StepNameNotFound", (String[])new String[]{inputDefinition.getOutputStepname()}));
                }
            }
            if (inputDefinition.isRenamingOnOutput()) {
                Mapping.addInputRenames(this.data.inputRenameList, inputDefinition.getValueRenames());
            }
            mappingInputTarget.setConnectorSteps(sourceSteps, inputDefinition.getValueRenames(), this.getStepname());
        }
        for (MappingIODefinition outputDefinition : this.meta.getOutputMappings()) {
            StepInterface[] targetSteps;
            MappingOutput mappingOutputSource = (MappingOutput)this.data.mappingTrans.findRunThread(outputDefinition.getInputStepname());
            if (mappingOutputSource == null) {
                MappingOutput[] mappingOutputSteps = this.data.mappingTrans.findMappingOutput();
                if (mappingOutputSteps.length == 0) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"MappingDialog.Exception.OneMappingOutputStepRequired", (String[])new String[0]));
                }
                if (mappingOutputSteps.length > 1) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"MappingDialog.Exception.OnlyOneMappingOutputStepAllowed", (String[])new String[]{"" + mappingOutputSteps.length}));
                }
                mappingOutputSource = mappingOutputSteps[0];
            }
            if (!Const.isEmpty((String)outputDefinition.getOutputStepname())) {
                StepInterface target = this.getTrans().findRunThread(outputDefinition.getOutputStepname());
                if (target == null) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"MappingDialog.Exception.StepNameNotFound", (String[])new String[]{outputDefinition.getOutputStepname()}));
                }
                targetSteps = new StepInterface[]{target};
            } else {
                List<StepMeta> nextSteps = this.getTransMeta().findNextSteps(this.getStepMeta());
                targetSteps = new StepInterface[nextSteps.size()];
                for (int s = 0; s < targetSteps.length; ++s) {
                    targetSteps[s] = this.getTrans().findRunThread(nextSteps.get(s).getName());
                }
            }
            mappingOutputSource.setConnectorSteps(targetSteps, this.data.inputRenameList, outputDefinition.getValueRenames());
            mappingOutputSource.setDistributed(this.isDistributed());
        }
        this.getTrans().getActiveSubtransformations().put(this.getStepname(), this.data.mappingTrans);
    }

    public static void addInputRenames(List<MappingValueRename> renameList, List<MappingValueRename> addRenameList) {
        for (MappingValueRename rename : addRenameList) {
            if (renameList.indexOf(rename) >= 0) continue;
            renameList.add(rename);
        }
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (MappingMeta)smi;
        this.data = (MappingData)sdi;
        if (super.init(smi, sdi)) {
            try {
                this.meta.setRepository(this.getTransMeta().getRepository());
                this.data.mappingTransMeta = MappingMeta.loadMappingMeta(this.meta, this.meta.getRepository(), this);
                if (this.data.mappingTransMeta != null) {
                    this.prepareMappingExecution();
                    this.lookupStatusStepNumbers();
                    return true;
                }
                this.logError("No valid mapping was specified!");
                return false;
            }
            catch (Exception e) {
                this.logError("Unable to load the mapping transformation because of an error : " + e.toString());
                this.logError(Const.getStackTracker((Throwable)e));
            }
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        if (this.data.wasStarted) {
            this.data.mappingTrans.waitUntilFinished();
            this.getTrans().getActiveSubtransformations().remove(this.getStepname());
            if (this.data.mappingTrans.getErrors() > 0) {
                this.logError(BaseMessages.getString(PKG, (String)"Mapping.Log.ErrorOccurredInSubTransformation", (String[])new String[0]));
                this.setErrors(1L);
            }
        }
        super.dispose(smi, sdi);
    }

    @Override
    public void stopRunning(StepMetaInterface stepMetaInterface, StepDataInterface stepDataInterface) throws KettleException {
        if (this.data.mappingTrans != null) {
            this.data.mappingTrans.stopAll();
        }
    }

    @Override
    public void stopAll() {
        if (this.data.mappingTrans != null) {
            this.data.mappingTrans.stopAll();
        }
        super.stopAll();
    }

    private void lookupStatusStepNumbers() {
        if (this.data.mappingTrans != null) {
            List<StepMetaDataCombi> steps = this.data.mappingTrans.getSteps();
            for (int i = 0; i < steps.size(); ++i) {
                StepMetaDataCombi sid = steps.get(i);
                BaseStep rt = (BaseStep)sid.step;
                if (rt.getStepname().equals(this.data.mappingTransMeta.getTransLogTable().getStepnameRead())) {
                    this.data.linesReadStepNr = i;
                }
                if (rt.getStepname().equals(this.data.mappingTransMeta.getTransLogTable().getStepnameInput())) {
                    this.data.linesInputStepNr = i;
                }
                if (rt.getStepname().equals(this.data.mappingTransMeta.getTransLogTable().getStepnameWritten())) {
                    this.data.linesWrittenStepNr = i;
                }
                if (rt.getStepname().equals(this.data.mappingTransMeta.getTransLogTable().getStepnameOutput())) {
                    this.data.linesOutputStepNr = i;
                }
                if (rt.getStepname().equals(this.data.mappingTransMeta.getTransLogTable().getStepnameUpdated())) {
                    this.data.linesUpdatedStepNr = i;
                }
                if (!rt.getStepname().equals(this.data.mappingTransMeta.getTransLogTable().getStepnameRejected())) continue;
                this.data.linesRejectedStepNr = i;
            }
        }
    }

    @Override
    public long getLinesInput() {
        if (this.data != null && this.data.linesInputStepNr != -1) {
            return this.data.mappingTrans.getSteps().get((int)this.data.linesInputStepNr).step.getLinesInput();
        }
        return 0L;
    }

    @Override
    public long getLinesOutput() {
        if (this.data != null && this.data.linesOutputStepNr != -1) {
            return this.data.mappingTrans.getSteps().get((int)this.data.linesOutputStepNr).step.getLinesOutput();
        }
        return 0L;
    }

    @Override
    public long getLinesRead() {
        if (this.data != null && this.data.linesReadStepNr != -1) {
            return this.data.mappingTrans.getSteps().get((int)this.data.linesReadStepNr).step.getLinesRead();
        }
        return 0L;
    }

    @Override
    public long getLinesRejected() {
        if (this.data != null && this.data.linesRejectedStepNr != -1) {
            return this.data.mappingTrans.getSteps().get((int)this.data.linesRejectedStepNr).step.getLinesRejected();
        }
        return 0L;
    }

    @Override
    public long getLinesUpdated() {
        if (this.data != null && this.data.linesUpdatedStepNr != -1) {
            return this.data.mappingTrans.getSteps().get((int)this.data.linesUpdatedStepNr).step.getLinesUpdated();
        }
        return 0L;
    }

    @Override
    public long getLinesWritten() {
        if (this.data != null && this.data.linesWrittenStepNr != -1) {
            return this.data.mappingTrans.getSteps().get((int)this.data.linesWrittenStepNr).step.getLinesWritten();
        }
        return 0L;
    }

    @Override
    public int rowsetInputSize() {
        int size = 0;
        for (MappingInput input : this.data.mappingTrans.findMappingInput()) {
            for (RowSet rowSet : input.getInputRowSets()) {
                size += rowSet.size();
            }
        }
        return size;
    }

    @Override
    public int rowsetOutputSize() {
        int size = 0;
        for (MappingOutput output : this.data.mappingTrans.findMappingOutput()) {
            for (RowSet rowSet : output.getOutputRowSets()) {
                size += rowSet.size();
            }
        }
        return size;
    }

    public Trans getMappingTrans() {
        return this.data.mappingTrans;
    }

    @Override
    public void addRowListener(RowListener rowListener) {
        MappingOutput[] mappingOutputs = this.data.mappingTrans.findMappingOutput();
        if (mappingOutputs == null || mappingOutputs.length == 0) {
            return;
        }
        for (MappingOutput mappingOutput : mappingOutputs) {
            mappingOutput.addRowListener(rowListener);
        }
    }
}

