/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mappinginput;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mapping.MappingValueRename;
import org.pentaho.di.trans.steps.mappinginput.MappingInput;
import org.pentaho.di.trans.steps.mappinginput.MappingInputData;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingInputMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = MappingInputMeta.class;
    private String[] fieldName;
    private int[] fieldType;
    private int[] fieldLength;
    private int[] fieldPrecision;
    private boolean selectingAndSortingUnspecifiedFields;
    private volatile RowMetaInterface inputRowMeta;
    private volatile List<MappingValueRename> valueRenames;

    public int[] getFieldLength() {
        return this.fieldLength;
    }

    public void setFieldLength(int[] fieldLength) {
        this.fieldLength = fieldLength;
    }

    public String[] getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String[] fieldName) {
        this.fieldName = fieldName;
    }

    public int[] getFieldPrecision() {
        return this.fieldPrecision;
    }

    public void setFieldPrecision(int[] fieldPrecision) {
        this.fieldPrecision = fieldPrecision;
    }

    public int[] getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(int[] fieldType) {
        this.fieldType = fieldType;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        MappingInputMeta retval = (MappingInputMeta)super.clone();
        int nrfields = this.fieldName.length;
        retval.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            retval.fieldName[i] = this.fieldName[i];
            retval.fieldType[i] = this.fieldType[i];
            this.fieldLength[i] = this.fieldLength[i];
            this.fieldPrecision[i] = this.fieldPrecision[i];
        }
        return retval;
    }

    public void allocate(int nrfields) {
        this.fieldName = new String[nrfields];
        this.fieldType = new int[nrfields];
        this.fieldLength = new int[nrfields];
        this.fieldPrecision = new int[nrfields];
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrfields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.fieldName[i] = XMLHandler.getTagValue((Node)fnode, (String)"name");
                this.fieldType[i] = ValueMeta.getType((String)XMLHandler.getTagValue((Node)fnode, (String)"type"));
                String slength = XMLHandler.getTagValue((Node)fnode, (String)"length");
                String sprecision = XMLHandler.getTagValue((Node)fnode, (String)"precision");
                this.fieldLength[i] = Const.toInt((String)slength, (int)-1);
                this.fieldPrecision[i] = Const.toInt((String)sprecision, (int)-1);
            }
            this.selectingAndSortingUnspecifiedFields = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)fields, (String)"select_unspecified"));
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"MappingInputMeta.Exception.UnableToLoadStepInfoFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(300);
        retval.append("    <fields>").append(Const.CR);
        for (int i = 0; i < this.fieldName.length; ++i) {
            if (this.fieldName[i] == null || this.fieldName[i].length() == 0) continue;
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)this.fieldName[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"type", (String)ValueMeta.getTypeDesc((int)this.fieldType[i])));
            retval.append("        ").append(XMLHandler.addTagValue((String)"length", (int)this.fieldLength[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"precision", (int)this.fieldPrecision[i]));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("        ").append(XMLHandler.addTagValue((String)"select_unspecified", (boolean)this.selectingAndSortingUnspecifiedFields));
        retval.append("    </fields>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void setDefault() {
        int nrfields = 0;
        this.selectingAndSortingUnspecifiedFields = false;
        this.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            this.fieldName[i] = "field" + i;
            this.fieldType[i] = 2;
            this.fieldLength[i] = 30;
            this.fieldPrecision[i] = -1;
        }
    }

    @Override
    public void getFields(RowMetaInterface row, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        block12: {
            block10: {
                block11: {
                    if (this.inputRowMeta == null || this.inputRowMeta.isEmpty()) break block10;
                    if (!this.selectingAndSortingUnspecifiedFields) break block11;
                    if (this.valueRenames != null) {
                        for (MappingValueRename valueRename : this.valueRenames) {
                            ValueMetaInterface valueMeta = this.inputRowMeta.searchValueMeta(valueRename.getSourceValueName());
                            if (valueMeta == null) {
                                throw new KettleStepException(BaseMessages.getString(PKG, (String)"MappingInput.Exception.UnableToFindMappedValue", (String[])new String[]{valueRename.getSourceValueName()}));
                            }
                            valueMeta.setName(valueRename.getTargetValueName());
                        }
                    }
                    RowMeta newRow = new RowMeta();
                    for (int i = 0; i < this.fieldName.length; ++i) {
                        int index = this.inputRowMeta.indexOfValue(this.fieldName[i]);
                        if (index < 0) {
                            throw new KettleStepException(BaseMessages.getString(PKG, (String)"MappingInputMeta.Exception.UnknownField", (String[])new String[]{this.fieldName[i]}));
                        }
                        newRow.addValueMeta(this.inputRowMeta.getValueMeta(index));
                    }
                    ArrayList<String> extra = new ArrayList<String>();
                    for (int i = 0; i < this.inputRowMeta.size(); ++i) {
                        String fieldName = this.inputRowMeta.getValueMeta(i).getName();
                        if (newRow.indexOfValue(fieldName) >= 0) continue;
                        extra.add(fieldName);
                    }
                    Collections.sort(extra);
                    for (String fieldName : extra) {
                        ValueMetaInterface extraValue = this.inputRowMeta.searchValueMeta(fieldName);
                        newRow.addValueMeta(extraValue);
                    }
                    row.mergeRowMeta((RowMetaInterface)newRow);
                    break block12;
                }
                row.mergeRowMeta(this.inputRowMeta);
                if (row.isEmpty()) break block12;
                for (int i = 0; i < this.fieldName.length; ++i) {
                    if (row.indexOfValue(this.fieldName[i]) >= 0) continue;
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"MappingInputMeta.Exception.UnknownField", (String[])new String[]{this.fieldName[i]}));
                }
                break block12;
            }
            for (int i = 0; i < this.fieldName.length; ++i) {
                if (Const.isEmpty((String)this.fieldName[i])) continue;
                ValueMeta v = new ValueMeta(this.fieldName[i], this.fieldType[i]);
                if (v.getType() == 0) {
                    v.setType(2);
                }
                v.setLength(this.fieldLength[i]);
                v.setPrecision(this.fieldPrecision[i]);
                v.setOrigin(origin);
                row.addValueMeta((ValueMetaInterface)v);
            }
        }
    }

    @Override
    public void readRep(Repository rep, ObjectId id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                this.fieldName[i] = rep.getStepAttributeString(id_step, i, "field_name");
                this.fieldType[i] = ValueMeta.getType((String)rep.getStepAttributeString(id_step, i, "field_type"));
                this.fieldLength[i] = (int)rep.getStepAttributeInteger(id_step, i, "field_length");
                this.fieldPrecision[i] = (int)rep.getStepAttributeInteger(id_step, i, "field_precision");
            }
            this.selectingAndSortingUnspecifiedFields = rep.getStepAttributeBoolean(id_step, "select_unspecified");
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"MappingInputMeta.Exception.UnexpectedErrorInReadingStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            for (int i = 0; i < this.fieldName.length; ++i) {
                if (this.fieldName[i] == null || this.fieldName[i].length() == 0) continue;
                rep.saveStepAttribute(id_transformation, id_step, i, "field_name", this.fieldName[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_type", ValueMeta.getTypeDesc((int)this.fieldType[i]));
                rep.saveStepAttribute(id_transformation, id_step, i, "field_length", this.fieldLength[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_precision", this.fieldPrecision[i]);
            }
            rep.saveStepAttribute(id_transformation, id_step, "select_unspecified", this.selectingAndSortingUnspecifiedFields);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"MappingInputMeta.Exception.UnableToSaveStepInfo", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepinfo, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"MappingInputMeta.CheckResult.NotReceivingFieldsError", (String[])new String[0]), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"MappingInputMeta.CheckResult.StepReceivingDatasFromPreviousOne", (String[])new String[]{prev.size() + ""}), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"MappingInputMeta.CheckResult.StepReceivingInfoFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"MappingInputMeta.CheckResult.NoInputReceived", (String[])new String[0]), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new MappingInput(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new MappingInputData();
    }

    public void setInputRowMeta(RowMetaInterface inputRowMeta) {
        this.inputRowMeta = inputRowMeta;
    }

    public RowMetaInterface getInputRowMeta() {
        return this.inputRowMeta;
    }

    public List<MappingValueRename> getValueRenames() {
        return this.valueRenames;
    }

    public void setValueRenames(List<MappingValueRename> valueRenames) {
        this.valueRenames = valueRenames;
    }

    public boolean isSelectingAndSortingUnspecifiedFields() {
        return this.selectingAndSortingUnspecifiedFields;
    }

    public void setSelectingAndSortingUnspecifiedFields(boolean selectingAndSortingUnspecifiedFields) {
        this.selectingAndSortingUnspecifiedFields = selectingAndSortingUnspecifiedFields;
    }
}

