/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.memgroupby;

import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueDataUtil;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.memgroupby.Aggregate;
import org.pentaho.di.trans.steps.memgroupby.MemoryGroupByData;
import org.pentaho.di.trans.steps.memgroupby.MemoryGroupByMeta;

public class MemoryGroupBy
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = MemoryGroupByMeta.class;
    private MemoryGroupByMeta meta = (MemoryGroupByMeta)this.getStepMeta().getStepMetaInterface();
    private MemoryGroupByData data;

    public MemoryGroupBy(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
        this.data = (MemoryGroupByData)stepDataInterface;
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (MemoryGroupByMeta)smi;
        this.data = (MemoryGroupByData)sdi;
        Object[] r = this.getRow();
        if (this.first) {
            int i;
            this.data.inputRowMeta = this.getInputRowMeta();
            if (this.data.inputRowMeta == null) {
                this.data.inputRowMeta = this.getTransMeta().getPrevStepFields(this.getStepMeta());
            }
            this.data.outputRowMeta = this.data.inputRowMeta.clone();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
            this.data.subjectnrs = new int[this.meta.getSubjectField().length];
            for (i = 0; i < this.meta.getSubjectField().length; ++i) {
                this.data.subjectnrs[i] = this.data.inputRowMeta.indexOfValue(this.meta.getSubjectField()[i]);
                if (this.data.subjectnrs[i] >= 0) continue;
                this.logError(BaseMessages.getString(PKG, (String)"MemoryGroupBy.Log.AggregateSubjectFieldCouldNotFound", (String[])new String[]{this.meta.getSubjectField()[i]}));
                this.setErrors(1L);
                this.stopAll();
                return false;
            }
            this.data.groupnrs = new int[this.meta.getGroupField().length];
            for (i = 0; i < this.meta.getGroupField().length; ++i) {
                this.data.groupnrs[i] = this.data.inputRowMeta.indexOfValue(this.meta.getGroupField()[i]);
                if (this.data.groupnrs[i] >= 0) continue;
                this.logError(BaseMessages.getString(PKG, (String)"MemoryGroupBy.Log.GroupFieldCouldNotFound", (String[])new String[]{this.meta.getGroupField()[i]}));
                this.setErrors(1L);
                this.stopAll();
                return false;
            }
            this.data.valueMetaInteger = new ValueMeta("count", 5);
            this.data.valueMetaNumber = new ValueMeta("sum", 1);
            this.initGroupMeta(this.data.inputRowMeta);
        }
        if (this.first) {
            this.newAggregate(r, null);
            this.data.groupAggMeta = new RowMeta();
            this.data.groupAggMeta.addRowMeta(this.data.groupMeta);
            this.data.groupAggMeta.addRowMeta(this.data.aggMeta);
        }
        if (r == null) {
            this.handleLastOfGroup();
            this.setOutputDone();
            return false;
        }
        if (this.first || this.data.newBatch) {
            this.first = false;
            this.data.newBatch = false;
        }
        this.addToAggregate(r);
        if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"MemoryGroupBy.LineNumber", (String[])new String[0]) + this.getLinesRead());
        }
        return true;
    }

    private void handleLastOfGroup() throws KettleException {
        for (MemoryGroupByData.HashEntry entry : this.data.map.keySet()) {
            int i;
            Aggregate aggregate = this.data.map.get(entry);
            Object[] aggregateResult = this.getAggregateResult(aggregate);
            Object[] outputRowData = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
            int index = 0;
            for (i = 0; i < this.data.groupMeta.size(); ++i) {
                outputRowData[index++] = entry.getGroupData()[i];
            }
            for (i = 0; i < this.data.aggMeta.size(); ++i) {
                outputRowData[index++] = aggregateResult[i];
            }
            this.putRow(this.data.outputRowMeta, outputRowData);
        }
        if (this.data.map.isEmpty() && this.meta.isAlwaysGivingBackOneRow()) {
            int i;
            Object[] outputRowData = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
            int index = 0;
            for (i = 0; i < this.data.groupMeta.size(); ++i) {
                outputRowData[index++] = null;
            }
            for (i = 0; i < this.data.aggMeta.size(); ++i) {
                outputRowData[index++] = this.meta.getAggregateType()[i] == 5 || this.meta.getAggregateType()[i] == 13 ? Long.valueOf(0L) : null;
            }
            this.putRow(this.data.outputRowMeta, outputRowData);
        }
    }

    private void addToAggregate(Object[] r) throws KettleException {
        Object[] groupData = new Object[this.data.groupMeta.size()];
        for (int i = 0; i < this.data.groupnrs.length; ++i) {
            ValueMetaInterface valueMeta = this.data.groupMeta.getValueMeta(i);
            groupData[i] = valueMeta.convertToNormalStorageType(r[this.data.groupnrs[i]]);
        }
        MemoryGroupByData.HashEntry entry = this.data.getHashEntry(groupData);
        Aggregate aggregate = this.data.map.get(entry);
        if (aggregate == null) {
            aggregate = new Aggregate();
            this.newAggregate(r, aggregate);
            this.data.map.put(entry, aggregate);
        }
        block16: for (int i = 0; i < this.data.subjectnrs.length; ++i) {
            Object subj = r[this.data.subjectnrs[i]];
            ValueMetaInterface subjMeta = this.data.inputRowMeta.getValueMeta(this.data.subjectnrs[i]);
            Object value = aggregate.agg[i];
            ValueMetaInterface valueMeta = this.data.aggMeta.getValueMeta(i);
            switch (this.meta.getAggregateType()[i]) {
                case 1: {
                    aggregate.agg[i] = ValueDataUtil.sum((ValueMetaInterface)valueMeta, (Object)value, (ValueMetaInterface)subjMeta, (Object)subj);
                    continue block16;
                }
                case 2: {
                    if (subjMeta.isNull(subj)) continue block16;
                    aggregate.agg[i] = ValueDataUtil.sum((ValueMetaInterface)valueMeta, (Object)value, (ValueMetaInterface)subjMeta, (Object)subj);
                    int n = i;
                    aggregate.counts[n] = aggregate.counts[n] + 1L;
                    continue block16;
                }
                case 11: {
                    if (aggregate.mean == null) {
                        aggregate.mean = new double[this.meta.getSubjectField().length];
                    }
                    int n = i;
                    aggregate.counts[n] = aggregate.counts[n] + 1L;
                    double n2 = aggregate.counts[i];
                    double x = subjMeta.getNumber(subj);
                    double sum = (Double)value;
                    double mean = aggregate.mean[i];
                    double delta = x - mean;
                    aggregate.mean[i] = mean;
                    aggregate.agg[i] = sum += delta * (x - (mean += delta / n2));
                    continue block16;
                }
                case 13: {
                    if (!subjMeta.isNull(subj)) {
                        Object obj;
                        if (aggregate.distinctObjs == null) {
                            aggregate.distinctObjs = new Set[this.meta.getSubjectField().length];
                        }
                        if (aggregate.distinctObjs[i] == null) {
                            aggregate.distinctObjs[i] = new TreeSet<Object>();
                        }
                        if (!aggregate.distinctObjs[i].contains(obj = subjMeta.convertToNormalStorageType(subj))) {
                            aggregate.distinctObjs[i].add(obj);
                            aggregate.agg[i] = (Long)value + 1L;
                        }
                    }
                }
                case 5: {
                    if (subjMeta.isNull(subj)) continue block16;
                    int n = i;
                    aggregate.counts[n] = aggregate.counts[n] + 1L;
                    continue block16;
                }
                case 3: {
                    if (subjMeta.compare(subj, valueMeta, value) >= 0) continue block16;
                    aggregate.agg[i] = subj;
                    continue block16;
                }
                case 4: {
                    if (subjMeta.compare(subj, valueMeta, value) <= 0) continue block16;
                    aggregate.agg[i] = subj;
                    continue block16;
                }
                case 7: {
                    if (subjMeta.isNull(subj) || value != null) continue block16;
                    aggregate.agg[i] = subj;
                    continue block16;
                }
                case 8: {
                    if (subjMeta.isNull(subj)) continue block16;
                    aggregate.agg[i] = subj;
                    continue block16;
                }
                case 9: {
                    if (aggregate.counts[i] != 0L) continue block16;
                    aggregate.agg[i] = subj;
                    int n = i;
                    aggregate.counts[n] = aggregate.counts[n] + 1L;
                    continue block16;
                }
                case 10: {
                    aggregate.agg[i] = subj;
                    continue block16;
                }
                case 6: {
                    if (subj == null) continue block16;
                    StringBuilder sb = (StringBuilder)value;
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(subjMeta.getString(subj));
                    continue block16;
                }
                case 12: {
                    StringBuilder sb;
                    if (subj == null) continue block16;
                    String separator = "";
                    if (!Const.isEmpty((String)this.meta.getValueField()[i])) {
                        separator = this.environmentSubstitute(this.meta.getValueField()[i]);
                    }
                    if ((sb = (StringBuilder)value).length() > 0) {
                        sb.append(separator);
                    }
                    sb.append(subjMeta.getString(subj));
                    continue block16;
                }
            }
        }
    }

    private void newAggregate(Object[] r, Aggregate aggregate) throws KettleException {
        int i;
        if (aggregate == null) {
            this.data.aggMeta = new RowMeta();
        } else {
            aggregate.counts = new long[this.data.subjectnrs.length];
            for (i = 0; i < aggregate.counts.length; ++i) {
                aggregate.counts[i] = 0L;
            }
            aggregate.distinctObjs = null;
            aggregate.agg = new Object[this.data.subjectnrs.length];
            aggregate.mean = new double[this.data.subjectnrs.length];
        }
        for (i = 0; i < this.data.subjectnrs.length; ++i) {
            ValueMetaInterface subjMeta = this.data.inputRowMeta.getValueMeta(this.data.subjectnrs[i]);
            Comparable<StringBuilder> v = null;
            ValueMetaInterface vMeta = null;
            switch (this.meta.getAggregateType()[i]) {
                case 1: 
                case 2: 
                case 11: {
                    vMeta = new ValueMeta(this.meta.getAggregateField()[i], 1);
                    v = new Double(0.0);
                    break;
                }
                case 5: 
                case 13: {
                    vMeta = new ValueMeta(this.meta.getAggregateField()[i], 5);
                    v = new Long(0L);
                    break;
                }
                case 3: 
                case 4: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    vMeta = subjMeta.clone();
                    vMeta.setName(this.meta.getAggregateField()[i]);
                    v = r == null ? null : r[this.data.subjectnrs[i]];
                    break;
                }
                case 6: {
                    vMeta = new ValueMeta(this.meta.getAggregateField()[i], 2);
                    v = new StringBuilder();
                    break;
                }
                case 12: {
                    vMeta = new ValueMeta(this.meta.getAggregateField()[i], 2);
                    v = new StringBuilder();
                    break;
                }
                default: {
                    throw new KettleException("Unknown data type for aggregation : " + this.meta.getAggregateField()[i]);
                }
            }
            if (this.meta.getAggregateType()[i] != 5 && this.meta.getAggregateType()[i] != 13) {
                vMeta.setLength(subjMeta.getLength(), subjMeta.getPrecision());
            }
            if (aggregate == null) {
                this.data.aggMeta.addValueMeta(vMeta);
                continue;
            }
            if (v == null) continue;
            aggregate.agg[i] = v;
        }
    }

    private void initGroupMeta(RowMetaInterface previousRowMeta) throws KettleValueException {
        this.data.groupMeta = new RowMeta();
        this.data.entryMeta = new RowMeta();
        for (int i = 0; i < this.data.groupnrs.length; ++i) {
            ValueMetaInterface valueMeta = previousRowMeta.getValueMeta(this.data.groupnrs[i]);
            this.data.groupMeta.addValueMeta(valueMeta);
            ValueMetaInterface normalMeta = valueMeta.clone();
            normalMeta.setStorageType(0);
        }
    }

    private Object[] getAggregateResult(Aggregate aggregate) throws KettleValueException {
        Object[] result = new Object[this.data.subjectnrs.length];
        if (this.data.subjectnrs != null) {
            for (int i = 0; i < this.data.subjectnrs.length; ++i) {
                Object ag = aggregate.agg[i];
                switch (this.meta.getAggregateType()[i]) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        ag = ValueDataUtil.divide((ValueMetaInterface)this.data.aggMeta.getValueMeta(i), (Object)ag, (ValueMetaInterface)new ValueMeta("c", 5), (Object)new Long(aggregate.counts[i]));
                        break;
                    }
                    case 5: {
                        ag = new Long(aggregate.counts[i]);
                        break;
                    }
                    case 13: {
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 11: {
                        double sum = (Double)ag / (double)aggregate.counts[i];
                        ag = Math.sqrt(sum);
                        break;
                    }
                    case 6: 
                    case 14: {
                        ag = ((StringBuilder)ag).toString();
                        break;
                    }
                }
                result[i] = ag;
            }
        }
        return result;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (MemoryGroupByMeta)smi;
        this.data = (MemoryGroupByData)sdi;
        if (super.init(smi, sdi)) {
            this.data.map = new HashMap(5000);
            return true;
        }
        return false;
    }

    public void batchComplete() throws KettleException {
        this.handleLastOfGroup();
        this.data.map.clear();
        this.data.newBatch = true;
    }
}

