/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.monetdbbulkloader;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.SQLStatement;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.StreamLogger;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.monetdbagilemart.MonetDBRowLimitException;
import org.pentaho.di.trans.steps.monetdbbulkloader.MonetDBBulkLoaderData;
import org.pentaho.di.trans.steps.monetdbbulkloader.MonetDBBulkLoaderMeta;
import org.pentaho.di.trans.steps.tableagilemart.AgileMartUtil;

public class MonetDBBulkLoader
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = MonetDBBulkLoaderMeta.class;
    private MonetDBBulkLoaderMeta meta;
    private MonetDBBulkLoaderData data;
    private String message;
    private TransMeta localTransMeta;
    protected long rowsWritten = -1L;
    private AgileMartUtil util = new AgileMartUtil();

    public String getMessage() {
        return this.message;
    }

    public MonetDBBulkLoader(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
        this.localTransMeta = transMeta;
    }

    protected void setMessage(String message) {
        this.message = message;
    }

    protected MonetDBBulkLoaderMeta getMeta() {
        return this.meta;
    }

    protected String escapeOsPath(String path, boolean isWindows) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == ' ') {
                sb.append(isWindows ? "^ " : "\\ ");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public String createCommandLine(MonetDBBulkLoaderMeta meta, boolean lSql) throws KettleException {
        DatabaseMeta dm;
        String enclosure;
        boolean isWindows;
        StringBuffer sb = new StringBuffer(300);
        String osName = System.getProperty("os.name");
        boolean bl = isWindows = osName.toLowerCase().indexOf("windows") != -1;
        if (!Const.isEmpty((String)meta.getMClientPath())) {
            try {
                FileObject fileObject = KettleVFS.getFileObject((String)this.environmentSubstitute(meta.getMClientPath()), (VariableSpace)this.getTransMeta());
                String psqlexec = KettleVFS.getFilename((FileObject)fileObject);
                psqlexec = this.escapeOsPath(psqlexec, isWindows);
                sb.append(psqlexec);
            }
            catch (KettleFileException ex) {
                throw new KettleException("Error retrieving mclient application string", (Throwable)ex);
            }
        } else {
            throw new KettleException("No mclient application specified");
        }
        String string = enclosure = isWindows ? "\"" : "";
        if (isWindows) {
            sb.append(" /STARTED-FROM-MENU");
        }
        if (lSql) {
            sb.append(" -lsql");
        }
        if (!Const.isEmpty((String)meta.getEncoding())) {
            sb.append(" ").append(enclosure).append("--encoding=");
            sb.append(this.environmentSubstitute(meta.getEncoding())).append(enclosure);
        }
        if ((dm = meta.getDatabaseMeta()) != null) {
            String hostname = this.environmentSubstitute(Const.NVL((String)dm.getHostname(), (String)""));
            String portnum = this.environmentSubstitute(Const.NVL((String)dm.getDatabasePortNumberString(), (String)""));
            String dbname = this.environmentSubstitute(Const.NVL((String)dm.getDatabaseName(), (String)""));
            if (!Const.isEmpty((String)hostname)) {
                sb.append(" ").append(enclosure).append("--host=").append(hostname).append(enclosure);
            }
            if (!Const.isEmpty((String)portnum) && Const.toInt((String)portnum, (int)-1) > 0) {
                sb.append(" ").append(enclosure).append("--port=").append(portnum).append(enclosure);
            }
            if (!Const.isEmpty((String)dbname)) {
                sb.append(" ").append(enclosure).append("--database=").append(dbname).append(enclosure);
            }
        } else {
            throw new KettleException("No connection specified");
        }
        return sb.toString();
    }

    public boolean execute(MonetDBBulkLoaderMeta meta, boolean wait) throws KettleException {
        Runtime rt = Runtime.getRuntime();
        if (this.log.isDetailed()) {
            this.logDetailed("Started execute");
        }
        String cmdLSql = null;
        if (this.log.isDetailed()) {
            this.logDetailed("Creating commands");
        }
        try {
            cmdLSql = this.createCommandLine(meta, true);
        }
        catch (Exception ex) {
            throw new KettleException("Error while generating MonetDB commands", (Throwable)ex);
        }
        if (this.log.isDetailed()) {
            this.logDetailed("Created command: " + cmdLSql);
        }
        try {
            if (this.log.isDetailed()) {
                this.logDetailed("Auto String Length flag: " + meta.isAutoStringWidths());
            }
            this.logBasic("Executing command: " + cmdLSql);
            ProcessHolder holder = this.startMClient(rt, cmdLSql);
            if (!holder.isRunning) {
                this.message = holder.message;
                throw new KettleException("An error occurred writing data to the mclient process: " + this.message);
            }
            this.data.mClientlProcess = holder.process;
            this.data.errorLogger = new StreamLogger(this.log, this.data.mClientlProcess.getErrorStream(), "ERROR");
            this.data.outputLogger = new StreamLogger(this.log, this.data.mClientlProcess.getInputStream(), "OUTPUT");
            this.data.monetOutputStream = this.data.mClientlProcess.getOutputStream();
            new Thread((Runnable)this.data.errorLogger).start();
            new Thread((Runnable)this.data.outputLogger).start();
        }
        catch (Exception ex) {
            throw new KettleException("Error while executing mclient : " + cmdLSql, (Throwable)ex);
        }
        return true;
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (MonetDBBulkLoaderMeta)smi;
        this.data = (MonetDBBulkLoaderData)sdi;
        try {
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                this.writeBufferToMonetDB();
                if (this.data.monetOutputStream != null) {
                    this.data.monetOutputStream.flush();
                    this.data.monetOutputStream.close();
                    int exitVal = this.data.mClientlProcess.waitFor();
                    this.logBasic(BaseMessages.getString(PKG, (String)"MonetDBBulkLoader.Log.ExitValuePsqlPath", (String[])new String[]{"" + exitVal}));
                }
                this.util.updateMetadata(this.meta, this.rowsWritten);
                return false;
            }
            if (this.first) {
                this.first = false;
                this.data.keynrs = new int[this.meta.getFieldStream().length];
                for (int i = 0; i < this.data.keynrs.length; ++i) {
                    this.data.keynrs[i] = this.getInputRowMeta().indexOfValue(this.meta.getFieldStream()[i]);
                }
                this.execute(this.meta, true);
            }
            this.writeRowToMonetDB(this.getInputRowMeta(), r);
            this.putRow(this.getInputRowMeta(), r);
            this.incrementLinesOutput();
            return true;
        }
        catch (MonetDBRowLimitException me) {
            this.logDebug(me.getMessage());
            this.stopAll();
            this.setOutputDone();
            return true;
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"MonetDBBulkLoader.Log.ErrorInStep", (String[])new String[0]), e);
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
            return false;
        }
    }

    protected void writeRowToMonetDB(RowMetaInterface rowMeta, Object[] r) throws KettleException {
        if (this.data.bufferIndex == this.data.bufferSize || this.log.isDebug()) {
            this.writeBufferToMonetDB();
        }
        this.addRowToBuffer(rowMeta, r);
    }

    protected void addRowToBuffer(RowMetaInterface rowMeta, Object[] r) throws KettleException {
        ByteArrayOutputStream line = new ByteArrayOutputStream(25000);
        try {
            for (int i = 0; i < this.data.keynrs.length; ++i) {
                if (i > 0) {
                    line.write(this.data.separator);
                }
                int index = this.data.keynrs[i];
                ValueMetaInterface valueMeta = rowMeta.getValueMeta(index);
                Object valueData = r[index];
                if (valueData != null) {
                    switch (valueMeta.getType()) {
                        case 2: {
                            line.write(this.data.quote);
                            String str = valueMeta.getString(valueData);
                            if (str == null) {
                                line.write("null".getBytes());
                            } else {
                                str = str.replace("\\", "\\\\");
                                str = str.replace("\"", "\\\"");
                                if (this.meta.isAutoStringWidths()) {
                                    int len = valueMeta.getLength();
                                    if (len < 1) {
                                        len = 100;
                                    }
                                    if (str.length() > len) {
                                        str = str.substring(0, len);
                                    }
                                    line.write(str.getBytes(this.meta.getEncoding()));
                                } else {
                                    line.write(str.getBytes(this.meta.getEncoding()));
                                }
                            }
                            line.write(this.data.quote);
                            break;
                        }
                        case 5: {
                            if (valueMeta.isStorageBinaryString() && this.meta.getFieldFormatOk()[i]) {
                                line.write((byte[])valueData);
                                break;
                            }
                            Long value = valueMeta.getInteger(valueData);
                            if (value == null) {
                                line.write("null".getBytes());
                                break;
                            }
                            line.write(Long.toString(value).getBytes());
                            break;
                        }
                        case 3: {
                            if (valueMeta.isStorageBinaryString() && this.meta.getFieldFormatOk()[i]) {
                                line.write((byte[])valueData);
                                break;
                            }
                            Date value = valueMeta.getDate(valueData);
                            if (value == null) {
                                line.write("null".getBytes());
                                break;
                            }
                            line.write(this.data.monetDateMeta.getString((Object)value).getBytes());
                            break;
                        }
                        case 4: {
                            Boolean value = valueMeta.getBoolean(valueData);
                            if (value == null) {
                                line.write("null".getBytes());
                                break;
                            }
                            if (value.booleanValue()) {
                                line.write("Y".getBytes());
                                break;
                            }
                            line.write("N".getBytes());
                            break;
                        }
                        case 1: {
                            if (valueMeta.isStorageBinaryString() && this.meta.getFieldFormatOk()[i]) {
                                line.write((byte[])valueData);
                                break;
                            }
                            Double value = valueMeta.getNumber(valueData);
                            if (value == null) {
                                line.write("null".getBytes());
                                break;
                            }
                            line.write(Double.toString(value).getBytes());
                            break;
                        }
                        case 6: {
                            if (valueMeta.isStorageBinaryString() && this.meta.getFieldFormatOk()[i]) {
                                line.write((byte[])valueData);
                                break;
                            }
                            String value = valueMeta.getString(valueData);
                            if (value == null) {
                                line.write("null".getBytes());
                                break;
                            }
                            line.write(value.getBytes());
                        }
                    }
                    continue;
                }
                line.write("null".getBytes());
            }
            line.write(this.data.newline);
            if (this.log.isDebug()) {
                this.log.logDebug(new String(line.toByteArray()));
            }
            this.data.rowBuffer[this.data.bufferIndex] = line.toByteArray();
            ++this.data.bufferIndex;
        }
        catch (Exception e) {
            throw new KettleException("Error serializing rows of data to the psql command", (Throwable)e);
        }
    }

    public void truncateTable(Runtime rt, String mClientCmd) throws KettleException {
        try {
            if (this.log.isDetailed()) {
                this.logDetailed("attempting to truncate table");
            }
            ProcessHolder holder = this.startMClient(rt, mClientCmd);
            if (!holder.isRunning) {
                this.message = holder.message;
                throw new KettleException("An error occurred writing data to the mclient process: " + this.message);
            }
            String cmd = this.meta.getDatabaseMeta().getTruncateTableStatement(null, this.data.schemaTable) + ";";
            if (this.log.isDetailed()) {
                this.logDetailed("Trying: " + cmd);
            }
            holder.stdIn.write(cmd.getBytes());
            holder.stdIn.flush();
            holder.stdIn.close();
            int exitVal = holder.process.waitFor();
            byte[] buffer = new byte[4096];
            holder.stdOut.read(buffer);
            this.message = new String(buffer);
            this.logBasic(BaseMessages.getString(PKG, (String)"MonetDBBulkLoader.Log.ExitValuePsqlPath", (String[])new String[]{"" + exitVal}));
            if (exitVal != 0) {
                this.logError(BaseMessages.getString(PKG, (String)"MonetDBBulkLoader.Log.ExitMessage", (String[])new String[]{this.message}));
            } else {
                this.logDebug(BaseMessages.getString(PKG, (String)"MonetDBBulkLoader.Log.ExitMessage", (String[])new String[]{this.message}));
            }
            if (exitVal != 0) {
                throw new KettleException("An error occurred executing a statement");
            }
            this.util.updateMetadata(this.meta, -1L);
            if (this.log.isDetailed()) {
                this.logDetailed("Successfull: " + cmd);
            }
        }
        catch (Exception e) {
            throw new KettleException("An error occurred writing data to the mclient process", (Throwable)e);
        }
    }

    protected ProcessHolder startMClient(Runtime rt, String command) {
        ProcessHolder holder = new ProcessHolder();
        holder.isRunning = true;
        try {
            holder.process = rt.exec(command);
            holder.stdIn = holder.process.getOutputStream();
            holder.stdOut = holder.process.getInputStream();
            holder.stdErr = holder.process.getErrorStream();
            try {
                int exitValue = holder.process.exitValue();
                byte[] buffer = new byte[4096];
                holder.stdErr.read(buffer);
                holder.message = new String(buffer);
                holder.isRunning = false;
            }
            catch (Exception e) {}
        }
        catch (Exception e) {
            this.log.logError("Could not execute MonetDB mclient command: " + command);
        }
        return holder;
    }

    public void dropTable(Runtime rt, String mClientCmd) throws KettleException {
        if (this.log.isDetailed()) {
            this.logDetailed("attempting to truncate table");
        }
        ProcessHolder holder = this.startMClient(rt, mClientCmd);
        if (!holder.isRunning) {
            this.message = holder.message;
            throw new KettleException("An error occurred writing data to the mclient process: " + this.message);
        }
        try {
            String cmd = "drop table " + this.data.schemaTable + ";";
            if (this.log.isDetailed()) {
                this.logDetailed("Trying: " + cmd);
            }
            holder.stdIn.write(cmd.getBytes());
            holder.stdIn.flush();
            holder.stdIn.close();
            int exitVal = holder.process.waitFor();
            byte[] buffer = new byte[4096];
            holder.stdOut.read(buffer);
            this.message = new String(buffer);
            this.logBasic(BaseMessages.getString(PKG, (String)"MonetDBBulkLoader.Log.ExitValuePsqlPath", (String[])new String[]{"" + exitVal}));
            this.logDebug(BaseMessages.getString(PKG, (String)"MonetDBBulkLoader.Log.ExitMessage", (String[])new String[]{this.message}));
            this.util.updateMetadata(this.meta, -1L);
            if (this.log.isDetailed()) {
                this.logDetailed("Successfull: " + cmd);
            }
        }
        catch (Exception e) {
            throw new KettleException("An error occurred writing data to the mclient process", (Throwable)e);
        }
    }

    public void autoAdjustSchema(MonetDBBulkLoaderMeta meta, Runtime rt, String mClientCmd) throws KettleException {
        block19: {
            ProcessHolder holder = null;
            try {
                if (this.log.isDetailed()) {
                    this.logDetailed("Attempting to auto adjust table structure");
                }
                this.dropTable(rt, mClientCmd);
                mClientCmd = this.createCommandLine(meta, false);
                holder = this.startMClient(rt, mClientCmd);
                if (!holder.isRunning) {
                    this.message = holder.message;
                    throw new KettleException("An error occurred writing data to the mclient process: " + this.message);
                }
                if (this.log.isDetailed()) {
                    this.logDetailed("getTransMeta: " + this.getTransMeta());
                }
                if (this.log.isDetailed()) {
                    this.logDetailed("getStepname: " + this.getStepname());
                }
                SQLStatement statement = meta.getTableDdl(this.getTransMeta(), this.getStepname(), true, this.data, true);
                if (this.log.isDetailed()) {
                    this.logDetailed("Statement: " + statement);
                }
                if (this.log.isDetailed() && statement != null) {
                    this.logDetailed("Statement has SQL: " + statement.hasSQL());
                }
                if (statement != null && statement.hasSQL()) {
                    String cmd = statement.getSQL();
                    this.message = "";
                    if (this.log.isDetailed()) {
                        this.logDetailed("Trying: " + cmd);
                    }
                    holder.stdIn.write(cmd.getBytes());
                    holder.stdIn.flush();
                    holder.stdIn.close();
                    try {
                        int exitVal = holder.process.waitFor();
                        byte[] buffer = new byte[4096];
                        holder.stdOut.read(buffer);
                        this.message = new String(buffer);
                        this.logBasic(BaseMessages.getString(PKG, (String)"MonetDBBulkLoader.Log.ExitValuePsqlPath", (String[])new String[]{"" + exitVal}));
                        if (exitVal != 0) {
                            this.logError(BaseMessages.getString(PKG, (String)"MonetDBBulkLoader.Log.ExitMessage", (String[])new String[]{this.message}));
                        } else {
                            this.logDebug(BaseMessages.getString(PKG, (String)"MonetDBBulkLoader.Log.ExitMessage", (String[])new String[]{this.message}));
                        }
                        if (exitVal != 0) {
                            throw new KettleException("An error occurred executing a statement");
                        }
                        break block19;
                    }
                    catch (Exception e) {
                        if (holder != null && holder.stdOut != null) {
                            byte[] buffer = new byte[4096];
                            try {
                                holder.stdOut.read(buffer);
                                this.message = new String(buffer);
                                this.logError(BaseMessages.getString(PKG, (String)"MonetDBBulkLoader.Log.ExitMessage", (String[])new String[]{new String(buffer)}));
                            }
                            catch (IOException e1) {
                                // empty catch block
                            }
                        }
                        throw new KettleException("An error occurred writing data to the mclient process", (Throwable)e);
                    }
                }
                this.message = statement.getError();
                this.logError(statement.getError());
                throw new KettleException("An error occurred creating SQL statement");
            }
            catch (Exception e) {
                throw new KettleException("An error occurred writing data to the mclient process", (Throwable)e);
            }
        }
        if (this.log.isDetailed()) {
            this.logDetailed("Successfull");
        }
    }

    protected void writeBufferToMonetDB() throws KettleException {
        if (this.data.bufferIndex == 0) {
            return;
        }
        try {
            StringBuffer cmdBuff = new StringBuffer();
            cmdBuff.append("COPY ").append(this.data.bufferIndex).append(" RECORDS INTO ").append(this.data.schemaTable).append(" FROM STDIN USING DELIMITERS '").append(new String(this.data.separator)).append("','\\n','").append(new String(this.data.quote)).append("';");
            String cmd = cmdBuff.toString();
            if (this.log.isDetailed()) {
                this.logDetailed(cmd);
            }
            this.data.monetOutputStream.write(cmd.getBytes());
            for (int i = 0; i < this.data.bufferIndex; ++i) {
                this.data.monetOutputStream.write(this.data.rowBuffer[i]);
                if (!this.log.isRowLevel()) continue;
                this.logRowlevel(new String(this.data.rowBuffer[i]));
            }
            if (this.log.isRowLevel()) {
                this.logRowlevel(Const.CR);
            }
            this.data.bufferIndex = 0;
        }
        catch (Exception e) {
            throw new KettleException("An error occurred writing data to the mclient process", (Throwable)e);
        }
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (MonetDBBulkLoaderMeta)smi;
        this.data = (MonetDBBulkLoaderData)sdi;
        if (super.init(smi, sdi)) {
            this.data.quote = "\"".getBytes();
            this.data.separator = "|".getBytes();
            this.data.newline = Const.CR.getBytes();
            this.data.monetDateMeta = new ValueMeta("dateMeta", 3);
            this.data.monetDateMeta.setConversionMask("yyyy/MM/dd HH:mm:ss");
            this.data.monetDateMeta.setStringEncoding(this.meta.getEncoding());
            this.data.monetNumberMeta = new ValueMeta("numberMeta", 1);
            this.data.monetNumberMeta.setConversionMask("#.#");
            this.data.monetNumberMeta.setGroupingSymbol(",");
            this.data.monetNumberMeta.setDecimalSymbol(".");
            this.data.monetNumberMeta.setStringEncoding(this.meta.getEncoding());
            this.data.bufferSize = Const.toInt((String)this.environmentSubstitute(this.meta.getBufferSize()), (int)100000);
            this.data.rowBuffer = new byte[this.data.bufferSize][];
            this.data.bufferIndex = 0;
            String connectionName = this.meta.getDbConnectionName();
            if (!Const.isEmpty((String)connectionName) && connectionName.startsWith("${") && connectionName.endsWith("}")) {
                this.meta.setDatabaseMeta(this.localTransMeta.findDatabase(this.environmentSubstitute(connectionName)));
            }
            this.data.schemaTable = this.meta.getDatabaseMeta(this).getQuotedSchemaTableCombination(this.environmentSubstitute(this.meta.getSchemaName()), this.environmentSubstitute(this.meta.getTableName()));
            return true;
        }
        return false;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (MonetDBBulkLoaderMeta)smi;
        this.data = (MonetDBBulkLoaderData)sdi;
        try {
            if (this.data.monetOutputStream != null) {
                this.data.monetOutputStream.close();
                int exitVal = this.data.mClientlProcess.waitFor();
                this.logBasic(BaseMessages.getString(PKG, (String)"MonetDBBulkLoader.Log.ExitValuePsqlPath", (String[])new String[]{"" + exitVal}));
                if (exitVal != 0) {
                    this.logError(BaseMessages.getString(PKG, (String)"MonetDBBulkLoader.Log.ExitMessage", (String[])new String[]{this.message}));
                } else {
                    this.logDebug(BaseMessages.getString(PKG, (String)"MonetDBBulkLoader.Log.ExitMessage", (String[])new String[]{this.message}));
                }
                if (exitVal != 0) {
                    throw new KettleException("An error occurred executing a statement");
                }
            }
        }
        catch (Exception e) {
            this.setErrors(1L);
            this.logError("Unexpected error encountered while finishing the mclient process", e);
        }
        super.dispose(smi, sdi);
    }

    protected MonetDBBulkLoaderData getData() {
        return this.data;
    }

    private class ProcessHolder {
        Process process;
        boolean isRunning = true;
        OutputStream stdIn = null;
        InputStream stdOut = null;
        InputStream stdErr = null;
        String message;

        private ProcessHolder() {
        }
    }
}

