/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.randomvalue;

import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.util.UUID4Util;
import org.pentaho.di.core.util.UUIDUtil;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.randomvalue.RandomValueData;
import org.pentaho.di.trans.steps.randomvalue.RandomValueMeta;

public class RandomValue
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = RandomValueMeta.class;
    private RandomValueMeta meta;
    private RandomValueData data;

    public RandomValue(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private Object[] getRandomValue(RowMetaInterface inputRowMeta, Object[] inputRowData) {
        int i;
        Object[] row = new Object[this.data.outputRowMeta.size()];
        for (i = 0; i < inputRowMeta.size(); ++i) {
            row[i] = inputRowData[i];
        }
        i = 0;
        int index = inputRowMeta.size();
        while (i < this.meta.getFieldName().length) {
            switch (this.meta.getFieldType()[i]) {
                case 1: {
                    row[index] = this.data.randomgen.nextDouble();
                    break;
                }
                case 2: {
                    row[index] = new Long(this.data.randomgen.nextInt());
                    break;
                }
                case 3: {
                    row[index] = Long.toString(Math.abs(this.data.randomgen.nextLong()), 32);
                    break;
                }
                case 4: {
                    row[index] = UUIDUtil.getUUIDAsString();
                    break;
                }
                case 5: {
                    row[index] = this.data.u4.getUUID4AsString();
                    break;
                }
                case 6: {
                    try {
                        row[index] = this.generateRandomMACHash(6);
                    }
                    catch (Exception e) {
                        this.logError(BaseMessages.getString(PKG, (String)"RandomValue.Log.ErrorGettingRandomHMACMD5", (String[])new String[]{e.getMessage()}));
                        this.setErrors(1L);
                        this.stopAll();
                    }
                    break;
                }
                case 7: {
                    try {
                        row[index] = this.generateRandomMACHash(7);
                    }
                    catch (Exception e) {
                        this.logError(BaseMessages.getString(PKG, (String)"RandomValue.Log.ErrorGettingRandomHMACSHA1", (String[])new String[]{e.getMessage()}));
                        this.setErrors(1L);
                        this.stopAll();
                    }
                    break;
                }
            }
            ++i;
            ++index;
        }
        return row;
    }

    private String generateRandomMACHash(int algorithm) throws Exception {
        Key sk = null;
        switch (algorithm) {
            case 6: {
                sk = this.data.keyGenHmacMD5.generateKey();
                break;
            }
            case 7: {
                sk = this.data.keyGenHmacSHA1.generateKey();
                break;
            }
        }
        if (sk == null) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"RandomValue.Log.SecretKeyNull", (String[])new String[0]));
        }
        Mac mac = Mac.getInstance(sk.getAlgorithm());
        mac.init(sk);
        byte[] hashCode = mac.doFinal();
        StringBuffer encoded = new StringBuffer();
        for (int i = 0; i < hashCode.length; ++i) {
            String _b = Integer.toHexString(hashCode[i]);
            if (_b.length() == 1) {
                _b = "0" + _b;
            }
            encoded.append(_b.substring(_b.length() - 2));
        }
        return encoded.toString();
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        RowMetaInterface imeta;
        Object[] row;
        if (this.data.readsRows) {
            row = this.getRow();
            if (row == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                this.first = false;
                this.data.outputRowMeta = this.getInputRowMeta().clone();
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
            }
        } else {
            row = new Object[]{};
            this.incrementLinesRead();
            if (this.first) {
                this.first = false;
                this.data.outputRowMeta = new RowMeta();
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
            }
        }
        if ((imeta = this.getInputRowMeta()) == null) {
            imeta = new RowMeta();
            this.setInputRowMeta(imeta);
        }
        row = this.getRandomValue(imeta, row);
        if (this.log.isRowLevel()) {
            this.logRowlevel(BaseMessages.getString(PKG, (String)"RandomValue.Log.ValueReturned", (String[])new String[]{this.data.outputRowMeta.getString(row)}));
        }
        this.putRow(this.data.outputRowMeta, row);
        if (!this.data.readsRows) {
            this.setOutputDone();
            return false;
        }
        return true;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (RandomValueMeta)smi;
        this.data = (RandomValueData)sdi;
        if (super.init(smi, sdi)) {
            this.data.readsRows = this.getStepMeta().getRemoteInputSteps().size() > 0;
            List<StepMeta> previous = this.getTransMeta().findPreviousSteps(this.getStepMeta());
            if (previous != null && previous.size() > 0) {
                this.data.readsRows = true;
            }
            boolean genHmacMD5 = false;
            boolean genHmacSHA1 = false;
            boolean uuid4 = false;
            block9: for (int i = 0; i < this.meta.getFieldName().length; ++i) {
                switch (this.meta.getFieldType()[i]) {
                    case 6: {
                        genHmacMD5 = true;
                        continue block9;
                    }
                    case 7: {
                        genHmacSHA1 = true;
                        continue block9;
                    }
                    case 5: {
                        uuid4 = true;
                        continue block9;
                    }
                }
            }
            if (genHmacMD5) {
                try {
                    this.data.keyGenHmacMD5 = KeyGenerator.getInstance("HmacMD5");
                }
                catch (NoSuchAlgorithmException s) {
                    this.logError(BaseMessages.getString(PKG, (String)"RandomValue.Log.HmacMD5AlgorithmException", (String[])new String[]{s.getMessage()}));
                    return false;
                }
            }
            if (genHmacSHA1) {
                try {
                    this.data.keyGenHmacSHA1 = KeyGenerator.getInstance("HmacSHA1");
                }
                catch (NoSuchAlgorithmException s) {
                    this.logError(BaseMessages.getString(PKG, (String)"RandomValue.Log.HmacSHA1AlgorithmException", (String[])new String[]{s.getMessage()}));
                    return false;
                }
            }
            if (uuid4) {
                this.data.u4 = new UUID4Util();
            }
            return true;
        }
        return false;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        super.dispose(smi, sdi);
    }
}

