/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.rest;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import com.sun.jersey.client.apache.ApacheHttpClient;
import com.sun.jersey.client.apache.config.DefaultApacheHttpClientConfig;
import com.sun.jersey.client.urlconnection.HTTPSProperties;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManagerFactory;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.httpclient.auth.AuthScope;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.rest.RestData;
import org.pentaho.di.trans.steps.rest.RestMeta;

public class Rest
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = RestMeta.class;
    private RestMeta meta;
    private RestData data;

    public Rest(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object[] callRest(Object[] rowData) throws KettleException {
        if (this.meta.isUrlInField()) {
            this.data.realUrl = this.data.inputRowMeta.getString(rowData, this.data.indexOfUrlField);
        }
        if (this.meta.isDynamicMethod()) {
            this.data.method = this.data.inputRowMeta.getString(rowData, this.data.indexOfMethod);
            if (Const.isEmpty((String)this.data.method)) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"Rest.Error.MethodMissing", (String[])new String[0]));
            }
        }
        WebResource webResource = null;
        Client client = null;
        Object[] newRow = null;
        if (rowData != null) {
            newRow = (Object[])rowData.clone();
        }
        try {
            try {
                ClientResponse response;
                long startTime;
                block32: {
                    String value;
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"Rest.Log.ConnectingToURL", (String[])new String[]{this.data.realUrl}));
                    }
                    client = this.getClient();
                    webResource = client.resource(this.data.realUrl);
                    startTime = System.currentTimeMillis();
                    if (this.data.useParams) {
                        MultivaluedMapImpl queryParams;
                        for (int i = 0; i < this.data.nrParams; webResource = webResource.queryParams((MultivaluedMap)queryParams), ++i) {
                            queryParams = new MultivaluedMapImpl();
                            value = this.data.inputRowMeta.getString(rowData, this.data.indexOfParamFields[i]);
                            queryParams.add(this.data.paramNames[i], value);
                            if (!this.isDebug()) continue;
                            this.logDebug(BaseMessages.getString(PKG, (String)"Rest.Log.parameterValue", (String[])new String[]{this.data.paramNames[i], value}));
                        }
                    }
                    WebResource.Builder builder = webResource.getRequestBuilder();
                    if (this.data.useHeaders) {
                        for (int i = 0; i < this.data.nrheader; ++i) {
                            value = this.data.inputRowMeta.getString(rowData, this.data.indexOfHeaderFields[i]);
                            builder = (WebResource.Builder)builder.header(this.data.headerNames[i], (Object)value);
                            if (!this.isDebug()) continue;
                            this.logDebug(BaseMessages.getString(PKG, (String)"Rest.Log.HeaderValue", (String[])new String[]{this.data.headerNames[i], value}));
                        }
                    }
                    response = null;
                    String entityString = "";
                    if (this.data.useBody) {
                        entityString = Const.NVL((String)this.data.inputRowMeta.getString(rowData, this.data.indexOfBodyField), (String)"");
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)"Rest.Log.BodyValue", (String[])new String[]{entityString}));
                        }
                    }
                    try {
                        if (this.data.method.equals("GET")) {
                            response = (ClientResponse)builder.get(ClientResponse.class);
                            break block32;
                        }
                        if (this.data.method.equals("POST")) {
                            response = (ClientResponse)((WebResource.Builder)builder.type(this.data.mediaType)).post(ClientResponse.class, (Object)entityString);
                            break block32;
                        }
                        if (this.data.method.equals("PUT")) {
                            response = (ClientResponse)((WebResource.Builder)builder.type(this.data.mediaType)).put(ClientResponse.class, (Object)entityString);
                            break block32;
                        }
                        if (this.data.method.equals("DELETE")) {
                            response = (ClientResponse)((WebResource.Builder)builder.type(this.data.mediaType)).delete(ClientResponse.class, (Object)entityString);
                            break block32;
                        }
                        if (this.data.method.equals("HEAD")) {
                            response = builder.head();
                        } else {
                            if (!this.data.method.equals("OPTIONS")) {
                                throw new KettleException(BaseMessages.getString(PKG, (String)"Rest.Error.UnknownMethod", (String[])new String[]{this.data.method}));
                            }
                            response = (ClientResponse)builder.options(ClientResponse.class);
                        }
                    }
                    catch (UniformInterfaceException u) {
                        response = u.getResponse();
                    }
                }
                long responseTime = System.currentTimeMillis() - startTime;
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"Rest.Log.ResponseTime", (String[])new String[]{String.valueOf(responseTime), this.data.realUrl}));
                }
                int status = response.getStatus();
                if (this.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"Rest.Log.ResponseCode", (String[])new String[]{"" + status}));
                }
                String body = (String)response.getEntity(String.class);
                int returnFieldsOffset = this.data.inputRowMeta.size();
                if (!Const.isEmpty((String)this.data.resultFieldName)) {
                    newRow = RowDataUtil.addValueData((Object[])newRow, (int)returnFieldsOffset, (Object)body);
                    ++returnFieldsOffset;
                }
                if (!Const.isEmpty((String)this.data.resultCodeFieldName)) {
                    newRow = RowDataUtil.addValueData((Object[])newRow, (int)returnFieldsOffset, (Object)new Long(status));
                    ++returnFieldsOffset;
                }
                if (!Const.isEmpty((String)this.data.resultResponseFieldName)) {
                    newRow = RowDataUtil.addValueData((Object[])newRow, (int)returnFieldsOffset, (Object)new Long(responseTime));
                }
            }
            catch (Exception e) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"Rest.Error.CanNotReadURL", (String[])new String[]{this.data.realUrl}), (Throwable)e);
            }
            Object var16_18 = null;
            if (webResource != null) {
                webResource = null;
            }
            if (client == null) return newRow;
        }
        catch (Throwable throwable) {
            Object var16_19 = null;
            if (webResource != null) {
                webResource = null;
            }
            if (client == null) throw throwable;
            client.destroy();
            throw throwable;
        }
        client.destroy();
        return newRow;
    }

    private Client getClient() {
        ApacheHttpClient c = ApacheHttpClient.create((ClientConfig)this.data.config);
        if (this.data.basicAuthentication != null) {
            c.addFilter((ClientFilter)this.data.basicAuthentication);
        }
        return c;
    }

    private void setConfig() throws KettleException {
        if (this.data.config == null) {
            this.data.config = new DefaultApacheHttpClientConfig();
            if (!Const.isEmpty((String)this.data.realProxyHost)) {
                this.data.config.getProperties().put("com.sun.jersey.impl.client.httpclient.proxyURI", "http://" + this.data.realProxyHost + ":" + this.data.realProxyPort);
                if (!Const.isEmpty((String)this.data.realHttpLogin) && !Const.isEmpty((String)this.data.realHttpPassword)) {
                    this.data.config.getState().setProxyCredentials(AuthScope.ANY_REALM, this.data.realProxyHost, this.data.realProxyPort, this.data.realHttpLogin, this.data.realHttpPassword);
                }
            } else if (!Const.isEmpty((String)this.data.realHttpLogin)) {
                this.data.basicAuthentication = new HTTPBasicAuthFilter(this.data.realHttpLogin, this.data.realHttpPassword);
            }
            if (this.meta.isPreemptive()) {
                this.data.config.getProperties().put("com.sun.jersey.impl.client.httpclient.preemptiveAuthentication", true);
            }
            if (!Const.isEmpty((String)this.data.trustStoreFile)) {
                try {
                    KeyStore trustStore = KeyStore.getInstance("JKS");
                    trustStore.load(new FileInputStream(this.data.trustStoreFile), this.data.trustStorePassword.toCharArray());
                    TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
                    tmf.init(trustStore);
                    SSLContext ctx = SSLContext.getInstance("SSL");
                    ctx.init(null, tmf.getTrustManagers(), null);
                    HostnameVerifier hv = new HostnameVerifier(){

                        public boolean verify(String hostname, SSLSession session) {
                            if (Rest.this.isDebug()) {
                                Rest.this.logDebug("Warning: URL Host: " + hostname + " vs. " + session.getPeerHost());
                            }
                            return true;
                        }
                    };
                    this.data.config.getProperties().put("com.sun.jersey.client.impl.urlconnection.httpsProperties", new HTTPSProperties(hv, ctx));
                }
                catch (NoSuchAlgorithmException e) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"Rest.Error.NoSuchAlgorithm", (String[])new String[0]), (Throwable)e);
                }
                catch (KeyStoreException e) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"Rest.Error.KeyStoreException", (String[])new String[0]), (Throwable)e);
                }
                catch (CertificateException e) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"Rest.Error.CertificateException", (String[])new String[0]), (Throwable)e);
                }
                catch (FileNotFoundException e) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"Rest.Error.FileNotFound", (String[])new String[]{this.data.trustStoreFile}), (Throwable)e);
                }
                catch (IOException e) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"Rest.Error.IOException", (String[])new String[0]), (Throwable)e);
                }
                catch (KeyManagementException e) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"Rest.Error.KeyManagementException", (String[])new String[0]), (Throwable)e);
                }
            }
        }
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block23: {
            this.meta = (RestMeta)smi;
            this.data = (RestData)sdi;
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                String field;
                int nrargs;
                this.first = false;
                this.data.inputRowMeta = this.getInputRowMeta();
                this.data.outputRowMeta = this.data.inputRowMeta.clone();
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
                if (this.meta.isUrlInField()) {
                    if (Const.isEmpty((String)this.meta.getUrlField())) {
                        this.logError(BaseMessages.getString(PKG, (String)"Rest.Log.NoField", (String[])new String[0]));
                        throw new KettleException(BaseMessages.getString(PKG, (String)"Rest.Log.NoField", (String[])new String[0]));
                    }
                    if (this.data.indexOfUrlField < 0) {
                        String realUrlfieldName = this.environmentSubstitute(this.meta.getUrlField());
                        this.data.indexOfUrlField = this.data.inputRowMeta.indexOfValue(realUrlfieldName);
                        if (this.data.indexOfUrlField < 0) {
                            throw new KettleException(BaseMessages.getString(PKG, (String)"Rest.Exception.ErrorFindingField", (String[])new String[]{realUrlfieldName}));
                        }
                    }
                } else {
                    this.data.realUrl = this.environmentSubstitute(this.meta.getUrl());
                }
                if (this.meta.isDynamicMethod()) {
                    String field2 = this.environmentSubstitute(this.meta.getMethodFieldName());
                    if (Const.isEmpty((String)field2)) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"Rest.Exception.MethodFieldMissing", (String[])new String[0]));
                    }
                    this.data.indexOfMethod = this.data.inputRowMeta.indexOfValue(field2);
                    if (this.data.indexOfMethod < 0) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"Rest.Exception.ErrorFindingField", (String[])new String[]{field2}));
                    }
                }
                int n = nrargs = this.meta.getHeaderName() == null ? 0 : this.meta.getHeaderName().length;
                if (nrargs > 0) {
                    this.data.nrheader = nrargs;
                    this.data.indexOfHeaderFields = new int[nrargs];
                    this.data.headerNames = new String[nrargs];
                    for (int i = 0; i < nrargs; ++i) {
                        this.data.headerNames[i] = this.environmentSubstitute(this.meta.getHeaderName()[i]);
                        String field3 = this.environmentSubstitute(this.meta.getHeaderField()[i]);
                        if (Const.isEmpty((String)field3)) {
                            throw new KettleException(BaseMessages.getString(PKG, (String)"Rest.Exception.HeaderFieldEmpty", (String[])new String[0]));
                        }
                        this.data.indexOfHeaderFields[i] = this.data.inputRowMeta.indexOfValue(field3);
                        if (this.data.indexOfHeaderFields[i] >= 0) continue;
                        throw new KettleException(BaseMessages.getString(PKG, (String)"Rest.Exception.ErrorFindingField", (String[])new String[]{field3}));
                    }
                    this.data.useHeaders = true;
                }
                if (RestMeta.isActiveParameters(this.meta.getMethod())) {
                    int nrparams;
                    int n2 = nrparams = this.meta.getParameterField() == null ? 0 : this.meta.getParameterField().length;
                    if (nrparams > 0) {
                        this.data.nrParams = nrparams;
                        this.data.paramNames = new String[nrparams];
                        this.data.indexOfParamFields = new int[nrparams];
                        for (int i = 0; i < nrparams; ++i) {
                            this.data.paramNames[i] = this.environmentSubstitute(this.meta.getParameterName()[i]);
                            String field4 = this.environmentSubstitute(this.meta.getParameterField()[i]);
                            if (Const.isEmpty((String)field4)) {
                                throw new KettleException(BaseMessages.getString(PKG, (String)"Rest.Exception.ParamFieldEmpty", (String[])new String[0]));
                            }
                            this.data.indexOfParamFields[i] = this.data.inputRowMeta.indexOfValue(field4);
                            if (this.data.indexOfParamFields[i] >= 0) continue;
                            throw new KettleException(BaseMessages.getString(PKG, (String)"Rest.Exception.ErrorFindingField", (String[])new String[]{field4}));
                        }
                        this.data.useParams = true;
                    }
                }
                if (RestMeta.isActiveBody(this.meta.getMethod()) && !Const.isEmpty((String)(field = this.environmentSubstitute(this.meta.getBodyField())))) {
                    this.data.indexOfBodyField = this.data.inputRowMeta.indexOfValue(field);
                    if (this.data.indexOfBodyField < 0) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"Rest.Exception.ErrorFindingField", (String[])new String[]{field}));
                    }
                    this.data.useBody = true;
                }
            }
            try {
                Object[] outputRowData = this.callRest(r);
                this.putRow(this.data.outputRowMeta, outputRowData);
                if (this.checkFeedback(this.getLinesRead()) && this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"Rest.LineNumber", (String[])new String[0]) + this.getLinesRead());
                }
            }
            catch (KettleException e) {
                boolean sendToErrorRow = false;
                String errorMessage = null;
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"Rest.ErrorInStepRunning", (String[])new String[0]) + e.getMessage());
                    this.setErrors(1L);
                    this.logError(Const.getStackTracker((Throwable)e));
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block23;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, null, "Rest001");
            }
        }
        return true;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (RestMeta)smi;
        this.data = (RestData)sdi;
        if (super.init(smi, sdi)) {
            this.data.resultFieldName = this.environmentSubstitute(this.meta.getFieldName());
            this.data.resultCodeFieldName = this.environmentSubstitute(this.meta.getResultCodeFieldName());
            this.data.resultResponseFieldName = this.environmentSubstitute(this.meta.getResponseTimeFieldName());
            this.data.realProxyHost = this.environmentSubstitute(this.meta.getProxyHost());
            this.data.realProxyPort = Const.toInt((String)this.environmentSubstitute(this.meta.getProxyPort()), (int)8080);
            this.data.realHttpLogin = this.environmentSubstitute(this.meta.getHttpLogin());
            this.data.realHttpPassword = Encr.decryptPasswordOptionallyEncrypted((String)this.environmentSubstitute(this.meta.getHttpPassword()));
            if (!this.meta.isDynamicMethod()) {
                this.data.method = this.environmentSubstitute(this.meta.getMethod());
                if (Const.isEmpty((String)this.data.method)) {
                    this.logError(BaseMessages.getString(PKG, (String)"Rest.Error.MethodMissing", (String[])new String[0]));
                    return false;
                }
            }
            this.data.trustStoreFile = this.environmentSubstitute(this.meta.getTrustStoreFile());
            this.data.trustStorePassword = this.environmentSubstitute(this.meta.getTrustStorePassword());
            String applicationType = Const.NVL((String)this.meta.getApplicationType(), (String)"");
            this.data.mediaType = applicationType.equals("XML") ? MediaType.APPLICATION_XML_TYPE : (applicationType.equals("JSON") ? MediaType.APPLICATION_JSON_TYPE : (applicationType.equals("OCTET STREAM") ? MediaType.APPLICATION_OCTET_STREAM_TYPE : (applicationType.equals("XHTML") ? MediaType.APPLICATION_XHTML_XML_TYPE : (applicationType.equals("FORM URLENCODED") ? MediaType.APPLICATION_FORM_URLENCODED_TYPE : (applicationType.equals("ATOM XML") ? MediaType.APPLICATION_ATOM_XML_TYPE : (applicationType.equals("SVG XML") ? MediaType.APPLICATION_SVG_XML_TYPE : (applicationType.equals("TEXT XML") ? MediaType.TEXT_XML_TYPE : MediaType.TEXT_PLAIN_TYPE)))))));
            try {
                this.setConfig();
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"Rest.Error.Config", (String[])new String[0]), e);
                return false;
            }
            return true;
        }
        return false;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (RestMeta)smi;
        this.data = (RestData)sdi;
        this.data.config = null;
        this.data.headerNames = null;
        this.data.indexOfHeaderFields = null;
        this.data.paramNames = null;
        super.dispose(smi, sdi);
    }
}

