/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.rowsfromresult;

import org.pentaho.di.core.Result;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.rowsfromresult.RowsFromResultData;

public class RowsFromResult
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = RowsFromResult.class;
    private RowsFromResultData data;

    public RowsFromResult(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
        this.data = (RowsFromResultData)stepDataInterface;
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        Result previousResult = this.getTransMeta().getPreviousResult();
        if (previousResult == null || this.getLinesRead() >= (long)previousResult.getRows().size()) {
            this.setOutputDone();
            return false;
        }
        RowMetaAndData row = (RowMetaAndData)previousResult.getRows().get((int)this.getLinesRead());
        this.incrementLinesRead();
        this.data = (RowsFromResultData)sdi;
        this.data.outputRowMeta = row.getRowMeta();
        this.putRow(this.data.outputRowMeta, row.getData());
        if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"RowsFromResult.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
        }
        return true;
    }
}

