/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.rules;

import java.util.Arrays;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.rules.RulesData;
import org.pentaho.di.trans.steps.rules.RulesMeta;

public class Rules
extends BaseStep
implements StepInterface {
    private RulesMeta meta;
    private RulesData data;

    public Rules(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (RulesMeta)smi;
        this.data = (RulesData)sdi;
        return super.init(smi, sdi);
    }

    public boolean runtimeInit() throws KettleStepException {
        this.data.setOutputRowMeta(this.getInputRowMeta().clone());
        this.meta.getFields(this.data.getOutputRowMeta(), this.getStepname(), null, null, this);
        this.data.setRuleFilePath(this.meta.getRuleFile());
        this.data.setRuleString(this.meta.getRuleDefinition());
        this.data.initializeRules();
        this.data.initializeColumns(this.getInputRowMeta());
        return true;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (RulesMeta)smi;
        this.data = (RulesData)sdi;
        super.dispose(smi, sdi);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        Object[] outputRow;
        this.meta = (RulesMeta)smi;
        this.data = (RulesData)sdi;
        Object[] r = this.getRow();
        if (r == null) {
            this.data.shutdown();
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            if (!this.runtimeInit()) {
                return false;
            }
            this.first = false;
        }
        this.data.loadRow(r);
        this.data.execute();
        int beginOutputRowFill = 0;
        String[] expectedResults = this.meta.getExpectedResultList();
        if (this.meta.isKeepInputFields()) {
            int inputRowSize = this.getInputRowMeta().size();
            outputRow = Arrays.copyOf(r, inputRowSize + expectedResults.length);
            beginOutputRowFill = inputRowSize;
        } else {
            outputRow = new Object[expectedResults.length];
        }
        Column result = null;
        for (int i = 0; i < expectedResults.length; ++i) {
            result = (Column)this.data.fetchResult(expectedResults[i]);
            outputRow[i + beginOutputRowFill] = result == null ? null : result.getPayload();
        }
        this.putRow(this.data.getOutputRowMeta(), outputRow);
        return true;
    }

    public static class Column {
        private String name;
        private String type;
        private Object payload;
        private Boolean external;

        public Column() {
            this.external = false;
        }

        public Column(Boolean external) {
            this.external = external;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public Object getPayload() {
            return this.payload;
        }

        public void setPayload(Object payload) {
            this.payload = payload;
        }

        public void setExternalSource(Boolean external) {
            this.external = external;
        }

        public Boolean isExternalSource() {
            return this.external;
        }
    }
}

