/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.salesforceinput;

import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.salesforceinput.SalesforceConnection;
import org.pentaho.di.trans.steps.salesforceinput.SalesforceInputData;
import org.pentaho.di.trans.steps.salesforceinput.SalesforceInputField;
import org.pentaho.di.trans.steps.salesforceinput.SalesforceInputMeta;
import org.pentaho.di.trans.steps.salesforceinput.SalesforceRecordValue;

public class SalesforceInput
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = SalesforceInputMeta.class;
    private SalesforceInputMeta meta;
    private SalesforceInputData data;

    public SalesforceInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        if (this.first) {
            this.first = false;
            this.data.outputRowMeta = new RowMeta();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
            this.data.convertRowMeta = this.data.outputRowMeta.clone();
            for (int i = 0; i < this.data.convertRowMeta.size(); ++i) {
                this.data.convertRowMeta.getValueMeta(i).setType(2);
            }
            this.data.connection.query(this.meta.isSpecifyQuery());
            this.data.limitReached = true;
            this.data.recordcount = this.data.connection.getQueryResultSize();
            if (this.data.recordcount > 0) {
                this.data.limitReached = false;
                this.data.nrRecords = this.data.connection.getRecordsCount();
            }
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceInput.Log.RecordCount", (String[])new String[0]) + " : " + this.data.recordcount);
            }
        }
        Object[] outputRowData = null;
        try {
            outputRowData = this.getOneRow();
            if (outputRowData == null) {
                this.setOutputDone();
                return false;
            }
            this.putRow(this.data.outputRowMeta, outputRowData);
            if (this.checkFeedback(this.getLinesInput()) && this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceInput.log.LineRow", (String[])new String[]{"" + this.getLinesInput()}));
            }
            ++this.data.rownr;
            ++this.data.recordIndex;
            return true;
        }
        catch (KettleException e) {
            boolean sendToErrorRow = false;
            String errorMessage = null;
            if (!this.getStepMeta().isDoingErrorHandling()) {
                this.logError(BaseMessages.getString(PKG, (String)"SalesforceInput.log.Exception", (String[])new String[]{e.getMessage()}));
                this.logError(Const.getStackTracker((Throwable)e));
                this.setErrors(1L);
                this.stopAll();
                this.setOutputDone();
                return false;
            }
            sendToErrorRow = true;
            errorMessage = e.toString();
            if (sendToErrorRow) {
                this.putError(this.getInputRowMeta(), outputRowData, 1L, errorMessage, null, "SalesforceInput001");
            }
            return true;
        }
    }

    private Object[] getOneRow() throws KettleException {
        if (this.data.limitReached || this.data.rownr >= (long)this.data.recordcount) {
            return null;
        }
        Object[] outputRowData = this.buildEmptyRow();
        try {
            RowMetaInterface irow;
            if (this.data.limit > 0L && this.data.rownr >= this.data.limit) {
                this.data.limitReached = true;
                return null;
            }
            if ((this.data.rownr >= (long)this.data.nrRecords || this.data.finishedRecord) && this.meta.getRecordsFilter() != 1) {
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceInput.Log.NeedQueryMore", (String[])new String[]{"" + this.data.rownr}));
                }
                if (this.data.connection.queryMore()) {
                    int nr = this.data.connection.getRecordsCount();
                    this.data.nrRecords += nr;
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceInput.Log.QueryMoreRetrieved", (String[])new String[]{"" + nr}));
                    }
                    this.data.recordIndex = 0;
                    this.data.finishedRecord = false;
                } else {
                    return null;
                }
            }
            SalesforceRecordValue srvalue = this.data.connection.getRecord(this.data.recordIndex);
            this.data.finishedRecord = srvalue.isAllRecordsProcessed();
            if (this.meta.getRecordsFilter() == 2) {
                if (srvalue.isRecordIndexChanges()) {
                    this.data.recordIndex = srvalue.getRecordIndex();
                }
                if (this.data.finishedRecord && srvalue.getRecordValue() == null) {
                    return null;
                }
            }
            for (int i = 0; i < this.data.nrfields; ++i) {
                String value = this.data.connection.getRecordValue(srvalue.getRecordValue(), i);
                switch (this.meta.getInputFields()[i].getTrimType()) {
                    case 1: {
                        value = Const.ltrim((String)value);
                        break;
                    }
                    case 2: {
                        value = Const.rtrim((String)value);
                        break;
                    }
                    case 3: {
                        value = Const.trim((String)value);
                        break;
                    }
                }
                ValueMetaInterface targetValueMeta = this.data.outputRowMeta.getValueMeta(i);
                ValueMetaInterface sourceValueMeta = this.data.convertRowMeta.getValueMeta(i);
                outputRowData[i] = targetValueMeta.convertData(sourceValueMeta, (Object)value);
                if (!this.meta.getInputFields()[i].isRepeated() || this.data.previousRow == null || !Const.isEmpty((String)value)) continue;
                outputRowData[i] = this.data.previousRow[i];
            }
            int rowIndex = this.data.nrfields;
            if (this.meta.includeTargetURL() && !Const.isEmpty((String)this.meta.getTargetURLField())) {
                outputRowData[rowIndex++] = this.data.connection.getURL();
            }
            if (this.meta.includeModule() && !Const.isEmpty((String)this.meta.getModuleField())) {
                outputRowData[rowIndex++] = this.data.connection.getModule();
            }
            if (this.meta.includeSQL() && !Const.isEmpty((String)this.meta.getSQLField())) {
                outputRowData[rowIndex++] = this.data.connection.getSQL();
            }
            if (this.meta.includeTimestamp() && !Const.isEmpty((String)this.meta.getTimestampField())) {
                outputRowData[rowIndex++] = this.data.connection.getServerTimestamp();
            }
            if (this.meta.includeRowNumber() && !Const.isEmpty((String)this.meta.getRowNumberField())) {
                outputRowData[rowIndex++] = new Long(this.data.rownr);
            }
            if (this.meta.includeDeletionDate() && !Const.isEmpty((String)this.meta.getDeletionDateField())) {
                outputRowData[rowIndex++] = srvalue.getDeletionDate();
            }
            this.data.previousRow = (irow = this.getInputRowMeta()) == null ? outputRowData : irow.cloneRow(outputRowData);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"SalesforceInput.Exception.CanNotReadFromSalesforce", (String[])new String[0]), (Throwable)e);
        }
        return outputRowData;
    }

    private String BuiltSOQl() {
        String sql = "";
        SalesforceInputField[] fields = this.meta.getInputFields();
        switch (this.meta.getRecordsFilter()) {
            case 1: {
                for (int i = 0; i < this.data.nrfields; ++i) {
                    SalesforceInputField field = fields[i];
                    sql = sql + this.environmentSubstitute(field.getField());
                    if (i >= this.data.nrfields - 1) continue;
                    sql = sql + ",";
                }
                break;
            }
            case 2: {
                sql = sql + "SELECT ";
                for (int i = 0; i < this.data.nrfields; ++i) {
                    SalesforceInputField field = fields[i];
                    sql = sql + this.environmentSubstitute(field.getField());
                    if (i >= this.data.nrfields - 1) continue;
                    sql = sql + ",";
                }
                sql = sql + " FROM " + this.environmentSubstitute(this.meta.getModule()) + " WHERE isDeleted = true";
                break;
            }
            default: {
                sql = sql + "SELECT ";
                for (int i = 0; i < this.data.nrfields; ++i) {
                    SalesforceInputField field = fields[i];
                    sql = sql + this.environmentSubstitute(field.getField());
                    if (i >= this.data.nrfields - 1) continue;
                    sql = sql + ",";
                }
                sql = sql + " FROM " + this.environmentSubstitute(this.meta.getModule());
                if (Const.isEmpty((String)this.environmentSubstitute(this.meta.getCondition()))) break;
                sql = sql + " WHERE " + this.environmentSubstitute(this.meta.getCondition().replace("\n\r", "").replace("\n", ""));
            }
        }
        return sql;
    }

    private Object[] buildEmptyRow() {
        Object[] rowData = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
        return rowData;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (SalesforceInputMeta)smi;
        this.data = (SalesforceInputData)sdi;
        if (super.init(smi, sdi)) {
            this.data.nrfields = this.meta.getInputFields().length;
            if (this.data.nrfields == 0) {
                this.log.logError(BaseMessages.getString(PKG, (String)"SalesforceInputDialog.FieldsMissing.DialogMessage", (String[])new String[0]));
                return false;
            }
            String soSQL = this.environmentSubstitute(this.meta.getQuery());
            String realUrl = this.environmentSubstitute(this.meta.getTargetURL());
            if (Const.isEmpty((String)realUrl)) {
                this.log.logError(BaseMessages.getString(PKG, (String)"SalesforceInput.TargetURLMissing.Error", (String[])new String[0]));
                return false;
            }
            String realUser = this.environmentSubstitute(this.meta.getUserName());
            if (Const.isEmpty((String)realUser)) {
                this.log.logError(BaseMessages.getString(PKG, (String)"SalesforceInput.UsernameMissing.Error", (String[])new String[0]));
                return false;
            }
            try {
                if (this.meta.isSpecifyQuery()) {
                    if (Const.isEmpty((String)soSQL)) {
                        this.log.logError(BaseMessages.getString(PKG, (String)"SalesforceInputDialog.QueryMissing.DialogMessage", (String[])new String[0]));
                        return false;
                    }
                } else {
                    this.data.Module = this.environmentSubstitute(this.meta.getModule());
                    if (Const.isEmpty((String)this.data.Module)) {
                        this.log.logError(BaseMessages.getString(PKG, (String)"SalesforceInputDialog.ModuleMissing.DialogMessage", (String[])new String[0]));
                        return false;
                    }
                    if (this.meta.getRecordsFilter() != 0) {
                        String realFromDateString = this.environmentSubstitute(this.meta.getReadFrom());
                        if (Const.isEmpty((String)realFromDateString)) {
                            this.log.logError(BaseMessages.getString(PKG, (String)"SalesforceInputDialog.FromDateMissing.DialogMessage", (String[])new String[0]));
                            return false;
                        }
                        String realToDateString = this.environmentSubstitute(this.meta.getReadTo());
                        if (Const.isEmpty((String)realToDateString)) {
                            this.log.logError(BaseMessages.getString(PKG, (String)"SalesforceInputDialog.ToDateMissing.DialogMessage", (String[])new String[0]));
                            return false;
                        }
                        try {
                            SimpleDateFormat dateFormat = new SimpleDateFormat(SalesforceInputMeta.DATE_TIME_FORMAT);
                            this.data.startCal = new GregorianCalendar();
                            this.data.startCal.setTime(dateFormat.parse(realFromDateString));
                            this.data.endCal = new GregorianCalendar();
                            this.data.endCal.setTime(dateFormat.parse(realToDateString));
                            dateFormat = null;
                        }
                        catch (Exception e) {
                            this.log.logError(BaseMessages.getString(PKG, (String)"SalesforceInput.ErrorParsingDate", (String[])new String[0]), (Throwable)e);
                            return false;
                        }
                    }
                }
                this.data.limit = Const.toLong((String)this.environmentSubstitute(this.meta.getRowLimit()), (long)0L);
                this.data.connection = new SalesforceConnection(this.log, realUrl, realUser, this.environmentSubstitute(this.meta.getPassword()));
                this.data.connection.setTimeOut(Const.toInt((String)this.environmentSubstitute(this.meta.getTimeOut()), (int)0));
                this.data.connection.setUsingCompression(this.meta.isUsingCompression());
                this.data.connection.queryAll(this.meta.isQueryAll());
                if (this.meta.isSpecifyQuery()) {
                    this.data.connection.setSQL(soSQL.replace("\n\r", " ").replace("\n", " "));
                } else {
                    String realCondition = this.environmentSubstitute(this.meta.getCondition());
                    if (!Const.isEmpty((String)realCondition)) {
                        this.data.connection.setCondition(realCondition);
                    }
                    this.data.connection.setModule(this.data.Module);
                    if (this.meta.getRecordsFilter() != 0) {
                        this.data.connection.setCalendar(this.meta.getRecordsFilter(), this.data.startCal, this.data.endCal);
                    }
                    if (this.meta.getRecordsFilter() == 1) {
                        this.data.connection.setFieldsList(this.BuiltSOQl());
                    } else {
                        this.data.connection.setSQL(this.BuiltSOQl());
                    }
                }
                this.data.connection.connect();
                return true;
            }
            catch (KettleException ke) {
                this.logError(BaseMessages.getString(PKG, (String)"SalesforceInput.Log.ErrorOccurredDuringStepInitialize", (String[])new String[0]) + ke.getMessage());
                return true;
            }
        }
        return false;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (SalesforceInputMeta)smi;
        this.data = (SalesforceInputData)sdi;
        try {
            if (this.data.connection != null) {
                this.data.connection.close();
            }
            if (this.data.outputRowMeta != null) {
                this.data.outputRowMeta = null;
            }
            if (this.data.convertRowMeta != null) {
                this.data.convertRowMeta = null;
            }
            if (this.data.previousRow != null) {
                this.data.previousRow = null;
            }
            if (this.data.startCal != null) {
                this.data.startCal = null;
            }
            if (this.data.endCal != null) {
                this.data.endCal = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.dispose(smi, sdi);
    }
}

