/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.salesforceupsert;

import com.sforce.soap.partner.Error;
import com.sforce.soap.partner.sobject.SObject;
import java.util.ArrayList;
import org.apache.axis.message.MessageElement;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.salesforceinput.SalesforceConnection;
import org.pentaho.di.trans.steps.salesforceupsert.SalesforceUpsertData;
import org.pentaho.di.trans.steps.salesforceupsert.SalesforceUpsertMeta;

public class SalesforceUpsert
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = SalesforceUpsertMeta.class;
    private SalesforceUpsertMeta meta;
    private SalesforceUpsertData data;

    public SalesforceUpsert(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        Object[] outputRowData = this.getRow();
        if (outputRowData == null) {
            if (this.data.iBufferPos > 0) {
                this.flushBuffers();
            }
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.data.sfBuffer = new SObject[this.meta.getBatchSizeInt()];
            this.data.outputBuffer = new Object[this.meta.getBatchSizeInt()][];
            this.data.nrfields = this.meta.getUpdateLookup().length;
            if (this.data.nrfields == 0) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"SalesforceUpsertDialog.FieldsMissing.DialogMessage", (String[])new String[0]));
            }
            this.data.inputRowMeta = this.getInputRowMeta().clone();
            this.data.outputRowMeta = this.data.inputRowMeta.clone();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
            this.data.fieldnrs = new int[this.meta.getUpdateStream().length];
            for (int i = 0; i < this.meta.getUpdateStream().length; ++i) {
                this.data.fieldnrs[i] = this.getInputRowMeta().indexOfValue(this.meta.getUpdateStream()[i]);
                if (this.data.fieldnrs[i] >= 0) continue;
                throw new KettleException(BaseMessages.getString(PKG, (String)"SalesforceUpsert.FieldNotFound", (String[])new String[]{this.meta.getUpdateStream()[i]}));
            }
        }
        try {
            this.writeToSalesForce(outputRowData);
        }
        catch (Exception e) {
            throw new KettleStepException(BaseMessages.getString(PKG, (String)"SalesforceUpsert.log.Exception", (String[])new String[0]), (Throwable)e);
        }
        return true;
    }

    private void writeToSalesForce(Object[] rowData) throws KettleException {
        try {
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceUpsert.CalledWrite", (Object[])new Object[]{this.data.iBufferPos, this.meta.getBatchSizeInt()}));
            }
            if (this.data.iBufferPos < this.meta.getBatchSizeInt()) {
                ArrayList<String> fieldsToNull = new ArrayList<String>();
                ArrayList<MessageElement> upsertfields = new ArrayList<MessageElement>();
                for (int i = 0; i < this.data.nrfields; ++i) {
                    if (this.data.inputRowMeta.isNull(rowData, this.data.fieldnrs[i])) {
                        fieldsToNull.add(this.meta.getUpdateLookup()[i]);
                        continue;
                    }
                    upsertfields.add(SalesforceConnection.createMessageElement(this.meta.getUpdateLookup()[i], rowData[this.data.fieldnrs[i]], this.meta.getUseExternalId()[i]));
                }
                SObject sobjPass = new SObject();
                sobjPass.setType(this.data.realModule);
                if (upsertfields.size() > 0) {
                    sobjPass.set_any(upsertfields.toArray(new MessageElement[upsertfields.size()]));
                }
                if (fieldsToNull.size() > 0) {
                    sobjPass.setFieldsToNull(fieldsToNull.toArray(new String[fieldsToNull.size()]));
                }
                this.data.sfBuffer[this.data.iBufferPos] = sobjPass;
                this.data.outputBuffer[this.data.iBufferPos] = rowData;
                ++this.data.iBufferPos;
            }
            if (this.data.iBufferPos >= this.meta.getBatchSizeInt()) {
                if (this.log.isDetailed()) {
                    this.logDetailed("Calling flush buffer from writeToSalesForce");
                }
                this.flushBuffers();
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"SalesforceUpsert.FailedInWrite", (String[])new String[]{e.toString()}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushBuffers() throws KettleException {
        try {
            try {
                this.data.upsertResult = this.data.connection.upsert(this.meta.getUpsertField(), this.data.sfBuffer);
                int nr = this.data.upsertResult.length;
                for (int j = 0; j < nr; ++j) {
                    if (this.data.upsertResult[j].isSuccess()) {
                        String id = this.data.upsertResult[j].getId();
                        if (this.data.upsertResult[j].isCreated()) {
                            this.incrementLinesOutput();
                            if (this.log.isDetailed()) {
                                this.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceUpsert.ObjectCreated", (String[])new String[]{id}));
                            }
                        } else {
                            this.incrementLinesUpdated();
                            if (this.log.isDetailed()) {
                                this.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceUpsert.ObjectUpdated", (String[])new String[]{id}));
                            }
                        }
                        Object[] newRow = RowDataUtil.resizeArray((Object[])this.data.outputBuffer[j], (int)this.data.outputRowMeta.size());
                        if (this.data.realSalesforceFieldName != null) {
                            int newIndex = this.data.inputRowMeta.size();
                            newRow[newIndex++] = id;
                        }
                        if (this.log.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceUpsert.NewRow", (Object[])new Object[]{newRow[0]}));
                        }
                        this.putRow(this.data.outputRowMeta, newRow);
                        if (!this.checkFeedback(this.getLinesInput()) || !this.log.isDetailed()) continue;
                        this.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceUpsert.log.LineRow", (String[])new String[]{"" + this.getLinesInput()}));
                        continue;
                    }
                    if (!this.getStepMeta().isDoingErrorHandling()) {
                        if (this.log.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"SalesforceUpsert.ErrorFound", (String[])new String[0]));
                        }
                        Error err = this.data.upsertResult[j].getErrors()[0];
                        throw new KettleException(BaseMessages.getString(PKG, (String)"SalesforceUpsert.Error.FlushBuffer", (Object[])new Object[]{new Integer(j), err.getStatusCode(), err.getMessage()}));
                    }
                    String errorMessage = "";
                    for (int i = 0; i < this.data.upsertResult[j].getErrors().length; ++i) {
                        Error err = this.data.upsertResult[j].getErrors()[i];
                        errorMessage = errorMessage + BaseMessages.getString(PKG, (String)"SalesforceUpsert.Error.FlushBuffer", (Object[])new Object[]{new Integer(j), err.getStatusCode(), err.getMessage()});
                    }
                    if (this.log.isDebug()) {
                        this.logDebug(BaseMessages.getString(PKG, (String)"SalesforceUpsert.PassingRowToErrorStep", (String[])new String[0]));
                    }
                    this.putError(this.getInputRowMeta(), this.data.outputBuffer[j], 1L, errorMessage, null, "SalesforceUpsert001");
                }
                this.data.sfBuffer = new SObject[this.meta.getBatchSizeInt()];
                this.data.outputBuffer = new Object[this.meta.getBatchSizeInt()][];
                this.data.iBufferPos = 0;
            }
            catch (Exception e) {
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"SalesforceUpsert.FailedUpsert", (String[])new String[]{e.getMessage()}));
                }
                if (this.log.isDebug()) {
                    this.logDebug("Passing row to error step");
                }
                for (int i = 0; i < this.data.iBufferPos; ++i) {
                    this.putError(this.data.inputRowMeta, this.data.outputBuffer[i], 1L, e.getMessage(), null, "SalesforceUpsert002");
                }
                Object var7_11 = null;
                if (this.data.upsertResult != null) {
                    this.data.upsertResult = null;
                }
            }
            Object var7_10 = null;
            if (this.data.upsertResult != null) {
                this.data.upsertResult = null;
            }
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            if (this.data.upsertResult != null) {
                this.data.upsertResult = null;
            }
            throw throwable;
        }
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (SalesforceUpsertMeta)smi;
        this.data = (SalesforceUpsertData)sdi;
        if (super.init(smi, sdi)) {
            try {
                this.data.realModule = this.environmentSubstitute(this.meta.getModule());
                if (Const.isEmpty((String)this.data.realModule)) {
                    this.log.logError(BaseMessages.getString(PKG, (String)"SalesforceUpsertDialog.ModuleMissing.DialogMessage", (String[])new String[0]));
                    return false;
                }
                String realUser = this.environmentSubstitute(this.meta.getUserName());
                if (Const.isEmpty((String)realUser)) {
                    this.log.logError(BaseMessages.getString(PKG, (String)"SalesforceUpsertDialog.UsernameMissing.DialogMessage", (String[])new String[0]));
                    return false;
                }
                String salesfoceIdFieldname = this.environmentSubstitute(this.meta.getSalesforceIDFieldName());
                if (!Const.isEmpty((String)salesfoceIdFieldname)) {
                    this.data.realSalesforceFieldName = salesfoceIdFieldname;
                }
                this.data.realURL = this.environmentSubstitute(this.meta.getTargetURL());
                this.data.connection = new SalesforceConnection(this.log, this.data.realURL, realUser, this.environmentSubstitute(this.meta.getPassword()));
                this.data.connection.setTimeOut(Const.toInt((String)this.environmentSubstitute(this.meta.getTimeOut()), (int)0));
                this.data.connection.setUsingCompression(this.meta.isUsingCompression());
                this.data.connection.rollbackAllChangesOnError(this.meta.isRollbackAllChangesOnError());
                this.data.connection.connect();
                return true;
            }
            catch (KettleException ke) {
                this.logError(BaseMessages.getString(PKG, (String)"SalesforceUpsert.Log.ErrorOccurredDuringStepInitialize", (String[])new String[0]) + ke.getMessage());
                return true;
            }
        }
        return false;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (SalesforceUpsertMeta)smi;
        this.data = (SalesforceUpsertData)sdi;
        try {
            if (this.data.outputBuffer != null) {
                this.data.outputBuffer = null;
            }
            if (this.data.sfBuffer != null) {
                this.data.sfBuffer = null;
            }
            if (this.data.connection != null) {
                this.data.connection.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.dispose(smi, sdi);
    }
}

