/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.sasinput;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.core.xml.XMLInterface;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.w3c.dom.Node;

public class SasInputField
implements XMLInterface,
Cloneable {
    private String name;
    private String rename;
    private int type;
    private int length;
    private int precision;
    private String conversionMask;
    private String decimalSymbol;
    private String groupingSymbol;
    private int trimType;

    public SasInputField(String name, String rename, int type, String conversionMask, String decimalSymbol, String groupingSymbol, int trimType) {
        this.name = name;
        this.rename = rename;
        this.type = type;
        this.conversionMask = conversionMask;
        this.decimalSymbol = decimalSymbol;
        this.groupingSymbol = groupingSymbol;
        this.trimType = trimType;
    }

    public SasInputField() {
    }

    protected SasInputField clone() {
        try {
            return (SasInputField)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append("    " + XMLHandler.addTagValue((String)"name", (String)this.name));
        retval.append("    " + XMLHandler.addTagValue((String)"rename", (String)this.rename));
        retval.append("    " + XMLHandler.addTagValue((String)"type", (String)ValueMeta.getTypeDesc((int)this.type)));
        retval.append("    " + XMLHandler.addTagValue((String)"length", (int)this.length));
        retval.append("    " + XMLHandler.addTagValue((String)"precision", (int)this.precision));
        retval.append("    " + XMLHandler.addTagValue((String)"conversion_mask", (String)this.conversionMask));
        retval.append("    " + XMLHandler.addTagValue((String)"decimal", (String)this.decimalSymbol));
        retval.append("    " + XMLHandler.addTagValue((String)"grouping", (String)this.groupingSymbol));
        retval.append("    " + XMLHandler.addTagValue((String)"trim_type", (String)ValueMeta.getTrimTypeCode((int)this.trimType)));
        return retval.toString();
    }

    public void saveRep(Repository rep, ObjectId transformationId, ObjectId stepId, int fieldNr) throws KettleException {
        rep.saveStepAttribute(transformationId, stepId, fieldNr, "field_name", this.name);
        rep.saveStepAttribute(transformationId, stepId, fieldNr, "field_rename", this.rename);
        rep.saveStepAttribute(transformationId, stepId, fieldNr, "field_type", ValueMeta.getTypeDesc((int)this.type));
        rep.saveStepAttribute(transformationId, stepId, fieldNr, "field_length", this.length);
        rep.saveStepAttribute(transformationId, stepId, fieldNr, "field_precision", this.precision);
        rep.saveStepAttribute(transformationId, stepId, fieldNr, "field_conversion_mask", this.conversionMask);
        rep.saveStepAttribute(transformationId, stepId, fieldNr, "field_decimal", this.decimalSymbol);
        rep.saveStepAttribute(transformationId, stepId, fieldNr, "field_grouping", this.groupingSymbol);
        rep.saveStepAttribute(transformationId, stepId, fieldNr, "field_trim_type", ValueMeta.getTrimTypeCode((int)this.trimType));
    }

    public SasInputField(Repository rep, ObjectId stepId, int fieldNr) throws KettleException {
        this.name = rep.getStepAttributeString(stepId, fieldNr, "field_name");
        this.rename = rep.getStepAttributeString(stepId, fieldNr, "field_rename");
        this.type = ValueMeta.getType((String)rep.getStepAttributeString(stepId, fieldNr, "field_type"));
        this.length = (int)rep.getStepAttributeInteger(stepId, fieldNr, "field_length");
        this.precision = (int)rep.getStepAttributeInteger(stepId, fieldNr, "field_precision");
        this.conversionMask = rep.getStepAttributeString(stepId, fieldNr, "field_conversion_mask");
        this.decimalSymbol = rep.getStepAttributeString(stepId, fieldNr, "field_decimal");
        this.groupingSymbol = rep.getStepAttributeString(stepId, fieldNr, "field_grouping");
        this.trimType = ValueMeta.getTrimTypeByCode((String)rep.getStepAttributeString(stepId, fieldNr, "field_trim_type"));
    }

    public SasInputField(Node node) throws KettleXMLException {
        this.name = XMLHandler.getTagValue((Node)node, (String)"name");
        this.rename = XMLHandler.getTagValue((Node)node, (String)"rename");
        this.type = ValueMeta.getType((String)XMLHandler.getTagValue((Node)node, (String)"type"));
        this.length = Const.toInt((String)XMLHandler.getTagValue((Node)node, (String)"length"), (int)-1);
        this.precision = Const.toInt((String)XMLHandler.getTagValue((Node)node, (String)"precision"), (int)-1);
        this.conversionMask = XMLHandler.getTagValue((Node)node, (String)"conversion_mask");
        this.decimalSymbol = XMLHandler.getTagValue((Node)node, (String)"decimal");
        this.groupingSymbol = XMLHandler.getTagValue((Node)node, (String)"grouping");
        this.trimType = ValueMeta.getTrimTypeByCode((String)XMLHandler.getTagValue((Node)node, (String)"trim_type"));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRename() {
        return this.rename;
    }

    public void setRename(String rename) {
        this.rename = rename;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getConversionMask() {
        return this.conversionMask;
    }

    public void setConversionMask(String conversionMask) {
        this.conversionMask = conversionMask;
    }

    public String getDecimalSymbol() {
        return this.decimalSymbol;
    }

    public void setDecimalSymbol(String decimalSymbol) {
        this.decimalSymbol = decimalSymbol;
    }

    public String getGroupingSymbol() {
        return this.groupingSymbol;
    }

    public void setGroupingSymbol(String groupingSymbol) {
        this.groupingSymbol = groupingSymbol;
    }

    public int getTrimType() {
        return this.trimType;
    }

    public void setTrimType(int trimType) {
        this.trimType = trimType;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public String getTrimTypeDesc() {
        return ValueMeta.getTrimTypeDesc((int)this.trimType);
    }
}

