/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.sasinput;

import java.io.File;
import org.eobjects.sassy.SasColumnType;
import org.eobjects.sassy.SasReader;
import org.eobjects.sassy.SasReaderCallback;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;

public class SasInputHelper {
    private String filename;
    private RowMetaInterface rowMeta;
    private SasReader sasReader;

    public SasInputHelper(String filename) throws KettleException {
        this.filename = filename;
        this.sasReader = new SasReader(new File(filename));
        try {
            this.rowMeta = new RowMeta();
            this.sasReader.read(new SasReaderCallback(){

                public void column(int index, String name, String label, SasColumnType type, int length) {
                    int kettleLength;
                    int kettleType = 0;
                    switch (type) {
                        case CHARACTER: {
                            kettleType = 2;
                            kettleLength = length;
                            break;
                        }
                        case NUMERIC: {
                            kettleType = 1;
                            kettleLength = -1;
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unhandled SAS data type encountered: " + type);
                        }
                    }
                    ValueMeta valueMeta = new ValueMeta(name, kettleType);
                    valueMeta.setLength(kettleLength);
                    valueMeta.setComments(label);
                    SasInputHelper.this.rowMeta.addValueMeta((ValueMetaInterface)valueMeta);
                }

                public boolean readData() {
                    return false;
                }

                public boolean row(int rowNumber, Object[] rowData) {
                    return true;
                }
            });
        }
        catch (Exception e) {
            throw new KettleException("Unable to determine the layout of SAS7BAT file '" + filename + "'", (Throwable)e);
        }
    }

    public String toString() {
        return this.filename;
    }

    public String getFilename() {
        return this.filename;
    }

    public RowMetaInterface getRowMeta() {
        return this.rowMeta;
    }
}

