/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.singlethreader;

import java.util.ArrayList;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.SingleThreadedTransExecutor;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.RowAdapter;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mapping.MappingValueRename;
import org.pentaho.di.trans.steps.mappinginput.MappingInputData;
import org.pentaho.di.trans.steps.singlethreader.SingleThreaderData;
import org.pentaho.di.trans.steps.singlethreader.SingleThreaderMeta;

public class SingleThreader
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = SingleThreaderMeta.class;
    private SingleThreaderMeta meta;
    private SingleThreaderData data;

    public SingleThreader(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        boolean timeWindow;
        this.meta = (SingleThreaderMeta)smi;
        this.data = (SingleThreaderData)sdi;
        Object[] row = this.getRow();
        if (row == null) {
            if (this.data.batchCount > 0) {
                return this.execOneIteration();
            }
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.data.startTime = System.currentTimeMillis();
        }
        this.data.rowProducer.putRow(this.getInputRowMeta(), row);
        ++this.data.batchCount;
        boolean countWindow = this.data.batchSize > 0 && this.data.batchCount >= this.data.batchSize;
        boolean bl = timeWindow = this.data.batchTime > 0 && System.currentTimeMillis() - this.data.startTime > (long)this.data.batchTime;
        if (countWindow || timeWindow) {
            this.data.batchCount = 0;
            boolean more = this.execOneIteration();
            if (!more) {
                this.setOutputDone();
                return false;
            }
            this.data.startTime = System.currentTimeMillis();
        }
        return true;
    }

    private boolean execOneIteration() {
        boolean more = false;
        try {
            more = this.data.executor.oneIteration();
            if (this.data.executor.isStopped() || this.data.executor.getErrors() > 0L) {
                this.setErrors(1L);
                this.stopAll();
                this.logError(BaseMessages.getString(PKG, (String)"SingleThreader.Log.ErrorOccurredInSubTransformation", (String[])new String[0]));
                return false;
            }
        }
        catch (Exception e) {
            this.setErrors(1L);
            this.stopAll();
            this.logError(BaseMessages.getString(PKG, (String)"SingleThreader.Log.ErrorOccurredInSubTransformation", (String[])new String[0]));
            return false;
        }
        return more;
    }

    private void passParameters() throws KettleException {
        int i;
        String[] parameterValues;
        String[] parameters;
        if (this.meta.isPassingAllParameters()) {
            parameters = this.data.mappingTransMeta.listParameters();
            parameterValues = new String[parameters.length];
            for (i = 0; i < parameters.length; ++i) {
                parameterValues[i] = this.getVariable(parameters[i]);
            }
        } else {
            parameters = this.meta.getParameters();
            parameterValues = new String[parameters.length];
            for (i = 0; i < parameters.length; ++i) {
                parameterValues[i] = this.environmentSubstitute(this.meta.getParameterValues()[i]);
            }
        }
        for (i = 0; i < parameters.length; ++i) {
            String value = Const.NVL((String)parameterValues[i], (String)"");
            this.data.mappingTrans.setParameterValue(parameters[i], value);
        }
        this.data.mappingTrans.activateParameters();
    }

    public void prepareMappingExecution() throws KettleException {
        this.data.mappingTransMeta.setTransformationType(TransMeta.TransformationType.SingleThreaded);
        this.data.mappingTrans = new Trans(this.data.mappingTransMeta, this.getTrans());
        this.passParameters();
        this.data.mappingTrans.getTransMeta().setUsingThreadPriorityManagment(false);
        this.data.mappingTrans.setParentTrans(this.getTrans());
        this.data.mappingTrans.setSafeModeEnabled(this.getTrans().isSafeModeEnabled());
        this.data.mappingTrans.setMappingStepName(this.getStepname());
        this.data.mappingTrans.setServletPrintWriter(this.getTrans().getServletPrintWriter());
        this.data.mappingTrans.prepareExecution(null);
        if (this.data.injectStepMeta.isMappingInput()) {
            MappingInputData mappingInputData = (MappingInputData)this.data.mappingTrans.findDataInterface(this.data.injectStepMeta.getName());
            mappingInputData.sourceSteps = new StepInterface[0];
            mappingInputData.valueRenames = new ArrayList<MappingValueRename>();
        }
        this.data.rowProducer = this.data.mappingTrans.addRowProducer(this.meta.getInjectStep(), 0);
        StepInterface retrieveStep = this.data.mappingTrans.getStepInterface(this.meta.getRetrieveStep(), 0);
        retrieveStep.addRowListener(new RowAdapter(){

            public void rowWrittenEvent(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
                SingleThreader.this.putRow(rowMeta, row);
            }
        });
        this.data.mappingTrans.startThreads();
        this.data.executor = new SingleThreadedTransExecutor(this.data.mappingTrans);
        try {
            boolean ok = this.data.executor.init();
            if (!ok) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"SingleThreader.Exception.UnableToInitSingleThreadedTransformation", (String[])new String[0]));
            }
        }
        catch (KettleException e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"SingleThreader.Exception.UnableToPrepareExecutionOfMapping", (String[])new String[0]), (Throwable)e);
        }
        this.getTrans().getActiveSubtransformations().put(this.getStepname(), this.data.mappingTrans);
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (SingleThreaderMeta)smi;
        this.data = (SingleThreaderData)sdi;
        if (super.init(smi, sdi)) {
            try {
                this.data.batchSize = Const.toInt((String)this.environmentSubstitute(this.meta.getBatchSize()), (int)0);
                this.data.batchTime = Const.toInt((String)this.environmentSubstitute(this.meta.getBatchTime()), (int)0);
                this.meta.setRepository(this.getTransMeta().getRepository());
                this.data.mappingTransMeta = SingleThreaderMeta.loadSingleThreadedTransMeta(this.meta, this.meta.getRepository(), this);
                if (this.data.mappingTransMeta != null) {
                    String retrieveStepName;
                    String injectStepName = this.environmentSubstitute(this.meta.getInjectStep());
                    this.data.injectStepMeta = this.data.mappingTransMeta.findStep(injectStepName);
                    if (this.data.injectStepMeta == null) {
                        this.logError("The inject step with name '" + injectStepName + "' couldn't be found in the sub-transformation");
                    }
                    if (!Const.isEmpty((String)(retrieveStepName = this.environmentSubstitute(this.meta.getRetrieveStep())))) {
                        this.data.retrieveStepMeta = this.data.mappingTransMeta.findStep(retrieveStepName);
                        if (this.data.retrieveStepMeta == null) {
                            this.logError("The retrieve step with name '" + retrieveStepName + "' couldn't be found in the sub-transformation");
                        }
                    }
                    this.prepareMappingExecution();
                    return true;
                }
                this.logError("No valid mapping was specified!");
                return false;
            }
            catch (Exception e) {
                this.logError("Unable to load the mapping transformation because of an error : " + e.toString());
                this.logError(Const.getStackTracker((Throwable)e));
            }
        }
        return false;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        try {
            this.data.executor.dispose();
        }
        catch (KettleException e) {
            this.log.logError("Error disposing of sub-transformation: ", (Throwable)e);
        }
        super.dispose(smi, sdi);
    }

    public void stopRunning(StepMetaInterface stepMetaInterface, StepDataInterface stepDataInterface) throws KettleException {
        if (this.data.mappingTrans != null) {
            this.data.mappingTrans.stopAll();
        }
    }

    public void stopAll() {
        if (this.data.mappingTrans != null) {
            this.data.mappingTrans.stopAll();
        }
        super.stopAll();
    }

    public Trans getMappingTrans() {
        return this.data.mappingTrans;
    }
}

