/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.splitfieldtorows;

import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.splitfieldtorows.SplitFieldToRows;
import org.pentaho.di.trans.steps.splitfieldtorows.SplitFieldToRowsData;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplitFieldToRowsMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = SplitFieldToRowsMeta.class;
    private String splitField;
    private String delimiter;
    private String newFieldname;
    private boolean includeRowNumber;
    private String rowNumberField;
    private boolean resetRowNumber;
    private boolean isDelimiterRegex;

    public boolean isDelimiterRegex() {
        return this.isDelimiterRegex;
    }

    public void setDelimiterRegex(boolean isDelimiterRegex) {
        this.isDelimiterRegex = isDelimiterRegex;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getSplitField() {
        return this.splitField;
    }

    public void setSplitField(String splitField) {
        this.splitField = splitField;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode);
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.splitField = XMLHandler.getTagValue((Node)stepnode, (String)"splitfield");
            this.delimiter = XMLHandler.getTagValue((Node)stepnode, (String)"delimiter");
            this.newFieldname = XMLHandler.getTagValue((Node)stepnode, (String)"newfield");
            this.includeRowNumber = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"rownum"));
            this.resetRowNumber = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"resetrownumber"));
            this.rowNumberField = XMLHandler.getTagValue((Node)stepnode, (String)"rownum_field");
            this.isDelimiterRegex = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"delimiter_is_regex"));
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"SplitFieldToRowsMeta.Exception.UnableToLoadStepInfoFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        this.splitField = "";
        this.delimiter = ";";
        this.newFieldname = "";
        this.includeRowNumber = false;
        this.isDelimiterRegex = false;
        this.rowNumberField = "";
        this.resetRowNumber = true;
    }

    @Override
    public void getFields(RowMetaInterface row, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        ValueMeta v = new ValueMeta(this.newFieldname, 2);
        v.setOrigin(name);
        row.addValueMeta((ValueMetaInterface)v);
        if (this.includeRowNumber) {
            v = new ValueMeta(space.environmentSubstitute(this.rowNumberField), 5);
            v.setLength(10, 0);
            v.setOrigin(name);
            row.addValueMeta((ValueMetaInterface)v);
        }
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append("   " + XMLHandler.addTagValue((String)"splitfield", (String)this.splitField));
        retval.append("   " + XMLHandler.addTagValue((String)"delimiter", (String)this.delimiter));
        retval.append("   " + XMLHandler.addTagValue((String)"newfield", (String)this.newFieldname));
        retval.append("   " + XMLHandler.addTagValue((String)"rownum", (boolean)this.includeRowNumber));
        retval.append("   " + XMLHandler.addTagValue((String)"rownum_field", (String)this.rowNumberField));
        retval.append("   " + XMLHandler.addTagValue((String)"resetrownumber", (boolean)this.resetRowNumber));
        retval.append("   " + XMLHandler.addTagValue((String)"delimiter_is_regex", (boolean)this.isDelimiterRegex));
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, ObjectId id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            this.splitField = rep.getStepAttributeString(id_step, "splitfield");
            this.delimiter = rep.getStepAttributeString(id_step, "delimiter");
            this.newFieldname = rep.getStepAttributeString(id_step, "newfield");
            this.includeRowNumber = rep.getStepAttributeBoolean(id_step, "rownum");
            this.rowNumberField = rep.getStepAttributeString(id_step, "rownum_field");
            this.resetRowNumber = rep.getStepAttributeBoolean(id_step, "reset_rownumber");
            this.isDelimiterRegex = rep.getStepAttributeBoolean(id_step, 0, "delimiter_is_regex", false);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"SplitFieldToRowsMeta.Exception.UnexpectedErrorInReadingStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "splitfield", this.splitField);
            rep.saveStepAttribute(id_transformation, id_step, "delimiter", this.delimiter);
            rep.saveStepAttribute(id_transformation, id_step, "newfield", this.newFieldname);
            rep.saveStepAttribute(id_transformation, id_step, "rownum", this.includeRowNumber);
            rep.saveStepAttribute(id_transformation, id_step, "reset_rownumber", this.resetRowNumber);
            rep.saveStepAttribute(id_transformation, id_step, "rownum_field", this.rowNumberField);
            rep.saveStepAttribute(id_transformation, id_step, "delimiter_is_regex", this.isDelimiterRegex);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"SplitFieldToRowsMeta.Exception.UnableToSaveStepInfoToRepository", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr;
        String error_message = "";
        if (prev != null && prev.size() > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SplitFieldToRowsMeta.CheckResult.StepReceivingFields", (String[])new String[]{prev.size() + ""}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            error_message = "";
            ValueMetaInterface v = prev.searchValueMeta(this.splitField);
            if (v == null) {
                error_message = BaseMessages.getString(PKG, (String)"SplitFieldToRowsMeta.CheckResult.FieldToSplitNotPresentInInputStream", (String[])new String[]{this.splitField});
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SplitFieldToRowsMeta.CheckResult.FieldToSplitFoundInInputStream", (String[])new String[]{this.splitField}), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        } else {
            error_message = BaseMessages.getString(PKG, (String)"SplitFieldToRowsMeta.CheckResult.CouldNotReadFieldsFromPreviousStep", (String[])new String[0]) + Const.CR;
            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SplitFieldToRowsMeta.CheckResult.StepReceivingInfoFromOtherStep", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SplitFieldToRowsMeta.CheckResult.NoInputReceivedFromOtherStep", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (Const.isEmpty((String)this.newFieldname)) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SplitFieldToRowsMeta.CheckResult.NewFieldNameIsNull", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (this.includeRowNumber) {
            cr = Const.isEmpty((String)transMeta.environmentSubstitute(this.rowNumberField)) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"SplitFieldToRowsMeta.CheckResult.RowNumberFieldMissing", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"SplitFieldToRowsMeta.CheckResult.RowNumberFieldOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new SplitFieldToRows(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new SplitFieldToRowsData();
    }

    public String getNewFieldname() {
        return this.newFieldname;
    }

    public void setNewFieldname(String newFieldname) {
        this.newFieldname = newFieldname;
    }

    public String getRowNumberField() {
        return this.rowNumberField;
    }

    public void setRowNumberField(String rowNumberField) {
        this.rowNumberField = rowNumberField;
    }

    public boolean resetRowNumber() {
        return this.resetRowNumber;
    }

    public void setResetRowNumber(boolean resetRowNumber) {
        this.resetRowNumber = resetRowNumber;
    }

    public void setIncludeRowNumber(boolean includeRowNumber) {
        this.includeRowNumber = includeRowNumber;
    }

    public boolean includeRowNumber() {
        return this.includeRowNumber;
    }
}

