/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.ssh;

import com.trilead.ssh2.Connection;
import com.trilead.ssh2.HTTPProxyData;
import com.trilead.ssh2.ProxyData;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepIOMeta;
import org.pentaho.di.trans.step.StepIOMetaInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.ssh.SSH;
import org.pentaho.di.trans.steps.ssh.SSHData;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSHMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = SSHMeta.class;
    private static int DEFAULT_PORT = 22;
    private String command;
    private boolean dynamicCommandField;
    private String commandfieldname;
    private String serverName;
    private String port;
    private String userName;
    private String password;
    private boolean usePrivateKey;
    private String keyFileName;
    private String passPhrase;
    private String stdOutFieldName;
    private String stdErrFieldName;
    private String timeOut;
    private String proxyHost;
    private String proxyPort;
    private String proxyUsername;
    private String proxyPassword;

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        SSHMeta retval = (SSHMeta)super.clone();
        return retval;
    }

    @Override
    public void setDefault() {
        this.dynamicCommandField = false;
        this.command = null;
        this.commandfieldname = null;
        this.port = String.valueOf(DEFAULT_PORT);
        this.serverName = null;
        this.userName = null;
        this.password = null;
        this.usePrivateKey = true;
        this.keyFileName = null;
        this.stdOutFieldName = "stdOut";
        this.stdErrFieldName = "stdErr";
        this.timeOut = "0";
        this.proxyHost = null;
        this.proxyPort = null;
        this.proxyUsername = null;
        this.proxyPassword = null;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getuserName() {
        return this.userName;
    }

    public void setuserName(String userName) {
        this.userName = userName;
    }

    public void setpassword(String password) {
        this.password = password;
    }

    public String getpassword() {
        return this.password;
    }

    public void setcommandfieldname(String commandfieldname) {
        this.commandfieldname = commandfieldname;
    }

    public String getcommandfieldname() {
        return this.commandfieldname;
    }

    public void setCommand(String value) {
        this.command = value;
    }

    public String getCommand() {
        return this.command;
    }

    public void setDynamicCommand(boolean value) {
        this.dynamicCommandField = value;
    }

    public boolean isDynamicCommand() {
        return this.dynamicCommandField;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void usePrivateKey(boolean value) {
        this.usePrivateKey = value;
    }

    public boolean isusePrivateKey() {
        return this.usePrivateKey;
    }

    public void setKeyFileName(String value) {
        this.keyFileName = value;
    }

    public String getKeyFileName() {
        return this.keyFileName;
    }

    public void setPassphrase(String value) {
        this.passPhrase = value;
    }

    public String getPassphrase() {
        return this.passPhrase;
    }

    public void setTimeOut(String timeOut) {
        this.timeOut = timeOut;
    }

    public String getTimeOut() {
        return this.timeOut;
    }

    public void setstdOutFieldName(String value) {
        this.stdOutFieldName = value;
    }

    public String getStdOutFieldName() {
        return this.stdOutFieldName;
    }

    public void setStdErrFieldName(String value) {
        this.stdErrFieldName = value;
    }

    public String getStdErrFieldName() {
        return this.stdErrFieldName;
    }

    public void setProxyHost(String value) {
        this.proxyHost = value;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyPort(String value) {
        this.proxyPort = value;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyUsername(String value) {
        this.proxyUsername = value;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyPassword(String value) {
        this.proxyPassword = value;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append("    " + XMLHandler.addTagValue((String)"dynamicCommandField", (boolean)this.dynamicCommandField));
        retval.append("    " + XMLHandler.addTagValue((String)"command", (String)this.command));
        retval.append("    " + XMLHandler.addTagValue((String)"commandfieldname", (String)this.commandfieldname));
        retval.append("    " + XMLHandler.addTagValue((String)"port", (String)this.port));
        retval.append("    " + XMLHandler.addTagValue((String)"servername", (String)this.serverName));
        retval.append("    " + XMLHandler.addTagValue((String)"userName", (String)this.userName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.password)));
        retval.append("    " + XMLHandler.addTagValue((String)"usePrivateKey", (boolean)this.usePrivateKey));
        retval.append("    " + XMLHandler.addTagValue((String)"keyFileName", (String)this.keyFileName));
        retval.append("    " + XMLHandler.addTagValue((String)"passPhrase", (String)this.passPhrase));
        retval.append("    " + XMLHandler.addTagValue((String)"stdOutFieldName", (String)this.stdOutFieldName));
        retval.append("    " + XMLHandler.addTagValue((String)"stdErrFieldName", (String)this.stdErrFieldName));
        retval.append("    " + XMLHandler.addTagValue((String)"timeOut", (String)this.timeOut));
        retval.append("    " + XMLHandler.addTagValue((String)"proxyHost", (String)this.proxyHost));
        retval.append("    " + XMLHandler.addTagValue((String)"proxyPort", (String)this.proxyPort));
        retval.append("    " + XMLHandler.addTagValue((String)"proxyUsername", (String)this.proxyUsername));
        retval.append("    ").append(XMLHandler.addTagValue((String)"proxyPassword", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.proxyPassword)));
        return retval.toString();
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.dynamicCommandField = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"dynamicCommandField"));
            this.command = XMLHandler.getTagValue((Node)stepnode, (String)"command");
            this.commandfieldname = XMLHandler.getTagValue((Node)stepnode, (String)"commandfieldname");
            this.port = XMLHandler.getTagValue((Node)stepnode, (String)"port");
            this.serverName = XMLHandler.getTagValue((Node)stepnode, (String)"servername");
            this.userName = XMLHandler.getTagValue((Node)stepnode, (String)"userName");
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)stepnode, (String)"password"));
            this.usePrivateKey = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"usePrivateKey"));
            this.keyFileName = XMLHandler.getTagValue((Node)stepnode, (String)"keyFileName");
            this.passPhrase = XMLHandler.getTagValue((Node)stepnode, (String)"passPhrase");
            this.stdOutFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"stdOutFieldName");
            this.stdErrFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"stdErrFieldName");
            this.timeOut = XMLHandler.getTagValue((Node)stepnode, (String)"timeOut");
            this.proxyHost = XMLHandler.getTagValue((Node)stepnode, (String)"proxyHost");
            this.proxyPort = XMLHandler.getTagValue((Node)stepnode, (String)"proxyPort");
            this.proxyUsername = XMLHandler.getTagValue((Node)stepnode, (String)"proxyUsername");
            this.proxyPassword = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)stepnode, (String)"proxyPassword"));
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"SSHMeta.Exception.UnableToReadStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void readRep(Repository rep, ObjectId id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            this.dynamicCommandField = rep.getStepAttributeBoolean(id_step, "dynamicCommandField");
            this.command = rep.getStepAttributeString(id_step, "command");
            this.commandfieldname = rep.getStepAttributeString(id_step, "commandfieldname");
            this.serverName = rep.getStepAttributeString(id_step, "servername");
            this.port = rep.getStepAttributeString(id_step, "port");
            this.userName = rep.getStepAttributeString(id_step, "userName");
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)rep.getStepAttributeString(id_step, "password"));
            this.usePrivateKey = rep.getStepAttributeBoolean(id_step, "usePrivateKey");
            this.keyFileName = rep.getStepAttributeString(id_step, "keyFileName");
            this.passPhrase = rep.getStepAttributeString(id_step, "passPhrase");
            this.stdOutFieldName = rep.getStepAttributeString(id_step, "stdOutFieldName");
            this.stdErrFieldName = rep.getStepAttributeString(id_step, "stdErrFieldName");
            this.timeOut = rep.getStepAttributeString(id_step, "timeOut");
            this.proxyHost = rep.getStepAttributeString(id_step, "proxyHost");
            this.proxyPort = rep.getStepAttributeString(id_step, "proxyPort");
            this.proxyUsername = rep.getStepAttributeString(id_step, "proxyUsername");
            this.proxyPassword = Encr.decryptPasswordOptionallyEncrypted((String)rep.getStepAttributeString(id_step, "proxyPassword"));
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"SSHMeta.Exception.UnexpectedErrorReadingStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "dynamicCommandField", this.dynamicCommandField);
            rep.saveStepAttribute(id_transformation, id_step, "command", this.command);
            rep.saveStepAttribute(id_transformation, id_step, "commandfieldname", this.commandfieldname);
            rep.saveStepAttribute(id_transformation, id_step, "port", this.port);
            rep.saveStepAttribute(id_transformation, id_step, "servername", this.serverName);
            rep.saveStepAttribute(id_transformation, id_step, "userName", this.userName);
            rep.saveStepAttribute(id_transformation, id_step, "password", Encr.encryptPasswordIfNotUsingVariables((String)this.password));
            rep.saveStepAttribute(id_transformation, id_step, "usePrivateKey", this.usePrivateKey);
            rep.saveStepAttribute(id_transformation, id_step, "keyFileName", this.keyFileName);
            rep.saveStepAttribute(id_transformation, id_step, "passPhrase", this.passPhrase);
            rep.saveStepAttribute(id_transformation, id_step, "stdOutFieldName", this.stdOutFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "stdErrFieldName", this.stdErrFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "timeOut", this.timeOut);
            rep.saveStepAttribute(id_transformation, id_step, "proxyHost", this.proxyHost);
            rep.saveStepAttribute(id_transformation, id_step, "proxyPort", this.proxyPort);
            rep.saveStepAttribute(id_transformation, id_step, "proxyUsername", this.proxyUsername);
            rep.saveStepAttribute(id_transformation, id_step, "proxyPassword", Encr.encryptPasswordIfNotUsingVariables((String)this.proxyPassword));
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"SSHMeta.Exception.UnableToSaveStepInfo", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr;
        String error_message = "";
        if (Const.isEmpty((String)this.getServerName())) {
            error_message = BaseMessages.getString(PKG, (String)"SSHMeta.CheckResult.TargetHostMissing", (String[])new String[0]);
            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            error_message = BaseMessages.getString(PKG, (String)"SSHMeta.CheckResult.TargetHostOK", (String[])new String[0]);
            cr = new CheckResult(1, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (this.isusePrivateKey()) {
            String keyfilename = transMeta.environmentSubstitute(this.getKeyFileName());
            if (Const.isEmpty((String)keyfilename)) {
                error_message = BaseMessages.getString(PKG, (String)"SSHMeta.CheckResult.PrivateKeyFileNameMissing", (String[])new String[0]);
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else {
                error_message = BaseMessages.getString(PKG, (String)"SSHMeta.CheckResult.PrivateKeyFileNameOK", (String[])new String[0]);
                cr = new CheckResult(1, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
                boolean keyFileExists = false;
                try {
                    keyFileExists = KettleVFS.fileExists((String)keyfilename);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (!keyFileExists) {
                    error_message = BaseMessages.getString(PKG, (String)"SSHMeta.CheckResult.PrivateKeyFileNotExist", (String[])new String[]{keyfilename});
                    cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                } else {
                    error_message = BaseMessages.getString(PKG, (String)"SSHMeta.CheckResult.PrivateKeyFileExists", (String[])new String[]{keyfilename});
                    cr = new CheckResult(1, error_message, (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                }
            }
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SSHMeta.CheckResult.ReceivingInfoFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SSHMeta.CheckResult.NoInpuReceived", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public void getFields(RowMetaInterface row, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        if (!this.isDynamicCommand()) {
            row.clear();
        }
        ValueMeta v = new ValueMeta(space.environmentSubstitute(this.getStdOutFieldName()), 2);
        v.setOrigin(name);
        row.addValueMeta((ValueMetaInterface)v);
        String stderrfield = space.environmentSubstitute(this.getStdErrFieldName());
        if (!Const.isEmpty((String)stderrfield)) {
            v = new ValueMeta(stderrfield, 4);
            v.setOrigin(name);
            row.addValueMeta((ValueMetaInterface)v);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new SSH(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new SSHData();
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }

    public static Connection OpenConnection(String serveur, int port, String username, String password, boolean useKey, String keyFilename, String passPhrase, int timeOut, VariableSpace space, String proxyhost, int proxyport, String proxyusername, String proxypassword) throws KettleException {
        Connection conn = null;
        boolean isAuthenticated = false;
        File keyFile = null;
        try {
            if (useKey) {
                if (Const.isEmpty((String)keyFilename)) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"SSH.Error.PrivateKeyFileMissing", (String[])new String[0]));
                }
                keyFile = new File(keyFilename);
                if (!keyFile.exists()) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"SSH.Error.PrivateKeyNotExist", (String[])new String[]{keyFilename}));
                }
            }
            conn = new Connection(serveur, port);
            if (!Const.isEmpty((String)proxyhost)) {
                if (!Const.isEmpty((String)proxyusername)) {
                    conn.setProxyData((ProxyData)new HTTPProxyData(proxyhost, proxyport, proxyusername, proxypassword));
                } else {
                    conn.setProxyData((ProxyData)new HTTPProxyData(proxyhost, proxyport));
                }
            }
            if (timeOut == 0) {
                conn.connect();
            } else {
                conn.connect(null, 0, timeOut * 1000);
            }
            isAuthenticated = useKey ? conn.authenticateWithPublicKey(username, keyFile, space.environmentSubstitute(passPhrase)) : conn.authenticateWithPassword(username, password);
            if (!isAuthenticated) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"SSH.Error.AuthenticationFailed", (String[])new String[]{username}));
            }
        }
        catch (Exception e) {
            if (conn != null) {
                conn.close();
            }
            throw new KettleException(BaseMessages.getString(PKG, (String)"SSH.Error.ErrorConnecting", (String[])new String[]{serveur, username}), (Throwable)e);
        }
        return conn;
    }

    @Override
    public StepIOMetaInterface getStepIOMeta() {
        return new StepIOMeta(this.isDynamicCommand(), true, false, false, false, false);
    }
}

