/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.stepmeta;

import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.stepmeta.StepMetastructure;
import org.pentaho.di.trans.steps.stepmeta.StepMetastructureData;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StepMetastructureMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = StepMetastructureMeta.class;
    private String fieldName;
    private String comments;
    private String typeName;
    private String positionName;
    private String lengthName;
    private String precisionName;
    private String originName;
    private boolean outputRowcount;
    private String rowcountField;

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        Object retval = super.clone();
        return retval;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(500);
        retval.append("      ").append(XMLHandler.addTagValue((String)"outputRowcount", (boolean)this.outputRowcount));
        retval.append("    ").append(XMLHandler.addTagValue((String)"rowcountField", (String)this.rowcountField));
        return retval.toString();
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.outputRowcount = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"outputRowcount"));
            this.rowcountField = XMLHandler.getTagValue((Node)stepnode, (String)"rowcountField");
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    @Override
    public void readRep(Repository rep, ObjectId id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            this.outputRowcount = rep.getStepAttributeBoolean(id_step, "outputRowcount");
            this.rowcountField = rep.getStepAttributeString(id_step, "rowcountField");
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "outputRowcount", this.outputRowcount);
            rep.saveStepAttribute(id_transformation, id_step, "rowcountField", this.rowcountField);
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new StepMetastructure(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new StepMetastructureData();
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepinfo, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr = new CheckResult(1, "Not implemented", (CheckResultSourceInterface)stepinfo);
        remarks.add((CheckResultInterface)cr);
    }

    @Override
    public void getFields(RowMetaInterface r, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        r.clear();
        this.setDefault();
        ValueMeta positionFieldValue = new ValueMeta(this.positionName, 5);
        positionFieldValue.setOrigin(name);
        r.addValueMeta((ValueMetaInterface)positionFieldValue);
        ValueMeta nameFieldValue = new ValueMeta(this.fieldName, 2);
        nameFieldValue.setOrigin(name);
        r.addValueMeta((ValueMetaInterface)nameFieldValue);
        ValueMeta commentsFieldValue = new ValueMeta(this.comments, 2);
        nameFieldValue.setOrigin(name);
        r.addValueMeta((ValueMetaInterface)commentsFieldValue);
        ValueMeta typeFieldValue = new ValueMeta(this.typeName, 2);
        typeFieldValue.setOrigin(name);
        r.addValueMeta((ValueMetaInterface)typeFieldValue);
        ValueMeta lengthFieldValue = new ValueMeta(this.lengthName, 5);
        lengthFieldValue.setOrigin(name);
        r.addValueMeta((ValueMetaInterface)lengthFieldValue);
        ValueMeta precisionFieldValue = new ValueMeta(this.precisionName, 5);
        precisionFieldValue.setOrigin(name);
        r.addValueMeta((ValueMetaInterface)precisionFieldValue);
        ValueMeta originFieldValue = new ValueMeta(this.originName, 2);
        originFieldValue.setOrigin(name);
        r.addValueMeta((ValueMetaInterface)originFieldValue);
        if (this.isOutputRowcount()) {
            ValueMeta v = new ValueMeta(this.getRowcountField(), 5);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
    }

    @Override
    public void setDefault() {
        this.positionName = BaseMessages.getString(PKG, (String)"StepMetastructureMeta.PositionName", (String[])new String[0]);
        this.fieldName = BaseMessages.getString(PKG, (String)"StepMetastructureMeta.FieldName", (String[])new String[0]);
        this.comments = BaseMessages.getString(PKG, (String)"StepMetastructureMeta.Comments", (String[])new String[0]);
        this.typeName = BaseMessages.getString(PKG, (String)"StepMetastructureMeta.TypeName", (String[])new String[0]);
        this.lengthName = BaseMessages.getString(PKG, (String)"StepMetastructureMeta.LengthName", (String[])new String[0]);
        this.precisionName = BaseMessages.getString(PKG, (String)"StepMetastructureMeta.PrecisionName", (String[])new String[0]);
        this.originName = BaseMessages.getString(PKG, (String)"StepMetastructureMeta.OriginName", (String[])new String[0]);
    }

    public boolean isOutputRowcount() {
        return this.outputRowcount;
    }

    public void setOutputRowcount(boolean outputRowcount) {
        this.outputRowcount = outputRowcount;
    }

    public String getRowcountField() {
        return this.rowcountField;
    }

    public void setRowcountField(String rowcountField) {
        this.rowcountField = rowcountField;
    }
}

