/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.streamlookup;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Collections;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.hash.ByteArrayHashIndex;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.streamlookup.KeyValue;
import org.pentaho.di.trans.steps.streamlookup.StreamLookupData;
import org.pentaho.di.trans.steps.streamlookup.StreamLookupMeta;

public class StreamLookup
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = StreamLookupMeta.class;
    private StreamLookupMeta meta;
    private StreamLookupData data;

    public StreamLookup(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private void handleNullIf() {
        this.data.nullIf = new Object[this.meta.getValue().length];
        block16: for (int i = 0; i < this.meta.getValue().length; ++i) {
            if (this.meta.getValueDefaultType()[i] < 0) {
                this.meta.getValueDefaultType()[i] = 2;
            }
            this.data.nullIf[i] = null;
            switch (this.meta.getValueDefaultType()[i]) {
                case 2: {
                    if (Const.isEmpty((String)this.meta.getValueDefault()[i])) {
                        this.data.nullIf[i] = null;
                        continue block16;
                    }
                    this.data.nullIf[i] = this.meta.getValueDefault()[i];
                    continue block16;
                }
                case 3: {
                    try {
                        this.data.nullIf[i] = DateFormat.getInstance().parse(this.meta.getValueDefault()[i]);
                    }
                    catch (Exception e) {}
                    continue block16;
                }
                case 1: {
                    try {
                        this.data.nullIf[i] = new Double(Double.parseDouble(this.meta.getValueDefault()[i]));
                    }
                    catch (Exception e) {}
                    continue block16;
                }
                case 5: {
                    try {
                        this.data.nullIf[i] = new Long(Long.parseLong(this.meta.getValueDefault()[i]));
                    }
                    catch (Exception e) {}
                    continue block16;
                }
                case 4: {
                    if ("TRUE".equalsIgnoreCase(this.meta.getValueDefault()[i]) || "Y".equalsIgnoreCase(this.meta.getValueDefault()[i])) {
                        this.data.nullIf[i] = Boolean.TRUE;
                        continue block16;
                    }
                    this.data.nullIf[i] = Boolean.FALSE;
                    continue block16;
                }
                case 6: {
                    try {
                        this.data.nullIf[i] = new BigDecimal(this.meta.getValueDefault()[i]);
                    }
                    catch (Exception exception) {}
                    continue block16;
                }
                default: {
                    if (this.meta.getValueDefault()[i] != null && this.meta.getValueDefault()[i].trim().length() > 0) {
                        throw new RuntimeException(BaseMessages.getString(PKG, (String)"StreamLookup.Exception.ConversionNotImplemented", (String[])new String[0]) + " " + ValueMeta.getTypeDesc((int)this.meta.getValueDefaultType()[i]));
                    }
                    this.data.nullIf[i] = null;
                }
            }
        }
    }

    private boolean readLookupValues() throws KettleException {
        this.data.infoStream = this.meta.getStepIOMeta().getInfoStreams().get(0);
        if (this.data.infoStream.getStepMeta() == null) {
            this.logError(BaseMessages.getString(PKG, (String)"StreamLookup.Log.NoLookupStepSpecified", (String[])new String[0]));
            return false;
        }
        if (this.log.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"StreamLookup.Log.ReadingFromStream", (String[])new String[0]) + this.data.infoStream.getStepname() + "]");
        }
        int[] keyNrs = new int[this.meta.getKeylookup().length];
        int[] valueNrs = new int[this.meta.getValue().length];
        boolean firstRun = true;
        RowSet rowSet = this.findInputRowSet(this.data.infoStream.getStepname());
        Object[] rowData = this.getRowFrom(rowSet);
        while (rowData != null) {
            if (this.log.isRowLevel()) {
                this.logRowlevel(BaseMessages.getString(PKG, (String)"StreamLookup.Log.ReadLookupRow", (String[])new String[0]) + rowSet.getRowMeta().getString(rowData));
            }
            if (firstRun) {
                int i;
                firstRun = false;
                this.data.hasLookupRows = true;
                this.data.infoMeta = rowSet.getRowMeta().clone();
                this.data.keyMeta = new RowMeta();
                this.data.valueMeta = new RowMeta();
                for (i = 0; i < this.meta.getKeylookup().length; ++i) {
                    keyNrs[i] = rowSet.getRowMeta().indexOfValue(this.meta.getKeylookup()[i]);
                    if (keyNrs[i] < 0) {
                        throw new KettleStepException(BaseMessages.getString(PKG, (String)"StreamLookup.Exception.UnableToFindField", (String[])new String[]{this.meta.getKeylookup()[i]}));
                    }
                    this.data.keyMeta.addValueMeta(rowSet.getRowMeta().getValueMeta(keyNrs[i]));
                }
                if (this.data.keyTypes == null) {
                    this.data.keyTypes = this.data.keyMeta.clone();
                }
                for (i = 0; i < keyNrs.length; ++i) {
                    this.data.keyMeta.getValueMeta(i).setStorageType(0);
                }
                for (int v = 0; v < this.meta.getValue().length; ++v) {
                    valueNrs[v] = rowSet.getRowMeta().indexOfValue(this.meta.getValue()[v]);
                    if (valueNrs[v] < 0) {
                        throw new KettleStepException(BaseMessages.getString(PKG, (String)"StreamLookup.Exception.UnableToFindField", (String[])new String[]{this.meta.getValue()[v]}));
                    }
                    this.data.valueMeta.addValueMeta(rowSet.getRowMeta().getValueMeta(valueNrs[v]));
                }
            }
            Object[] keyData = new Object[keyNrs.length];
            for (int i = 0; i < keyNrs.length; ++i) {
                ValueMetaInterface keyMeta = this.data.keyTypes.getValueMeta(i);
                keyData[i] = keyMeta.convertToNormalStorageType(rowData[keyNrs[i]]);
                keyMeta.setStorageType(0);
            }
            Object[] valueData = new Object[valueNrs.length];
            for (int i = 0; i < valueNrs.length; ++i) {
                ValueMetaInterface valueMeta = this.data.valueMeta.getValueMeta(i);
                valueData[i] = valueMeta.convertToNormalStorageType(rowData[valueNrs[i]]);
            }
            this.addToCache(this.data.keyMeta, keyData, this.data.valueMeta, valueData);
            rowData = this.getRowFrom(rowSet);
        }
        return true;
    }

    private Object[] lookupValues(RowMetaInterface rowMeta, Object[] row) throws KettleException {
        int i;
        if (this.isStopped()) {
            return null;
        }
        if (this.data.lookupColumnIndex == null) {
            String[] names = this.data.lookupMeta.getFieldNames();
            this.data.lookupColumnIndex = new int[names.length];
            for (i = 0; i < names.length; ++i) {
                this.data.lookupColumnIndex[i] = rowMeta.indexOfValue(names[i]);
                if (this.data.lookupColumnIndex[i] >= 0) continue;
                throw new KettleStepException("The lookup column '" + names[i] + "' could not be found");
            }
        }
        Object[] lu = new Object[this.data.keynrs.length];
        for (i = 0; i < this.data.keynrs.length; ++i) {
            lu[i] = this.data.convertKeysToNative[i] ? this.data.lookupMeta.getValueMeta(i).convertBinaryStringToNativeType((byte[])row[this.data.keynrs[i]]) : row[this.data.keynrs[i]];
        }
        if (this.data.keyTypes != null) {
            for (i = 0; i < this.data.lookupMeta.size(); ++i) {
                ValueMetaInterface inputValue = this.data.lookupMeta.getValueMeta(i);
                ValueMetaInterface lookupValue = this.data.keyTypes.getValueMeta(i);
                if (inputValue.getType() == lookupValue.getType()) continue;
                try {
                    lu[i] = lookupValue.convertDataCompatible(inputValue, lu[i]);
                    continue;
                }
                catch (KettleValueException e) {
                    throw new KettleStepException("Error converting data while looking up value", (Throwable)e);
                }
            }
        }
        Object[] add = null;
        if (this.data.hasLookupRows) {
            try {
                if (this.meta.getKeystream().length <= 0) {
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"StreamLookup.Log.GotRowWithoutKeys", (String[])new String[0]));
                }
                add = this.getFromCache(this.data.keyTypes, lu);
            }
            catch (Exception e) {
                throw new KettleStepException((Throwable)e);
            }
        }
        if (add == null) {
            add = this.data.nullIf;
        }
        return RowDataUtil.addRowData((Object[])row, (int)rowMeta.size(), (Object[])add);
    }

    private void addToCache(RowMetaInterface keyMeta, Object[] keyData, RowMetaInterface valueMeta, Object[] valueData) throws KettleValueException {
        if (this.meta.isMemoryPreservationActive()) {
            if (this.meta.isUsingSortedList()) {
                KeyValue keyValue = new KeyValue(keyData, valueData);
                int idx = Collections.binarySearch(this.data.list, keyValue, this.data.comparator);
                if (idx < 0) {
                    int index = -idx - 1;
                    this.data.list.add(index, keyValue);
                } else {
                    this.data.list.set(idx, keyValue);
                }
            } else if (this.meta.isUsingIntegerPair()) {
                if (!this.data.metadataVerifiedIntegerPair) {
                    this.data.metadataVerifiedIntegerPair = true;
                    if (keyMeta.size() != 1 || valueMeta.size() != 1 || !keyMeta.getValueMeta(0).isInteger() || !valueMeta.getValueMeta(0).isInteger()) {
                        throw new KettleValueException(BaseMessages.getString(PKG, (String)"StreamLookup.Exception.CanNotUseIntegerPairAlgorithm", (String[])new String[0]));
                    }
                }
                Long key = keyMeta.getInteger(keyData, 0);
                Long value = valueMeta.getInteger(valueData, 0);
                this.data.longIndex.put(key.longValue(), value);
            } else {
                if (this.data.hashIndex == null) {
                    this.data.hashIndex = new ByteArrayHashIndex(keyMeta);
                }
                this.data.hashIndex.put(RowMeta.extractData((RowMetaInterface)keyMeta, (Object[])keyData), RowMeta.extractData((RowMetaInterface)valueMeta, (Object[])valueData));
            }
        } else {
            this.data.look.put(new RowMetaAndData(keyMeta, keyData), valueData);
        }
    }

    private Object[] getFromCache(RowMetaInterface keyMeta, Object[] keyData) throws KettleValueException {
        if (this.meta.isMemoryPreservationActive()) {
            if (this.meta.isUsingSortedList()) {
                KeyValue keyValue = new KeyValue(keyData, null);
                int idx = Collections.binarySearch(this.data.list, keyValue, this.data.comparator);
                if (idx < 0) {
                    return null;
                }
                keyValue = this.data.list.get(idx);
                return keyValue.getValue();
            }
            if (this.meta.isUsingIntegerPair()) {
                Long value = this.data.longIndex.get(keyMeta.getInteger(keyData, 0).longValue());
                if (value == null) {
                    return null;
                }
                return new Object[]{value};
            }
            try {
                byte[] value = this.data.hashIndex.get(RowMeta.extractData((RowMetaInterface)keyMeta, (Object[])keyData));
                if (value == null) {
                    return null;
                }
                return RowMeta.getRow((RowMetaInterface)this.data.valueMeta, (byte[])value);
            }
            catch (Exception e) {
                this.logError("Oops", e);
                throw new RuntimeException(e);
            }
        }
        return this.data.look.get(new RowMetaAndData(keyMeta, keyData));
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        Object[] outputRow;
        this.meta = (StreamLookupMeta)smi;
        this.data = (StreamLookupData)sdi;
        if (this.data.readLookupValues) {
            this.data.readLookupValues = false;
            if (!this.readLookupValues()) {
                this.logError(BaseMessages.getString(PKG, (String)"StreamLookup.Log.UnableToReadDataFromLookupStream", (String[])new String[0]));
                this.setErrors(1L);
                this.stopAll();
                return false;
            }
            if (this.data.keyMeta != null) {
                for (ValueMetaInterface valueMeta : this.data.keyMeta.getValueMetaList()) {
                    valueMeta.setStorageType(0);
                }
            }
            if (this.data.valueMeta != null) {
                for (ValueMetaInterface valueMeta : this.data.valueMeta.getValueMetaList()) {
                    valueMeta.setStorageType(0);
                }
            }
            return true;
        }
        Object[] r = this.getRow();
        if (r == null) {
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"StreamLookup.Log.StoppedProcessingWithEmpty", (String[])new String[]{this.getLinesRead() + ""}));
            }
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.data.keynrs = new int[this.meta.getKeystream().length];
            this.data.lookupMeta = new RowMeta();
            this.data.convertKeysToNative = new boolean[this.meta.getKeystream().length];
            for (int i = 0; i < this.meta.getKeystream().length; ++i) {
                this.data.keynrs[i] = this.getInputRowMeta().indexOfValue(this.meta.getKeystream()[i]);
                if (this.data.keynrs[i] < 0) {
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"StreamLookup.Log.FieldNotFound", (String[])new String[]{this.meta.getKeystream()[i], "" + this.getInputRowMeta().getString(r)}));
                }
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"StreamLookup.Log.FieldInfo", (String[])new String[]{this.meta.getKeystream()[i], "" + this.data.keynrs[i]}));
                }
                this.data.lookupMeta.addValueMeta(this.getInputRowMeta().getValueMeta(this.data.keynrs[i]).clone());
                this.data.convertKeysToNative[i] = this.getInputRowMeta().getValueMeta(this.data.keynrs[i]).isStorageBinaryString();
            }
            this.data.outputRowMeta = this.getInputRowMeta().clone();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), new RowMetaInterface[]{this.data.infoMeta}, null, this);
            this.handleNullIf();
        }
        if ((outputRow = this.lookupValues(this.getInputRowMeta(), r)) == null) {
            this.setOutputDone();
            return false;
        }
        this.putRow(this.data.outputRowMeta, outputRow);
        if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"StreamLookup.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
        }
        return true;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (StreamLookupMeta)smi;
        this.data = (StreamLookupData)sdi;
        if (super.init(smi, sdi)) {
            this.data.readLookupValues = true;
            return true;
        }
        return false;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.data.look = null;
        this.data.list = null;
        this.data.hashIndex = null;
        this.data.longIndex = null;
        super.dispose(smi, sdi);
    }
}

