/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.streamlookup;

import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepIOMeta;
import org.pentaho.di.trans.step.StepIOMetaInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.errorhandling.Stream;
import org.pentaho.di.trans.step.errorhandling.StreamIcon;
import org.pentaho.di.trans.step.errorhandling.StreamInterface;
import org.pentaho.di.trans.steps.streamlookup.StreamLookup;
import org.pentaho.di.trans.steps.streamlookup.StreamLookupData;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamLookupMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = StreamLookupMeta.class;
    private String[] keystream;
    private String[] keylookup;
    private String[] value;
    private String[] valueName;
    private String[] valueDefault;
    private int[] valueDefaultType;
    private boolean inputSorted;
    private boolean memoryPreservationActive;
    private boolean usingSortedList;
    private boolean usingIntegerPair;

    public boolean isInputSorted() {
        return this.inputSorted;
    }

    public void setInputSorted(boolean inputSorted) {
        this.inputSorted = inputSorted;
    }

    public String[] getKeylookup() {
        return this.keylookup;
    }

    public void setKeylookup(String[] keylookup) {
        this.keylookup = keylookup;
    }

    public String[] getKeystream() {
        return this.keystream;
    }

    public void setKeystream(String[] keystream) {
        this.keystream = keystream;
    }

    public String[] getValue() {
        return this.value;
    }

    public void setValue(String[] value) {
        this.value = value;
    }

    public String[] getValueDefault() {
        return this.valueDefault;
    }

    public void setValueDefault(String[] valueDefault) {
        this.valueDefault = valueDefault;
    }

    public int[] getValueDefaultType() {
        return this.valueDefaultType;
    }

    public void setValueDefaultType(int[] valueDefaultType) {
        this.valueDefaultType = valueDefaultType;
    }

    public String[] getValueName() {
        return this.valueName;
    }

    public void setValueName(String[] valueName) {
        this.valueName = valueName;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode);
    }

    public void allocate(int nrkeys, int nrvalues) {
        this.keystream = new String[nrkeys];
        this.keylookup = new String[nrkeys];
        this.value = new String[nrvalues];
        this.valueName = new String[nrvalues];
        this.valueDefault = new String[nrvalues];
        this.valueDefaultType = new int[nrvalues];
    }

    @Override
    public Object clone() {
        StreamLookupMeta retval = (StreamLookupMeta)super.clone();
        return retval;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            int i;
            String lookupFromStepname = XMLHandler.getTagValue((Node)stepnode, (String)"from");
            StreamInterface infoStream = this.getStepIOMeta().getInfoStreams().get(0);
            infoStream.setSubject(lookupFromStepname);
            this.inputSorted = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"input_sorted"));
            this.memoryPreservationActive = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"preserve_memory"));
            this.usingSortedList = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"sorted_list"));
            this.usingIntegerPair = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"integer_pair"));
            Node lookup = XMLHandler.getSubNode((Node)stepnode, (String)"lookup");
            int nrkeys = XMLHandler.countNodes((Node)lookup, (String)"key");
            int nrvalues = XMLHandler.countNodes((Node)lookup, (String)"value");
            this.allocate(nrkeys, nrvalues);
            for (i = 0; i < nrkeys; ++i) {
                Node knode = XMLHandler.getSubNodeByNr((Node)lookup, (String)"key", (int)i);
                this.keystream[i] = XMLHandler.getTagValue((Node)knode, (String)"name");
                this.keylookup[i] = XMLHandler.getTagValue((Node)knode, (String)"field");
            }
            for (i = 0; i < nrvalues; ++i) {
                Node vnode = XMLHandler.getSubNodeByNr((Node)lookup, (String)"value", (int)i);
                this.value[i] = XMLHandler.getTagValue((Node)vnode, (String)"name");
                this.valueName[i] = XMLHandler.getTagValue((Node)vnode, (String)"rename");
                if (this.valueName[i] == null) {
                    this.valueName[i] = this.value[i];
                }
                this.valueDefault[i] = XMLHandler.getTagValue((Node)vnode, (String)"default");
                String dtype = XMLHandler.getTagValue((Node)vnode, (String)"type");
                this.valueDefaultType[i] = ValueMeta.getType((String)dtype);
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"StreamLookupMeta.Exception.UnableToLoadStepInfoFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void searchInfoAndTargetSteps(List<StepMeta> steps) {
        for (StreamInterface stream : this.getStepIOMeta().getInfoStreams()) {
            stream.setStepMeta(StepMeta.findStep(steps, (String)stream.getSubject()));
        }
    }

    @Override
    public void setDefault() {
        int i;
        this.keystream = null;
        this.value = null;
        this.valueDefault = null;
        this.memoryPreservationActive = true;
        this.usingSortedList = false;
        this.usingIntegerPair = false;
        int nrkeys = 0;
        int nrvalues = 0;
        this.allocate(nrkeys, nrvalues);
        for (i = 0; i < nrkeys; ++i) {
            this.keystream[i] = "key" + i;
            this.keylookup[i] = "keyfield" + i;
        }
        for (i = 0; i < nrvalues; ++i) {
            this.value[i] = "value" + i;
            this.valueName[i] = "valuename" + i;
            this.valueDefault[i] = "default" + i;
            this.valueDefaultType[i] = 1;
        }
    }

    @Override
    public void getFields(RowMetaInterface row, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        if (info != null && info.length == 1 && info[0] != null) {
            for (int i = 0; i < this.valueName.length; ++i) {
                ValueMetaInterface v = info[0].searchValueMeta(this.value[i]);
                if (v == null) {
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"StreamLookupMeta.Exception.ReturnValueCanNotBeFound", (String[])new String[]{this.value[i]}));
                }
                v.setName(this.valueName[i]);
                v.setOrigin(origin);
                v.setStorageType(0);
                row.addValueMeta(v);
            }
        } else {
            for (int i = 0; i < this.valueName.length; ++i) {
                ValueMeta v = new ValueMeta(this.valueName[i], this.valueDefaultType[i]);
                v.setOrigin(origin);
                row.addValueMeta((ValueMetaInterface)v);
            }
        }
    }

    @Override
    public String getXML() {
        int i;
        StringBuffer retval = new StringBuffer();
        StreamInterface infoStream = this.getStepIOMeta().getInfoStreams().get(0);
        retval.append("    " + XMLHandler.addTagValue((String)"from", (String)infoStream.getStepname()));
        retval.append("    " + XMLHandler.addTagValue((String)"input_sorted", (boolean)this.inputSorted));
        retval.append("    " + XMLHandler.addTagValue((String)"preserve_memory", (boolean)this.memoryPreservationActive));
        retval.append("    " + XMLHandler.addTagValue((String)"sorted_list", (boolean)this.usingSortedList));
        retval.append("    " + XMLHandler.addTagValue((String)"integer_pair", (boolean)this.usingIntegerPair));
        retval.append("    <lookup>" + Const.CR);
        for (i = 0; i < this.keystream.length; ++i) {
            retval.append("      <key>" + Const.CR);
            retval.append("        " + XMLHandler.addTagValue((String)"name", (String)this.keystream[i]));
            retval.append("        " + XMLHandler.addTagValue((String)"field", (String)this.keylookup[i]));
            retval.append("      </key>" + Const.CR);
        }
        for (i = 0; i < this.value.length; ++i) {
            retval.append("      <value>" + Const.CR);
            retval.append("        " + XMLHandler.addTagValue((String)"name", (String)this.value[i]));
            retval.append("        " + XMLHandler.addTagValue((String)"rename", (String)this.valueName[i]));
            retval.append("        " + XMLHandler.addTagValue((String)"default", (String)this.valueDefault[i]));
            retval.append("        " + XMLHandler.addTagValue((String)"type", (String)ValueMeta.getTypeDesc((int)this.valueDefaultType[i])));
            retval.append("      </value>" + Const.CR);
        }
        retval.append("    </lookup>" + Const.CR);
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, ObjectId id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            int i;
            String lookupFromStepname = rep.getStepAttributeString(id_step, "lookup_from_step");
            StreamInterface infoStream = this.getStepIOMeta().getInfoStreams().get(0);
            infoStream.setSubject(lookupFromStepname);
            this.inputSorted = rep.getStepAttributeBoolean(id_step, "input_sorted");
            this.memoryPreservationActive = rep.getStepAttributeBoolean(id_step, "preserve_memory");
            this.usingSortedList = rep.getStepAttributeBoolean(id_step, "sorted_list");
            this.usingIntegerPair = rep.getStepAttributeBoolean(id_step, "integer_pair");
            int nrkeys = rep.countNrStepAttributes(id_step, "lookup_key_name");
            int nrvalues = rep.countNrStepAttributes(id_step, "return_value_name");
            this.allocate(nrkeys, nrvalues);
            for (i = 0; i < nrkeys; ++i) {
                this.keystream[i] = rep.getStepAttributeString(id_step, i, "lookup_key_name");
                this.keylookup[i] = rep.getStepAttributeString(id_step, i, "lookup_key_field");
            }
            for (i = 0; i < nrvalues; ++i) {
                this.value[i] = rep.getStepAttributeString(id_step, i, "return_value_name");
                this.valueName[i] = rep.getStepAttributeString(id_step, i, "return_value_rename");
                this.valueDefault[i] = rep.getStepAttributeString(id_step, i, "return_value_default");
                this.valueDefaultType[i] = ValueMeta.getType((String)rep.getStepAttributeString(id_step, i, "return_value_type"));
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"StreamLookupMeta.Exception.UnexpecteErrorReadingStepInfoFromRepository", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            int i;
            StreamInterface infoStream = this.getStepIOMeta().getInfoStreams().get(0);
            rep.saveStepAttribute(id_transformation, id_step, "lookup_from_step", infoStream.getStepname());
            rep.saveStepAttribute(id_transformation, id_step, "input_sorted", this.inputSorted);
            rep.saveStepAttribute(id_transformation, id_step, "preserve_memory", this.memoryPreservationActive);
            rep.saveStepAttribute(id_transformation, id_step, "sorted_list", this.usingSortedList);
            rep.saveStepAttribute(id_transformation, id_step, "integer_pair", this.usingIntegerPair);
            for (i = 0; i < this.keystream.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "lookup_key_name", this.keystream[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "lookup_key_field", this.keylookup[i]);
            }
            for (i = 0; i < this.value.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "return_value_name", this.value[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "return_value_rename", this.valueName[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "return_value_default", this.valueDefault[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "return_value_type", ValueMeta.getTypeDesc((int)this.valueDefaultType[i]));
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"StreamLookupMeta.Exception.UnableToSaveStepInfoToRepository", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        int idx;
        int i;
        boolean error_found;
        String error_message;
        CheckResult cr;
        if (prev != null && prev.size() > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"StreamLookupMeta.CheckResult.StepReceivingFields", (String[])new String[]{prev.size() + ""}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            error_message = "";
            error_found = false;
            for (i = 0; i < this.keystream.length; ++i) {
                idx = prev.indexOfValue(this.keystream[i]);
                if (idx >= 0) continue;
                error_message = error_message + "\t\t" + this.keystream[i] + Const.CR;
                error_found = true;
            }
            if (error_found) {
                error_message = BaseMessages.getString(PKG, (String)"StreamLookupMeta.CheckResult.FieldsNotFound", (String[])new String[0]) + Const.CR + Const.CR + error_message;
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"StreamLookupMeta.CheckResult.AllFieldsFound", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"StreamLookupMeta.CheckResult.CouldNotFindFieldsFromPreviousSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (info != null && info.size() > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"StreamLookupMeta.CheckResult.StepReceivingLookupData", (String[])new String[]{info.size() + ""}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            error_message = "";
            error_found = false;
            for (i = 0; i < this.keylookup.length; ++i) {
                idx = info.indexOfValue(this.keylookup[i]);
                if (idx >= 0) continue;
                error_message = error_message + "\t\t" + this.keylookup[i] + Const.CR;
                error_found = true;
            }
            if (error_found) {
                error_message = BaseMessages.getString(PKG, (String)"StreamLookupMeta.CheckResult.FieldsNotFoundInLookupStream", (String[])new String[0]) + Const.CR + Const.CR + error_message;
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"StreamLookupMeta.CheckResult.AllFieldsFoundInTheLookupStream", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
            for (i = 0; i < this.value.length; ++i) {
                idx = info.indexOfValue(this.value[i]);
                if (idx >= 0) continue;
                error_message = error_message + "\t\t" + this.value[i] + Const.CR;
                error_found = true;
            }
            if (error_found) {
                error_message = BaseMessages.getString(PKG, (String)"StreamLookupMeta.CheckResult.FieldsNotFoundInLookupStream2", (String[])new String[0]) + Const.CR + Const.CR + error_message;
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"StreamLookupMeta.CheckResult.AllFieldsFoundInTheLookupStream2", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"StreamLookupMeta.CheckResult.FieldsNotFoundFromInLookupSep", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        StreamInterface infoStream = this.getStepIOMeta().getInfoStreams().get(0);
        if (infoStream.getStepMeta() == null) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"StreamLookupMeta.CheckResult.SourceStepNotSelected", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"StreamLookupMeta.CheckResult.SourceStepIsSelected", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            if (info != null) {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"StreamLookupMeta.CheckResult.SourceStepExist", (String[])new String[]{infoStream.getStepname()}), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"StreamLookupMeta.CheckResult.SourceStepDoesNotExist", (String[])new String[]{infoStream.getStepname()}), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        }
        if (input.length >= 2) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"StreamLookupMeta.CheckResult.StepReceivingInfoFromInputSteps", (String[])new String[]{input.length + ""}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"StreamLookupMeta.CheckResult.NeedAtLeast2InputStreams", (String[])new String[]{Const.CR, Const.CR}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new StreamLookup(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new StreamLookupData();
    }

    public boolean isMemoryPreservationActive() {
        return this.memoryPreservationActive;
    }

    public void setMemoryPreservationActive(boolean memoryPreservationActive) {
        this.memoryPreservationActive = memoryPreservationActive;
    }

    public boolean isUsingSortedList() {
        return this.usingSortedList;
    }

    public void setUsingSortedList(boolean usingSortedList) {
        this.usingSortedList = usingSortedList;
    }

    public boolean isUsingIntegerPair() {
        return this.usingIntegerPair;
    }

    public void setUsingIntegerPair(boolean usingIntegerPair) {
        this.usingIntegerPair = usingIntegerPair;
    }

    @Override
    public boolean excludeFromRowLayoutVerification() {
        return true;
    }

    @Override
    public StepIOMetaInterface getStepIOMeta() {
        if (this.ioMeta == null) {
            this.ioMeta = new StepIOMeta(true, true, false, false, false, false);
            Stream stream = new Stream(StreamInterface.StreamType.INFO, null, BaseMessages.getString(PKG, (String)"StreamLookupMeta.InfoStream.Description", (String[])new String[0]), StreamIcon.INFO, null);
            this.ioMeta.addStream(stream);
        }
        return this.ioMeta;
    }

    @Override
    public void resetStepIoMeta() {
    }
}

