/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.stringoperations;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.stringoperations.StringOperationsData;
import org.pentaho.di.trans.steps.stringoperations.StringOperationsMeta;

public class StringOperations
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = StringOperationsMeta.class;
    private StringOperationsMeta meta;
    private StringOperationsData data;

    public StringOperations(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private String processString(String string, int trimType, int lowerUpper, int padType, String padChar, int padLen, int iniCap, int maskHTML, int digits, int removeSpecialCharacters) {
        String rcode = string;
        if (!Const.isEmpty((String)rcode)) {
            switch (trimType) {
                case 2: {
                    rcode = Const.rtrim((String)rcode);
                    break;
                }
                case 1: {
                    rcode = Const.ltrim((String)rcode);
                    break;
                }
                case 3: {
                    rcode = Const.trim((String)rcode);
                    break;
                }
            }
        }
        if (!Const.isEmpty((String)rcode)) {
            switch (lowerUpper) {
                case 1: {
                    rcode = rcode.toLowerCase();
                    break;
                }
                case 2: {
                    rcode = rcode.toUpperCase();
                    break;
                }
            }
        }
        if (!Const.isEmpty((String)rcode)) {
            switch (padType) {
                case 1: {
                    rcode = Const.Lpad((String)rcode, (String)padChar, (int)padLen);
                    break;
                }
                case 2: {
                    rcode = Const.Rpad((String)rcode, (String)padChar, (int)padLen);
                    break;
                }
            }
        }
        if (!Const.isEmpty((String)rcode)) {
            switch (iniCap) {
                case 0: {
                    break;
                }
                case 1: {
                    rcode = Const.initCap((String)rcode);
                    break;
                }
            }
        }
        if (!Const.isEmpty((String)rcode)) {
            switch (maskHTML) {
                case 1: {
                    rcode = Const.escapeXml((String)rcode);
                    break;
                }
                case 2: {
                    rcode = Const.protectXMLCDATA((String)rcode);
                    break;
                }
                case 3: {
                    rcode = Const.unEscapeXml((String)rcode);
                    break;
                }
                case 5: {
                    rcode = Const.escapeHtml((String)rcode);
                    break;
                }
                case 6: {
                    rcode = Const.unEscapeHtml((String)rcode);
                    break;
                }
                case 4: {
                    rcode = Const.escapeSQL((String)rcode);
                    break;
                }
            }
        }
        if (!Const.isEmpty((String)rcode)) {
            switch (digits) {
                case 0: {
                    break;
                }
                case 1: {
                    rcode = Const.getDigitsOnly((String)rcode);
                    break;
                }
                case 2: {
                    rcode = Const.removeDigits((String)rcode);
                    break;
                }
            }
        }
        if (!Const.isEmpty((String)rcode)) {
            switch (removeSpecialCharacters) {
                case 0: {
                    break;
                }
                case 1: {
                    rcode = Const.removeCR((String)rcode);
                    break;
                }
                case 2: {
                    rcode = Const.removeLF((String)rcode);
                    break;
                }
                case 3: {
                    rcode = Const.removeCRLF((String)rcode);
                    break;
                }
                case 4: {
                    rcode = Const.removeTAB((String)rcode);
                    break;
                }
                case 5: {
                    rcode = rcode.replace(" ", "");
                    break;
                }
            }
        }
        return rcode;
    }

    private synchronized Object[] processRow(RowMetaInterface rowMeta, Object[] row) throws KettleException {
        Object[] RowData = new Object[this.data.outputRowMeta.size()];
        System.arraycopy(row, 0, RowData, 0, rowMeta.size());
        int j = 0;
        for (int i = 0; i < this.data.nrFieldsInStream; ++i) {
            if (this.data.inStreamNrs[i] < 0) continue;
            String value = this.getInputRowMeta().getString(row, this.data.inStreamNrs[i]);
            value = this.processString(value, this.data.trimOperators[i], this.data.lowerUpperOperators[i], this.data.padType[i], this.data.padChar[i], this.data.padLen[i], this.data.initCap[i], this.data.maskHTML[i], this.data.digits[i], this.data.removeSpecialCharacters[i]);
            if (Const.isEmpty((String)this.data.outStreamNrs[i])) {
                RowData[this.data.inStreamNrs[i]] = value;
                continue;
            }
            RowData[this.data.inputFieldsNr + j] = value;
            ++j;
        }
        return RowData;
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block18: {
            this.meta = (StringOperationsMeta)smi;
            this.data = (StringOperationsData)sdi;
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                int i;
                this.first = false;
                this.data.outputRowMeta = this.getInputRowMeta().clone();
                this.data.inputFieldsNr = this.data.outputRowMeta.size();
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
                this.data.nrFieldsInStream = this.meta.getFieldInStream().length;
                this.data.inStreamNrs = new int[this.data.nrFieldsInStream];
                for (i = 0; i < this.meta.getFieldInStream().length; ++i) {
                    this.data.inStreamNrs[i] = this.getInputRowMeta().indexOfValue(this.meta.getFieldInStream()[i]);
                    if (this.data.inStreamNrs[i] < 0) {
                        throw new KettleStepException(BaseMessages.getString(PKG, (String)"StringOperations.Exception.FieldRequired", (String[])new String[]{this.meta.getFieldInStream()[i]}));
                    }
                    if (this.getInputRowMeta().getValueMeta(this.data.inStreamNrs[i]).isString()) continue;
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"StringOperations.Exception.FieldTypeNotString", (String[])new String[]{this.meta.getFieldInStream()[i]}));
                }
                this.data.outStreamNrs = new String[this.data.nrFieldsInStream];
                for (i = 0; i < this.meta.getFieldInStream().length; ++i) {
                    this.data.outStreamNrs[i] = this.meta.getFieldOutStream()[i];
                }
                this.data.trimOperators = new int[this.data.nrFieldsInStream];
                for (i = 0; i < this.meta.getFieldInStream().length; ++i) {
                    this.data.trimOperators[i] = this.meta.getTrimType()[i];
                }
                this.data.lowerUpperOperators = new int[this.data.nrFieldsInStream];
                for (i = 0; i < this.meta.getFieldInStream().length; ++i) {
                    this.data.lowerUpperOperators[i] = this.meta.getLowerUpper()[i];
                }
                this.data.padType = new int[this.data.nrFieldsInStream];
                for (i = 0; i < this.meta.getFieldInStream().length; ++i) {
                    this.data.padType[i] = this.meta.getPaddingType()[i];
                }
                this.data.padChar = new String[this.data.nrFieldsInStream];
                for (i = 0; i < this.meta.getFieldInStream().length; ++i) {
                    this.data.padChar[i] = this.environmentSubstitute(this.meta.getPadChar()[i]);
                }
                this.data.padLen = new int[this.data.nrFieldsInStream];
                for (i = 0; i < this.meta.getFieldInStream().length; ++i) {
                    this.data.padLen[i] = Const.toInt((String)this.environmentSubstitute(this.meta.getPadLen()[i]), (int)0);
                }
                this.data.initCap = new int[this.data.nrFieldsInStream];
                for (i = 0; i < this.meta.getFieldInStream().length; ++i) {
                    this.data.initCap[i] = this.meta.getInitCap()[i];
                }
                this.data.maskHTML = new int[this.data.nrFieldsInStream];
                for (i = 0; i < this.meta.getFieldInStream().length; ++i) {
                    this.data.maskHTML[i] = this.meta.getMaskXML()[i];
                }
                this.data.digits = new int[this.data.nrFieldsInStream];
                for (i = 0; i < this.meta.getFieldInStream().length; ++i) {
                    this.data.digits[i] = this.meta.getDigits()[i];
                }
                this.data.removeSpecialCharacters = new int[this.data.nrFieldsInStream];
                for (i = 0; i < this.meta.getFieldInStream().length; ++i) {
                    this.data.removeSpecialCharacters[i] = this.meta.getRemoveSpecialCharacters()[i];
                }
            }
            try {
                Object[] output = this.processRow(this.getInputRowMeta(), r);
                this.putRow(this.data.outputRowMeta, output);
                if (this.checkFeedback(this.getLinesRead()) && this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"StringOperations.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
                }
            }
            catch (KettleException e) {
                boolean sendToErrorRow = false;
                String errorMessage = null;
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"StringOperations.Log.ErrorInStep", (String[])new String[]{e.getMessage()}));
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block18;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, null, "StringOperations001");
            }
        }
        return true;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        boolean rCode = true;
        this.meta = (StringOperationsMeta)smi;
        this.data = (StringOperationsData)sdi;
        if (super.init(smi, sdi)) {
            return rCode;
        }
        return false;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (StringOperationsMeta)smi;
        this.data = (StringOperationsData)sdi;
        super.dispose(smi, sdi);
    }
}

