/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.syslog;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.entries.syslog.SyslogDefs;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.syslog.SyslogMessageData;
import org.pentaho.di.trans.steps.syslog.SyslogMessageMeta;
import org.productivity.java.syslog4j.Syslog;

public class SyslogMessage
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = SyslogMessageMeta.class;
    private SyslogMessageMeta meta;
    private SyslogMessageData data;

    public SyslogMessage(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block9: {
            this.meta = (SyslogMessageMeta)smi;
            this.data = (SyslogMessageData)sdi;
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                this.first = false;
                if (Const.isEmpty((String)this.meta.getMessageFieldName())) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"SyslogMessage.Error.MessageFieldMissing", (String[])new String[0]));
                }
                this.data.indexOfMessageFieldName = this.getInputRowMeta().indexOfValue(this.meta.getMessageFieldName());
                if (this.data.indexOfMessageFieldName < 0) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"SyslogMessage.Exception.CouldnotFindField", (String[])new String[]{this.meta.getMessageFieldName()}));
                }
            }
            try {
                String message = this.getInputRowMeta().getString(r, this.data.indexOfMessageFieldName);
                if (Const.isEmpty((String)message)) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"SyslogMessage.Error.MessageEmpty", (String[])new String[0]));
                }
                SyslogDefs.sendMessage(this.data.syslog, SyslogDefs.getPriority(this.meta.getPriority()), message, this.meta.isAddTimestamp(), this.data.datePattern, this.meta.isAddHostName());
                this.putRow(this.getInputRowMeta(), r);
                if (this.checkFeedback(this.getLinesRead()) && this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"SyslogMessage.LineNumber", (Object[])new Object[]{this.getLinesRead()}));
                }
            }
            catch (Exception e) {
                boolean sendToErrorRow = false;
                String errorMessage = null;
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"SyslogMessage.ErrorInStepRunning", (String[])new String[0]) + e.getMessage());
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block9;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, null, "SyslogMessage001");
            }
        }
        return true;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (SyslogMessageMeta)smi;
        this.data = (SyslogMessageData)sdi;
        if (super.init(smi, sdi)) {
            String servername = this.environmentSubstitute(this.meta.getServerName());
            if (Const.isEmpty((String)servername)) {
                this.logError(BaseMessages.getString(PKG, (String)"SyslogMessage.MissingServerName", (String[])new String[0]));
            }
            if (Const.isEmpty((String)this.meta.getMessageFieldName())) {
                this.logError(BaseMessages.getString(PKG, (String)"SyslogMessage.Error.MessageFieldMissing", (String[])new String[0]));
                return false;
            }
            int nrPort = Const.toInt((String)this.environmentSubstitute(this.meta.getPort()), (int)514);
            if (this.meta.isAddTimestamp()) {
                this.data.datePattern = this.environmentSubstitute(this.meta.getDatePattern());
                if (Const.isEmpty((String)this.data.datePattern)) {
                    this.logError(BaseMessages.getString(PKG, (String)"SyslogMessage.DatePatternEmpty", (String[])new String[0]));
                    return false;
                }
            }
            try {
                this.data.syslog = Syslog.getInstance((String)"udp");
                this.data.syslog.getConfig().setHost(servername);
                this.data.syslog.getConfig().setPort(nrPort);
                this.data.syslog.getConfig().setFacility(this.meta.getFacility());
                this.data.syslog.getConfig().setSendLocalName(false);
                this.data.syslog.getConfig().setSendLocalTimestamp(false);
            }
            catch (Exception ex) {
                this.logError(BaseMessages.getString(PKG, (String)"SyslogMessage.UnknownHost", (String[])new String[]{servername, ex.getMessage()}));
                this.logError(Const.getStackTracker((Throwable)ex));
                return false;
            }
            return true;
        }
        return false;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (SyslogMessageMeta)smi;
        this.data = (SyslogMessageData)sdi;
        if (this.data.syslog != null) {
            this.data.syslog.shutdown();
        }
        super.dispose(smi, sdi);
    }
}

