/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.terafast;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.AbstractStep;
import org.pentaho.di.core.util.ConfigurableStreamLogger;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.terafast.FastloadControlBuilder;
import org.pentaho.di.trans.steps.terafast.TeraFastMeta;

public class TeraFast
extends AbstractStep
implements StepInterface {
    private static Class<?> PKG = TeraFastMeta.class;
    private TeraFastMeta meta;
    private Process process;
    private OutputStream fastload;
    private OutputStream dataFile;
    private List<Integer> columnSortOrder;
    private RowMetaInterface tableRowMeta;

    public TeraFast(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public String createCommandLine() throws KettleException {
        FileObject fileObject;
        if (StringUtils.isBlank((String)((String)this.meta.getFastloadPath().getValue()))) {
            throw new KettleException("Fastload path not set");
        }
        StringBuilder builder = new StringBuilder();
        try {
            fileObject = KettleVFS.getFileObject((String)this.environmentSubstitute((String)this.meta.getFastloadPath().getValue()));
            String fastloadExec = KettleVFS.getFilename((FileObject)fileObject);
            builder.append(fastloadExec);
        }
        catch (Exception e) {
            throw new KettleException("Error retrieving fastload application string", (Throwable)e);
        }
        if (StringUtils.isNotBlank((String)((String)this.meta.getLogFile().getValue()))) {
            try {
                fileObject = KettleVFS.getFileObject((String)this.environmentSubstitute((String)this.meta.getLogFile().getValue()));
                builder.append(" -e ");
                builder.append("\"" + KettleVFS.getFilename((FileObject)fileObject) + "\"");
            }
            catch (Exception e) {
                throw new KettleException("Error retrieving logfile string", (Throwable)e);
            }
        }
        return builder.toString();
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (TeraFastMeta)smi;
        return super.init(smi, sdi);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (TeraFastMeta)smi;
        Object[] row = this.getRow();
        if (row == null) {
            IOUtils.closeQuietly((OutputStream)this.dataFile);
            this.execute();
            this.setOutputDone();
            try {
                this.logBasic("TeraFast.Log.WatingForFastload");
                int exitVal = this.process.waitFor();
                if (exitVal != 0) {
                    this.setErrors(1L);
                }
                this.logBasic(BaseMessages.getString(PKG, (String)"TeraFast.Log.ExitValueFastloadPath", (String[])new String[]{"" + exitVal}));
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"TeraFast.Log.ErrorInStep", (String[])new String[0]), e);
                this.setDefaultError();
                this.stopAll();
            }
            return false;
        }
        if (this.first) {
            this.first = false;
            try {
                File tempDataFile = new File(this.resolveFileName((String)this.meta.getDataFile().getValue()));
                this.dataFile = FileUtils.openOutputStream((File)tempDataFile);
            }
            catch (IOException e) {
                throw new KettleException("Cannot open data file [path=" + this.dataFile + "]", (Throwable)e);
            }
            this.tableRowMeta = this.meta.getRequiredFields(this.getTransMeta());
            RowMetaInterface streamRowMeta = this.getTransMeta().getPrevStepFields(this.getStepMeta());
            this.columnSortOrder = new ArrayList<Integer>(this.tableRowMeta.size());
            for (int i = 0; i < this.tableRowMeta.size(); ++i) {
                ValueMetaInterface column = this.tableRowMeta.getValueMeta(i);
                int tableIndex = ((List)this.meta.getTableFieldList().getValue()).indexOf(column.getName());
                String streamField = (String)((List)this.meta.getStreamFieldList().getValue()).get(tableIndex);
                this.columnSortOrder.add(streamRowMeta.indexOfValue(streamField));
            }
        }
        this.writeToDataFile(row);
        return true;
    }

    private void writeToDataFile(Object[] row) throws KettleException {
        try {
            int tableCol = 0;
            for (Integer index : this.columnSortOrder) {
                String nullString;
                int length = 0;
                length = this.tableRowMeta.getValueMeta(tableCol).getType() == 3 ? "YYYYMMDD".length() : this.tableRowMeta.getValueMeta(tableCol).getLength();
                byte[] rowData = new byte[length];
                System.arraycopy(row[index], 0, rowData, 0, length);
                if (((byte[])row[index]).length < rowData.length) {
                    Arrays.fill(rowData, ((byte[])row[index]).length, rowData.length, (byte)32);
                }
                if ("?".equals(nullString = new String(rowData).trim())) {
                    rowData = String.format("%1$#" + rowData.length + "s", "?").getBytes();
                }
                this.dataFile.write(rowData);
                this.dataFile.write("|".getBytes());
                ++tableCol;
            }
            this.dataFile.write(SystemUtils.LINE_SEPARATOR.getBytes());
        }
        catch (IOException e) {
            throw new KettleException("Cannot write data file [path=" + this.dataFile + "]", (Throwable)e);
        }
    }

    public void execute() throws KettleException {
        if (((Boolean)this.meta.getTruncateTable().getValue()).booleanValue()) {
            Database db = new Database((LoggingObjectInterface)this, this.meta.getDbMeta());
            db.connect();
            db.truncateTable((String)this.meta.getTargetTable().getValue());
            db.commit();
            db.disconnect();
        }
        this.startFastLoad();
        if (((Boolean)this.meta.getUseControlFile().getValue()).booleanValue()) {
            this.invokeLoadingControlFile();
        } else {
            this.invokeLoadingCommand();
        }
    }

    private void startFastLoad() throws KettleException {
        String command = this.createCommandLine();
        this.logBasic("About to execute: " + command);
        try {
            this.process = Runtime.getRuntime().exec(command);
            new Thread(new ConfigurableStreamLogger(this.getLogChannel(), this.process.getErrorStream(), LogLevel.ERROR, "ERROR")).start();
            new Thread(new ConfigurableStreamLogger(this.getLogChannel(), this.process.getInputStream(), LogLevel.DETAILED, "OUTPUT")).start();
            this.fastload = this.process.getOutputStream();
        }
        catch (Exception e) {
            throw new KettleException("Error while setup: " + command, (Throwable)e);
        }
    }

    private void invokeLoadingControlFile() throws KettleException {
        String controlContent;
        FileInputStream control;
        File controlFile = null;
        try {
            controlFile = new File(this.resolveFileName((String)this.meta.getControlFile().getValue()));
            control = FileUtils.openInputStream((File)controlFile);
            controlContent = this.environmentSubstitute(FileUtils.readFileToString((File)controlFile));
        }
        catch (IOException e) {
            throw new KettleException("Cannot open control file [path=" + controlFile + "]", (Throwable)e);
        }
        try {
            try {
                IOUtils.write((String)controlContent, (OutputStream)this.fastload);
                this.fastload.flush();
            }
            catch (IOException e) {
                throw new KettleException("Cannot pipe content of control file to fastload [path=" + controlFile + "]", (Throwable)e);
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            IOUtils.closeQuietly((InputStream)control);
            IOUtils.closeQuietly((OutputStream)this.fastload);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)control);
        IOUtils.closeQuietly((OutputStream)this.fastload);
    }

    private void invokeLoadingCommand() throws KettleException {
        FastloadControlBuilder builder = new FastloadControlBuilder();
        builder.setSessions((Integer)this.meta.getSessions().getValue());
        builder.setErrorLimit((Integer)this.meta.getErrorLimit().getValue());
        builder.logon(this.meta.getDbMeta().getHostname(), this.meta.getDbMeta().getUsername(), this.meta.getDbMeta().getPassword());
        builder.setRecordFormat("VARTEXT \"|\"");
        try {
            builder.define(this.meta.getRequiredFields(this.getTransMeta()), this.resolveFileName((String)this.meta.getDataFile().getValue()));
        }
        catch (Exception ex) {
            throw new KettleException("Error defining data file!", (Throwable)ex);
        }
        builder.show();
        builder.beginLoading((String)this.meta.getTargetTable().getValue());
        builder.insert(this.meta.getRequiredFields(this.getTransMeta()), (String)this.meta.getTargetTable().getValue());
        builder.endLoading();
        builder.logoff();
        String control = builder.toString();
        try {
            try {
                IOUtils.write((String)control, (OutputStream)this.fastload);
                this.fastload.flush();
            }
            catch (IOException e) {
                throw new KettleException("Error while execution control command [controlCommand=" + control + "]", (Throwable)e);
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            IOUtils.closeQuietly((OutputStream)this.fastload);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)this.fastload);
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (TeraFastMeta)smi;
        try {
            IOUtils.write((String)new FastloadControlBuilder().endLoading().toString(), (OutputStream)this.fastload);
        }
        catch (IOException e) {
            this.logError("Unexpected error encountered while issuing END LOADING", e);
        }
        IOUtils.closeQuietly((OutputStream)this.dataFile);
        IOUtils.closeQuietly((OutputStream)this.fastload);
        try {
            int exitValue = this.process.waitFor();
            this.logDetailed("Exit value for the fastload process was : " + exitValue);
            if (exitValue != 0) {
                this.setErrors(1L);
            }
        }
        catch (InterruptedException e) {
            this.setErrors(1L);
            this.logError("Unexpected error encountered while finishing the fastload process", e);
        }
        super.dispose(smi, sdi);
    }

    private String resolveFileName(String fileName) throws KettleException {
        FileObject fileObject = KettleVFS.getFileObject((String)this.environmentSubstitute(fileName));
        return KettleVFS.getFilename((FileObject)fileObject);
    }
}

