/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.terafast;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.util.AbstractStepMeta;
import org.pentaho.di.core.util.BooleanPluginProperty;
import org.pentaho.di.core.util.GenericStepData;
import org.pentaho.di.core.util.IntegerPluginProperty;
import org.pentaho.di.core.util.PluginMessages;
import org.pentaho.di.core.util.StringListPluginProperty;
import org.pentaho.di.core.util.StringPluginProperty;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.terafast.TeraFast;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TeraFastMeta
extends AbstractStepMeta {
    public static final PluginMessages MESSAGES = PluginMessages.getMessages(TeraFastMeta.class);
    public static final String DEFAULT_FASTLOAD_PATH = "/usr/bin/fastload";
    public static final String DEFAULT_DATA_FILE = "${internal.step.copyNr}.dat";
    public static final String DEFAULT_TARGET_TABLE = "${TARGET_TABLE}_${RUN_ID}";
    public static final int DEFAULT_SESSIONS = 2;
    public static final boolean DEFAULT_TRUNCATETABLE = true;
    public static final boolean DEFAULT_VARIABLE_SUBSTITUTION = true;
    public static final int DEFAULT_ERROR_LIMIT = 25;
    private static final String FASTLOADPATH = "fastload_path";
    private static final String CONTROLFILE = "controlfile_path";
    private static final String DATAFILE = "datafile_path";
    private static final String LOGFILE = "logfile_path";
    private static final String SESSIONS = "sessions";
    private static final String ERRORLIMIT = "error_limit";
    private static final String USECONTROLFILE = "use_control_file";
    private static final String TARGETTABLE = "target_table";
    private static final String TRUNCATETABLE = "truncate_table";
    private static final String TABLE_FIELD_LIST = "table_field_list";
    private static final String STREAM_FIELD_LIST = "stream_field_list";
    private static final String VARIABLE_SUBSTITUTION = "variable_substitution";
    private StringPluginProperty fastloadPath = this.getPropertyFactory().createString("fastload_path");
    private StringPluginProperty controlFile = this.getPropertyFactory().createString("controlfile_path");
    private StringPluginProperty dataFile = this.getPropertyFactory().createString("datafile_path");
    private StringPluginProperty logFile = this.getPropertyFactory().createString("logfile_path");
    private IntegerPluginProperty sessions = this.getPropertyFactory().createInteger("sessions");
    private IntegerPluginProperty errorLimit = this.getPropertyFactory().createInteger("error_limit");
    private BooleanPluginProperty useControlFile;
    private BooleanPluginProperty variableSubstitution;
    private BooleanPluginProperty truncateTable;
    private StringPluginProperty targetTable = this.getPropertyFactory().createString("target_table");
    private StringListPluginProperty tableFieldList;
    private StringListPluginProperty streamFieldList;

    public TeraFastMeta() {
        this.useControlFile = this.getPropertyFactory().createBoolean(USECONTROLFILE);
        this.truncateTable = this.getPropertyFactory().createBoolean(TRUNCATETABLE);
        this.tableFieldList = this.getPropertyFactory().createStringList(TABLE_FIELD_LIST);
        this.streamFieldList = this.getPropertyFactory().createStringList(STREAM_FIELD_LIST);
        this.variableSubstitution = this.getPropertyFactory().createBoolean(VARIABLE_SUBSTITUTION);
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transmeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        try {
            RowMetaInterface tableFields = this.getRequiredFields(transmeta);
            CheckResult checkResult = new CheckResult(1, MESSAGES.getString("TeraFastMeta.Message.ConnectionEstablished"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)checkResult);
            checkResult = new CheckResult(1, MESSAGES.getString("TeraFastMeta.Message.TableExists"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)checkResult);
            boolean error = false;
            for (String field : (List)this.tableFieldList.getValue()) {
                if (tableFields.searchValueMeta(field) != null) continue;
                error = true;
                checkResult = new CheckResult(4, MESSAGES.getString("TeraFastMeta.Exception.TableFieldNotFound"), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)checkResult);
            }
            if (!error) {
                checkResult = new CheckResult(1, MESSAGES.getString("TeraFastMeta.Message.AllTableFieldsFound"), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)checkResult);
            }
            if (prev != null && prev.size() > 0) {
                checkResult = new CheckResult(1, MESSAGES.getString("TeraFastMeta.Message.StepInputDataFound"), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)checkResult);
                error = false;
                for (String field : (List)this.streamFieldList.getValue()) {
                    if (prev.searchValueMeta(field) != null) continue;
                    error = true;
                    checkResult = new CheckResult(4, MESSAGES.getString("TeraFastMeta.Exception.StreamFieldNotFound"), (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)checkResult);
                }
                if (!error) {
                    checkResult = new CheckResult(1, MESSAGES.getString("TeraFastMeta.Message.AllStreamFieldsFound"), (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)checkResult);
                }
            }
        }
        catch (KettleDatabaseException e) {
            CheckResult checkResult = new CheckResult(4, MESSAGES.getString("TeraFastMeta.Exception.ConnectionFailed"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)checkResult);
        }
        catch (KettleException e) {
            CheckResult checkResult = new CheckResult(4, e.getMessage(), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)checkResult);
        }
    }

    public String getQuotedSchemaTableName(VariableSpace space) throws KettleException {
        String realTableName = space.environmentSubstitute((String)this.targetTable.getValue());
        if (StringUtils.isEmpty((String)realTableName)) {
            throw new KettleException(MESSAGES.getString("TeraFastMeta.Exception.TableNotSpecified"));
        }
        return this.getDbMeta().getQuotedSchemaTableCombination("", realTableName);
    }

    public Database connectToDatabase() throws KettleException {
        if (this.getDbMeta() != null) {
            Database db = new Database(loggingObject, this.getDbMeta());
            db.connect();
            return db;
        }
        throw new KettleException(MESSAGES.getString("TeraFastMeta.Exception.ConnectionNotDefined"));
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans disp) {
        return new TeraFast(stepMeta, stepDataInterface, cnr, transMeta, disp);
    }

    @Override
    public StepDataInterface getStepData() {
        return new GenericStepData();
    }

    @Override
    public void setDefault() {
        this.fastloadPath.setValue(DEFAULT_FASTLOAD_PATH);
        this.dataFile.setValue(DEFAULT_DATA_FILE);
        this.sessions.setValue(2);
        this.errorLimit.setValue(25);
        this.truncateTable.setValue(true);
        this.variableSubstitution.setValue(true);
        this.targetTable.setValue(DEFAULT_TARGET_TABLE);
        this.useControlFile.setValue(true);
    }

    @Override
    public void getFields(RowMetaInterface inputRowMeta, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
    }

    @Override
    public RowMetaInterface getRequiredFields(VariableSpace space) throws KettleException {
        if (!((Boolean)this.useControlFile.getValue()).booleanValue()) {
            Database database = this.connectToDatabase();
            database.shareVariablesWith(space);
            String schemaTable = this.getQuotedSchemaTableName(space);
            RowMetaInterface fields = database.getTableFields(schemaTable);
            database.disconnect();
            if (fields == null) {
                throw new KettleException(MESSAGES.getString("TeraFastMeta.Exception.TableNotFound"));
            }
            return fields;
        }
        return null;
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    public StringPluginProperty getFastloadPath() {
        return this.fastloadPath;
    }

    public void setFastloadPath(StringPluginProperty fastloadPath) {
        this.fastloadPath = fastloadPath;
    }

    public StringPluginProperty getControlFile() {
        return this.controlFile;
    }

    public void setControlFile(StringPluginProperty controlFile) {
        this.controlFile = controlFile;
    }

    public StringPluginProperty getDataFile() {
        return this.dataFile;
    }

    public void setDataFile(StringPluginProperty dataFile) {
        this.dataFile = dataFile;
    }

    public StringPluginProperty getLogFile() {
        return this.logFile;
    }

    public void setLogFile(StringPluginProperty logFile) {
        this.logFile = logFile;
    }

    public IntegerPluginProperty getSessions() {
        return this.sessions;
    }

    public void setSessions(IntegerPluginProperty sessions) {
        this.sessions = sessions;
    }

    public IntegerPluginProperty getErrorLimit() {
        return this.errorLimit;
    }

    public void setErrorLimit(IntegerPluginProperty errorLimit) {
        this.errorLimit = errorLimit;
    }

    public BooleanPluginProperty getUseControlFile() {
        return this.useControlFile;
    }

    public void setUseControlFile(BooleanPluginProperty useControlFile) {
        this.useControlFile = useControlFile;
    }

    public StringPluginProperty getTargetTable() {
        return this.targetTable;
    }

    public void setTargetTable(StringPluginProperty targetTable) {
        this.targetTable = targetTable;
    }

    public BooleanPluginProperty getTruncateTable() {
        return this.truncateTable;
    }

    public void setTruncateTable(BooleanPluginProperty truncateTable) {
        this.truncateTable = truncateTable;
    }

    public StringListPluginProperty getTableFieldList() {
        return this.tableFieldList;
    }

    public void setTableFieldList(StringListPluginProperty tableFieldList) {
        this.tableFieldList = tableFieldList;
    }

    public StringListPluginProperty getStreamFieldList() {
        return this.streamFieldList;
    }

    public void setStreamFieldList(StringListPluginProperty streamFieldList) {
        this.streamFieldList = streamFieldList;
    }

    public BooleanPluginProperty getVariableSubstitution() {
        return this.variableSubstitution;
    }

    public void setVariableSubstitution(BooleanPluginProperty variableSubstitution) {
        this.variableSubstitution = variableSubstitution;
    }
}

