/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.textfileinput;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.fileinput.FileInputList;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.EnvUtil;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.textfileinput.InputFileMetaInterface;
import org.pentaho.di.trans.steps.textfileinput.TextFileFilter;
import org.pentaho.di.trans.steps.textfileinput.TextFileInput;
import org.pentaho.di.trans.steps.textfileinput.TextFileInputData;
import org.pentaho.di.trans.steps.textfileinput.TextFileInputField;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextFileInputMeta
extends BaseStepMeta
implements StepMetaInterface,
InputFileMetaInterface {
    private static Class<?> PKG = TextFileInputMeta.class;
    public static final String[] RequiredFilesDesc = new String[]{BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0])};
    public static final String[] RequiredFilesCode = new String[]{"N", "Y"};
    private static final String NO = "N";
    private static final String YES = "Y";
    private static final String STRING_BASE64_PREFIX = "Base64: ";
    public static final int FILE_FORMAT_DOS = 0;
    public static final int FILE_FORMAT_UNIX = 1;
    public static final int FILE_FORMAT_MIXED = 2;
    public static final int FILE_TYPE_CSV = 0;
    public static final int FILE_TYPE_FIXED = 1;
    private String[] fileName;
    private String[] fileMask;
    private String[] excludeFileMask;
    private String[] fileRequired;
    private String fileType;
    private String separator;
    private String enclosure;
    private String escapeCharacter;
    private boolean breakInEnclosureAllowed;
    private boolean header;
    private int nrHeaderLines;
    private boolean footer;
    private int nrFooterLines;
    private boolean lineWrapped;
    private int nrWraps;
    private boolean layoutPaged;
    private int nrLinesDocHeader;
    private int nrLinesPerPage;
    private String fileCompression;
    private boolean noEmptyLines;
    private boolean includeFilename;
    private String filenameField;
    private boolean includeRowNumber;
    private boolean rowNumberByFile;
    private String rowNumberField;
    private String fileFormat;
    private long rowLimit;
    private TextFileInputField[] inputFields;
    private String[] includeSubFolders;
    private TextFileFilter[] filter;
    private String encoding;
    private boolean errorIgnored;
    private String errorCountField;
    private String errorFieldsField;
    private String errorTextField;
    private String warningFilesDestinationDirectory;
    private String warningFilesExtension;
    private String errorFilesDestinationDirectory;
    private String errorFilesExtension;
    private String lineNumberFilesDestinationDirectory;
    private String lineNumberFilesExtension;
    private boolean dateFormatLenient;
    private Locale dateFormatLocale;
    private boolean errorLineSkipped;
    private boolean acceptingFilenames;
    private boolean passingThruFields;
    private String acceptingField;
    private String acceptingStepName;
    private StepMeta acceptingStep;
    private boolean isaddresult;
    private String shortFileFieldName;
    private String pathFieldName;
    private String hiddenFieldName;
    private String lastModificationTimeFieldName;
    private String uriNameFieldName;
    private String rootUriNameFieldName;
    private String extensionFieldName;
    private String sizeFieldName;
    private boolean skipBadFiles;
    private String fileErrorField;
    private String fileErrorMessageField;

    public String getShortFileNameField() {
        return this.shortFileFieldName;
    }

    public void setShortFileNameField(String field) {
        this.shortFileFieldName = field;
    }

    public String getPathField() {
        return this.pathFieldName;
    }

    public void setPathField(String field) {
        this.pathFieldName = field;
    }

    public String isHiddenField() {
        return this.hiddenFieldName;
    }

    public void setIsHiddenField(String field) {
        this.hiddenFieldName = field;
    }

    public String getLastModificationDateField() {
        return this.lastModificationTimeFieldName;
    }

    public void setLastModificationDateField(String field) {
        this.lastModificationTimeFieldName = field;
    }

    public String getUriField() {
        return this.uriNameFieldName;
    }

    public void setUriField(String field) {
        this.uriNameFieldName = field;
    }

    public String getRootUriField() {
        return this.rootUriNameFieldName;
    }

    public void setRootUriField(String field) {
        this.rootUriNameFieldName = field;
    }

    public String getExtensionField() {
        return this.extensionFieldName;
    }

    public void setExtensionField(String field) {
        this.extensionFieldName = field;
    }

    public String getSizeField() {
        return this.sizeFieldName;
    }

    public void setSizeField(String field) {
        this.sizeFieldName = field;
    }

    public boolean isSkipBadFiles() {
        return this.skipBadFiles;
    }

    public void setSkipBadFiles(boolean value) {
        this.skipBadFiles = value;
    }

    public String getFileErrorField() {
        return this.fileErrorField;
    }

    public void setFileErrorField(String field) {
        this.fileErrorField = field;
    }

    public String getFileErrorMessageField() {
        return this.fileErrorMessageField;
    }

    public void setFileErrorMessageField(String field) {
        this.fileErrorMessageField = field;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public TextFileInputField[] getInputFields() {
        return this.inputFields;
    }

    public void setInputFields(TextFileInputField[] inputFields) {
        this.inputFields = inputFields;
    }

    @Override
    public String getEnclosure() {
        return StringUtil.substituteHex((String)this.enclosure);
    }

    public void setEnclosure(String enclosure) {
        this.enclosure = enclosure;
    }

    public boolean isBreakInEnclosureAllowed() {
        return this.breakInEnclosureAllowed;
    }

    public void setBreakInEnclosureAllowed(boolean breakInEnclosureAllowed) {
        this.breakInEnclosureAllowed = breakInEnclosureAllowed;
    }

    public String[] getExludeFileMask() {
        return this.excludeFileMask;
    }

    public void setExcludeFileMask(String[] excludeFileMask) {
        this.excludeFileMask = excludeFileMask;
    }

    public String getFileFormat() {
        return this.fileFormat;
    }

    public void setFileFormat(String fileFormat) {
        this.fileFormat = fileFormat;
    }

    public String[] getFileMask() {
        return this.fileMask;
    }

    public String[] getFileRequired() {
        return this.fileRequired;
    }

    public void setFileMask(String[] fileMask) {
        this.fileMask = fileMask;
    }

    public void setFileRequired(String[] fileRequiredin) {
        for (int i = 0; i < fileRequiredin.length; ++i) {
            this.fileRequired[i] = this.getRequiredFilesCode(fileRequiredin[i]);
        }
    }

    public String[] getIncludeSubFolders() {
        return this.includeSubFolders;
    }

    public void setIncludeSubFolders(String[] includeSubFoldersin) {
        for (int i = 0; i < includeSubFoldersin.length; ++i) {
            this.includeSubFolders[i] = this.getRequiredFilesCode(includeSubFoldersin[i]);
        }
    }

    public String getRequiredFilesCode(String tt) {
        if (tt == null) {
            return RequiredFilesCode[0];
        }
        if (tt.equals(RequiredFilesDesc[1])) {
            return RequiredFilesCode[1];
        }
        return RequiredFilesCode[0];
    }

    public String[] getFileName() {
        return this.fileName;
    }

    public void setFileName(String[] fileName) {
        this.fileName = fileName;
    }

    public String getFilenameField() {
        return this.filenameField;
    }

    public void setFilenameField(String filenameField) {
        this.filenameField = filenameField;
    }

    @Override
    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public TextFileFilter[] getFilter() {
        return this.filter;
    }

    public void setFilter(TextFileFilter[] filter) {
        this.filter = filter;
    }

    public boolean hasFooter() {
        return this.footer;
    }

    public void setFooter(boolean footer) {
        this.footer = footer;
    }

    @Override
    public boolean hasHeader() {
        return this.header;
    }

    public void setHeader(boolean header) {
        this.header = header;
    }

    @Override
    public boolean includeFilename() {
        return this.includeFilename;
    }

    public void setIncludeFilename(boolean includeFilename) {
        this.includeFilename = includeFilename;
    }

    @Override
    public boolean includeRowNumber() {
        return this.includeRowNumber;
    }

    public void setIncludeRowNumber(boolean includeRowNumber) {
        this.includeRowNumber = includeRowNumber;
    }

    public boolean isRowNumberByFile() {
        return this.rowNumberByFile;
    }

    public void setRowNumberByFile(boolean rowNumberByFile) {
        this.rowNumberByFile = rowNumberByFile;
    }

    public boolean noEmptyLines() {
        return this.noEmptyLines;
    }

    public void setNoEmptyLines(boolean noEmptyLines) {
        this.noEmptyLines = noEmptyLines;
    }

    public long getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(long rowLimit) {
        this.rowLimit = rowLimit;
    }

    public String getRowNumberField() {
        return this.rowNumberField;
    }

    public void setRowNumberField(String rowNumberField) {
        this.rowNumberField = rowNumberField;
    }

    @Override
    public String getSeparator() {
        return StringUtil.substituteHex((String)this.separator);
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public String getFileCompression() {
        return this.fileCompression;
    }

    public void setFileCompression(String fileCompression) {
        this.fileCompression = fileCompression;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        int i;
        TextFileInputMeta retval = (TextFileInputMeta)super.clone();
        int nrfiles = this.fileName.length;
        int nrfields = this.inputFields.length;
        int nrfilters = this.filter.length;
        retval.allocate(nrfiles, nrfields, nrfilters);
        for (i = 0; i < nrfiles; ++i) {
            retval.fileName[i] = this.fileName[i];
            retval.fileMask[i] = this.fileMask[i];
            retval.excludeFileMask[i] = this.excludeFileMask[i];
            retval.fileRequired[i] = this.fileRequired[i];
            retval.includeSubFolders[i] = this.includeSubFolders[i];
        }
        for (i = 0; i < nrfields; ++i) {
            retval.inputFields[i] = (TextFileInputField)this.inputFields[i].clone();
        }
        for (i = 0; i < nrfilters; ++i) {
            retval.filter[i] = (TextFileFilter)this.filter[i].clone();
        }
        retval.dateFormatLocale = (Locale)this.dateFormatLocale.clone();
        return retval;
    }

    public void allocate(int nrfiles, int nrfields, int nrfilters) {
        this.fileName = new String[nrfiles];
        this.fileMask = new String[nrfiles];
        this.excludeFileMask = new String[nrfiles];
        this.fileRequired = new String[nrfiles];
        this.includeSubFolders = new String[nrfiles];
        this.inputFields = new TextFileInputField[nrfields];
        this.filter = new TextFileFilter[nrfilters];
    }

    @Override
    public void setDefault() {
        int i;
        this.shortFileFieldName = null;
        this.pathFieldName = null;
        this.hiddenFieldName = null;
        this.lastModificationTimeFieldName = null;
        this.uriNameFieldName = null;
        this.rootUriNameFieldName = null;
        this.extensionFieldName = null;
        this.sizeFieldName = null;
        this.isaddresult = true;
        this.separator = ";";
        this.enclosure = "\"";
        this.breakInEnclosureAllowed = false;
        this.header = true;
        this.nrHeaderLines = 1;
        this.footer = false;
        this.nrFooterLines = 1;
        this.lineWrapped = false;
        this.nrWraps = 1;
        this.layoutPaged = false;
        this.nrLinesPerPage = 80;
        this.nrLinesDocHeader = 0;
        this.fileCompression = "None";
        this.noEmptyLines = true;
        this.fileFormat = "DOS";
        this.fileType = "CSV";
        this.includeFilename = false;
        this.filenameField = "";
        this.includeRowNumber = false;
        this.rowNumberField = "";
        this.errorIgnored = false;
        this.skipBadFiles = false;
        this.errorLineSkipped = false;
        this.warningFilesDestinationDirectory = null;
        this.warningFilesExtension = "warning";
        this.errorFilesDestinationDirectory = null;
        this.errorFilesExtension = "error";
        this.lineNumberFilesDestinationDirectory = null;
        this.lineNumberFilesExtension = "line";
        this.dateFormatLenient = true;
        this.rowNumberByFile = false;
        int nrfiles = 0;
        int nrfields = 0;
        int nrfilters = 0;
        this.allocate(nrfiles, nrfields, nrfilters);
        for (i = 0; i < nrfiles; ++i) {
            this.fileName[i] = "filename" + (i + 1);
            this.fileMask[i] = "";
            this.excludeFileMask[i] = "";
            this.fileRequired[i] = NO;
            this.includeSubFolders[i] = NO;
        }
        for (i = 0; i < nrfields; ++i) {
            this.inputFields[i] = new TextFileInputField("field" + (i + 1), 1, -1);
        }
        this.dateFormatLocale = Locale.getDefault();
        this.rowLimit = 0L;
    }

    @Override
    public void getFields(RowMetaInterface row, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        if (!this.isPassingThruFields()) {
            row.clear();
        } else if (info != null) {
            boolean found = false;
            for (int i = 0; i < info.length && !found; ++i) {
                if (info[i] == null) continue;
                row.mergeRowMeta(info[i]);
                found = true;
            }
        }
        for (int i = 0; i < this.inputFields.length; ++i) {
            TextFileInputField field = this.inputFields[i];
            int type = field.getType();
            if (type == 0) {
                type = 2;
            }
            ValueMeta v = new ValueMeta(field.getName(), type);
            v.setLength(field.getLength());
            v.setPrecision(field.getPrecision());
            v.setOrigin(name);
            v.setConversionMask(field.getFormat());
            v.setDecimalSymbol(field.getDecimalSymbol());
            v.setGroupingSymbol(field.getGroupSymbol());
            v.setCurrencySymbol(field.getCurrencySymbol());
            v.setDateFormatLenient(this.dateFormatLenient);
            v.setDateFormatLocale(this.dateFormatLocale);
            v.setTrimType(field.getTrimType());
            row.addValueMeta((ValueMetaInterface)v);
        }
        if (this.errorIgnored) {
            if (this.errorCountField != null && this.errorCountField.length() > 0) {
                ValueMeta v = new ValueMeta(this.errorCountField, 5);
                v.setLength(10, 0);
                v.setOrigin(name);
                row.addValueMeta((ValueMetaInterface)v);
            }
            if (this.errorFieldsField != null && this.errorFieldsField.length() > 0) {
                ValueMeta v = new ValueMeta(this.errorFieldsField, 2);
                v.setOrigin(name);
                row.addValueMeta((ValueMetaInterface)v);
            }
            if (this.errorTextField != null && this.errorTextField.length() > 0) {
                ValueMeta v = new ValueMeta(this.errorTextField, 2);
                v.setOrigin(name);
                row.addValueMeta((ValueMetaInterface)v);
            }
        }
        if (this.includeFilename) {
            ValueMeta v = new ValueMeta(this.filenameField, 2);
            v.setLength(100);
            v.setOrigin(name);
            row.addValueMeta((ValueMetaInterface)v);
        }
        if (this.includeRowNumber) {
            ValueMeta v = new ValueMeta(this.rowNumberField, 5);
            v.setLength(10, 0);
            v.setOrigin(name);
            row.addValueMeta((ValueMetaInterface)v);
        }
        if (this.getShortFileNameField() != null && this.getShortFileNameField().length() > 0) {
            ValueMeta v = new ValueMeta(space.environmentSubstitute(this.getShortFileNameField()), 2);
            v.setLength(100, -1);
            v.setOrigin(name);
            row.addValueMeta((ValueMetaInterface)v);
        }
        if (this.getExtensionField() != null && this.getExtensionField().length() > 0) {
            ValueMeta v = new ValueMeta(space.environmentSubstitute(this.getExtensionField()), 2);
            v.setLength(100, -1);
            v.setOrigin(name);
            row.addValueMeta((ValueMetaInterface)v);
        }
        if (this.getPathField() != null && this.getPathField().length() > 0) {
            ValueMeta v = new ValueMeta(space.environmentSubstitute(this.getPathField()), 2);
            v.setLength(100, -1);
            v.setOrigin(name);
            row.addValueMeta((ValueMetaInterface)v);
        }
        if (this.getSizeField() != null && this.getSizeField().length() > 0) {
            ValueMeta v = new ValueMeta(space.environmentSubstitute(this.getSizeField()), 5);
            v.setOrigin(name);
            v.setLength(9);
            row.addValueMeta((ValueMetaInterface)v);
        }
        if (this.isHiddenField() != null && this.isHiddenField().length() > 0) {
            ValueMeta v = new ValueMeta(space.environmentSubstitute(this.isHiddenField()), 4);
            v.setOrigin(name);
            row.addValueMeta((ValueMetaInterface)v);
        }
        if (this.getLastModificationDateField() != null && this.getLastModificationDateField().length() > 0) {
            ValueMeta v = new ValueMeta(space.environmentSubstitute(this.getLastModificationDateField()), 3);
            v.setOrigin(name);
            row.addValueMeta((ValueMetaInterface)v);
        }
        if (this.getUriField() != null && this.getUriField().length() > 0) {
            ValueMeta v = new ValueMeta(space.environmentSubstitute(this.getUriField()), 2);
            v.setLength(100, -1);
            v.setOrigin(name);
            row.addValueMeta((ValueMetaInterface)v);
        }
        if (this.getRootUriField() != null && this.getRootUriField().length() > 0) {
            ValueMeta v = new ValueMeta(this.getRootUriField(), 2);
            v.setLength(100, -1);
            v.setOrigin(name);
            row.addValueMeta((ValueMetaInterface)v);
        }
    }

    @Override
    public String getXML() {
        int i;
        StringBuffer retval = new StringBuffer(1500);
        retval.append("    ").append(XMLHandler.addTagValue((String)"accept_filenames", (boolean)this.acceptingFilenames));
        retval.append("    ").append(XMLHandler.addTagValue((String)"passing_through_fields", (boolean)this.passingThruFields));
        retval.append("    ").append(XMLHandler.addTagValue((String)"accept_field", (String)this.acceptingField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"accept_stepname", (String)(this.acceptingStep != null ? this.acceptingStep.getName() : "")));
        retval.append("    ").append(XMLHandler.addTagValue((String)"separator", (String)this.separator));
        retval.append("    ").append(XMLHandler.addTagValue((String)"enclosure", (String)this.enclosure));
        retval.append("    ").append(XMLHandler.addTagValue((String)"enclosure_breaks", (boolean)this.breakInEnclosureAllowed));
        retval.append("    ").append(XMLHandler.addTagValue((String)"escapechar", (String)this.escapeCharacter));
        retval.append("    ").append(XMLHandler.addTagValue((String)"header", (boolean)this.header));
        retval.append("    ").append(XMLHandler.addTagValue((String)"nr_headerlines", (int)this.nrHeaderLines));
        retval.append("    ").append(XMLHandler.addTagValue((String)"footer", (boolean)this.footer));
        retval.append("    ").append(XMLHandler.addTagValue((String)"nr_footerlines", (int)this.nrFooterLines));
        retval.append("    ").append(XMLHandler.addTagValue((String)"line_wrapped", (boolean)this.lineWrapped));
        retval.append("    ").append(XMLHandler.addTagValue((String)"nr_wraps", (int)this.nrWraps));
        retval.append("    ").append(XMLHandler.addTagValue((String)"layout_paged", (boolean)this.layoutPaged));
        retval.append("    ").append(XMLHandler.addTagValue((String)"nr_lines_per_page", (int)this.nrLinesPerPage));
        retval.append("    ").append(XMLHandler.addTagValue((String)"nr_lines_doc_header", (int)this.nrLinesDocHeader));
        retval.append("    ").append(XMLHandler.addTagValue((String)"noempty", (boolean)this.noEmptyLines));
        retval.append("    ").append(XMLHandler.addTagValue((String)"include", (boolean)this.includeFilename));
        retval.append("    ").append(XMLHandler.addTagValue((String)"include_field", (String)this.filenameField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"rownum", (boolean)this.includeRowNumber));
        retval.append("    ").append(XMLHandler.addTagValue((String)"rownumByFile", (boolean)this.rowNumberByFile));
        retval.append("    ").append(XMLHandler.addTagValue((String)"rownum_field", (String)this.rowNumberField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"format", (String)this.fileFormat));
        retval.append("    ").append(XMLHandler.addTagValue((String)"encoding", (String)this.encoding));
        retval.append("    " + XMLHandler.addTagValue((String)"add_to_result_filenames", (boolean)this.isaddresult));
        retval.append("    <file>").append(Const.CR);
        for (i = 0; i < this.fileName.length; ++i) {
            retval.append("      ").append(XMLHandler.addTagValue((String)"name", (String)this.fileName[i]));
            retval.append("      ").append(XMLHandler.addTagValue((String)"filemask", (String)this.fileMask[i]));
            retval.append("      ").append(XMLHandler.addTagValue((String)"exclude_filemask", (String)this.excludeFileMask[i]));
            retval.append("      ").append(XMLHandler.addTagValue((String)"file_required", (String)this.fileRequired[i]));
            retval.append("      ").append(XMLHandler.addTagValue((String)"include_subfolders", (String)this.includeSubFolders[i]));
        }
        retval.append("      ").append(XMLHandler.addTagValue((String)"type", (String)this.fileType));
        retval.append("      ").append(XMLHandler.addTagValue((String)"compression", (String)this.fileCompression));
        retval.append("    </file>").append(Const.CR);
        retval.append("    <filters>").append(Const.CR);
        for (i = 0; i < this.filter.length; ++i) {
            String filterString = this.filter[i].getFilterString();
            byte[] filterBytes = new byte[]{};
            String filterPrefix = "";
            if (filterString != null) {
                filterBytes = filterString.getBytes();
                filterPrefix = STRING_BASE64_PREFIX;
            }
            String filterEncoded = filterPrefix + new String(Base64.encodeBase64((byte[])filterBytes));
            retval.append("      <filter>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"filter_string", (String)filterEncoded, (boolean)false, (String[])new String[0]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"filter_position", (int)this.filter[i].getFilterPosition(), (boolean)false));
            retval.append("        ").append(XMLHandler.addTagValue((String)"filter_is_last_line", (boolean)this.filter[i].isFilterLastLine(), (boolean)false));
            retval.append("        ").append(XMLHandler.addTagValue((String)"filter_is_positive", (boolean)this.filter[i].isFilterPositive(), (boolean)false));
            retval.append("      </filter>").append(Const.CR);
        }
        retval.append("    </filters>").append(Const.CR);
        retval.append("    <fields>").append(Const.CR);
        for (i = 0; i < this.inputFields.length; ++i) {
            TextFileInputField field = this.inputFields[i];
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)field.getName()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"type", (String)field.getTypeDesc()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"format", (String)field.getFormat()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"currency", (String)field.getCurrencySymbol()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"decimal", (String)field.getDecimalSymbol()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"group", (String)field.getGroupSymbol()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"nullif", (String)field.getNullString()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"ifnull", (String)field.getIfNullValue()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"position", (int)field.getPosition()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"length", (int)field.getLength()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"precision", (int)field.getPrecision()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"trim_type", (String)field.getTrimTypeCode()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"repeat", (boolean)field.isRepeated()));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        retval.append("    ").append(XMLHandler.addTagValue((String)"limit", (long)this.rowLimit));
        retval.append("    ").append(XMLHandler.addTagValue((String)"error_ignored", (boolean)this.errorIgnored));
        retval.append("    ").append(XMLHandler.addTagValue((String)"skip_bad_files", (boolean)this.skipBadFiles));
        retval.append("    ").append(XMLHandler.addTagValue((String)"file_error_field", (String)this.fileErrorField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"file_error_message_field", (String)this.fileErrorMessageField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"error_line_skipped", (boolean)this.errorLineSkipped));
        retval.append("    ").append(XMLHandler.addTagValue((String)"error_count_field", (String)this.errorCountField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"error_fields_field", (String)this.errorFieldsField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"error_text_field", (String)this.errorTextField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"bad_line_files_destination_directory", (String)this.warningFilesDestinationDirectory));
        retval.append("    ").append(XMLHandler.addTagValue((String)"bad_line_files_extension", (String)this.warningFilesExtension));
        retval.append("    ").append(XMLHandler.addTagValue((String)"error_line_files_destination_directory", (String)this.errorFilesDestinationDirectory));
        retval.append("    ").append(XMLHandler.addTagValue((String)"error_line_files_extension", (String)this.errorFilesExtension));
        retval.append("    ").append(XMLHandler.addTagValue((String)"line_number_files_destination_directory", (String)this.lineNumberFilesDestinationDirectory));
        retval.append("    ").append(XMLHandler.addTagValue((String)"line_number_files_extension", (String)this.lineNumberFilesExtension));
        retval.append("    ").append(XMLHandler.addTagValue((String)"date_format_lenient", (boolean)this.dateFormatLenient));
        retval.append("    ").append(XMLHandler.addTagValue((String)"date_format_locale", (String)this.dateFormatLocale.toString()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"shortFileFieldName", (String)this.shortFileFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"pathFieldName", (String)this.pathFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"hiddenFieldName", (String)this.hiddenFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"lastModificationTimeFieldName", (String)this.lastModificationTimeFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"uriNameFieldName", (String)this.uriNameFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"rootUriNameFieldName", (String)this.rootUriNameFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"extensionFieldName", (String)this.extensionFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"sizeFieldName", (String)this.sizeFieldName));
        return retval.toString();
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            Node fnode;
            int i;
            this.acceptingFilenames = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"accept_filenames"));
            this.passingThruFields = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"passing_through_fields"));
            this.acceptingField = XMLHandler.getTagValue((Node)stepnode, (String)"accept_field");
            this.acceptingStepName = XMLHandler.getTagValue((Node)stepnode, (String)"accept_stepname");
            this.separator = XMLHandler.getTagValue((Node)stepnode, (String)"separator");
            this.enclosure = XMLHandler.getTagValue((Node)stepnode, (String)"enclosure");
            this.breakInEnclosureAllowed = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"enclosure_breaks"));
            this.escapeCharacter = XMLHandler.getTagValue((Node)stepnode, (String)"escapechar");
            this.header = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"header"));
            this.nrHeaderLines = Const.toInt((String)XMLHandler.getTagValue((Node)stepnode, (String)"nr_headerlines"), (int)1);
            this.footer = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"footer"));
            this.nrFooterLines = Const.toInt((String)XMLHandler.getTagValue((Node)stepnode, (String)"nr_footerlines"), (int)1);
            this.lineWrapped = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"line_wrapped"));
            this.nrWraps = Const.toInt((String)XMLHandler.getTagValue((Node)stepnode, (String)"nr_wraps"), (int)1);
            this.layoutPaged = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"layout_paged"));
            this.nrLinesPerPage = Const.toInt((String)XMLHandler.getTagValue((Node)stepnode, (String)"nr_lines_per_page"), (int)1);
            this.nrLinesDocHeader = Const.toInt((String)XMLHandler.getTagValue((Node)stepnode, (String)"nr_lines_doc_header"), (int)1);
            String addToResult = XMLHandler.getTagValue((Node)stepnode, (String)"add_to_result_filenames");
            this.isaddresult = Const.isEmpty((String)addToResult) ? true : YES.equalsIgnoreCase(addToResult);
            String nempty = XMLHandler.getTagValue((Node)stepnode, (String)"noempty");
            this.noEmptyLines = YES.equalsIgnoreCase(nempty) || nempty == null;
            this.includeFilename = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"include"));
            this.filenameField = XMLHandler.getTagValue((Node)stepnode, (String)"include_field");
            this.includeRowNumber = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"rownum"));
            this.rowNumberByFile = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"rownumByFile"));
            this.rowNumberField = XMLHandler.getTagValue((Node)stepnode, (String)"rownum_field");
            this.fileFormat = XMLHandler.getTagValue((Node)stepnode, (String)"format");
            this.encoding = XMLHandler.getTagValue((Node)stepnode, (String)"encoding");
            Node filenode = XMLHandler.getSubNode((Node)stepnode, (String)"file");
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            Node filtersNode = XMLHandler.getSubNode((Node)stepnode, (String)"filters");
            int nrfiles = XMLHandler.countNodes((Node)filenode, (String)"name");
            int nrfields = XMLHandler.countNodes((Node)fields, (String)"field");
            int nrfilters = XMLHandler.countNodes((Node)filtersNode, (String)"filter");
            this.allocate(nrfiles, nrfields, nrfilters);
            for (i = 0; i < nrfiles; ++i) {
                Node filenamenode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"name", (int)i);
                Node filemasknode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"filemask", (int)i);
                Node excludefilemasknode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"exclude_filemask", (int)i);
                Node fileRequirednode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"file_required", (int)i);
                Node includeSubFoldersnode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"include_subfolders", (int)i);
                this.fileName[i] = XMLHandler.getNodeValue((Node)filenamenode);
                this.fileMask[i] = XMLHandler.getNodeValue((Node)filemasknode);
                this.excludeFileMask[i] = XMLHandler.getNodeValue((Node)excludefilemasknode);
                this.fileRequired[i] = XMLHandler.getNodeValue((Node)fileRequirednode);
                this.includeSubFolders[i] = XMLHandler.getNodeValue((Node)includeSubFoldersnode);
            }
            this.fileType = XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"type");
            this.fileCompression = XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"compression");
            if (this.fileCompression == null && YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"zipped"))) {
                this.fileCompression = "Zip";
            }
            if (XMLHandler.getTagValue((Node)stepnode, (String)"filter") != null) {
                this.filter = new TextFileFilter[1];
                this.filter[0] = new TextFileFilter();
                this.filter[0].setFilterPosition(Const.toInt((String)XMLHandler.getTagValue((Node)stepnode, (String)"filter_position"), (int)-1));
                this.filter[0].setFilterString(XMLHandler.getTagValue((Node)stepnode, (String)"filter_string"));
                this.filter[0].setFilterLastLine(YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"filter_is_last_line")));
                this.filter[0].setFilterPositive(YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"filter_is_positive")));
            } else {
                for (i = 0; i < nrfilters; ++i) {
                    fnode = XMLHandler.getSubNodeByNr((Node)filtersNode, (String)"filter", (int)i);
                    this.filter[i] = new TextFileFilter();
                    this.filter[i].setFilterPosition(Const.toInt((String)XMLHandler.getTagValue((Node)fnode, (String)"filter_position"), (int)-1));
                    String filterString = XMLHandler.getTagValue((Node)fnode, (String)"filter_string");
                    if (filterString != null && filterString.startsWith(STRING_BASE64_PREFIX)) {
                        this.filter[i].setFilterString(new String(Base64.decodeBase64((byte[])filterString.substring(STRING_BASE64_PREFIX.length()).getBytes())));
                    } else {
                        this.filter[i].setFilterString(filterString);
                    }
                    this.filter[i].setFilterLastLine(YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)fnode, (String)"filter_is_last_line")));
                    this.filter[i].setFilterPositive(YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)fnode, (String)"filter_is_positive")));
                }
            }
            for (i = 0; i < nrfields; ++i) {
                fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                TextFileInputField field = new TextFileInputField();
                field.setName(XMLHandler.getTagValue((Node)fnode, (String)"name"));
                field.setType(ValueMeta.getType((String)XMLHandler.getTagValue((Node)fnode, (String)"type")));
                field.setFormat(XMLHandler.getTagValue((Node)fnode, (String)"format"));
                field.setCurrencySymbol(XMLHandler.getTagValue((Node)fnode, (String)"currency"));
                field.setDecimalSymbol(XMLHandler.getTagValue((Node)fnode, (String)"decimal"));
                field.setGroupSymbol(XMLHandler.getTagValue((Node)fnode, (String)"group"));
                field.setNullString(XMLHandler.getTagValue((Node)fnode, (String)"nullif"));
                field.setIfNullValue(XMLHandler.getTagValue((Node)fnode, (String)"ifnull"));
                field.setPosition(Const.toInt((String)XMLHandler.getTagValue((Node)fnode, (String)"position"), (int)-1));
                field.setLength(Const.toInt((String)XMLHandler.getTagValue((Node)fnode, (String)"length"), (int)-1));
                field.setPrecision(Const.toInt((String)XMLHandler.getTagValue((Node)fnode, (String)"precision"), (int)-1));
                field.setTrimType(ValueMeta.getTrimTypeByCode((String)XMLHandler.getTagValue((Node)fnode, (String)"trim_type")));
                field.setRepeated(YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)fnode, (String)"repeat")));
                this.inputFields[i] = field;
            }
            this.rowLimit = Const.toLong((String)XMLHandler.getTagValue((Node)stepnode, (String)"limit"), (long)0L);
            this.errorIgnored = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"error_ignored"));
            this.skipBadFiles = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"skip_bad_files"));
            this.fileErrorField = XMLHandler.getTagValue((Node)stepnode, (String)"file_error_field");
            this.fileErrorMessageField = XMLHandler.getTagValue((Node)stepnode, (String)"file_error_message_field");
            this.errorLineSkipped = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"error_line_skipped"));
            this.errorCountField = XMLHandler.getTagValue((Node)stepnode, (String)"error_count_field");
            this.errorFieldsField = XMLHandler.getTagValue((Node)stepnode, (String)"error_fields_field");
            this.errorTextField = XMLHandler.getTagValue((Node)stepnode, (String)"error_text_field");
            this.warningFilesDestinationDirectory = XMLHandler.getTagValue((Node)stepnode, (String)"bad_line_files_destination_directory");
            this.warningFilesExtension = XMLHandler.getTagValue((Node)stepnode, (String)"bad_line_files_extension");
            this.errorFilesDestinationDirectory = XMLHandler.getTagValue((Node)stepnode, (String)"error_line_files_destination_directory");
            this.errorFilesExtension = XMLHandler.getTagValue((Node)stepnode, (String)"error_line_files_extension");
            this.lineNumberFilesDestinationDirectory = XMLHandler.getTagValue((Node)stepnode, (String)"line_number_files_destination_directory");
            this.lineNumberFilesExtension = XMLHandler.getTagValue((Node)stepnode, (String)"line_number_files_extension");
            this.dateFormatLenient = !NO.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"date_format_lenient"));
            String dateLocale = XMLHandler.getTagValue((Node)stepnode, (String)"date_format_locale");
            this.dateFormatLocale = dateLocale != null ? EnvUtil.createLocale((String)dateLocale) : Locale.getDefault();
            this.shortFileFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"shortFileFieldName");
            this.pathFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"pathFieldName");
            this.hiddenFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"hiddenFieldName");
            this.lastModificationTimeFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"lastModificationTimeFieldName");
            this.uriNameFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"uriNameFieldName");
            this.rootUriNameFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"rootUriNameFieldName");
            this.extensionFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"extensionFieldName");
            this.sizeFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"sizeFieldName");
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    public String getLookupStepname() {
        if (this.acceptingFilenames && this.acceptingStep != null && !Const.isEmpty((String)this.acceptingStep.getName())) {
            return this.acceptingStep.getName();
        }
        return null;
    }

    @Override
    public void searchInfoAndTargetSteps(List<StepMeta> steps) {
        this.acceptingStep = StepMeta.findStep(steps, this.acceptingStepName);
    }

    public String[] getInfoSteps() {
        if (this.acceptingFilenames && this.acceptingStep != null) {
            return new String[]{this.acceptingStep.getName()};
        }
        return null;
    }

    @Override
    public void readRep(Repository rep, ObjectId id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            int i;
            this.acceptingFilenames = rep.getStepAttributeBoolean(id_step, "accept_filenames");
            this.passingThruFields = rep.getStepAttributeBoolean(id_step, "passing_through_fields");
            this.acceptingField = rep.getStepAttributeString(id_step, "accept_field");
            this.acceptingStepName = rep.getStepAttributeString(id_step, "accept_stepname");
            this.separator = rep.getStepAttributeString(id_step, "separator");
            this.enclosure = rep.getStepAttributeString(id_step, "enclosure");
            this.breakInEnclosureAllowed = rep.getStepAttributeBoolean(id_step, "enclosure_breaks");
            this.escapeCharacter = rep.getStepAttributeString(id_step, "escapechar");
            this.header = rep.getStepAttributeBoolean(id_step, "header");
            this.nrHeaderLines = (int)rep.getStepAttributeInteger(id_step, "nr_headerlines");
            this.footer = rep.getStepAttributeBoolean(id_step, "footer");
            this.nrFooterLines = (int)rep.getStepAttributeInteger(id_step, "nr_footerlines");
            this.lineWrapped = rep.getStepAttributeBoolean(id_step, "line_wrapped");
            this.nrWraps = (int)rep.getStepAttributeInteger(id_step, "nr_wraps");
            this.layoutPaged = rep.getStepAttributeBoolean(id_step, "layout_paged");
            this.nrLinesPerPage = (int)rep.getStepAttributeInteger(id_step, "nr_lines_per_page");
            this.nrLinesDocHeader = (int)rep.getStepAttributeInteger(id_step, "nr_lines_doc_header");
            this.noEmptyLines = rep.getStepAttributeBoolean(id_step, "noempty");
            this.includeFilename = rep.getStepAttributeBoolean(id_step, "include");
            this.filenameField = rep.getStepAttributeString(id_step, "include_field");
            this.includeRowNumber = rep.getStepAttributeBoolean(id_step, "rownum");
            this.rowNumberByFile = rep.getStepAttributeBoolean(id_step, "rownumByFile");
            this.rowNumberField = rep.getStepAttributeString(id_step, "rownum_field");
            this.fileFormat = rep.getStepAttributeString(id_step, "format");
            this.encoding = rep.getStepAttributeString(id_step, "encoding");
            String addToResult = rep.getStepAttributeString(id_step, "add_to_result_filenames");
            this.isaddresult = Const.isEmpty((String)addToResult) ? true : rep.getStepAttributeBoolean(id_step, "add_to_result_filenames");
            this.rowLimit = (int)rep.getStepAttributeInteger(id_step, "limit");
            int nrfiles = rep.countNrStepAttributes(id_step, "file_name");
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            int nrfilters = rep.countNrStepAttributes(id_step, "filter_string");
            this.allocate(nrfiles, nrfields, nrfilters);
            for (i = 0; i < nrfiles; ++i) {
                this.fileName[i] = rep.getStepAttributeString(id_step, i, "file_name");
                this.fileMask[i] = rep.getStepAttributeString(id_step, i, "file_mask");
                this.excludeFileMask[i] = rep.getStepAttributeString(id_step, i, "exclude_file_mask");
                this.fileRequired[i] = rep.getStepAttributeString(id_step, i, "file_required");
                if (!YES.equalsIgnoreCase(this.fileRequired[i])) {
                    this.fileRequired[i] = NO;
                }
                this.includeSubFolders[i] = rep.getStepAttributeString(id_step, i, "include_subfolders");
                if (YES.equalsIgnoreCase(this.includeSubFolders[i])) continue;
                this.includeSubFolders[i] = NO;
            }
            this.fileType = rep.getStepAttributeString(id_step, "file_type");
            this.fileCompression = rep.getStepAttributeString(id_step, "compression");
            if (this.fileCompression == null && rep.getStepAttributeBoolean(id_step, "file_zipped")) {
                this.fileCompression = "Zip";
            }
            for (i = 0; i < nrfilters; ++i) {
                this.filter[i] = new TextFileFilter();
                this.filter[i].setFilterPosition((int)rep.getStepAttributeInteger(id_step, i, "filter_position"));
                this.filter[i].setFilterString(rep.getStepAttributeString(id_step, i, "filter_string"));
                this.filter[i].setFilterLastLine(rep.getStepAttributeBoolean(id_step, i, "filter_is_last_line"));
                this.filter[i].setFilterPositive(rep.getStepAttributeBoolean(id_step, i, "filter_is_positive"));
            }
            for (i = 0; i < nrfields; ++i) {
                TextFileInputField field = new TextFileInputField();
                field.setName(rep.getStepAttributeString(id_step, i, "field_name"));
                field.setType(ValueMeta.getType((String)rep.getStepAttributeString(id_step, i, "field_type")));
                field.setFormat(rep.getStepAttributeString(id_step, i, "field_format"));
                field.setCurrencySymbol(rep.getStepAttributeString(id_step, i, "field_currency"));
                field.setDecimalSymbol(rep.getStepAttributeString(id_step, i, "field_decimal"));
                field.setGroupSymbol(rep.getStepAttributeString(id_step, i, "field_group"));
                field.setNullString(rep.getStepAttributeString(id_step, i, "field_nullif"));
                field.setIfNullValue(rep.getStepAttributeString(id_step, i, "field_ifnull"));
                field.setPosition((int)rep.getStepAttributeInteger(id_step, i, "field_position"));
                field.setLength((int)rep.getStepAttributeInteger(id_step, i, "field_length"));
                field.setPrecision((int)rep.getStepAttributeInteger(id_step, i, "field_precision"));
                field.setTrimType(ValueMeta.getTrimTypeByCode((String)rep.getStepAttributeString(id_step, i, "field_trim_type")));
                field.setRepeated(rep.getStepAttributeBoolean(id_step, i, "field_repeat"));
                this.inputFields[i] = field;
            }
            this.errorIgnored = rep.getStepAttributeBoolean(id_step, "error_ignored");
            this.skipBadFiles = rep.getStepAttributeBoolean(id_step, "skip_bad_files");
            this.fileErrorField = rep.getStepAttributeString(id_step, "file_error_field");
            this.fileErrorMessageField = rep.getStepAttributeString(id_step, "file_error_message_field");
            this.errorLineSkipped = rep.getStepAttributeBoolean(id_step, "error_line_skipped");
            this.errorCountField = rep.getStepAttributeString(id_step, "error_count_field");
            this.errorFieldsField = rep.getStepAttributeString(id_step, "error_fields_field");
            this.errorTextField = rep.getStepAttributeString(id_step, "error_text_field");
            this.warningFilesDestinationDirectory = rep.getStepAttributeString(id_step, "bad_line_files_dest_dir");
            this.warningFilesExtension = rep.getStepAttributeString(id_step, "bad_line_files_ext");
            this.errorFilesDestinationDirectory = rep.getStepAttributeString(id_step, "error_line_files_dest_dir");
            this.errorFilesExtension = rep.getStepAttributeString(id_step, "error_line_files_ext");
            this.lineNumberFilesDestinationDirectory = rep.getStepAttributeString(id_step, "line_number_files_dest_dir");
            this.lineNumberFilesExtension = rep.getStepAttributeString(id_step, "line_number_files_ext");
            this.dateFormatLenient = rep.getStepAttributeBoolean(id_step, 0, "date_format_lenient", true);
            String dateLocale = rep.getStepAttributeString(id_step, 0, "date_format_locale");
            this.dateFormatLocale = dateLocale != null ? EnvUtil.createLocale((String)dateLocale) : Locale.getDefault();
            this.shortFileFieldName = rep.getStepAttributeString(id_step, "shortFileFieldName");
            this.pathFieldName = rep.getStepAttributeString(id_step, "pathFieldName");
            this.hiddenFieldName = rep.getStepAttributeString(id_step, "hiddenFieldName");
            this.lastModificationTimeFieldName = rep.getStepAttributeString(id_step, "lastModificationTimeFieldName");
            this.rootUriNameFieldName = rep.getStepAttributeString(id_step, "rootUriNameFieldName");
            this.extensionFieldName = rep.getStepAttributeString(id_step, "extensionFieldName");
            this.sizeFieldName = rep.getStepAttributeString(id_step, "sizeFieldName");
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            int i;
            rep.saveStepAttribute(id_transformation, id_step, "accept_filenames", this.acceptingFilenames);
            rep.saveStepAttribute(id_transformation, id_step, "passing_through_fields", this.passingThruFields);
            rep.saveStepAttribute(id_transformation, id_step, "accept_field", this.acceptingField);
            rep.saveStepAttribute(id_transformation, id_step, "accept_stepname", this.acceptingStep != null ? this.acceptingStep.getName() : "");
            rep.saveStepAttribute(id_transformation, id_step, "separator", this.separator);
            rep.saveStepAttribute(id_transformation, id_step, "enclosure", this.enclosure);
            rep.saveStepAttribute(id_transformation, id_step, "enclosure_breaks", this.breakInEnclosureAllowed);
            rep.saveStepAttribute(id_transformation, id_step, "escapechar", this.escapeCharacter);
            rep.saveStepAttribute(id_transformation, id_step, "header", this.header);
            rep.saveStepAttribute(id_transformation, id_step, "nr_headerlines", this.nrHeaderLines);
            rep.saveStepAttribute(id_transformation, id_step, "footer", this.footer);
            rep.saveStepAttribute(id_transformation, id_step, "nr_footerlines", this.nrFooterLines);
            rep.saveStepAttribute(id_transformation, id_step, "line_wrapped", this.lineWrapped);
            rep.saveStepAttribute(id_transformation, id_step, "nr_wraps", this.nrWraps);
            rep.saveStepAttribute(id_transformation, id_step, "layout_paged", this.layoutPaged);
            rep.saveStepAttribute(id_transformation, id_step, "nr_lines_per_page", this.nrLinesPerPage);
            rep.saveStepAttribute(id_transformation, id_step, "nr_lines_doc_header", this.nrLinesDocHeader);
            rep.saveStepAttribute(id_transformation, id_step, "noempty", this.noEmptyLines);
            rep.saveStepAttribute(id_transformation, id_step, "include", this.includeFilename);
            rep.saveStepAttribute(id_transformation, id_step, "include_field", this.filenameField);
            rep.saveStepAttribute(id_transformation, id_step, "rownum", this.includeRowNumber);
            rep.saveStepAttribute(id_transformation, id_step, "rownumByFile", this.rowNumberByFile);
            rep.saveStepAttribute(id_transformation, id_step, "rownum_field", this.rowNumberField);
            rep.saveStepAttribute(id_transformation, id_step, "format", this.fileFormat);
            rep.saveStepAttribute(id_transformation, id_step, "encoding", this.encoding);
            rep.saveStepAttribute(id_transformation, id_step, "add_to_result_filenames", this.isaddresult);
            rep.saveStepAttribute(id_transformation, id_step, "limit", this.rowLimit);
            for (i = 0; i < this.fileName.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "file_name", this.fileName[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "file_mask", this.fileMask[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "exclude_file_mask", this.excludeFileMask[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "file_required", this.fileRequired[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "include_subfolders", this.includeSubFolders[i]);
            }
            rep.saveStepAttribute(id_transformation, id_step, "file_type", this.fileType);
            rep.saveStepAttribute(id_transformation, id_step, "compression", this.fileCompression);
            for (i = 0; i < this.filter.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "filter_position", this.filter[i].getFilterPosition());
                rep.saveStepAttribute(id_transformation, id_step, i, "filter_string", this.filter[i].getFilterString());
                rep.saveStepAttribute(id_transformation, id_step, i, "filter_is_last_line", this.filter[i].isFilterLastLine());
                rep.saveStepAttribute(id_transformation, id_step, i, "filter_is_positive", this.filter[i].isFilterPositive());
            }
            for (i = 0; i < this.inputFields.length; ++i) {
                TextFileInputField field = this.inputFields[i];
                rep.saveStepAttribute(id_transformation, id_step, i, "field_name", field.getName());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_type", field.getTypeDesc());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_format", field.getFormat());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_currency", field.getCurrencySymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_decimal", field.getDecimalSymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_group", field.getGroupSymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_nullif", field.getNullString());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_ifnull", field.getIfNullValue());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_position", field.getPosition());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_length", field.getLength());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_precision", field.getPrecision());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_trim_type", field.getTrimTypeCode());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_repeat", field.isRepeated());
            }
            rep.saveStepAttribute(id_transformation, id_step, "error_ignored", this.errorIgnored);
            rep.saveStepAttribute(id_transformation, id_step, "skip_bad_files", this.skipBadFiles);
            rep.saveStepAttribute(id_transformation, id_step, "file_error_field", this.fileErrorField);
            rep.saveStepAttribute(id_transformation, id_step, "file_error_message_field", this.fileErrorMessageField);
            rep.saveStepAttribute(id_transformation, id_step, "error_line_skipped", this.errorLineSkipped);
            rep.saveStepAttribute(id_transformation, id_step, "error_count_field", this.errorCountField);
            rep.saveStepAttribute(id_transformation, id_step, "error_fields_field", this.errorFieldsField);
            rep.saveStepAttribute(id_transformation, id_step, "error_text_field", this.errorTextField);
            rep.saveStepAttribute(id_transformation, id_step, "bad_line_files_dest_dir", this.warningFilesDestinationDirectory);
            rep.saveStepAttribute(id_transformation, id_step, "bad_line_files_ext", this.warningFilesExtension);
            rep.saveStepAttribute(id_transformation, id_step, "error_line_files_dest_dir", this.errorFilesDestinationDirectory);
            rep.saveStepAttribute(id_transformation, id_step, "error_line_files_ext", this.errorFilesExtension);
            rep.saveStepAttribute(id_transformation, id_step, "line_number_files_dest_dir", this.lineNumberFilesDestinationDirectory);
            rep.saveStepAttribute(id_transformation, id_step, "line_number_files_ext", this.lineNumberFilesExtension);
            rep.saveStepAttribute(id_transformation, id_step, "date_format_lenient", this.dateFormatLenient);
            rep.saveStepAttribute(id_transformation, id_step, "date_format_locale", this.dateFormatLocale.toString());
            rep.saveStepAttribute(id_transformation, id_step, "shortFileFieldName", this.shortFileFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "pathFieldName", this.pathFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "hiddenFieldName", this.hiddenFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "lastModificationTimeFieldName", this.lastModificationTimeFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "uriNameFieldName", this.uriNameFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "rootUriNameFieldName", this.rootUriNameFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "extensionFieldName", this.extensionFieldName);
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    @Override
    public String[] getFilePaths(VariableSpace space) {
        return FileInputList.createFilePathList((VariableSpace)space, (String[])this.fileName, (String[])this.fileMask, (String[])this.excludeFileMask, (String[])this.fileRequired, (boolean[])this.includeSubFolderBoolean());
    }

    public FileInputList getTextFileList(VariableSpace space) {
        return FileInputList.createFileList((VariableSpace)space, (String[])this.fileName, (String[])this.fileMask, (String[])this.excludeFileMask, (String[])this.fileRequired, (boolean[])this.includeSubFolderBoolean());
    }

    private boolean[] includeSubFolderBoolean() {
        int len = this.fileName.length;
        boolean[] includeSubFolderBoolean = new boolean[len];
        for (int i = 0; i < len; ++i) {
            includeSubFolderBoolean[i] = YES.equalsIgnoreCase(this.includeSubFolders[i]);
        }
        return includeSubFolderBoolean;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepinfo, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr;
        if (input.length > 0) {
            if (!this.isAcceptingFilenames()) {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"TextFileInputMeta.CheckResult.NoInputError", (String[])new String[0]), (CheckResultSourceInterface)stepinfo);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TextFileInputMeta.CheckResult.AcceptFilenamesOk", (String[])new String[0]), (CheckResultSourceInterface)stepinfo);
                remarks.add((CheckResultInterface)cr);
            }
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TextFileInputMeta.CheckResult.NoInputOk", (String[])new String[0]), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        }
        FileInputList textFileList = this.getTextFileList(transMeta);
        if (textFileList.nrOfFiles() == 0) {
            if (!this.isAcceptingFilenames()) {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"TextFileInputMeta.CheckResult.ExpectedFilesError", (String[])new String[0]), (CheckResultSourceInterface)stepinfo);
                remarks.add((CheckResultInterface)cr);
            }
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TextFileInputMeta.CheckResult.ExpectedFilesOk", (String[])new String[]{"" + textFileList.nrOfFiles()}), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new TextFileInput(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new TextFileInputData();
    }

    @Override
    public String getEscapeCharacter() {
        return StringUtil.substituteHex((String)this.escapeCharacter);
    }

    public void setEscapeCharacter(String escapeCharacter) {
        this.escapeCharacter = escapeCharacter;
    }

    @Override
    public String getErrorCountField() {
        return this.errorCountField;
    }

    public void setErrorCountField(String errorCountField) {
        this.errorCountField = errorCountField;
    }

    @Override
    public String getErrorFieldsField() {
        return this.errorFieldsField;
    }

    public void setErrorFieldsField(String errorFieldsField) {
        this.errorFieldsField = errorFieldsField;
    }

    @Override
    public boolean isErrorIgnored() {
        return this.errorIgnored;
    }

    public void setErrorIgnored(boolean errorIgnored) {
        this.errorIgnored = errorIgnored;
    }

    @Override
    public String getErrorTextField() {
        return this.errorTextField;
    }

    public void setErrorTextField(String errorTextField) {
        this.errorTextField = errorTextField;
    }

    public boolean isLineWrapped() {
        return this.lineWrapped;
    }

    public void setLineWrapped(boolean lineWrapped) {
        this.lineWrapped = lineWrapped;
    }

    public int getNrFooterLines() {
        return this.nrFooterLines;
    }

    public void setNrFooterLines(int nrFooterLines) {
        this.nrFooterLines = nrFooterLines;
    }

    public String getRequiredFilesDesc(String tt) {
        if (tt == null) {
            return RequiredFilesDesc[0];
        }
        if (tt.equals(RequiredFilesCode[1])) {
            return RequiredFilesDesc[1];
        }
        return RequiredFilesDesc[0];
    }

    @Override
    public int getNrHeaderLines() {
        return this.nrHeaderLines;
    }

    public void setNrHeaderLines(int nrHeaderLines) {
        this.nrHeaderLines = nrHeaderLines;
    }

    public int getNrWraps() {
        return this.nrWraps;
    }

    public void setNrWraps(int nrWraps) {
        this.nrWraps = nrWraps;
    }

    public boolean isLayoutPaged() {
        return this.layoutPaged;
    }

    public void setLayoutPaged(boolean layoutPaged) {
        this.layoutPaged = layoutPaged;
    }

    public int getNrLinesPerPage() {
        return this.nrLinesPerPage;
    }

    public void setNrLinesPerPage(int nrLinesPerPage) {
        this.nrLinesPerPage = nrLinesPerPage;
    }

    public int getNrLinesDocHeader() {
        return this.nrLinesDocHeader;
    }

    public void setNrLinesDocHeader(int nrLinesDocHeader) {
        this.nrLinesDocHeader = nrLinesDocHeader;
    }

    public String getWarningFilesDestinationDirectory() {
        return this.warningFilesDestinationDirectory;
    }

    public void setWarningFilesDestinationDirectory(String warningFilesDestinationDirectory) {
        this.warningFilesDestinationDirectory = warningFilesDestinationDirectory;
    }

    public String getWarningFilesExtension() {
        return this.warningFilesExtension;
    }

    public void setWarningFilesExtension(String warningFilesExtension) {
        this.warningFilesExtension = warningFilesExtension;
    }

    public String getLineNumberFilesDestinationDirectory() {
        return this.lineNumberFilesDestinationDirectory;
    }

    public void setLineNumberFilesDestinationDirectory(String lineNumberFilesDestinationDirectory) {
        this.lineNumberFilesDestinationDirectory = lineNumberFilesDestinationDirectory;
    }

    public String getLineNumberFilesExtension() {
        return this.lineNumberFilesExtension;
    }

    public void setLineNumberFilesExtension(String lineNumberFilesExtension) {
        this.lineNumberFilesExtension = lineNumberFilesExtension;
    }

    public String getErrorFilesDestinationDirectory() {
        return this.errorFilesDestinationDirectory;
    }

    public void setErrorFilesDestinationDirectory(String errorFilesDestinationDirectory) {
        this.errorFilesDestinationDirectory = errorFilesDestinationDirectory;
    }

    public String getErrorLineFilesExtension() {
        return this.errorFilesExtension;
    }

    public void setErrorLineFilesExtension(String errorLineFilesExtension) {
        this.errorFilesExtension = errorLineFilesExtension;
    }

    public boolean isDateFormatLenient() {
        return this.dateFormatLenient;
    }

    public void setDateFormatLenient(boolean dateFormatLenient) {
        this.dateFormatLenient = dateFormatLenient;
    }

    public void setAddResultFile(boolean isaddresult) {
        this.isaddresult = isaddresult;
    }

    public boolean isAddResultFile() {
        return this.isaddresult;
    }

    @Override
    public boolean isErrorLineSkipped() {
        return this.errorLineSkipped;
    }

    public void setErrorLineSkipped(boolean errorLineSkipped) {
        this.errorLineSkipped = errorLineSkipped;
    }

    public Locale getDateFormatLocale() {
        return this.dateFormatLocale;
    }

    public void setDateFormatLocale(Locale dateFormatLocale) {
        this.dateFormatLocale = dateFormatLocale;
    }

    public boolean isAcceptingFilenames() {
        return this.acceptingFilenames;
    }

    public void setAcceptingFilenames(boolean getFileFromJob) {
        this.acceptingFilenames = getFileFromJob;
    }

    public boolean isPassingThruFields() {
        return this.passingThruFields;
    }

    public void setPassingThruFields(boolean passingThruFields) {
        this.passingThruFields = passingThruFields;
    }

    public String getAcceptingField() {
        return this.acceptingField;
    }

    public void setAcceptingField(String fileNameField) {
        this.acceptingField = fileNameField;
    }

    public String getAcceptingStepName() {
        return this.acceptingStepName;
    }

    public void setAcceptingStepName(String acceptingStep) {
        this.acceptingStepName = acceptingStep;
    }

    public StepMeta getAcceptingStep() {
        return this.acceptingStep;
    }

    public void setAcceptingStep(StepMeta acceptingStep) {
        this.acceptingStep = acceptingStep;
    }

    @Override
    public int getFileFormatTypeNr() {
        if (this.getFileFormat().equalsIgnoreCase("DOS")) {
            return 0;
        }
        if (this.getFileFormat().equalsIgnoreCase("unix")) {
            return 1;
        }
        return 2;
    }

    public int getFileTypeNr() {
        if (this.getFileType().equalsIgnoreCase("CSV")) {
            return 0;
        }
        return 1;
    }

    @Override
    public List<ResourceReference> getResourceDependencies(TransMeta transMeta, StepMeta stepInfo) {
        ArrayList<ResourceReference> references = new ArrayList<ResourceReference>(5);
        ResourceReference reference = new ResourceReference(stepInfo);
        references.add(reference);
        String[] textFiles = this.getFilePaths(transMeta);
        if (textFiles != null) {
            for (int i = 0; i < textFiles.length; ++i) {
                reference.getEntries().add(new ResourceEntry(textFiles[i], ResourceEntry.ResourceType.FILE));
            }
        }
        return references;
    }

    @Override
    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface resourceNamingInterface, Repository repository) throws KettleException {
        try {
            if (!this.acceptingFilenames) {
                for (int i = 0; i < this.fileName.length; ++i) {
                    FileObject fileObject = KettleVFS.getFileObject((String)space.environmentSubstitute(this.fileName[i]), (VariableSpace)space);
                    this.fileName[i] = resourceNamingInterface.nameResource(fileObject, space, Const.isEmpty((String)this.fileMask[i]));
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }

    @Override
    public boolean supportsErrorHandling() {
        return this.isErrorIgnored() && this.isSkipBadFiles();
    }
}

